ORCA/M Asm65816 2.1.0

0001 554A              ***********************************************************************************
0002 554A              *
0003 554A              *            Copyright Apple Computer, Inc. 1986-92
0004 554A              *                     All Rights Reserved
0005 554A              *                    Written by Dan Oliver
0006 554A              *
0007 554A              *               *** C O N F I D E N T I A L ***
0008 554A              *
0009 554A              *
0010 554A              *                   Change History:
0011 554A              *
0012 554A              * 21 June 1988      Harry Yee
0013 554A              *                   Converted version 2.1 of the menu manager that went on
0014 554A              *                   System Disk 3.2 to MAX.
0015 554A              *
0016 554A              *
0017 554A              * 27 June 1988      Steven Glass
0018 554A              *
0019 554A              * Changed all accesses to popXbytes.  All but two loaded y-reg with zero before
0020 554A              * branching so we changed these to access the new pop routines that assumed
0021 554A              * no error.  (these are now called popXbytes.)
0022 554A              *
0023 554A              * The error accesses still branch to the routines that assume y-reg has error
0024 554A              * code.  These have been renamed EpopXbytes.
0025 554A              *
0026 554A              * 30 June 1988      Steven Glass
0027 554A              *
0028 554A              * When calling the creamed routine we did a jsr to Long_Call instead of a JSL.
0029 554A              *
0030 554A              * 10 Aug 88         Dan Oliver
0031 554A              *
0032 554A              * Free allocated data area on shutdown.
0033 554A              *
0034 554A              * 02 Oct 88         Steven Glass
0035 554A              *
0036 554A              * Changed the data structure for Menu Items.  They now have two bytes for
0037 554A              * the item flag.
0038 554A              *
0039 554A              * Added the outline and shadow bits to the item flag
0040 554A              *
0041 554A              * Funnelled all calls to set text face to a common routine.  This saved code
0042 554A              * and lets me futz the text face bits.
0043 554A              *
0044 554A              * Changed parse routines so that they set check mark and flag separately instead
0045 554A              * of both at once.
0046 554A              *
0047 554A              *
0048 554A              * 14 Oct 88         Steven Glass
0049 554A              *
0050 554A              * Shutdown checks to see if it's active first before doing anything.
0051 554A              *
0052 554A              * 17 Oct 88         Harry Yee
0053 554A              *
0054 554A              * Put in code for scrollable menus. Modified Size_menu, took out code that checked to see
0055 554A              * if menuheight was greater than 1988.  (Does that mean 198?? --DAL Jan-91)
0056 554A              *
0057 554A              * 18 Oct 88         Harry Yee           (released in Proto 03 ROM)
0058 554A              * Initialized FirstItem field for custom menus to be 1. In DeleteMItem needed to decrement
0059 554A              * NumOfItems each time an item gets deleted.
0060 554A              *
0061 554A              * 19 Oct 88         Harry Yee
0062 554A              * Now using PortRect instead of BoundsRect to check if menu needs to be adjusted or not.
0063 554A              *
0064 554A              * 20 Oct 88         Harry Yee
0065 554A              * Not using the fields FirstItem and NumOfItems in the menu record anymore. Making space
0066 554A              * on direct page to hold these values. FirstItem and NumOfItems were 1 byte values,
0067 554A              * since I don't need FirstItem anymore, I am making NumOfItems 1 word long. NumOfItems
0068 554A              * will hold the total number of items in the menu. Fixed some problems dealing with
0069 554A              * custom menus. Made sure that a menu is not going to be scrollable if there are less
0070 554A              * than 3 items.
0071 554A              *
0072 554A              * 25 Oct 88         Harry Yee
0073 554A              * Put in code for PopupMenuSelect and tracking the pop-up menu (TrackMenu2).
0074 554A              * Made change to the routine pull_down during the savescreen process. The first line of
0075 554A              * the menu was not being cached, this was ok for regular menus, since the menu bar was
0076 554A              * there, but for pop-ups this was a problem, so the first line of the menu is cached for
0077 554A              * all regular and pop-up menus.
0078 554A              *
0079 554A              * 28 Oct 88 (morning) Harry Yee
0080 554A              * Changed the makefile to include the popupproc.asm code.  Added a new call DrawPopup $3D0F
0081 554A              * this is called by the popupproc do_draw and do_track to draw the pop-up box and drop
0082 554A              * shadow. A flag is also passed to this call which tells me whether to draw the name of the
0083 554A              * currently selected item in the pop-up box or not.
0084 554A              *
0085 554A              * 28 Oct 88 (afternoon) Harry Yee
0086 554A              * In routine DrawPopup set clip region to the pop-box (which is inset just a bit to account
0087 554A              * for the border) before drawing the item string.
0088 554A              *
0089 554A              * 31 Oct 88         Harry Yee
0090 554A              * Fixed problem when the pop-up rect is at bottom of the window.
0091 554A              *
0092 554A              * 02 Nov 88         Harry Yee
0093 554A              * Fixed more problems when the pop-up rect gets close to the bottom of the screen and the
0094 554A              * user trys to bring up the pop-up menu.
0095 554A              *
0096 554A              * 08 Nov 88         Harry Yee
0097 554A              *
0098 554A              * In the Oct 25 change that enabled caching of the first line of the menu this caused some
0099 554A              * problems in routine AllocateCache. Routine was allocating one line too less since it was
0100 554A              * allocating memory on the old assumption that the first line was not cached. I now increment
0101 554A              * the height by one so that everyone is happy (BRC #38017).
0102 554A              *
0103 554A              * 10 Nov 88         Harry Yee
0104 554A              *
0105 554A              * We now define the first two bits of the item flag. 00 = ptr, 01 = handle, 10 = resource ID.
0106 554A              * The first two bits of the menures byte is now also defined: 00 = ptr, 01 = handle, 10 = res ID
0107 554A              *
0108 554A              * Initial coding of NewMenu2 call ($3E0F). Don't know if it works though.
0109 554A              * Defined the format of menu, item and menubar resources.
0110 554A              *
0111 554A              * 11 Nov 88         Harry Yee
0112 554A              *
0113 554A              * NewMenu2 now works!! Hurrah! Now start on adding calls InsertMItem2, SetMenuTitle2,
0114 554A              * SetMItem2, and SetMItemName2.
0115 554A              *
0116 554A              * 15 Nov 88         Harry Yee
0117 554A              *
0118 554A              * Pop-up menus can now be resources. Hurrah! All the calls InsertMItem2, SetMenuTitle2,
0119 554A              * SetMItem2, and SetMItemName2 are now complete. Still need NewMenuBar2 call.
0120 554A              *
0121 554A              * 18 Nov 88         Harry Yee
0122 554A              *
0123 554A              * NewMenuBar2 has now been implemented.
0124 554A              *
0125 554A              * 23 Nov 88         Harry Yee
0126 554A              *
0127 554A              * The routines DrawPopup and PopUpMenuSelect were not unlocking the handle to the menu record
0128 554A              * upon exit. I now unlocke before exiting.
0129 554A              * DrawPopUp has been modified so that it now right justifies the result if the
0130 554A              * FRightJustifyResult bit was set in whatToDoFlag.
0131 554A              *
0132 554A              * I now use PPToPort to draw the up/down arrows instead of DrawIcon, so I now no longer depend
0133 554A              * on QDAux to be started. (BRC #37822)
0134 554A              *
0135 554A              * 29 Nov 88         Harry Yee
0136 554A              *
0137 554A              * Change PopUpMenuSelect so that the initial value passed is the item's ID instead of an offset
0138 554A              * into the item list (BRC #38519)
0139 554A              *
0140 554A              * In PopUpMenuSelect, if an invalid item ID is passed for the initial then an error is now
0141 554A              * returned (BRC #38521, #38520)
0142 554A              *
0143 554A              * Fixed problem in routine adjustTop. (WorkSheet #BCORMR518)
0144 554A              *
0145 554A              * 01 Dec 88         Harry Yee
0146 554A              *
0147 554A              * Empty menus are now valid. (BRC #38523) The routine parse was changed to check if the first
0148 554A              * character in the first item is a title character, if it is then I assume the menu is empty.
0149 554A              * (since this char. is not a valid item character and it equals the title char. then this
0150 554A              * signifies a termination char.)  InsertMItem was also modified to support empty menus. It always
0151 554A              * checked to make sure that an item could be found for the insertAfter id passed to it. Since
0152 554A              * the menu was empty none could be found and we exited. I now check if the menu is empty first.
0153 554A              *
0154 554A              * 02 Dec 88         Harry Yee
0155 554A              *
0156 554A              * Change the way I handle a bad initial value passed to the pop-up. If the item ID is invalid then
0157 554A              * the item that appears under the pop-up defaults to the first item in the menu. (BRC #38521,
0158 554A              * #38520)
0159 554A              *
0160 554A              * PopUpMenuSelect has been modified to work for empty pop-up menus.
0161 554A              *
0162 554A              * 05 Dec 88         Harry Yee
0163 554A              *
0164 554A              * Change GetMItem back to the way it was before (just return what is in ItemName). I used to check
0165 554A              * the itemFlag, and if it was a resource I would load the resource, deref the handle and
0166 554A              * return the ptr to the string. If it's a resource I now just return the ID and let the
0167 554A              * app worry about what to do with it.
0168 554A              *
0169 554A              * DeleteMItem wasn't working right for empty menus. Fixed in routine Getiptr3.
0170 554A              *
0171 554A              * 08 Dec 88         Harry Yee
0172 554A              *
0173 554A              * Putting in variable speed scroller. First 5 pixels of each up/down arrow will scroll at about
0174 554A              * .3 seconds per item.
0175 554A              *
0176 554A              * Fixed BRC #37987. FixMenuBar now computes the width of the apple logo correctly if it gets
0177 554A              * zeroed by calling SetMTitleWidth.
0178 554A              *
0179 554A              * Changed the default menu bar template so that the first menu in the menubar is indented
0180 554A              * by 10 pixels. This is so the AppleShare "busy" arrows have somewhere to go.
0181 554A              *
0182 554A              * 09 Dec 88         Harry Yee
0183 554A              *
0184 554A              * SetMItemStyle doesn't handle shadow and outline styles correctly. Fixed (BRC #39324)
0185 554A              *
0186 554A              * Fixed problem with drawing up/down arrows in 320 mode. Was using the 640
0187 554A              * boundsrect and locinfo instead of the 320 one. This has been fixed.
0188 554A              *
0189 554A              * 12 Dec 88         Harry Yee
0190 554A              *
0191 554A              * Fix GetItem to return ITEM_NOT_FOUND error if item not found. (for Andy Stadler)
0192 554A              * Changed the pen mode to notBIC when calling PPToPort to draw up/down arrows, so these
0193 554A              * arrows show up correctly when the menu is in color.
0194 554A              *
0195 554A              * 15 Dec 88         Harry Yee
0196 554A              *
0197 554A              * Put in code for user to create a second type of pop-up (with white space). PopUpMenuSelect
0198 554A              * had to be changed. Another input param has been added, a flag parameter.
0199 554A              *
0200 554A              * Popups now handle command key equivalents (all handled in popupproc.asm).
0201 554A              *
0202 554A              * Drop shadow for menus (popups and regular menus) were not being drawn in the color that
0203 554A              * the app had specified as the outline color if the _SpecialRect call completed. This was
0204 554A              * because the setoutline routine was called only when SpecialRect failed.
0205 554A              *
0206 554A              * 22 Dec 88
0207 554A              *
0208 554A              * Fixed some problems with creating type 2 pop-ups. When 1st item was selected and pop-up
0209 554A              * was down near bottom of screen we had problems.
0210 554A              *
0211 554A              * Defined another bit in the menu flag. Bit 8 is defined as the ALWAYSCALLMCHOOSE flag.
0212 554A              * Change put in for Andy Stadler for doing tear off menus. When set the custom menu def proc
0213 554A              * mChoose gets called even when the mouse is not in the menu rectangle. (It sends off the
0214 554A              * last draw message,if there is one, before calling mChoose).
0215 554A              *
0216 554A              * 03 Jan 89         Dan O.
0217 554A              *
0218 554A              * Choose_item did a tdc ora #rect instead of tdc clc adc #rect.  This worked as long as the
0219 554A              * direct page had bits 2-3 clear.
0220 554A              *
0221 554A              * 04 Jan 89         Harry Yee
0222 554A              *
0223 554A              * NewMenuBar now checks what mode we're in before setting the default starting position of the
0224 554A              * first menu title. Titles start at 10 pixels in for 640 mode and 5 pixels in, for 320 mode.
0225 554A              *
0226 554A              * Fixed bug in the type 2 pop-up. The pop-up was not being calculated correctly when the top had
0227 554A              * to be adjusted but not the bottom and the window the pop-up was in was off the screen.
0228 554A              *
0229 554A              * 09 Jan 89         Harry Yee
0230 554A              *
0231 554A              * Keyboard equivalents and check marks will appear in plain text regardless of the style
0232 554A              * of the menu item. BRC #39042, #39444.
0233 554A              *
0234 554A              * 18 Jan 89         Harry Yee
0235 554A              *
0236 554A              * Added two new calls HideMenuBar and ShowMenuBar. Both calls work only on the system menu bar.
0237 554A              * HideMenuBar hides the menu bar by subtracting the menu bar's rect from the desktop, ShowMenuBar
0238 554A              * does the exact opposite, the rect is added to the desktop. This fixes the bug where you
0239 554A              * change the font to a larger one then back to a smaller one.
0240 554A              *
0241 554A              * Changed routine Cache. If a regular pop-up menu extended beyond the top of the screen this
0242 554A              * routine doesn't expect any values to be negative. Therefore if <menurect+y1 is negative
0243 554A              * we use zero instead.
0244 554A              *
0245 554A              * When a large font was used for drawing menus and the menu had command-key equivalents, the width
0246 554A              * of the menu was not being calculated correctly. This was because in size_menu the values added
0247 554A              * to the menu width for an item having a command-key equiv. and a check mark was hard coded. This
0248 554A              * has been changed. The direct page variable Menu_type was never being used previously, I now use
0249 554A              * it to store the width of the widest item in the current font strike. It has been renamed to
0250 554A              * text_width. This value is calculated in MenuNewRes where GetFontInfo is being called.
0251 554A              * BRC #37985.
0252 554A              *
0253 554A              * 20 Jan 89         Harry Yee
0254 554A              *
0255 554A              * Menus in an info bar now work correctly. Changed the way I calculate if a menu needs to scroll
0256 554A              * or not. Before I was just using the PortRect to determine if the menu needed to be resized, now
0257 554A              * I use the intersection between the VisRgn, ClipRgn, and PortRect. BRC #40477.
0258 554A              *
0259 554A              * 27 Jan 89         Harry Yee
0260 554A              *
0261 554A              * Change the way empty menus work. To create an empty menu you now have to terminate the menu with
0262 554A              * either $00 (null character) or $0D (return). The original scheme was to terminate the menu with
0263 554A              * the title character but this caused some problems with an app. (Notes'n'file). BRC #39489.
0264 554A              *
0265 554A              * 29 Jan 89         Harry Yee
0266 554A              *
0267 554A              * Changed DrawPopUp. This routine first clears the current selection in the pop-up rect before
0268 554A              * checking if the itemnum is valid or not. If the selection being made is not valid there is no
0269 554A              * selection in the pop-up's rect. After deleting an item, I now check if the menu is a pop-up
0270 554A              * menu, if it is I check if the item just deleted was the currently selected item, if it is
0271 554A              * I then call SetCtlValue with the value of zero which then clears the selection just deleted
0272 554A              * in the pop-up's rect. BRC #39760.
0273 554A              *
0274 554A              * 30 Jan 89         Harry Yee
0275 554A              *
0276 554A              * Changed HiliteMenu to work with pop-ups.
0277 554A              *
0278 554A              * When caching menus I now switch to the menu manager's pixel map bank instead of going directly to
0279 554A              * bank $E1. This now allows shadowing to be enabled. (J. Mensch's idea)
0280 554A              *
0281 554A              * 01 Feb 89         Harry Yee
0282 554A              *
0283 554A              * Changed PopUpMenuSelect so that the menu's flag is saved upon entering routine and restored upon
0284 554A              * exit. I do this because the flag may need to be altered, the M_CACHE bit needs to be cleared
0285 554A              * and the M_POPUP bit needs to be set for everything to work correctly. (BRC #41040, 41041)
0286 554A              *
0287 554A              * 06 Feb 89         Harry Yee
0288 554A              *
0289 554A              * Changed Draw_Menu routine to set Text Mode to modeForeCopy. This was needed to make menus in
0290 554A              * windows work correctly. When menus are drawn in the Menu Manager's port the text mode is set up
0291 554A              * correctly when the port is first initialized, but for menus in windows this is not the case.
0292 554A              * (BRC #40708)
0293 554A              *
0294 554A              * 07 Feb 89         Harry Yee
0295 554A              *
0296 554A              * Changed DeleteMenu, to first release the cache for the menu being deleted and also freeing
0297 554A              * all the caches once the menu is deleted since the position of the menus may now be out of
0298 554A              * order. InsertMenu now also free's all the caches for this same reason.
0299 554A              *
0300 554A              * GetColor now checks if the ctlColor field is zero or not, if it is then the default color table
0301 554A              * is used. SetBarColors also checks this field and if it's zero then it doesn't do anything.
0302 554A              *
0303 554A              * 22 Feb 89         Harry Yee
0304 554A              *
0305 554A              * Fix some problems with FixMenuBar and HideMenuBar. It was doing far too much making it very
0306 554A              * slow if there were windows open. RefreshDesktop is no longer being called for ShowMenuBar and
0307 554A              * for HideMenuBar the whole screen is no longer being refreshed, only the rect for the menubar
0308 554A              * being hidden. Also initPalette is called after the menu is drawn.
0309 554A              *
0310 554A              * 24 Feb 89         Harry Yee
0311 554A              *
0312 554A              * I used to use MaxWidth to determine how much to add to the width of a menu item if it had
0313 554A              * a check mark and a command key equivalent. This caused problems for AppleWorks GS which
0314 554A              * installed their own font with one very very wide char. I now use the character 'W' out of
0315 554A              * currently installed font strike as my MaxWidth char. BRC #41164, 41415
0316 554A              *
0317 554A              * A menu in a window would have problems when, 1) the window was off the left side of the
0318 554A              * screen and 2) the menu title was visible but the width of the menu was greater than
0319 554A              * the right side of the window minus the left side of the screen. Fixed. BRC #41440
0320 554A              *
0321 554A              * 15 Mar 89         Harry Yee
0322 554A              *
0323 554A              * Removing DrawPopUp call. This makes the pop-up defproc easier to maintain.
0324 554A              *
0325 554A              * 27 Mar 89         Harry Yee
0326 554A              *
0327 554A              * I now restore original foreground color in routine draw_title.
0328 554A              *
0329 554A              * 30 Mar 89         Mensch/Yee
0330 554A              *
0331 554A              * Changed GetColor to make it work with pop-up color tables that reference handle/resources.
0332 554A              *
0333 554A              * We now save and restore all grafport shit in PopUpMenuSelect (two new routines PushPortData
0334 554A              * and PopPortData).
0335 554A              *
0336 554A              * 04 Apr 89         Yee
0337 554A              *
0338 554A              * Make PopUpMenuSelect scrambler proof. The menu bar's handle was not getting locked
0339 554A              * when it should. Fixed.
0340 554A              *
0341 554A              * 06 Apr 89         Yee
0342 554A              *
0343 554A              * When drawing a popup or regular menu title, the text mode is set to fore copy. I now
0344 554A              * save and restore the original text mode once I am done drawing the title.
0345 554A              *
0346 554A              * 19 Apr 89         Mensch/Yee
0347 554A              *
0348 554A              * Fixed bug in menu caching that cause a bad left mask to be used for re-blitting a chached
0349 554A              * menu. Was using the <X> register to save the screen mode, this was being trashed by the
0350 554A              * routine before it was used again. We now use <Y> save screen mode. BRC#36702
0351 554A              *
0352 554A              * Also, Tidbits (the fine routine to reblit the corners) now does the top 4 lines of a menu
0353 554A              * instead of 3 ( the drop shadow was 1 pixel lower than tidbits saved)
0354 554A              *
0355 554A              * 24 Apr 89         Glass/Mensch/Yee (on the Eve of freezing the ROM)
0356 554A              *
0357 554A              * In routine Draw_Title we now check whether we're in the menu manager's port before
0358 554A              * deciding not to save the fore color and text mode we just changed. This fixes a problem
0359 554A              * in Word Perfect that was depending on the menu manager's port to be set up correctly.
0360 554A              *
0361 554A              * 15 May 89         Yee
0362 554A              *
0363 554A              * Memory was being trashed when a menu extended below the screen. In routine Cache I now
0364 554A              * check to make sure y2 is never greater than 200. This is so the height of the menu
0365 554A              * never extends past the bottom of the screen and we'll restore the menu just fine.
0366 554A              * BRC #49085.
0367 554A              *
0368 554A              * The routines DrawDwnArrow/DrawUpArrow needed RECT to be setup. There was an instance
0369 554A              * that RECT was not being setup. This caused garbage to be drawn on the screen in those
0370 554A              * instances. Now I make sure RECT is setup.
0371 554A              *
0372 554A              * 19 May 89         Yee                 (for system disk d23)
0373 554A              *
0374 554A              * Calling HiliteMenu with an ID of 0 or $FFFF is not valid. ToolBox Reference manual
0375 554A              * says that these IDs mean first and last menu in menubar respectively.
0376 554A              *
0377 554A              * 23 May 89         Yee                 (for system disk d24)
0378 554A              *
0379 554A              * Take out above fix because some apps were actually creating menus with an ID
0380 554A              * of zero.
0381 554A              *
0382 554A              * 25 May 89         Yee
0383 554A              *
0384 554A              * Fix routine freecache. This routine never did dispose of the menu cache correctly.
0385 554A              *
0386 554A              * When this routine was fixed it uncovered a bug in routine pullup, which only affected
0387 554A              * a menu if it was scrollable and only if someone had scrolled it. I was disposing of
0388 554A              * the cache (i.e. calling freecache) before it was getting uncached. Therefore when
0389 554A              * we tried to restore what was behind the menu the cache was already gone.
0390 554A              *
0391 554A              * 07 Sep 89         Yee
0392 554A              *
0393 554A              * Fix bug in NewMenuBar2. The resource ID is not being copied into a temporary location
0394 554A              * correctly. Only the low word is being stored to. This causes problems when we use
0395 554A              * this temp location to release the menubar resource. Either the menubar resource is
0396 554A              * not released at all (whenever high word of resource ID is zero, or the call crashes
0397 554A              * whenever the high word of resource ID is non-zero.)
0398 554A              *
0399 554A              ***********************************************************************************
0400 554A                       blanks off 
0401 554A                       string asis 
0402 554A
0403 554A                       print push 
0404 554A                       print off 
0405 554A
0406 554A                       include 'all.macros' 
0407 554A
0408 554A                       INCLUDE 'e16.qdaux' 
0409 554A                       INCLUDE 'e16.resources' 
0410 554A
0411 554A                       print pop 
0412 554A
0413 554A                       include 'MenuEquates.asm' 
0414 554A
0415 554A              ;-----------------------------------------------
0416 554A              ;
0417 554A              ;   Imported addresses from WCM.Lib
0418 554A              ;
0419 554A              ;-----------------------------------------------
0420 554A                       IMPORT pushDpage
0421 554A                       IMPORT pushDlong
0422 554A                       IMPORT allocate2
0423 554A                       IMPORT allocate3
0424 554A                       IMPORT startup
0425 554A                       IMPORT Epop0bytes
0426 554A                       IMPORT Epop2bytes
0427 554A                       IMPORT Epop4bytes
0428 554A                       IMPORT Epop6bytes
0429 554A                       IMPORT Epop8bytes
0430 554A                       IMPORT Epop10bytes
0431 554A                       IMPORT Epop12bytes
0432 554A                       IMPORT Epop14bytes
0433 554A                       IMPORT Epop16bytes
0434 554A                       IMPORT Epop18bytes
0435 554A                       IMPORT Epop26bytes
0436 554A                       IMPORT Epop32bytes
0437 554A
0438 554A                       import pop0bytes
0439 554A                       import pop2bytes
0440 554A                       import pop4bytes
0441 554A                       import pop6bytes
0442 554A                       import pop8bytes
0443 554A                       import pop10bytes
0444 554A                       import pop12bytes
0445 554A                       import pop14bytes
0446 554A                       import pop16bytes
0447 554A                       import pop18bytes
0448 554A                       import pop26bytes
0449 554A                       import pop32bytes
0450 554A
0451 554A                       import GetPopUpDefProc
0452 554A
0453 554A              ;-----------------------------------------------
0454 554A              ;
0455 554A              ;   Forward addresses and entries
0456 554A              ;
0457 554A              ;-----------------------------------------------
0458 554A                       ENTRY GetMenuMgrPort
0459 554A                       ENTRY InitPalette
0460 554A                       ENTRY MenuBootInit
0461 554A                       ENTRY MenuGlobal
0462 554A                       ENTRY MenuNewRes
0463 554A                       ENTRY MenuReset
0464 554A                       ENTRY MenuShutDown
0465 554A                       ENTRY MenuStartup
0466 554A                       ENTRY MenuStatus
0467 554A                       ENTRY MenuVersion
0468 554A                       ENTRY NewMenu
0469 554A                       ENTRY Reserved
0470 554A                       ENTRY clearWAP
0471 554A                       ENTRY initres
0472 554A
0473 554A                       ENTRY MENUKEY
0474 554A                       ENTRY GETMENUBAR
0475 554A                       ENTRY MENUREFRESH
0476 554A                       ENTRY FLASHMENUBAR
0477 554A                       ENTRY INSERTMENU
0478 554A                       ENTRY DELETEMENU
0479 554A                       ENTRY GETSYSBAR
0480 554A                       ENTRY SETSYSBAR
0481 554A                       ENTRY FIXMENUBAR
0482 554A                       ENTRY COUNTMITEMS
0483 554A                       ENTRY NEWMENUBAR
0484 554A                       ENTRY GETMHANDLE
0485 554A                       ENTRY SETBARCOLORS
0486 554A                       ENTRY GETBARCOLORS
0487 554A                       ENTRY SETMTITLESTART
0488 554A                       ENTRY GETMTITLESTART
0489 554A                       ENTRY CALCMENUSIZE
0490 554A                       ENTRY SETMTITLEWIDTH
0491 554A                       ENTRY GETMTITLEWIDTH
0492 554A                       ENTRY SETMENUFLAG
0493 554A                       ENTRY GETMENUFLAG
0494 554A                       ENTRY SETMENUTITLE
0495 554A                       ENTRY GETMENUTITLE
0496 554A                       ENTRY SETMITEM
0497 554A                       ENTRY GETITEM
0498 554A                       ENTRY SETMITEMFLAG
0499 554A                       ENTRY GETITEMFLAG
0500 554A                       ENTRY SETITEMBLINK
0501 554A                       ENTRY DRAWMENUBAR
0502 554A                       ENTRY MENUSELECT
0503 554A                       ENTRY HILITEMENU
0504 554A                       ENTRY DISPOSEMENU
0505 554A                       ENTRY ENABLEMITEM
0506 554A                       ENTRY DISABLEMITEM
0507 554A                       ENTRY CHECKMITEM
0508 554A                       ENTRY SETMITEMMARK
0509 554A                       ENTRY INSERTMITEM
0510 554A                       ENTRY DELETEMITEM
0511 554A                       ENTRY GETITEMMARK
0512 554A                       ENTRY SETMITEMSTYLE
0513 554A                       ENTRY GETITEMSTYLE
0514 554A                       ENTRY SETMENUID
0515 554A                       ENTRY SETITEMID
0516 554A                       ENTRY SETMENUBAR
0517 554A                       ENTRY SETMITEMNAME
0518 554A                       ENTRY ENDINITRAM
0519 554A                       ENTRY STARTINITRAM
0520 554A                       ENTRY DefColorTable
0521 554A                       ENTRY SYS_CURRENT
0522 554A                       ENTRY LOCKMENUBAR
0523 554A                       ENTRY CLOSEMENUPORT
0524 554A                       ENTRY EVERYCACHEFREE
0525 554A                       ENTRY UNLOCKMENUBAR
0526 554A                       ENTRY SAVE_PORT
0527 554A                       ENTRY PUSHPORT
0528 554A                       ENTRY PUSHSCINFO1
0529 554A                       ENTRY PUSHDEFBARRECT
0530 554A                       ENTRY TO_UPORT
0531 554A                       ENTRY SCANBYTE
0532 554A                       ENTRY PUSHCOLORTABLE
0533 554A                       ENTRY LOGOCOLOR
0534 554A                       ENTRY MAKE_BLOCK
0535 554A                       ENTRY LOCKMENUHAND
0536 554A                       ENTRY DEREFMENUHAND
0537 554A                       ENTRY UNLOCKMENUHAND
0538 554A                       ENTRY NEXT_ITEM
0539 554A                       ENTRY PUSHDEFMENU
0540 554A                       ENTRY PUSHDATA
0541 554A                       ENTRY TO_MYPORT
0542 554A                       ENTRY GETCOLOR
0543 554A                       ENTRY SETOUTLINE
0544 554A                       ENTRY DRAWRECT
0545 554A                       ENTRY GETMFIRST
0546 554A                       ENTRY NEXT_MENU
0547 554A                       ENTRY GETMPTR
0548 554A                       ENTRY TITLEXSTART
0549 554A                       ENTRY DISPATCH
0550 554A                       ENTRY GETMEVENT
0551 554A                       ENTRY ONBAR
0552 554A                       ENTRY PULL_DOWN
0553 554A                       ENTRY PULLUP
0554 554A                       ENTRY PUSHYRAT
0555 554A                       ENTRY PUSHMRECT
0556 554A                       ENTRY GET_IDS
0557 554A                       ENTRY GETIFIRST
0558 554A                       ENTRY PUSHCOLOR
0559 554A                       ENTRY ALLOCATECACHE
0560 554A                       ENTRY FREECACHE
0561 554A                       ENTRY MAKECACHE
0562 554A                       ENTRY CACHE
0563 554A                       ENTRY PUSHCOLOR2
0564 554A                       ENTRY UNCACHE
0565 554A                       ENTRY LONG_CALL
0566 554A                       ENTRY DRAW_MENU
0567 554A                       ENTRY CHOOSE_ITEM
0568 554A                       ENTRY SIZE_MENU
0569 554A                       ENTRY DRAW_TITLE
0570 554A                       ENTRY DRAW_ITEM
0571 554A                       ENTRY GET_ITEMID
0572 554A                       ENTRY CALCITEM
0573 554A                       ENTRY GETITEMH
0574 554A                       ENTRY TEXT_GUTS
0575 554A                       ENTRY GETISTRG
0576 554A                       ENTRY GET_APPLE
0577 554A                       ENTRY PRINTSTRG
0578 554A                       ENTRY color_patt
0579 554A                       ENTRY DIMMED
0580 554A                       ENTRY NOR_MASK
0581 554A                       ENTRY PUSHRECT
0582 554A                       ENTRY PUSHMARK
0583 554A                       ENTRY PUSHCOM_KEY
0584 554A                       ENTRY HLINE
0585 554A                       ENTRY GETIPTR2
0586 554A                       ENTRY INTO_BLOCK
0587 554A                       ENTRY GETIPTR
0588 554A                       ENTRY GROWBLOCK
0589 554A                       ENTRY EVERYCACHEBAD
0590 554A                       ENTRY BADCACHE
0591 554A                       ENTRY _320_MASK
0592 554A                       ENTRY _320_DATA
0593 554A                       ENTRY _640_MASK
0594 554A                       ENTRY _640_DATA
0595 554A                       ENTRY JustifyLeft
0596 554A                       ENTRY JustifyRight
0597 554A
0598 554A                       ENTRY FixTextFace
0599 554A                       ENTRY ClearTextFace
0600 554A                       ENTRY CheckForScrolling
0601 554A                       ENTRY CheckBounds
0602 554A                       ENTRY GetStarting
0603 554A                       ENTRY ResetThings
0604 554A                       ENTRY UpArrowIcon
0605 554A                       ENTRY DownArrowIcon
0606 554A                       ENTRY DrawUpArrow
0607 554A                       ENTRY DrawDwnArrow
0608 554A                       ENTRY AdjustBottom
0609 554A                       ENTRY AdjustTop
0610 554A                       ENTRY InitStuff
0611 554A                       ENTRY AdjustRect
0612 554A                       ENTRY Pull_Down2
0613 554A                       ENTRY TrackMenu2
0614 554A                       ENTRY GetrMenuTitle
0615 554A                       ENTRY GetrItemName
0616 554A                       ENTRY LoadnRelease
0617 554A                       ENTRY FillItemRec
0618 554A                       ENTRY UpArrowLocInfo640
0619 554A                       ENTRY UpArrowLocInfo320
0620 554A                       ENTRY UpArrowBounds640
0621 554A                       ENTRY UpArrowBounds320
0622 554A                       ENTRY DownArrowLocInfo640
0623 554A                       ENTRY DownArrowLocInfo320
0624 554A                       ENTRY DownArrowBounds640
0625 554A                       ENTRY DownArrowBounds320
0626 554A                       ENTRY CommonInsert
0627 554A                       ENTRY GetResMTitle
0628 554A                       ENTRY PopupMenuSelect
0629 554A                       ENTRY NewMenu2
0630 554A                       ENTRY InsertMItem2
0631 554A                       ENTRY SetMenuTitle2
0632 554A                       ENTRY SetMItem2
0633 554A                       ENTRY SetMItemName2
0634 554A                       ENTRY NewMenuBar2
0635 554A                       ENTRY PushSmearLow
0636 554A                       ENTRY SaveColor
0637 554A                       ENTRY RestoreColor
0638 554A                       ENTRY doWhiteSpace
0639 554A                       ENTRY addToTop
0640 554A                       ENTRY addToBottom
0641 554A                       ENTRY NeverMind
0642 554A                       ENTRY HideMenuBar
0643 554A                       ENTRY ShowMenuBar
0644 554A                       ENTRY AddorSubRegion
0645 554A                       ENTRY Hole
0646 554A
0647 554A              ;===========================================================================
0648 554A              ;          Menu Manager function table.
0649 554A              ;===========================================================================
0650 554A              MenuCallTable PROC EXPORT
0651 554A
0652 554A                       ENTRY FPT
0653 554A 47 00        FPT      DC W:(ENDFPT-FPT)/4
0654 554C 00 00                 DC W:0
0655 554E 76 57 FD 00           DC L:MenuBootInit-1            $010F
0656 5552 66 56 FD 00           DC L:MenuStartup-1             $020F
0657 5556 81 57 FD 00           DC L:MenuShutDown-1            $030F
0658 555A 93 59 FD 00           DC L:MenuVersion-1             $040F
0659 555E 7B 57 FD 00           DC L:MenuReset-1               $050F
0660 5562 6E 57 FD 00           DC L:MenuStatus-1              $060F
0661 5566 76 57 FD 00           DC L:Reserved-1                $070F
0662 556A 76 57 FD 00           DC L:Reserved-1                $080F
0663 556E 37 6C FD 00           DC L:MenuKey-1                 $090F
0664 5572 8B 77 FD 00           DC L:GetMenuBar-1              $0A0F
0665 5576 D2 6C FD 00           DC L:MenuRefresh-1             $0B0F
0666 557A D6 61 FD 00           DC L:FlashMenuBar-1            $0C0F
0667 557E E1 75 FD 00           DC L:InsertMenu-1              $0D0F
0668 5582 D6 76 FD 00           DC L:DeleteMenu-1              $0E0F
0669 5586 63 75 FD 00           DC L:InsertMItem-1             $0F0F
0670 558A 4E 76 FD 00           DC L:DeleteMItem-1             $100F
0671 558E 66 77 FD 00           DC L:GetSysBar-1               $110F
0672 5592 74 77 FD 00           DC L:SetSysBar-1               $120F
0673 5596 67 74 FD 00           DC L:FixMenuBar-1              $130F
0674 559A 99 77 FD 00           DC L:CountMItems-1             $140F
0675 559E 77 5F FD 00           DC L:NewMenuBar-1              $150F
0676 55A2 4E 78 FD 00           DC L:GetMHandle-1              $160F
0677 55A6 C5 77 FD 00           DC L:SetBarColors-1            $170F
0678 55AA FD 77 FD 00           DC L:GetBarColors-1            $180F
0679 55AE 19 78 FD 00           DC L:SetMTitleStart-1          $190F
0680 55B2 36 78 FD 00           DC L:GetMTitleStart-1          $1A0F
0681 55B6 9B 59 FD 00           DC L:GetMenuMgrPort-1          $1B0F
0682 55BA E5 74 FD 00           DC L:CalcMenuSize-1            $1C0F
0683 55BE 82 78 FD 00           DC L:SetMTitleWidth-1          $1D0F
0684 55C2 A1 78 FD 00           DC L:GetMTitleWidth-1          $1E0F
0685 55C6 BD 78 FD 00           DC L:SetMenuFlag-1             $1F0F
0686 55CA E4 78 FD 00           DC L:GetMenuFlag-1             $200F
0687 55CE 5C 79 FD 00           DC L:SetMenuTitle-1            $210F
0688 55D2 9C 79 FD 00           DC L:GetMenuTitle-1            $220F
0689 55D6 2E 58 FD 00           DC L:MenuGlobal-1              $230F	;Added 2/18/87
0690 55DA 8A 7A FD 00           DC L:SetMItem-1                $240F
0691 55DE C3 7A FD 00           DC L:GetItem-1                 $250F
0692 55E2 D3 7B FD 00           DC L:SetMItemFlag-1            $260F
0693 55E6 50 7C FD 00           DC L:GetItemFlag-1             $270F
0694 55EA 6C 7C FD 00           DC L:SetItemBlink-1            $280F
0695 55EE EA 57 FD 00           DC L:MenuNewRes-1              $290F
0696 55F2 2E 60 FD 00           DC L:DrawMenuBar-1             $2A0F
0697 55F6 BE 6B FD 00           DC L:MenuSelect-1              $2B0F
0698 55FA 57 61 FD 00           DC L:HiliteMenu-1              $2C0F
0699 55FE E4 5B FD 00           DC L:NewMenu-1                 $2D0F
0700 5602 0B 5E FD 00           DC L:DisposeMenu-1             $2E0F
0701 5606 2D 59 FD 00           DC L:InitPalette-1             $2F0F
0702 560A 61 7B FD 00           DC L:EnableMItem-1             $300F
0703 560E 75 7B FD 00           DC L:DisableMItem-1            $310F
0704 5612 FA 7B FD 00           DC L:CheckMItem-1              $320F
0705 5616 0D 7C FD 00           DC L:SetMItemMark-1            $330F
0706 561A 31 7C FD 00           DC L:GetItemMark-1             $340F
0707 561E 7D 7B FD 00           DC L:SetMItemStyle-1           $350F
0708 5622 AA 7B FD 00           DC L:GetItemStyle-1            $360F
0709 5626 69 78 FD 00           DC L:SetMenuID-1               $370F
0710 562A F8 79 FD 00           DC L:SetItemID-1               $380F
0711 562E 82 77 FD 00           DC L:SetMenuBar-1              $390F
0712 5632 32 7B FD 00           DC L:SetMItemName-1            $3A0F
0713 5636
0714 5636              ******* Adding new calls for System Disk 4.1 ******************************
0715 5636
0716 5636 D1 89 FD 00           DC L:GetPopUpDefProc-1         $3B0F
0717 563A BE 68 FD 00           DC L:PopUpMenuSelect-1         $3C0F
0718 563E 65 56 FD 00           DC L:Hole-1                    $3D0F 	;used to be DrawPopUp call
0719 5642 AA 59 FD 00           DC L:NewMenu2-1                $3E0F
0720 5646
0721 5646 39 75 FD 00           DC L:InsertMItem2-1            $3F0F
0722 564A 00 79 FD 00           DC L:SetMenuTitle2-1           $400F
0723 564E 11 7A FD 00           DC L:SetMItem2-1               $410F
0724 5652 EE 7A FD 00           DC L:SetMItemName2-1           $420F
0725 5656 1F 5E FD 00           DC L:NewMenuBar2-1             $430F
0726 565A
0727 565A 44 5B FD 00           DC L:GetResMTitle-1            $440F
0728 565E 8A 60 FD 00           DC L:HideMenuBar-1             $450F
0729 5662 D9 60 FD 00           DC L:ShowMenuBar-1             $460F
0730 5666              ENDFPT    
0731 5666                       ENDP 
0732 5666
0733 5666              ;===========================================================================
0734 5666              ;                   Hole
0735 5666              ;===========================================================================
0736 5666              Hole     PROC 
0737 5666
0738 5666 6B                    rtl   
0739 5667
0740 5667                       ENDP 
0741 5667
0742 5667
0743 5667              ;===========================================================================
0744 5667              ;
0745 5667              ;                   MenuStartup
0746 5667              ;
0747 5667              ;                   Initialize Menu Manager
0748 5667              ;
0749 5667              ;  IN:     PUSH:WORD - ID to use.
0750 5667              ;          PUSH:WORD - zero page number to use.
0751 5667              ;
0752 5667              ; OUT:     Nothing.
0753 5667              ;
0754 5667              ;===========================================================================
0755 5667              MenuStartup PROC 
0756 5667                       import SelfMod1Low
0757 5667                       import SelfMod1High
0758 5667                       import SelfMod2
0759 5667
0760 5667              TheReturnAddr equ   1                   Stack offset before setup called.
0761 5667              directPage equ   TheReturnAddr+6
0762 5667
0763 5667              newZero  equ   input                    Stack offset after setup called.
0764 5667              newID    equ   newZero+2
0765 5667
0766 5667
0767 5667 C9 00 00              cmp   #0                       Has the Menu Manager already been started?
0768 566A F0 0C                 beq   ok1
0769 566C
0770 566C 22 64 00 E1           jsl   IncBusyFlg
0771 5670 A0 01 0F              ldy   #MENU_STARTED            Return error code.
0772 5673 0B                    phd   
0773 5674 8B                    phb   
0774 5675 82 3E 39              brl   Epop4bytes
0775 5678
0776 5678 A3 07        ok1      lda   directPage,s             Get direct page to use.
0777 567A 20 97 8F              jsr   startup                  Do startup initialization for tool call.
0778 567D
0779 567D F4 00 00              pea   0                        Tell Tool Locator about zero page.
0780 5680 F4 0F 00              pea   MenuToolNum              Tool number.
0781 5683 F4 00 00              pea   0
0782 5686 0B                    phd                            Zero page number.
0783 5687 A2 01 0D 22           _SetWAP 
0784 568E
0785 568E A2 FE 00              ldx   #$00FE                   Clear my direct page.
0786 5691 74 00        lop10    stz   $00,x
0787 5693 CA                    dex   
0788 5694 10 FB                 bpl   lop10
0789 5696
0790 5696 A3 0C                 lda   newID,s
0791 5698 85 06                 sta   <MyID
0792 569A
0793 569A              ;
0794 569A              ; --- Allocate and initialize RAM data area -----------------
0795 569A              ;
0796 569A A4 06                 ldy   <MyID                    Pass ID to use.
0797 569C A9 DB 01              lda   #RAMSIZE                 Pass number of bytes to allocate.
0798 569F 20 7F 8F              jsr   allocate2                Allocate a fixed RAM area.
0799 56A2 85 00                 sta   <data                    Store handle to data area.
0800 56A4 86 02                 stx   <data+2
0801 56A6 A0 02 00              ldy   #2                       Dereference data area.
0802 56A9 B7 00                 lda   [<data],y
0803 56AB A8                    tay   
0804 56AC A7 00                 lda   [<data]
0805 56AE 85 00                 sta   <data                    Store pointer to data area.
0806 56B0 84 02                 sty   <data+2
0807 56B2
0808 56B2 E2 20                 sep   #$20
0809 56B4                       longa off
0810 56B4
0811 56B4 A0 DA 01              ldy   #RAMSIZE-1
0812 56B7 A9 00                 lda   #0
0813 56B9 97 00        lop2     sta   [<data],y
0814 56BB 88                    dey   
0815 56BC C0 74 00              cpy   #(endInitRAM-startInitRAM)-1
0816 56BF D0 F8                 bne   lop2
0817 56C1
0818 56C1 B9 D2 84     lop3     lda   startInitRAM,y
0819 56C4 97 00                 sta   [<data],y
0820 56C6 88                    dey   
0821 56C7 10 F8                 bpl   lop3
0822 56C9
0823 56C9 C2 20                 rep   #$20
0824 56CB                       longa on
0825 56CB
0826 56CB A2 10 00              ldx   #16
0827 56CE BD 4B 57     lop5     lda   RAMpatch,x               Compute address, direct page or data area?
0828 56D1 10 0E                 bpl   ok5
0829 56D3
0830 56D3 29 FF 7F              and   #$7FFF                   Compute address in direct page.
0831 56D6 48                    pha   
0832 56D7 7B                    tdc   
0833 56D8 18                    clc   
0834 56D9 63 01                 adc   1,s
0835 56DB 7A                    ply   
0836 56DC A0 00 00              ldy   #0
0837 56DF 80 0B                 bra   store5
0838 56E1
0839 56E1 A4 02        ok5      ldy   <data+2                  Compute address in data area.
0840 56E3 A5 00                 lda   <data
0841 56E5 18                    clc   
0842 56E6 7D 4B 57              adc   RAMpatch,x
0843 56E9 90 01                 bcc   store5
0844 56EB C8                    iny   
0845 56EC
0846 56EC 5A           store5   phy                            Save address.
0847 56ED 48                    pha   
0848 56EE
0849 56EE BD 5D 57              lda   RAMoffset,x              Get offset to variable to be patched.
0850 56F1 10 10                 bpl   ok6                      Is patch in direct page or data area?
0851 56F3
0852 56F3 86 EA                 stx   <work                    Patch in direct page.
0853 56F5 29 FF 7F              and   #$7FFF
0854 56F8 AA                    tax   
0855 56F9 68                    pla   
0856 56FA 95 00                 sta   <0,x
0857 56FC 68                    pla   
0858 56FD 95 02                 sta   <2,x
0859 56FF A6 EA                 ldx   <work
0860 5701 80 09                 bra   next5
0861 5703
0862 5703 A8           ok6      tay                            Patch in data area.
0863 5704 68                    pla   
0864 5705 97 00                 sta   [<data],y
0865 5707 C8                    iny   
0866 5708 C8                    iny   
0867 5709 68                    pla   
0868 570A 97 00                 sta   [<data],y
0869 570C
0870 570C CA           next5    dex   
0871 570D CA                    dex   
0872 570E 10 BE                 bpl   lop5
0873 5710
0874 5710              ;
0875 5710              ; --- Other initialization ----------------------------------
0876 5710              ;
0877 5710 48                    pha                            Space for result.
0878 5711 48                    pha   
0879 5712 F4 01 00              pea   1                        Get pointer to address table command.
0880 5715 A2 04 09 22           _GetAddress 
0881 571C 68                    pla                            Get table of scan line addresses.
0882 571D 85 CC                 sta   <lineTable
0883 571F 68                    pla   
0884 5720 85 CE                 sta   <lineTable+2
0885 5722
0886 5722 20 43 58              jsr   initres                  Make resolution dependent inits.
0887 5725
0888 5725 A9 03 00              lda   #3                       Number of blinks for selected items.
0889 5728 85 38                 sta   <blink
0890 572A
0891 572A              ;
0892 572A              ; --- Create an empty system menu bar ------------------------
0893 572A              ;
0894 572A 48                    pha                            Space for result.
0895 572B 48                    pha   
0896 572C A9 00 00              lda   #0                       System menu bar.
0897 572F 48                    pha   
0898 5730 48                    pha   
0899 5731 A2 0F 15 22           _NewMenuBar                    Allocate a system menu bar.
0900 5738 68                    pla   
0901 5739 85 08                 sta   <sysmenu                 Save handle.
0902 573B 68                    pla   
0903 573C 85 0A                 sta   <sysmenu+2
0904 573E
0905 573E 20 82 62              jsr   sys_current              Make the system menu bar current.
0906 5741
0907 5741 A2 0F 2A 22           _DrawMenuBar 
0908 5748
0909 5748 82 68 38              brl   pop4bytes                no error
0910 574B
0911 574B              ;
0912 574B              ; --- Table of offsets to address that must be patched ----------------
0913 574B              ;
0914 574B              ;  Set the high bit if the variable to be patched is in direct page.
0915 574B              ;  Clear the high bit if the variable to be patched is in data area.
0916 574B
0917 574B 07 00        RAMpatch DC W:scrnInfo                  0
0918 574D 17 00                 DC W:memInfo                   2
0919 574F C4 80                 DC W:scrnRect+$8000            4
0920 5751 C0 80                 DC W:des_0+$8000               6
0921 5753 17 00                 DC W:memInfo                   8
0922 5755 07 00                 DC W:scrnInfo                  10
0923 5757 1F 00                 DC W:memInfo+BoundsRect        12
0924 5759 BC 80                 DC W:des_y+$8000               14
0925 575B 9B 01                 DC W:image                     16
0926 575D
0927 575D              ;
0928 575D              ; --- Table of offsets to address that must be patched ----------------
0929 575D              ;
0930 575D              ;  Set the high bit if offset into direct page.
0931 575D              ;  Clear the high bit if offset into data area.
0932 575D              ;
0933 575D 70 80        RAMoffset DC W:tomemory+$8000
0934 575F 74 80                 DC W:tomemory+4+$8000
0935 5761 78 80                 DC W:tomemory+8+$8000
0936 5763 7C 80                 DC W:tomemory+12+$8000
0937 5765 86 80                 DC W:toscreen+$8000
0938 5767 8A 80                 DC W:toscreen+4+$8000
0939 5769 8E 80                 DC W:toscreen+8+$8000
0940 576B 92 80                 DC W:toscreen+12+$8000
0941 576D 35 00                 DC W:imageInfo+PixelImage
0942 576F
0943 576F                       ENDP 
0944 576F
0945 576F
0946 576F              ;===========================================================================
0947 576F              ;
0948 576F              ;                   MenuStatus
0949 576F              ;
0950 576F              ;                   Return status of Menu Manager.
0951 576F              ;
0952 576F              ;   IN:    None.
0953 576F              ;
0954 576F              ;  OUT:    WORD - 1 if active, 0 if not active.
0955 576F              ;
0956 576F              ;===========================================================================
0957 576F              MenuStatus PROC 
0958 576F
0959 576F              TheReturnAddr equ   1                   Stack offset before startup called.
0960 576F              result   equ   TheReturnAddr+6
0961 576F
0962 576F AA                    tax   
0963 5770 F0 03                 beq   store
0964 5772 A9 07 00              lda   #7                       Dan O. version number.
0965 5775 83 07        store    sta   result,s                 Return status.
0966 5777
0967 5777
0968 5777              ;================================================================
0969 5777              ;          Boot Initialization code.
0970 5777              ;================================================================
0971 5777                       ENTRY MenuBootInit
0972 5777              MenuBootInit  
0973 5777                       ENTRY Reserved
0974 5777              Reserved  
0975 5777                       ENTRY exitTool
0976 5777              exitTool  
0977 5777
0978 5777 A9 00 00              lda   #0                       No error code.
0979 577A 18                    clc                            No error.
0980 577B
0981 577B 6B                    rtl   
0982 577C
0983 577C                       ENDP 
0984 577C
0985 577C
0986 577C              ;===========================================================================
0987 577C              ;
0988 577C              ;                   MenuReset
0989 577C              ;
0990 577C              ;                   Reset handler.
0991 577C              ;
0992 577C              ;   IN:    None.
0993 577C              ;  OUT:    None.
0994 577C              ;
0995 577C              ;===========================================================================
0996 577C              MenuReset PROC 
0997 577C              ;
0998 577C 20 97 8F              jsr   startup                  Do startup initialization for tool call.
0999 577F 82 56 00              brl   clearWAP
1000 5782
1001 5782                       ENDP 
1002 5782
1003 5782
1004 5782              ;===========================================================================
1005 5782              ;
1006 5782              ;                   MenuShutDown
1007 5782              ;
1008 5782              ;                   ShutDown the Menu Manager.
1009 5782              ;
1010 5782              ; Change History
1011 5782              ;
1012 5782              ; 14 Oct 88         Steven Glass
1013 5782              ;
1014 5782              ; Check to see if active before trying to shutdown.
1015 5782              ;
1016 5782              ;===========================================================================
1017 5782              MenuShutDown PROC 
1018 5782
1019 5782 C9 00 00              cmp   #0                       If the tool is not active, we
1020 5785 D0 02                 bne   @Continue                just get out.
1021 5787
1022 5787 18                    clc   
1023 5788 6B                    rtl   
1024 5789
1025 5789              @Continue  
1026 5789
1027 5789 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1028 578C
1029 578C              ;
1030 578C              ; --- Free all menus in system menu bar --------------------------------
1031 578C              ;
1032 578C A5 09                 lda   <sysMenu+1               Is there a system menu bar?
1033 578E F0 31                 beq   exit3
1034 5790
1035 5790 20 82 62              jsr   sys_current              <barHand = <sysMenu. Current = system.
1036 5793 20 8B 62              jsr   lockMenuBar              Dereference and lock menu bar and menus.
1037 5796              ;                                       <barPtr = (<barHand).
1038 5796
1039 5796 A0 28 00              ldy   #MenuList
1040 5799 B7 14        lop1     lda   [<barptr],y
1041 579B 85 EA                 sta   <work
1042 579D C8                    iny   
1043 579E C8                    iny   
1044 579F B7 14                 lda   [<barptr],y
1045 57A1 AA                    tax   
1046 57A2 C8                    iny   
1047 57A3 C8                    iny   
1048 57A4 05 EA                 ora   <work                    End of menu list?
1049 57A6 F0 0E                 beq   exit2
1050 57A8
1051 57A8 5A                    phy                            Save Y.
1052 57A9
1053 57A9 DA                    phx   
1054 57AA D4 EA                 pei   <work
1055 57AC A2 02 10 22           _DisposeHandle                 Free menu record.
1056 57B3
1057 57B3 7A                    ply   
1058 57B4 80 E3                 bra   lop1
1059 57B6
1060 57B6              ;
1061 57B6              ; --- Free system menu bar ------------------------------------
1062 57B6              ;
1063 57B6 D4 0A        exit2    pei   <sysmenu+2
1064 57B8 D4 08                 pei   <sysmenu
1065 57BA A2 02 10 22           _DisposeHandle                 Free system menu bar.
1066 57C1
1067 57C1              ;
1068 57C1              ; --- Close Menu Manager's port -------------------------------
1069 57C1              ;
1070 57C1 20 A5 7C     exit3    jsr   closeMenuPort            Close Menu Manager's port.
1071 57C4
1072 57C4              ;
1073 57C4              ;
1074 57C4              ; --- Free allocated data area.
1075 57C4              ;
1076 57C4 48                    pha   
1077 57C5 48                    pha   
1078 57C6 D4 02                 pei   <data+2                  Find handle of data area.
1079 57C8 D4 00                 pei   <data
1080 57CA A2 02 1A 22           _FindHandle 
1081 57D1 A2 02 10 22           _DisposeHandle 
1082 57D8              ;
1083 57D8              ;
1084 57D8              ; --- Set work value in Tool Locator to zero ------------------
1085 57D8              ;
1086 57D8                       ENTRY clearWAP
1087 57D8              clearWAP  
1088 57D8 A9 00 00              lda   #0
1089 57DB 48                    pha   
1090 57DC F4 0F 00              pea   MenuToolNum              Pass Menu Manager tool number.
1091 57DF 48                    pha                            Pass new parameter (zero).
1092 57E0 48                    pha   
1093 57E1 A2 01 0D 22           _SetWAP                        Tell Tool Locator about it.
1094 57E8
1095 57E8 82 B8 37              brl   pop0bytes                no error
1096 57EB
1097 57EB                       ENDP 
1098 57EB
1099 57EB
1100 57EB              ;===========================================================================
1101 57EB              ;
1102 57EB              ;                   MenuNewRes
1103 57EB              ;
1104 57EB              ;                   Set up in Screen Resolution.
1105 57EB              ;
1106 57EB              ;   IN:  Nothing.
1107 57EB              ;  OUT:  Nothing.
1108 57EB              ;
1109 57EB              ;===========================================================================
1110 57EB              MenuNewRes PROC 
1111 57EB
1112 57EB 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1113 57EE
1114 57EE              ;
1115 57EE              ; --- Fix current menu bar and redraw --------------------------------------
1116 57EE              ;
1117 57EE A5 09                 lda   <sysMenu+1               Is there a system menu bar?
1118 57F0 F0 3A                 beq   exit
1119 57F2
1120 57F2 20 82 62              jsr   sys_current              <barHand = <sysMenu. Current = system.
1121 57F5 20 8B 62              jsr   lockMenuBar              Dereference and lock menu bar and menus.
1122 57F8              ;                                       <barPtr = (<barHand).
1123 57F8 A0 10 00              ldy   #ctlFlag
1124 57FB B7 14                 lda   [<barptr],y
1125 57FD 29 80 00              and   #$0080                   See if the current system menu bar is visible or not.
1126 5800              ;                                       Since initres tries to subtract menu bar for desktop
1127 5800              ;                                       we only want to do it if it's visible.
1128 5800 85 58                 sta   <temp
1129 5802              ;
1130 5802              ; --- Shut down current graphics mode, start new one up ----------------------
1131 5802              ;
1132 5802 20 A5 7C              jsr   closeMenuPort            Close Menu Manager's port.
1133 5805 20 43 58              jsr   initres                  Reinitialize in new mode.
1134 5808
1135 5808              ;
1136 5808              ; --- Fix current menu bar and redraw --------------------------------------
1137 5808              ;
1138 5808 A5 09                 lda   <sysMenu+1               Is there a system menu bar?
1139 580A F0 20                 beq   exit
1140 580C
1141 580C 20 82 62              jsr   sys_current              <barHand = <sysMenu. Current = system.
1142 580F 20 8B 62              jsr   lockMenuBar              Dereference and lock menu bar and menus.
1143 5812              ;                                       <barPtr = (<barHand).
1144 5812
1145 5812 20 F6 80              jsr   everyCacheFree           Free all caches, size may change.
1146 5815
1147 5815 A9 40 01              lda   #320
1148 5818 A0 0E 00              ldy   #CtlRect+x2
1149 581B A6 46                 ldx   <screenmode              320 or 640 mode?
1150 581D F0 01                 beq   store
1151 581F 0A                    asl   a
1152 5820 97 14        store    sta   [<barptr],y
1153 5822
1154 5822 A2 0F 2A 22           _DrawMenuBar                   Redraw system menu bar.
1155 5829
1156 5829 20 C4 62              jsr   unlockMenuBar            Unlock menu bar and menus.
1157 582C
1158 582C 82 74 37     exit     brl   pop0bytes                no error
1159 582F
1160 582F                       ENDP 
1161 582F
1162 582F
1163 582F              ;===========================================================================
1164 582F              ;
1165 582F              ;                   MenuGlobal
1166 582F              ;
1167 582F              ;                   Get/Set global flag.
1168 582F              ;
1169 582F              ;   IN:    WORD - negative to clear bits, positive to set bits,
1170 582F              ;                 zero to just return current global flag.
1171 582F              ;
1172 582F              ;  OUT:    WORD - global flag after change.
1173 582F              ;
1174 582F              ;===========================================================================
1175 582F              MenuGlobal PROC 
1176 582F
1177 582F              newState equ   input
1178 582F              newFlag  equ   newState+2
1179 582F
1180 582F 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1181 5832
1182 5832 A3 0A                 lda   newState,s               Set or reset bits?
1183 5834 10 04                 bpl   setBits
1184 5836
1185 5836 25 04                 and   <globalFlag
1186 5838 80 02                 bra   exit3
1187 583A
1188 583A 05 04        setBits  ora   <globalFlag
1189 583C 85 04        exit3    sta   <globalFlag
1190 583E 83 0C                 sta   newFlag,s
1191 5840
1192 5840 82 68 37              brl   pop2bytes                no error
1193 5843
1194 5843                       ENDP 
1195 5843
1196 5843
1197 5843              ;===========================================================================
1198 5843              ;
1199 5843              ;                   InitRes
1200 5843              ;
1201 5843              ;                   Resolution dependent initialization.
1202 5843              ;
1203 5843              ;   IN:    <temp = 0 if menu bar visible, 1 if invisible.
1204 5843              ;  OUT:    None.
1205 5843              ;
1206 5843              ;        Resolution should already have been set.
1207 5843              ;
1208 5843              ;===========================================================================
1209 5843              initres  PROC 
1210 5843
1211 5843 20 44 63              jsr   save_port                Save current port.
1212 5846
1213 5846 20 95 7C              jsr   pushport                 Pass pointer to Menu Manager port.
1214 5849 A2 04 18 22           _OpenPort                      Open port for Menu Manager.
1215 5850
1216 5850 F4 04 00              pea   4                        Use OR mode to write text.
1217 5853 A2 04 9C 22           _SetTextMode                   Set text mode.
1218 585A
1219 585A 20 2F 75              jsr   pushscInfo1              Pass pointer to scInfo1.
1220 585D A2 04 1E 22           _GetPortLoc                    Get the parameters of the screen.
1221 5864
1222 5864              ;
1223 5864              ; --- Initialize for 320 mode -------------------------
1224 5864              ;
1225 5864 64 5A                 stz   <vert_pen                Width of vertical lines
1226 5866 E6 5A                 inc   <vert_pen                is one in 320.
1227 5868
1228 5868 64 46                 stz   <screenmode
1229 586A A9 00 00              lda   #0
1230 586D A0 07 00              ldy   #scrnInfo
1231 5870 97 00                 sta   [<data],y
1232 5872 A0 17 00              ldy   #memInfo
1233 5875 97 00                 sta   [<data],y
1234 5877 A0 33 00              ldy   #imageInfo
1235 587A 97 00                 sta   [<data],y
1236 587C A9 08 00              lda   #8
1237 587F A0 39 00              ldy   #imageInfo+6
1238 5882 97 00                 sta   [<data],y
1239 5884
1240 5884 A5 AA                 lda   <scInfo1+BoundsRect+x2   Get width of screen.
1241 5886 A0 51 00              ldy   #defmenu+CtlRect+x2      Set width of system menu bar.
1242 5889 97 00                 sta   [<data],y
1243 588B A0 15 00              ldy   #scrnInfo+8+x2
1244 588E 97 00                 sta   [<data],y
1245 5890
1246 5890 C9 40 01              cmp   #320
1247 5893 F0 1E                 beq   ok200                    320 mode? Flag already set to zero.
1248 5895              ;
1249 5895              ;
1250 5895              ; --- Initialize for 640 mode --------------------------
1251 5895              ;
1252 5895 E6 5A                 inc   <vert_pen                Vertical lines are 2 wide in 640.
1253 5897
1254 5897 E6 46                 inc   <screenmode              640 mode flag, 1.
1255 5899
1256 5899 A9 80 00              lda   #$0080
1257 589C A0 07 00              ldy   #scrnInfo
1258 589F 97 00                 sta   [<data],y
1259 58A1 A0 17 00              ldy   #memInfo
1260 58A4 97 00                 sta   [<data],y
1261 58A6 A0 33 00              ldy   #imageInfo
1262 58A9 97 00                 sta   [<data],y
1263 58AB A9 04 00              lda   #4
1264 58AE A0 39 00              ldy   #imageInfo+6
1265 58B1 97 00                 sta   [<data],y
1266 58B3
1267 58B3              ;
1268 58B3              ; --- Get system font's parameters ----------------------
1269 58B3              ;
1270 58B3 F4 00 00     ok200    pea   0                        ; space for result
1271 58B6 F4 57 00              PushWord #$57                  ; get the width of 'W' and we'll use this as our maxwidth
1272 58B9 A2 04 A8 22           _CharWidth 
1273 58C0 68                    pla   
1274 58C1 85 62                 sta   <text_width
1275 58C3
1276 58C3 A9 E6 00              lda   #font_h
1277 58C6 20 64 8F              jsr   pushDpage
1278 58C9 A2 04 96 22           _GetFontInfo 
1279 58D0
1280 58D0 A5 E8                 lda   <descent
1281 58D2 18                    clc   
1282 58D3 69 02 00              adc   #B_LEADING
1283 58D6 85 E8                 sta   <descent
1284 58D8
1285 58D8 18                    clc   
1286 58D9 65 E6                 adc   <font_h                  Add the ascent,
1287 58DB 69 02 00              adc   #T_LEADING               plus top leading.
1288 58DE 85 E6                 sta   <font_h                  Store the height.
1289 58E0
1290 58E0              ;
1291 58E0              ; --- Subtract the system menu bar from the desktop ---------
1292 58E0              ;
1293 58E0 1A                    inc   a
1294 58E1 A0 4F 00              ldy   #defMenu+CtlRect+y2
1295 58E4 97 00                 sta   [<data],y                Set bottom of default menu bar.
1296 58E6
1297 58E6 A5 58                 lda   <temp
1298 58E8 D0 40                 bne   MenuBarInvisible
1299 58EA
1300 58EA A2 0F 2F 22           _InitPalette                   Initialize palette for color logo.
1301 58F1
1302 58F1 48                    pha   
1303 58F2 48                    pha   
1304 58F3 A2 04 67 22           _NewRgn                        Allocate a temp region.
1305 58FA
1306 58FA A3 01                 lda   1,s                      Save temp region handle.
1307 58FC 85 EA                 sta   <work
1308 58FE A3 03                 lda   3,s
1309 5900 85 EC                 sta   <work+2
1310 5902
1311 5902 20 77 7C              jsr   pushdefBarRect           Pass pointer to default menu bar RECT.
1312 5905 A2 04 6C 22           _RectRgn                       Make a region out of the menubar.
1313 590C
1314 590C F4 00 00              pea   0                        Subtract operation.
1315 590F D4 EC                 pei   <work+2                  Handle of region to subtract.
1316 5911 D4 EA                 pei   <work
1317 5913 A2 0E 0C 22           _Desktop                       Subtract the menubar from the desktop.
1318 591A 90 03                 bcc   noerr                    Error?
1319 591C 68                    pla                            Fix stack, _Desktop didn't.
1320 591D 68                    pla   
1321 591E 68                    pla   
1322 591F
1323 591F D4 EC        noerr    pei   <work+2
1324 5921 D4 EA                 pei   <work
1325 5923 A2 04 68 22           _DisposeRgn                    Free the temp region.
1326 592A
1327 592A 20 5C 63     MenuBarInvisible jsr   to_uport
1328 592D
1329 592D 60                    rts   
1330 592E
1331 592E                       ENDP 
1332 592E
1333 592E
1334 592E              ;===========================================================================
1335 592E              ;
1336 592E              ;                   InitPalette
1337 592E              ;
1338 592E              ;                   Initialize color palette for Apple Logo.
1339 592E              ;
1340 592E              ;   IN:    None.
1341 592E              ;  OUT:    None.
1342 592E              ;
1343 592E              ;===========================================================================
1344 592E              InitPalette PROC 
1345 592E
1346 592E 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1347 5931
1348 5931 A2 07 00              ldx   #7
1349 5934 DA           lop200   phx                            Save.
1350 5935
1351 5935 BD BA 82              lda   scanbyte,x
1352 5938 A0 07 00              ldy   #scrnInfo
1353 593B 17 00                 ora   [<data],y
1354 593D 29 FF 00              and   #$00FF
1355 5940 E8                    inx   
1356 5941 E8                    inx   
1357 5942 DA                    phx                            Scan line number.
1358 5943 48                    pha                            Scan byte value.
1359 5944 A2 04 12 22           _SetSCB 
1360 594B
1361 594B FA                    plx                            Restore counter.
1362 594C CA                    dex   
1363 594D 10 E5                 bpl   lop200
1364 594F
1365 594F F4 00 00              pea   0
1366 5952 20 8B 7C              jsr   pushColorTable
1367 5955 A2 04 0F 22           _GetColorTable 
1368 595C
1369 595C A2 06 00              ldx   #6
1370 595F A0 0A 00              ldy   #10
1371 5962
1372 5962 DA           lop202   phx                            Save.
1373 5963 5A                    phy                            Save.
1374 5964
1375 5964 B9 AE 82              lda   logocolor,y
1376 5967 A0 7D 01              ldy   #ColorTable+2
1377 596A 97 00                 sta   [<data],y
1378 596C A4 46                 ldy   <screenmode
1379 596E F0 0F                 beq   ok202
1380 5970
1381 5970 A0 85 01              ldy   #ColorTable+10
1382 5973 97 00                 sta   [<data],y
1383 5975 A0 8D 01              ldy   #ColorTable+18
1384 5978 97 00                 sta   [<data],y
1385 597A A0 95 01              ldy   #ColorTable+26
1386 597D 97 00                 sta   [<data],y
1387 597F
1388 597F DA           ok202    phx                            Table number.
1389 5980 20 8B 7C              jsr   pushColorTable
1390 5983 A2 04 0E 22           _SetColorTable 
1391 598A
1392 598A 7A                    ply                            Restore.
1393 598B FA                    plx                            Restore.
1394 598C 88                    dey   
1395 598D 88                    dey   
1396 598E CA                    dex   
1397 598F D0 D1                 bne   lop202
1398 5991
1399 5991 82 0F 36              brl   pop0bytes                no error
1400 5994
1401 5994                       ENDP 
1402 5994
1403 5994
1404 5994              ;===========================================================================
1405 5994              ;
1406 5994              ;                   MenuVersion
1407 5994              ;
1408 5994              ;                   Return Menu Manager's Version number.
1409 5994              ;
1410 5994              ;   IN:  Nothing.
1411 5994              ;  OUT:  WORD - version number.
1412 5994              ;
1413 5994              ;===========================================================================
1414 5994              MenuVersion PROC 
1415 5994
1416 5994              TheReturnAddr equ   1                   Stack offset before setup called.
1417 5994              result   equ   TheReturnAddr+6
1418 5994
1419 5994 A9 00 03              lda   #$0300                   Version Number
1420 5997 83 07                 sta   result,s                 Store in return space.
1421 5999 82 DB FD              brl   exitTool
1422 599C
1423 599C                       ENDP 
1424 599C
1425 599C
1426 599C              ;===========================================================================
1427 599C              ;
1428 599C              ;                   GetMenuMgrPort
1429 599C              ;
1430 599C              ;                   Return Menu Manager's Port pointer.
1431 599C              ;
1432 599C              ;   IN:    Nothing.
1433 599C              ;
1434 599C              ;  OUT:    LONG - pointer to Menu Manager's port.
1435 599C              ;
1436 599C              ;===========================================================================
1437 599C              GetMenuMgrPort PROC 
1438 599C
1439 599C              result   equ   input
1440 599C
1441 599C 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1442 599F
1443 599F 20 95 7C              jsr   pushport
1444 59A2 68                    pla                            Return Menu Manager's port pointer.
1445 59A3 83 0C                 sta   result+2,s
1446 59A5 68                    pla   
1447 59A6 83 0C                 sta   result+2,s
1448 59A8
1449 59A8 82 F8 35              brl   pop0bytes                no error
1450 59AB
1451 59AB                       ENDP 
1452 59AB
1453 59AB
1454 59AB              ;=======================================================================
1455 59AB              ;
1456 59AB              ;                   N E W M E N U 2
1457 59AB              ;
1458 59AB              ;=======================================================================
1459 59AB              NewMenu2 PROC 
1460 59AB
1461 59AB              menuRef  equ   input
1462 59AB              inputVerb equ   menuRef+4
1463 59AB              result   equ   inputVerb+2
1464 59AB
1465 59AB              myTemp   equ   work                     ; 0 used for dereferencing
1466 59AB              resMenuHdl equ   work+4                 ; 4 redefine some zero page equates
1467 59AB              resMenuPtr equ   resMenuHdl+4           ; 8
1468 59AB              origMenuRef equ   resMenuPtr+4          ; 12 save original menuref just in case it was a resource ID
1469 59AB              count1   equ   origMenuRef+4            ; 16 counter for number of items in the menu
1470 59AB              count2   equ   count1+2                 ; 18
1471 59AB              mem_needed equ   count2+2               ; 20
1472 59AB
1473 59AB              itemVerb equ   temp
1474 59AB
1475 59AB 20 97 8F              jsr   startup
1476 59AE
1477 59AE 64 EE                 stz   <resMenuHdl
1478 59B0 64 F0                 stz   <resMenuHdl+2
1479 59B2 64 F6                 stz   <origMenuRef
1480 59B4 64 F8                 stz   <origMenuRef+2
1481 59B6
1482 59B6 A3 0E                 lda   inputVerb,s
1483 59B8 0A                    asl   a
1484 59B9 AA                    tax   
1485 59BA 7C BD 59              jmp   (startupTable,x)
1486 59BD
1487 59BD 00 5A        startupTable DC W:ptrStartup            ; verb = 0
1488 59BF E4 59                 DC W:handStartup               ; verb = 1
1489 59C1 C3 59                 DC W:resStartup                ; verb = 2
1490 59C3
1491 59C3              ;==================================================
1492 59C3              ;
1493 59C3              ; The menuref is the resource ID to the menu.
1494 59C3
1495 59C3 A3 0A        resStartup lda   menuRef,s              ; save resource ID so we can use it to release resource
1496 59C5 85 F6                 sta   <origMenuRef             ; later on down the road
1497 59C7 A3 0C                 lda   menuRef+2,s
1498 59C9 85 F8                 sta   <origMenuRef+2
1499 59CB
1500 59CB 48                    pha                            ; space for handle to menu resource
1501 59CC 48                    pha   
1502 59CD F4 09 80              PushWord #rMenu                ; resource type
1503 59D0 A3 12                 lda   <menuRef+8,s             ; resource ID
1504 59D2 48                    pha   
1505 59D3 A3 12                 lda   <menuRef+8,s
1506 59D5 48                    pha   
1507 59D6 A2 10 32 22           _CMLoadResource                ; CMLoadResource
1508 59DD 68                    pla   
1509 59DE FA                    plx   
1510 59DF 83 0A                 sta   <menuRef,s
1511 59E1 8A                    txa   
1512 59E2 83 0C                 sta   <menuRef+2,s
1513 59E4
1514 59E4
1515 59E4              ;==================================================
1516 59E4              ;
1517 59E4              ; The menuref is a handle to the resource.
1518 59E4
1519 59E4 A3 0C        handStartup lda   menuRef+2,s
1520 59E6 85 F0                 sta   <resMenuHdl+2
1521 59E8 A3 0A                 lda   menuRef,s
1522 59EA 85 EE                 sta   <resMenuHdl
1523 59EC
1524 59EC A0 04 00              ldy   #4                       ; lock down the handle
1525 59EF B7 EE                 lda   [<resMenuHdl],y
1526 59F1 09 00 80              ora   #$8000
1527 59F4 97 EE                 sta   [<resMenuHdl],y
1528 59F6
1529 59F6 88                    dey   
1530 59F7 88                    dey   
1531 59F8 B7 EE                 lda   [<resMenuHdl],y          ; dereference the handle and put it back on the
1532 59FA 83 0C                 sta   menuRef+2,s              ; stack, so we can fall down to the next code section
1533 59FC A7 EE                 lda   [<resMenuHdl]
1534 59FE 83 0A                 sta   menuRef,s
1535 5A00
1536 5A00              ;==================================================
1537 5A00              ;
1538 5A00              ; The menuref is a pointer to the menu resource.
1539 5A00              ; This is where we get the memory for our menu record and fill this record
1540 5A00              ; in.
1541 5A00
1542 5A00 A3 0C        ptrStartup lda   menuRef+2,s
1543 5A02 85 F4                 sta   <resMenuPtr+2            ; put the ptr to the resource on our
1544 5A04 A3 0A                 lda   menuRef,s                ; direct page for easier access
1545 5A06 85 F2                 sta   <resMenuPtr
1546 5A08
1547 5A08              ;
1548 5A08              ; pass 1 determines how much memory we need
1549 5A08              ;
1550 5A08 64 FA                 stz   <count1
1551 5A0A 64 FE                 stz   <mem_needed              ; keep track of amount of memory needed
1552 5A0C A0 0A 00              ldy   #itemResourceID          ; let's get the first item in the menu
1553 5A0F A9 1A 00              lda   #MENUSIZE+2              ; get size of menu record
1554 5A12
1555 5A12 18           lop1     clc   
1556 5A13 65 FE                 adc   <mem_needed
1557 5A15 85 FE                 sta   <mem_needed
1558 5A17
1559 5A17 B7 F2                 lda   [<resMenuPtr],y
1560 5A19 C8                    iny   
1561 5A1A C8                    iny   
1562 5A1B 17 F2                 ora   [<resMenuPtr],y
1563 5A1D F0 09                 beq   noMoreItems
1564 5A1F E6 FA                 inc   <count1
1565 5A21 A9 0C 00              lda   #ITEMSIZE
1566 5A24 C8                    iny                            ; skip to next item
1567 5A25 C8                    iny   
1568 5A26 80 EA                 bra   lop1
1569 5A28
1570 5A28 A5 FE        noMoreItems lda   <mem_needed
1571 5A2A 20 27 60              jsr   make_block               ; get the memory we need
1572 5A2D 85 20                 sta   <menuhand
1573 5A2F 83 10                 sta   result,s                 ; return handle to the menu record
1574 5A31 86 22                 stx   <menuhand+2
1575 5A33 8A                    txa   
1576 5A34 83 12                 sta   result+2,s
1577 5A36 90 03                 bcc   gotMemOK                 ; could'nt get the memory
1578 5A38 82 C6 00              brl   exit
1579 5A3B
1580 5A3B 20 F1 62     gotMemOK jsr   lockMenuHand
1581 5A3E 20 15 63              jsr   derefMenuHand
1582 5A41
1583 5A41 A9 00 00              lda   #0                       ; first zero out the memory we just got
1584 5A44 A4 FE                 ldy   <mem_needed
1585 5A46 80 02                 bra   enter1
1586 5A48 97 1C        lop2     sta   [<menuptr],y
1587 5A4A 88           enter1   dey   
1588 5A4B 88                    dey   
1589 5A4C 10 FA                 bpl   lop2
1590 5A4E
1591 5A4E              ;
1592 5A4E              ; Pass 2 we start filling in the menu record
1593 5A4E              ;
1594 5A4E A0 02 00              ldy   #resMenuID               ; copy ID of menu into menu record
1595 5A51 B7 F2                 lda   [<resMenuPtr],y
1596 5A53 A0 00 00              ldy   #MenuID
1597 5A56 97 1C                 sta   [<menuptr],y
1598 5A58
1599 5A58 A0 04 00              ldy   #resMenuFlag             ; copy menuFlag and menuRes bytes into menu record
1600 5A5B B7 F2                 lda   [<resMenuPtr],y
1601 5A5D 29 FF CF              and   #$CFFF                   ; get rid of the low two bits of high byte
1602 5A60 A0 0A 00              ldy   #MenuFlag
1603 5A63 97 1C                 sta   [<menuptr],y
1604 5A65
1605 5A65 A0 0C 00              ldy   #NumOfItems              ; get number of items in the menu, calculated
1606 5A68 A5 FA                 lda   <count1                  ; above when figuring out size of menu
1607 5A6A 97 1C                 sta   [<menuptr],y
1608 5A6C
1609 5A6C A0 06 00              ldy   #resTitleName            ; get reference to the menu title and move it into
1610 5A6F B7 F2                 lda   [<resMenuPtr],y          ; our menu record
1611 5A71 A0 10 00              ldy   #TitleName
1612 5A74 97 1C                 sta   [<menuptr],y
1613 5A76 A0 08 00              ldy   #resTitleName+2
1614 5A79 B7 F2                 lda   [<resMenuPtr],y
1615 5A7B A0 12 00              ldy   #TitleName+2
1616 5A7E 97 1C                 sta   [<menuptr],y
1617 5A80
1618 5A80              ; Load the menu title string resource so we can check to see if it's the Apple logo.
1619 5A80              ; If so, we have to set the titlewidth.
1620 5A80              ;
1621 5A80 20 89 5B              jsr   getrMenuTitle            ; get ptr to the menu title
1622 5A83 85 EA                 sta   <myTemp
1623 5A85 86 EC                 stx   <myTemp+2
1624 5A87
1625 5A87 A7 EA                 lda   [<myTemp]                ; now check to see if this is the apple logo
1626 5A89 C9 01 40              cmp   #$4001                   ; has the apple logo already been set
1627 5A8C D0 08                 bne   skip_apple_logo
1628 5A8E
1629 5A8E A0 0E 00              ldy   #titleWidth              ; set default width for the an apple logo title
1630 5A91 A9 18 00              lda   #24
1631 5A94 97 1C                 sta   [<menuptr],y             ; copy default title width into menu record
1632 5A96
1633 5A96 A9 18 00     skip_apple_logo lda   #MenuSize         ; keep track of where we are in the menu record
1634 5A99 85 FA                 sta   <count1
1635 5A9B A9 0A 00              lda   #itemResourceID
1636 5A9E 85 FC                 sta   <count2                  ; keep track of where we are in the resource menu record
1637 5AA0
1638 5AA0 A0 04 00              ldy   #resMenuFlag
1639 5AA3 B7 F2                 lda   [<resMenuPtr],y
1640 5AA5 29 00 30              and   #$3000                   ; just look at the low two bits of the high byte
1641 5AA8 EB                    xba                            ; now we have the correct verb value
1642 5AA9 4A                    lsr   a
1643 5AAA 4A                    lsr   a
1644 5AAB 4A                    lsr   a
1645 5AAC 4A                    lsr   a
1646 5AAD 85 58                 sta   <itemVerb
1647 5AAF
1648 5AAF A4 FC        getNextItem ldy   <count2
1649 5AB1 B7 F2                 lda   [<resMenuPtr],y
1650 5AB3 85 2C                 sta   <temptr2
1651 5AB5 C8                    iny   
1652 5AB6 C8                    iny   
1653 5AB7 17 F2                 ora   [<resMenuPtr],y
1654 5AB9 F0 1D                 beq   ThatsAllFolks
1655 5ABB B7 F2                 lda   [<resMenuPtr],y
1656 5ABD 85 2E                 sta   <temptr2+2
1657 5ABF
1658 5ABF A5 58                 lda   <itemVerb                ; x contains the what the item reference is
1659 5AC1 A4 FA                 ldy   <count1                  ; y is index into the menu record
1660 5AC3 20 04 5B              jsr   fillItemRec              ; now fill in the item record
1661 5AC6
1662 5AC6 A5 FA                 lda   <count1
1663 5AC8 18                    clc   
1664 5AC9 69 0C 00              adc   #ITEMSIZE
1665 5ACC 85 FA                 sta   <count1                  ; update index into menu rec where next item is to go
1666 5ACE
1667 5ACE A5 FC                 lda   <count2
1668 5AD0 18                    clc   
1669 5AD1 69 04 00              adc   #4
1670 5AD4 85 FC                 sta   <count2                  ; get next item
1671 5AD6 80 D7                 bra   getNextItem
1672 5AD8              ;
1673 5AD8              ; Let's clean everything up. Otay!
1674 5AD8              ;
1675 5AD8 20 03 63     ThatsAllFolks jsr   unlockmenuhand
1676 5ADB
1677 5ADB A5 EF                 lda   <resMenuHdl+1            ; see if there was a handle involved
1678 5ADD F0 22                 beq   exit
1679 5ADF
1680 5ADF A0 04 00              ldy   #4                       ; There was! There was! I knew I thaw a handle.
1681 5AE2 B7 EE                 lda   [<resMenuHdl],y          ; unlock the sucker
1682 5AE4 29 FF 7F              and   #$7FFF
1683 5AE7 97 EE                 sta   [<resMenuHdl],y
1684 5AE9
1685 5AE9 A5 F6                 lda   <origMenuRef             ; check to see if we loaded a menu resource
1686 5AEB D0 04                 bne   releaseMenuRes
1687 5AED A5 F8                 lda   <origMenuRef+2
1688 5AEF F0 10                 beq   exit
1689 5AF1
1690 5AF1 F4 09 80     releaseMenuRes PushWord #rMenu 
1691 5AF4 A5 F8                 lda   <origMenuRef+2
1692 5AF6 48                    pha   
1693 5AF7 A5 F6                 lda   <origMenuRef
1694 5AF9 48                    pha   
1695 5AFA A2 10 33 22           _CMReleaseResource 
1696 5B01
1697 5B01 82 B7 34     exit     brl   pop6bytes
1698 5B04
1699 5B04                       ENDP 
1700 5B04
1701 5B04              ;=======================================================================
1702 5B04              ;
1703 5B04              ;                   FillItemRec
1704 5B04              ;
1705 5B04              ;  IN: a = item reference, i.e. ptr, handle, or resource ID
1706 5B04              ;      y = index into menu record where item is to go
1707 5B04              ;      temptr2 = item reference (ptr, handle or resource ID)
1708 5B04              ;      menuptr = ptr to menu record that item is to be inserted into
1709 5B04              ; OUT: <menuptr with the current item record inserted
1710 5B04              ;
1711 5B04              ;=======================================================================
1712 5B04              FillItemRec PROC 
1713 5B04
1714 5B04 84 50                 sty   <count
1715 5B06
1716 5B06 0A                    asl   a
1717 5B07 AA                    tax   
1718 5B08 7C 0B 5B              jmp   (itemtable,x)
1719 5B0B
1720 5B0B 2B 5B        itemtable DC W:doItemPtr                ; verb = 0
1721 5B0D 1F 5B                 DC W:doItemHandle              ; verb = 1
1722 5B0F 11 5B                 DC W:doItemResource            ; verb = 2
1723 5B11
1724 5B11 A0 0A 80     doItemResource ldy   #rMenuItem
1725 5B14 A5 2C                 lda   <temptr2
1726 5B16 A6 2E                 ldx   <temptr2+2
1727 5B18 20 C4 5B              jsr   LoadnRelease
1728 5B1B 85 2C                 sta   <temptr2
1729 5B1D 86 2E                 stx   <temptr2+2
1730 5B1F
1731 5B1F A0 02 00     doItemHandle ldy   #2
1732 5B22 B7 2C                 lda   [<temptr2],y
1733 5B24 AA                    tax   
1734 5B25 A7 2C                 lda   [<temptr2]
1735 5B27 85 2C                 sta   <temptr2
1736 5B29 86 2E                 stx   <temptr2+2
1737 5B2B
1738 5B2B A0 02 00     doItemPtr ldy   #resItemID
1739 5B2E A6 50                 ldx   <count
1740 5B30
1741 5B30 B7 2C        fillNext lda   [<temptr2],y             ; start filling in the item record portion of the
1742 5B32 C8                    iny                            ; menu record
1743 5B33 C8                    iny   
1744 5B34 5A                    phy   
1745 5B35 9B                    txy   
1746 5B36 97 1C                 sta   [<menuptr],y
1747 5B38 C8                    iny   
1748 5B39 C8                    iny   
1749 5B3A BB                    tyx   
1750 5B3B 7A                    ply   
1751 5B3C C0 0E 00              cpy   #ItemRecSize
1752 5B3F F0 03                 beq   done
1753 5B41 82 EC FF              brl   fillNext
1754 5B44
1755 5B44 60           done     rts   
1756 5B45
1757 5B45                       ENDP 
1758 5B45
1759 5B45              ;=======================================================================
1760 5B45              ;
1761 5B45              ;                   getResMTitle
1762 5B45              ;
1763 5B45              ;  IN:  handle to menu record
1764 5B45              ; OUT:  result contains ptr to the menu title
1765 5B45              ;
1766 5B45              ;=======================================================================
1767 5B45              getResMTitle PROC 
1768 5B45
1769 5B45              menuin   equ   input                    ; handle to menu record
1770 5B45              result   equ   menuin+4                 ; ptr to the title
1771 5B45
1772 5B45 20 97 8F              jsr   startup
1773 5B48
1774 5B48 A3 0A                 lda   menuin,s
1775 5B4A 85 20                 sta   <menuhand
1776 5B4C A3 0C                 lda   menuin+2,s
1777 5B4E 85 22                 sta   <menuhand+2
1778 5B50
1779 5B50 20 F1 62              jsr   lockmenuhand
1780 5B53 20 15 63              jsr   derefmenuhand
1781 5B56
1782 5B56 20 89 5B              jsr   getrMenuTitle
1783 5B59
1784 5B59 83 0E                 sta   result,s
1785 5B5B 8A                    txa   
1786 5B5C 83 10                 sta   result+2,s
1787 5B5E
1788 5B5E 20 03 63              jsr   unlockmenuhand
1789 5B61
1790 5B61 82 4F 34              brl   pop4bytes
1791 5B64
1792 5B64                       ENDP 
1793 5B64
1794 5B64              ;=======================================================================
1795 5B64              ;
1796 5B64              ;                   getrItemName
1797 5B64              ;
1798 5B64              ;  IN:  <itemptr contains ptr current item record in menu
1799 5B64              ; OUT:  a = low word of ptr to item name, x = high word of ptr
1800 5B64              ;
1801 5B64              ;=======================================================================
1802 5B64              getrItemName PROC 
1803 5B64
1804 5B64 A0 08 00              ldy   #ItemName
1805 5B67 B7 24                 lda   [<itemptr],y
1806 5B69 85 28                 sta   <temptr
1807 5B6B C8                    iny   
1808 5B6C C8                    iny   
1809 5B6D B7 24                 lda   [<itemptr],y
1810 5B6F 85 2A                 sta   <temptr+2
1811 5B71
1812 5B71 A0 06 00              ldy   #ItemFlag
1813 5B74 B7 24                 lda   [<itemptr],y
1814 5B76 29 00 C0              and   #FIRST_TWO_BITS
1815 5B79 D0 03                 bne   @1
1816 5B7B 82 41 00              brl   doPointer
1817 5B7E C9 00 40     @1       cmp   #HANDLE_REF
1818 5B81 D0 03                 bne   @2
1819 5B83 82 2D 00              brl   doHandle
1820 5B86 82 1C 00     @2       brl   doResource
1821 5B89
1822 5B89              ;=======================================================================
1823 5B89              ;
1824 5B89              ;                   getrMenuTitle
1825 5B89              ;
1826 5B89              ;  IN:  <menuptr contains ptr to the menu record
1827 5B89              ; OUT:  a = low word of ptr to title, x = high word of ptr
1828 5B89              ;
1829 5B89              ;=======================================================================
1830 5B89                       ENTRY getrMenuTitle
1831 5B89              getrMenuTitle  
1832 5B89 A0 10 00              ldy   #TitleName               ; copy the titlename into one of our direct page locations
1833 5B8C B7 1C                 lda   [<menuptr],y
1834 5B8E 85 28                 sta   <temptr
1835 5B90 C8                    iny   
1836 5B91 C8                    iny   
1837 5B92 B7 1C                 lda   [<menuptr],y
1838 5B94 85 2A                 sta   <temptr+2
1839 5B96
1840 5B96 A0 0A 00              ldy   #MenuFlag                ; first find out how the menu title will be referenced
1841 5B99 B7 1C                 lda   [<menuptr],y
1842 5B9B 29 00 C0              and   #FIRST_TWO_BITS          ; first two bits of the flag tells all
1843 5B9E F0 1F                 beq   doPointer
1844 5BA0 C9 00 40              cmp   #HANDLE_REF
1845 5BA3 F0 0E                 beq   doHandle
1846 5BA5
1847 5BA5              ; if not pointer or handle then the menu title must be a resource ID
1848 5BA5              ;
1849 5BA5 A0 06 80     doResource ldy   #rPString              ; type
1850 5BA8
1851 5BA8                       ENTRY doResource2
1852 5BA8 A5 28        doResource2 lda   <temptr               ; resource ID
1853 5BAA A6 2A                 ldx   <temptr+2
1854 5BAC 20 C4 5B              jsr   LoadnRelease             ; loads resource and releases it, then returns handle
1855 5BAF 85 28                 sta   <temptr
1856 5BB1 86 2A                 stx   <temptr+2
1857 5BB3
1858 5BB3                       ENTRY doHandle
1859 5BB3 A0 02 00     doHandle ldy   #2
1860 5BB6 B7 28                 lda   [<temptr],y
1861 5BB8 AA                    tax   
1862 5BB9 A7 28                 lda   [<temptr]
1863 5BBB 85 28                 sta   <temptr
1864 5BBD 86 2A                 stx   <temptr+2
1865 5BBF
1866 5BBF                       ENTRY doPointer
1867 5BBF A5 28        doPointer lda   <temptr                 ; low word of ptr to menu title/item name/icon ref
1868 5BC1 A6 2A                 ldx   <temptr+2                ; high word of ptr to menu title/item name/icon ref
1869 5BC3
1870 5BC3 60                    rts   
1871 5BC4
1872 5BC4                       ENDP 
1873 5BC4
1874 5BC4
1875 5BC4              ;=======================================================================
1876 5BC4              ;
1877 5BC4              ;                   LoadnRelease
1878 5BC4              ;
1879 5BC4              ;  IN:  a = low word of resource ID, x = high word of resource ID
1880 5BC4              ;       y = resource type
1881 5BC4              ; OUT:  a = low word of handle to resource, x = high word of handle
1882 5BC4              ;
1883 5BC4              ;=======================================================================
1884 5BC4              LoadnRelease PROC 
1885 5BC4
1886 5BC4              myTemp   equ   work
1887 5BC4
1888 5BC4 5A                    phy                            ; inputs for CMReleaseResource, type
1889 5BC5 DA                    phx                            ; resource ID
1890 5BC6 48                    pha   
1891 5BC7
1892 5BC7 48                    pha                            ; space for result
1893 5BC8 48                    pha   
1894 5BC9 5A                    phy                            ; type
1895 5BCA DA                    phx                            ; resource ID
1896 5BCB 48                    pha   
1897 5BCC A2 10 32 22           _CMLoadResource 
1898 5BD3 68                    pla   
1899 5BD4 85 EA                 sta   <myTemp
1900 5BD6 68                    pla   
1901 5BD7 85 EC                 sta   <myTemp+2
1902 5BD9
1903 5BD9 A2 10 33 22           _CMReleaseResource             ; remember inputs pushed at beginning of routine
1904 5BE0
1905 5BE0 A5 EA                 lda   <myTemp
1906 5BE2 A6 EC                 ldx   <myTemp+2
1907 5BE4
1908 5BE4 60                    rts   
1909 5BE5
1910 5BE5                       ENDP 
1911 5BE5
1912 5BE5
1913 5BE5              ;===========================================================================
1914 5BE5              ;
1915 5BE5              ;                   NewMenu
1916 5BE5              ;
1917 5BE5              ;                   Allocate and initialize a menu.
1918 5BE5              ;
1919 5BE5              ;   IN:    PUSH:LONG - pointer to menu list.
1920 5BE5              ;
1921 5BE5              ;  OUT:    LONG - Handle of menu, zero if error.
1922 5BE5              ;
1923 5BE5              ;===========================================================================
1924 5BE5              NewMenu  PROC 
1925 5BE5
1926 5BE5              menuline equ   input
1927 5BE5              return   equ   menuline+4
1928 5BE5
1929 5BE5              mem_needed equ   work                   0
1930 5BE5              list     equ   mem_needed+2             2
1931 5BE5              menu_char equ   list+4                  6
1932 5BE5              item_char equ   menu_char+2             8
1933 5BE5              check_mark equ   item_char+2            10
1934 5BE5              command  equ   check_mark+2             12
1935 5BE5              flag     equ   command+2                14
1936 5BE5              length   equ   flag+2                   16
1937 5BE5              real_len equ   length+2                 18
1938 5BE5              ;                                       20
1939 5BE5
1940 5BE5 20 97 8F              jsr   startup                  Do startup initialization for tool call.
1941 5BE8
1942 5BE8              ;
1943 5BE8              ; --- Compute size of data structure needed -----------------------------
1944 5BE8              ;
1945 5BE8 A2 00 00              ldx   #0                       Just count, flag.
1946 5BEB 20 20 5C              jsr   parse
1947 5BEE
1948 5BEE              ;
1949 5BEE              ; --- Allocate menu record -----------------------------------------------
1950 5BEE              ;
1951 5BEE A5 EA                 lda   <mem_needed              Number of bytes needed.
1952 5BF0 20 27 60              jsr   make_block               Allocate the memory.
1953 5BF3 85 20                 sta   <menuhand                Save handle of menu.
1954 5BF5 86 22                 stx   <menuhand+2
1955 5BF7 B0 19                 bcs   exit                     Was the block allocated?
1956 5BF9
1957 5BF9 20 F1 62              jsr   lockMenuHand             <menuhand = locked.
1958 5BFC 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand)
1959 5BFF
1960 5BFF              ;
1961 5BFF              ; --- Clear some fields of menu record -----------------------------------
1962 5BFF              ;
1963 5BFF A9 00 00              lda   #0
1964 5C02 A4 EA                 ldy   <mem_needed
1965 5C04 80 02                 bra   enter3
1966 5C06 97 1C        lop3     sta   [<menuptr],y
1967 5C08 88           enter3   dey   
1968 5C09 88                    dey   
1969 5C0A 10 FA                 bpl   lop3
1970 5C0C
1971 5C0C              ;
1972 5C0C              ; --- Parse Menu strings and initialize Menu record ------------------------
1973 5C0C              ;
1974 5C0C A2 01 00              ldx   #1                       Initialize menu records flag.
1975 5C0F 20 20 5C              jsr   parse
1976 5C12              ;
1977 5C12              ; --- Return handle of menu ------------------------------------------------
1978 5C12              ;
1979 5C12 A5 20        exit     lda   <menuhand
1980 5C14 83 0E                 sta   return,s
1981 5C16 A5 22                 lda   <menuhand+2
1982 5C18 83 10                 sta   return+2,s
1983 5C1A
1984 5C1A 20 03 63              jsr   unlockMenuHand           <menuhand = unlocked.
1985 5C1D
1986 5C1D 82 93 33              brl   pop4bytes                no error
1987 5C20
1988 5C20
1989 5C20              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1990 5C20              ;          Menu list parser.
1991 5C20              ;
1992 5C20              ;   IN:    x = 0 if just counting items.
1993 5C20              ;          menuptr = pointer of data area to initialize, zero if just counting.
1994 5C20              ;          list = pointer to list of menus.
1995 5C20              ;
1996 5C20              ;  OUT:    work = number of bytes needed.
1997 5C20              ;
1998 5C20              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1999 5C20 A3 0C        parse    lda   menuline+2,s
2000 5C22 85 EC                 sta   <list
2001 5C24 85 64                 sta   <strg_ptr
2002 5C26 A3 0E                 lda   menuline+4,s
2003 5C28 85 EE                 sta   <list+2
2004 5C2A 85 66                 sta   <strg_ptr+2
2005 5C2C
2006 5C2C A7 64                 lda   [<strg_ptr]              Store title character.
2007 5C2E 29 FF 00              and   #$00FF
2008 5C31 85 F0                 sta   <menu_char
2009 5C33
2010 5C33 64 EA                 stz   <mem_needed              Initialize size accumulator.
2011 5C35 64 F2                 stz   <item_char               No item character yet.
2012 5C37
2013 5C37 20 B4 5C     lop1     jsr   parse_strg               Parse the string.
2014 5C3A
2015 5C3A              ;
2016 5C3A              ; ------ Store address of menu's title ------------------
2017 5C3A              ;
2018 5C3A 8A                    txa                            Just counting?
2019 5C3B F0 45                 beq   skip1
2020 5C3D
2021 5C3D A0 10 00              ldy   #TitleName               Store pointer to menu's title.
2022 5C40 A5 64                 lda   <strg_ptr
2023 5C42 97 1C                 sta   [<menuptr],y
2024 5C44 A5 65                 lda   <strg_ptr+1
2025 5C46 C8                    iny   
2026 5C47 97 1C                 sta   [<menuptr],y
2027 5C49
2028 5C49              ;
2029 5C49              ; ------- Special case Apple logo title ----------------------
2030 5C49              ;
2031 5C49 A7 64                 lda   [<strg_ptr]
2032 5C4B C9 01 FF              cmp   #$FF01                   Apple logo already set?
2033 5C4E F0 0A                 beq   apple_len
2034 5C50              ;
2035 5C50              ************* THE FOLLOWING LINE MUST BE CONVERTED MANUALLY!!!!! *************
2036 5C50 C9 01 40              cmp   #$4001                   Just one '@' for Apple logo.
2037 5C53 D0 0D                 bne   skip_logo
2038 5C55
2039 5C55 A9 01 FF              lda   #$FF01                   Make it the real logo value.
2040 5C58 87 64                 sta   [<strg_ptr]
2041 5C5A
2042 5C5A A0 0E 00     apple_len ldy   #TitleWidth             Set logo title width here.
2043 5C5D A9 18 00              lda   #24
2044 5C60 97 1C                 sta   [<menuptr],y
2045 5C62
2046 5C62              ;
2047 5C62              ; ------- Set menu flag --------------------------------------
2048 5C62              ;
2049 5C62 A0 0A 00     skip_logo ldy   #MenuFlag
2050 5C65 A5 F8                 lda   <flag
2051 5C67 29 A0 00              and   #M_ENABLED+M_NO_XOR
2052 5C6A 09 08 00              ora   #M_CACHE                 Because it's allocated, it has caching.
2053 5C6D 97 1C                 sta   [<menuptr],y
2054 5C6F
2055 5C6F              ;
2056 5C6F              ; ------- Set menu's ID Number ------------------------------
2057 5C6F              ;
2058 5C6F A5 50                 lda   <count
2059 5C71 87 1C                 sta   [<menuptr]
2060 5C73
2061 5C73              ;
2062 5C73              ; ------- Compute address of item list --------------------------
2063 5C73              ;
2064 5C73 A4 1E        skip10   ldy   <menuptr+2
2065 5C75 A5 1C                 lda   <menuptr                 Set pointer to menu's item list.
2066 5C77 18                    clc   
2067 5C78 69 18 00              adc   #MENUSIZE
2068 5C7B 90 01                 bcc   ok1
2069 5C7D C8                    iny   
2070 5C7E 85 24        ok1      sta   <itemptr                 Set itemptr while I'm here.
2071 5C80 84 26                 sty   <itemptr+2
2072 5C82
2073 5C82              ;
2074 5C82              ; ------- Increment the memory counter ---------------------------
2075 5C82              ;
2076 5C82 A9 1A 00     skip1    lda   #MENUSIZE+2              Pass size of menu record.
2077 5C85 80 06                 bra   enter1
2078 5C87
2079 5C87              ;
2080 5C87              ; --- Parse the items in the menu ---------------------------------
2081 5C87              ;
2082 5C87 20 D6 5D     lop2     jsr   parse_item
2083 5C8A
2084 5C8A A9 0C 00              lda   #ITEMSIZE
2085 5C8D 18           enter1   clc                            Accumulate number of bytes needed.
2086 5C8E 65 EA                 adc   <mem_needed
2087 5C90 85 EA                 sta   <mem_needed
2088 5C92
2089 5C92              ;
2090 5C92              ; ------ Compute address of next string ---------------------------
2091 5C92              ;
2092 5C92 A5 64                 lda   <strg_ptr
2093 5C94 18                    clc   
2094 5C95 65 FC                 adc   <real_len
2095 5C97 90 02                 bcc   ok10
2096 5C99 E6 66                 inc   <strg_ptr+2
2097 5C9B 85 64        ok10     sta   <strg_ptr
2098 5C9D
2099 5C9D              ;
2100 5C9D              ; ------ Is this a menu or item string? ---------------------------
2101 5C9D              ;
2102 5C9D A7 64                 lda   [<strg_ptr]
2103 5C9F 29 FF 00              and   #$00FF
2104 5CA2
2105 5CA2 F0 0F                 beq   allDone                  If either a null or return character is the first character
2106 5CA4 C9 0D 00              cmp   #13                      of an item definition then this is an empty menu.
2107 5CA7 F0 0A                 beq   allDone
2108 5CA9
2109 5CA9 A4 F2                 ldy   <item_char               Is this the first item?
2110 5CAB D0 02                 bne   ck_it
2111 5CAD
2112 5CAD 85 F2                 sta   <item_char               This will be the item mark from now on.
2113 5CAF
2114 5CAF C5 F2        ck_it    cmp   <item_char
2115 5CB1 F0 D4                 beq   lop2                     Is the next string an item string?
2116 5CB3
2117 5CB3 60           allDone  rts   
2118 5CB4
2119 5CB4
2120 5CB4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2121 5CB4              ;          Parse a string.
2122 5CB4              ;
2123 5CB4              ;   IN:    x = parsing flag.
2124 5CB4              ;          strg_ptr = address of string.
2125 5CB4              ;
2126 5CB4              ;  OUT:    check_mark = item mark character.
2127 5CB4              ;          command = keyboard equivalent character.
2128 5CB4              ;          flag = set for disabled, underlined, special text, XOR.
2129 5CB4              ;          length = string's length.
2130 5CB4              ;          real_len = real string's length.
2131 5CB4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2132 5CB4                       ENTRY parse_strg
2133 5CB4 DA           parse_strg phx                          ;Save X.
2134 5CB5              ;
2135 5CB5              ; --- Find end of text string ------------------------------
2136 5CB5              ;
2137 5CB5 A0 02 00              ldy   #2
2138 5CB8 C8           lop51    iny   
2139 5CB9 B7 64                 lda   [<strg_ptr],y
2140 5CBB 29 FF 00              and   #$00FF
2141 5CBE F0 0A                 beq   eol
2142 5CC0 C9 0D 00              cmp   #13                      ;Return?
2143 5CC3 F0 05                 beq   eol
2144 5CC5 C9 5C 00              cmp   #'\'                     ;Start of special characters.
2145 5CC8 D0 EE                 bne   lop51
2146 5CCA
2147 5CCA 88           eol      dey   
2148 5CCB
2149 5CCB A3 01                 lda   1,s                      ;Just counting?
2150 5CCD F0 11                 beq   skip50
2151 5CCF
2152 5CCF BB                    tyx                            ;Save Y in X.
2153 5CD0
2154 5CD0 88                    dey   
2155 5CD1 84 FA                 sty   <length
2156 5CD3
2157 5CD3 A0 01 00              ldy   #1
2158 5CD6 B7 64                 lda   [<strg_ptr],y
2159 5CD8 29 00 FF              and   #$FF00
2160 5CDB 05 FA                 ora   <length
2161 5CDD 97 64                 sta   [<strg_ptr],y            Set string length.
2162 5CDF
2163 5CDF 9B                    txy                            Retore text length.
2164 5CE0
2165 5CE0              ;
2166 5CE0              ; --- Parse special characters ---------------------------
2167 5CE0              ;
2168 5CE0 64 F4        skip50   stz   <check_mark              Set defaults.
2169 5CE2 64 F6                 stz   <command
2170 5CE4 A9 20 00              lda   #I_NO_XOR                Set XOR highlighting flag.
2171 5CE7 85 F8                 sta   <flag
2172 5CE9
2173 5CE9 C8                    iny   
2174 5CEA B7 64                 lda   [<strg_ptr],y            Are there any special characters?
2175 5CEC 29 FF 00              and   #$00FF                   (Actually, there should always be one).
2176 5CEF AA                    tax   
2177 5CF0 82 D1 00              brl   next58
2178 5CF3
2179 5CF3 C8           lop52    iny   
2180 5CF4 B7 64        lop53    lda   [<strg_ptr],y
2181 5CF6 29 FF 00              and   #$00FF
2182 5CF9 C9 2A 00              cmp   #'*'                     Keyboard equivalent?
2183 5CFC D0 17                 bne   next51
2184 5CFE
2185 5CFE C8                    iny   
2186 5CFF B7 64                 lda   [<strg_ptr],y            Grab two characters, primary & alternate.
2187 5D01 C8                    iny                            Two bytes.
2188 5D02 85 F6                 sta   <command                 Save key characters.
2189 5D04 29 00 FF              and   #$FF00                   Get alternate key alone.
2190 5D07 C9 00 20              cmp   #$2000                   Is alternate a space?
2191 5D0A D0 E7                 bne   lop52
2192 5D0C A5 F6                 lda   <command
2193 5D0E 29 FF 00              and   #$00FF                   Zero out alternate if a space.
2194 5D11 85 F6                 sta   <command
2195 5D13 80 DE                 bra   lop52                    Next character.
2196 5D15
2197 5D15 C9 43 00     next51   cmp   #'C'                     Check mark?
2198 5D18 D0 0A                 bne   next52
2199 5D1A
2200 5D1A C8                    iny   
2201 5D1B B7 64                 lda   [<strg_ptr],y
2202 5D1D 29 FF 00              and   #$00FF
2203 5D20 85 F4                 sta   <check_mark
2204 5D22 80 CF                 bra   lop52                    Next character.
2205 5D24
2206 5D24 C9 4E 00     next52   cmp   #'N'                     ID Number?
2207 5D27 D0 38                 bne   next60
2208 5D29
2209 5D29 48                    pha                            Space to save Y.
2210 5D2A 48                    pha                            Space for result.
2211 5D2B C8                    iny   
2212 5D2C 98                    tya                            Compute address of number.
2213 5D2D A6 66                 ldx   <strg_ptr+2
2214 5D2F 18                    clc   
2215 5D30 65 64                 adc   <strg_ptr
2216 5D32 90 01                 bcc   ok60
2217 5D34 E8                    inx   
2218 5D35 DA           ok60     phx                            Pass address of number string.
2219 5D36 48                    pha   
2220 5D37
2221 5D37 A2 00 00              ldx   #0                       Compute length of number string.
2222 5D3A B7 64        lop60    lda   [<strg_ptr],y
2223 5D3C 29 FF 00              and   #$00FF
2224 5D3F C9 30 00              cmp   #'0'
2225 5D42 90 09                 bcc   done60
2226 5D44 C9 3A 00              cmp   #'9'+1
2227 5D47 B0 04                 bcs   done60
2228 5D49 C8                    iny   
2229 5D4A E8                    inx   
2230 5D4B 80 ED                 bra   lop60
2231 5D4D
2232 5D4D DA           done60   phx                            Pass length.
2233 5D4E F4 00 00              pea   0                        Unsigned.
2234 5D51 98                    tya   
2235 5D52 83 0B                 sta   11,s                     Save Y.
2236 5D54 A2 0B 28 22           _Dec2Int                       Convert ASCII number string to integer.
2237 5D5B 68                    pla   
2238 5D5C 85 50                 sta   <count                   Save ID number.
2239 5D5E 7A                    ply                            Restore Y, index of character after ID.
2240 5D5F 80 93                 bra   lop53
2241 5D61
2242 5D61 C9 48 00     next60   cmp   #'H'
2243 5D64 D0 08                 bne   next61
2244 5D66
2245 5D66 C8                    iny                            ID number is in hex.
2246 5D67 B7 64                 lda   [<strg_ptr],y
2247 5D69 85 50                 sta   <count
2248 5D6B C8                    iny   
2249 5D6C 80 85                 bra   lop52
2250 5D6E
2251 5D6E AA           next61   tax   
2252 5D6F A5 F8                 lda   <flag
2253 5D71
2254 5D71
2255 5D71              ;-----------------------------------------------------------
2256 5D71              ;
2257 5D71              ; Add checks for shadow and outline
2258 5D71              ;
2259 5D71
2260 5D71 E0 53 00              cpx   #'S'
2261 5D74 D0 05                 bne   @NotS
2262 5D76 09 00 10              ora   #I_NOShadow              Set shadow text flag.
2263 5D79 80 44                 bra   store_flag
2264 5D7B
2265 5D7B E0 4F 00     @NotS    cpx   #'O'
2266 5D7E D0 05                 bne   @NotO
2267 5D80 09 00 08              ora   #I_NOOutLine             Set outline text flag.
2268 5D83 80 3A                 bra   store_flag
2269 5D85              @NotO     
2270 5D85 E0 42 00              cpx   #'B'
2271 5D88 D0 05                 bne   next53
2272 5D8A 09 01 00              ora   #I_NOBOLD                Set bold text flag.
2273 5D8D 80 30                 bra   store_flag
2274 5D8F
2275 5D8F              ;-----------------------------------------------------------
2276 5D8F              ;
2277 5D8F              ; Continue with old checks for the rest of this stuff.
2278 5D8F              ;
2279 5D8F E0 49 00     next53   cpx   #'I'
2280 5D92 D0 05                 bne   next54
2281 5D94
2282 5D94 09 02 00              ora   #I_NOITALIC              Set italicize text flag.
2283 5D97 80 26                 bra   store_flag
2284 5D99
2285 5D99 E0 55 00     next54   cpx   #'U'
2286 5D9C D0 05                 bne   next55
2287 5D9E
2288 5D9E 09 04 00              ora   #I_NOSCORE               Set underscore text flag.
2289 5DA1 80 1C                 bra   store_flag
2290 5DA3
2291 5DA3 E0 56 00     next55   cpx   #'V'
2292 5DA6 D0 05                 bne   next56
2293 5DA8
2294 5DA8 09 40 00              ora   #I_NOUNDER               Set underline flag.
2295 5DAB 80 12                 bra   store_flag
2296 5DAD
2297 5DAD E0 44 00     next56   cpx   #'D'
2298 5DB0 D0 05                 bne   next57
2299 5DB2
2300 5DB2 09 80 00              ora   #I_ENABLED               Disable item.
2301 5DB5 80 08                 bra   store_flag
2302 5DB7
2303 5DB7 E0 58 00     next57   cpx   #'X'
2304 5DBA D0 08                 bne   next58
2305 5DBC
2306 5DBC 49 20 00              eor   #I_NO_XOR                Clear XOR highlighting flag.
2307 5DBF 85 F8        store_flag sta   <flag
2308 5DC1 82 2F FF     tolop52  brl   lop52
2309 5DC4
2310 5DC4 8A           next58   txa                            Zero terminator?
2311 5DC5 F0 05                 beq   endofline
2312 5DC7
2313 5DC7 E0 0D 00              cpx   #13                      Return?
2314 5DCA D0 F5                 bne   tolop52
2315 5DCC
2316 5DCC 84 FC        endofline sty   <real_len
2317 5DCE
2318 5DCE E6 64                 inc   <strg_ptr                Move string pointer past first byte.
2319 5DD0 D0 02                 bne   exit58
2320 5DD2 E6 64                 inc   <strg_ptr
2321 5DD4
2322 5DD4 FA           exit58   plx   
2323 5DD5 60                    rts   
2324 5DD6
2325 5DD6
2326 5DD6              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2327 5DD6              ;          Parse an item string an
2328 5DD6              ;          build item record.
2329 5DD6              ;
2330 5DD6              ;   IN:    strg_ptr = pointer to item string.
2331 5DD6              ;          itemptr = pointer to item record.
2332 5DD6              ;          x = zero to just parse string, nonzero to parse and build record.
2333 5DD6              ;
2334 5DD6              ;  OUT:    strg_ptr = same as in.
2335 5DD6              ;          itemptr = next item space.
2336 5DD6              ;          x = same as in.
2337 5DD6              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2338 5DD6                       ENTRY parse_item
2339 5DD6 20 B4 5C     parse_item jsr   parse_strg
2340 5DD9              ;
2341 5DD9              ; ------------ Link item into item list -----------------
2342 5DD9              ;
2343 5DD9 9B                    txy                            Just counting?
2344 5DDA F0 2F                 beq   exit2
2345 5DDC
2346 5DDC              ;
2347 5DDC              ; ------------ Store item's ID number -------------------
2348 5DDC              ;
2349 5DDC A5 50                 lda   <count
2350 5DDE 87 24                 sta   [<itemptr]               Store item's ID number.
2351 5DE0
2352 5DE0              ;
2353 5DE0              ; ------------ Store address of item's string -----------
2354 5DE0              ;
2355 5DE0 A0 08 00              ldy   #ItemName
2356 5DE3 A5 64                 lda   <strg_ptr                Store pointer to item's text string.
2357 5DE5 97 24                 sta   [<itemptr],y
2358 5DE7 A5 66                 lda   <strg_ptr+2
2359 5DE9 C8                    iny   
2360 5DEA C8                    iny   
2361 5DEB 97 24        store3   sta   [<itemptr],y
2362 5DED
2363 5DED              ;
2364 5DED              ; ------------ Set item's primary and alternate keyboard equvalents ------
2365 5DED              ;
2366 5DED A0 02 00              ldy   #ItemChar
2367 5DF0 A5 F6                 lda   <command                 Both primary and alternate key equvalents.
2368 5DF2 97 24                 sta   [<itemptr],y
2369 5DF4
2370 5DF4              ;
2371 5DF4              ; ------------ Set item's check mark and flag -----------------------------
2372 5DF4              ;
2373 5DF4 C8                    iny   
2374 5DF5 C8                    iny   
2375 5DF6 A5 F4                 lda   <check_mark
2376 5DF8 97 24                 sta   [<itemptr],y
2377 5DFA
2378 5DFA C8                    iny   
2379 5DFB C8                    iny   
2380 5DFC A5 F8                 lda   <flag
2381 5DFE 97 24                 sta   [<itemptr],y             Store mark and flag.
2382 5E00
2383 5E00 20 37 74              jsr   next_item                Get pointer to next item space.
2384 5E03
2385 5E03 A0 0C 00              ldy   #NumOfItems              counter to keep track of the total number of
2386 5E06 B7 1C                 lda   [<menuptr],y             items in the menu
2387 5E08 1A                    inc   a
2388 5E09 97 1C                 sta   [<menuptr],y
2389 5E0B
2390 5E0B 60           exit2    rts   
2391 5E0C
2392 5E0C                       ENDP 
2393 5E0C
2394 5E0C
2395 5E0C              ;===========================================================================
2396 5E0C              ;
2397 5E0C              ;                   DisposeMenu
2398 5E0C              ;
2399 5E0C              ;                   Free allocated menu.
2400 5E0C              ;
2401 5E0C              ;   IN:    PUSH:LONG - handle of menu to delete.
2402 5E0C              ;
2403 5E0C              ;===========================================================================
2404 5E0C              DisposeMenu PROC 
2405 5E0C
2406 5E0C              menu     equ   input
2407 5E0C
2408 5E0C 20 97 8F              jsr   startup                  Do startup initialization for tool call.
2409 5E0F
2410 5E0F              ;
2411 5E0F              ; --- Free the menu record ----------------------------
2412 5E0F              ;
2413 5E0F A3 0C                 lda   menu+2,s                 Pass pointer to allocated block.
2414 5E11 48                    pha   
2415 5E12 A3 0C                 lda   menu+2,s
2416 5E14 48                    pha   
2417 5E15 A2 02 10 22           _DisposeHandle                 Free block.
2418 5E1C A8                    tay                            Return result from DisposeHandle.
2419 5E1D
2420 5E1D 82 96 31              brl   Epop4bytes
2421 5E20
2422 5E20                       ENDP 
2423 5E20
2424 5E20
2425 5E20              ;===========================================================================
2426 5E20              ;
2427 5E20              ;                   NewMenuBar2
2428 5E20              ;
2429 5E20              ;  IN: PUSH:WORD - RefDescriptor, describes what the next parameter is.
2430 5E20              ;      PUSH:LONG - MenuBarTemplateRef, pointer, handle, or resource ID of template
2431 5E20              ;      PUSH:LONG - Pointer to window's port or NIL for system menu bar
2432 5E20              ;
2433 5E20              ; OUT: LONG - handle to the menu bar record
2434 5E20              ;
2435 5E20              ;===========================================================================
2436 5E20              NewMenuBar2 PROC 
2437 5E20
2438 5E20                       DefineStack 
2439 5E20              menuBarPtr long 
2440 5E20              theHandle long 
2441 5E20              origMenuBarRef long 
2442 5E20              count1   word 
2443 5E20              count2   word 
2444 5E20              mem_needed word 
2445 5E20
2446 5E20              OrigB    byte 
2447 5E20              OrigD    word 
2448 5E20              RTLAdr1  block 3
2449 5E20              RTLAdr2  block 3
2450 5E20              menuOwner long 
2451 5E20              menuBarRef long 
2452 5E20              refDescriptor word 
2453 5E20              result   long 
2454 5E20
2455 5E20              zPageSize equ   OrigB-menuBarPtr
2456 5E20
2457 5E20 0B                    phd   
2458 5E21 8B                    phb   
2459 5E22 4B                    phk   
2460 5E23 AB                    plb   
2461 5E24
2462 5E24 3B                    tsc   
2463 5E25 38                    sec   
2464 5E26 E9 12 00              sbc   #zPageSize
2465 5E29 1B                    tcs   
2466 5E2A 5B                    tcd                            switch direct page into stack
2467 5E2B
2468 5E2B 64 05                 stz   <theHandle
2469 5E2D 64 07                 stz   <theHandle+2
2470 5E2F 64 09                 stz   <origMenuBarRef
2471 5E31 64 0B                 stz   <origMenuBarRef+2
2472 5E33 64 11                 stz   <mem_needed
2473 5E35
2474 5E35 48                    pha                            space for menu bar handle
2475 5E36 48                    pha   
2476 5E37 A5 1E                 lda   <menuOwner+2
2477 5E39 48                    pha   
2478 5E3A A5 1C                 lda   <menuOwner
2479 5E3C 48                    pha   
2480 5E3D A2 0F 15 22           _NewMenuBar                    get a new menu bar
2481 5E44
2482 5E44 68                    pla                            store menu bar hdl in our direct page
2483 5E45 85 26                 sta   <result
2484 5E47 68                    pla   
2485 5E48 85 28                 sta   <result+2
2486 5E4A
2487 5E4A A5 24                 lda   <refDescriptor
2488 5E4C 0A                    asl   a
2489 5E4D AA                    tax   
2490 5E4E 7C 51 5E              jmp   (table,x)
2491 5E51
2492 5E51 93 5E        table    DC W:pointer
2493 5E53 77 5E                 DC W:handle
2494 5E55 57 5E                 DC W:resourceID
2495 5E57
2496 5E57 A5 20        resourceID lda   <menuBarRef            save resource ID so we can use it to release this resource
2497 5E59 85 09                 sta   <origMenuBarRef          later
2498 5E5B A5 22                 lda   <menuBarRef+2
2499 5E5D 85 09                 sta   <origMenuBarRef          ROM 03 bug! Should be <origMenuBarRef+2
2500 5E5F
2501 5E5F 48                    pha                            space for result
2502 5E60 48                    pha   
2503 5E61 F4 08 80              PushWord #rMenuBar 
2504 5E64 A5 22                 lda   <menuBarRef+2
2505 5E66 48                    pha   
2506 5E67 A5 20                 lda   <menuBarRef
2507 5E69 48                    pha   
2508 5E6A A2 10 32 22           _CMLoadResource 
2509 5E71 68                    pla   
2510 5E72 85 20                 sta   <menuBarRef
2511 5E74 68                    pla   
2512 5E75 85 22                 sta   <menuBarRef+2
2513 5E77
2514 5E77 A5 20        handle   lda   <menuBarRef
2515 5E79 85 05                 sta   <theHandle
2516 5E7B A5 22                 lda   <menuBarRef+2
2517 5E7D 85 07                 sta   <theHandle+2
2518 5E7F
2519 5E7F A0 04 00              ldy   #4
2520 5E82 B7 05                 lda   [<theHandle],y
2521 5E84 09 00 80              ora   #$8000                   lock the handle and dereference it
2522 5E87 97 05                 sta   [<theHandle],y
2523 5E89 88                    dey   
2524 5E8A 88                    dey   
2525 5E8B B7 05                 lda   [<theHandle],y
2526 5E8D 85 22                 sta   <menuBarRef+2
2527 5E8F A7 05                 lda   [<theHandle]
2528 5E91 85 20                 sta   <menuBarRef
2529 5E93
2530 5E93 A0 02 00     pointer  ldy   #resMenuBarFlag
2531 5E96 B7 20                 lda   [<menuBarRef],y
2532 5E98 29 00 C0              and   #FIRST_TWO_BITS
2533 5E9B 18                    clc   
2534 5E9C 2A                    rol   a                        move carry into bit 0
2535 5E9D 2A                    rol   a                        move the last two bits into the first two bits
2536 5E9E 2A                    rol   a                        now a-reg is in correct format for a verb
2537 5E9F 85 24                 sta   <refDescriptor
2538 5EA1
2539 5EA1 A0 04 00              ldy   #MenuRef1
2540 5EA4
2541 5EA4 5A           nextMenu phy   
2542 5EA5 20 69 5F              jsr   getNextMenuRef
2543 5EA8 B0 10                 bcs   noMore
2544 5EAA A5 11                 lda   <mem_needed
2545 5EAC 18                    clc   
2546 5EAD 69 04 00              adc   #4
2547 5EB0 85 11                 sta   <mem_needed
2548 5EB2 68                    pla   
2549 5EB3 18                    clc   
2550 5EB4 69 04 00              adc   #4
2551 5EB7 A8                    tay   
2552 5EB8 80 EA                 bra   nextMenu
2553 5EBA
2554 5EBA 7A           noMore   ply   
2555 5EBB
2556 5EBB 48                    pha                            ;space for result
2557 5EBC 48                    pha   
2558 5EBD A5 28                 lda   <result+2                ;we need to increase the size of the handle returned
2559 5EBF 48                    pha                            ;from the NewMenuBar call to insert our menu
2560 5EC0 A5 26                 lda   <result                  ;record handles
2561 5EC2 48                    pha   
2562 5EC3 A2 02 18 22           _GetHandleSize 
2563 5ECA 68                    pla   
2564 5ECB
2565 5ECB 18                    clc   
2566 5ECC 65 11                 adc   <mem_needed
2567 5ECE 48                    pha   
2568 5ECF A5 28                 lda   <result+2
2569 5ED1 48                    pha   
2570 5ED2 A5 26                 lda   <result
2571 5ED4 48                    pha   
2572 5ED5 A2 02 19 22           _SetHandleSize 
2573 5EDC
2574 5EDC A0 04 00              ldy   #4                       ;lock and deref this our newly sized handle
2575 5EDF B7 26                 lda   [<result],y
2576 5EE1 09 00 80              ora   #$8000
2577 5EE4 97 26                 sta   [<result],y
2578 5EE6 88                    dey   
2579 5EE7 88                    dey   
2580 5EE8 B7 26                 lda   [<result],y
2581 5EEA 85 03                 sta   <menuBarPtr+2
2582 5EEC A7 26                 lda   [<result]
2583 5EEE 85 01                 sta   <menuBarPtr
2584 5EF0
2585 5EF0 A9 04 00              lda   #MenuRef1                ;get the first menu in the menu bar
2586 5EF3 85 0D                 sta   <count1                  ;keeps track of where we are in the menu bar record
2587 5EF5 A9 28 00              lda   #BARSIZE
2588 5EF8 85 0F                 sta   <count2
2589 5EFA
2590 5EFA A4 0D        getAnotherMenu ldy   <count1
2591 5EFC 20 69 5F              jsr   getNextMenuRef
2592 5EFF B0 27                 bcs   noMoreMenus
2593 5F01
2594 5F01 48                    pha                            ;space for handle to menu record
2595 5F02 48                    pha   
2596 5F03 A4 24                 ldy   <refDescriptor
2597 5F05 5A                    phy   
2598 5F06 48                    pha                            ;MenuTemplateRef
2599 5F07 DA                    phx   
2600 5F08 A2 0F 3E 22           _NewMenu2 
2601 5F0F A4 0F                 ldy   <count2                  ;Store menu handle into our menu bar record
2602 5F11 68                    pla   
2603 5F12 97 01                 sta   [<menuBarPtr],y
2604 5F14 C8                    iny   
2605 5F15 C8                    iny   
2606 5F16 68                    pla   
2607 5F17 97 01                 sta   [<menuBarPtr],y
2608 5F19 C8                    iny   
2609 5F1A C8                    iny   
2610 5F1B 84 0F                 sty   <count2
2611 5F1D A5 0D                 lda   <count1
2612 5F1F 18                    clc   
2613 5F20 69 04 00              adc   #4
2614 5F23 85 0D                 sta   <count1
2615 5F25 82 D2 FF              brl   getAnotherMenu
2616 5F28
2617 5F28 A4 0F        noMoreMenus ldy   <count2               ;terminator for menu bar record
2618 5F2A A9 00 00              lda   #0
2619 5F2D 97 01                 sta   [<menuBarPtr],y
2620 5F2F C8                    iny   
2621 5F30 C8                    iny   
2622 5F31 97 01                 sta   [<menuBarPtr],y
2623 5F33
2624 5F33 A5 06                 lda   <theHandle+1
2625 5F35 F0 29                 beq   exit
2626 5F37
2627 5F37 A0 04 00              ldy   #4
2628 5F3A B7 26                 lda   [<result],y              unlock the menu bar handle that we're passing back to caller
2629 5F3C 29 FF 7F              and   #$7FFF
2630 5F3F 97 26                 sta   [<result],y
2631 5F41
2632 5F41 B7 05                 lda   [<theHandle],y           unlock the menu bar handle to the resource menu bar
2633 5F43 29 FF 7F              and   #$7FFF
2634 5F46 97 05                 sta   [<theHandle],y
2635 5F48
2636 5F48 A5 09                 lda   <origMenuBarRef
2637 5F4A D0 04                 bne   releaseMenuBarRef
2638 5F4C A5 0B                 lda   <origMenuBarRef+2
2639 5F4E F0 10                 beq   exit
2640 5F50
2641 5F50 F4 08 80     releaseMenuBarRef PushWord #rMenuBar 
2642 5F53 A5 0B                 lda   <origMenuBarRef+2
2643 5F55 48                    pha   
2644 5F56 A5 09                 lda   <origMenuBarRef
2645 5F58 48                    pha   
2646 5F59 A2 10 33 22           _CMReleaseResource 
2647 5F60
2648 5F60 3B           exit     tsc   
2649 5F61 18                    clc   
2650 5F62 69 12 00              adc   #zPageSize
2651 5F65 1B                    tcs   
2652 5F66
2653 5F66 82 62 30              brl   pop10bytes
2654 5F69
2655 5F69              ;=======================================================
2656 5F69              ;
2657 5F69              ;                   getNextMenuRef
2658 5F69              ;
2659 5F69              ; IN: y-reg contains the index into the menu bar record
2660 5F69              ;
2661 5F69              ;=======================================================
2662 5F69                       ENTRY getNextMenuRef
2663 5F69              getNextMenuRef  
2664 5F69 B7 20                 lda   [<menuBarRef],y
2665 5F6B AA                    tax   
2666 5F6C C8                    iny   
2667 5F6D C8                    iny   
2668 5F6E 17 20                 ora   [<menuBarRef],y
2669 5F70 F0 04                 beq   terminate
2670 5F72 B7 20                 lda   [<menuBarRef],y
2671 5F74
2672 5F74 18                    clc   
2673 5F75 60                    rts   
2674 5F76
2675 5F76 38           terminate sec   
2676 5F77 60                    rts   
2677 5F78
2678 5F78                       ENDP 
2679 5F78
2680 5F78              ;===========================================================================
2681 5F78              ;
2682 5F78              ;                   NewMenuBar
2683 5F78              ;
2684 5F78              ;                   Allocate and initialize a menu bar.
2685 5F78              ;
2686 5F78              ;   IN:    PUSH:LONG - pointer to window's port that will own menu bar,
2687 5F78              ;                      zero for system menu bar.
2688 5F78              ;
2689 5F78              ;  OUT:    LONG - Handle of menu, zero if error.
2690 5F78              ;
2691 5F78              ;===========================================================================
2692 5F78              NewMenuBar PROC 
2693 5F78
2694 5F78              owner    equ   input
2695 5F78              result   equ   owner+4
2696 5F78
2697 5F78 20 97 8F              jsr   startup                  Do startup initialization for tool call.
2698 5F7B
2699 5F7B A9 2C 00              lda   #BARSIZE+4               Number of bytes to allocate.
2700 5F7E 20 27 60              jsr   make_block               Allocate memory.
2701 5F81 83 0E                 sta   result,s                 Return handle.
2702 5F83 85 20                 sta   <menuhand                Put handle here and leave barhand alone.
2703 5F85 8A                    txa   
2704 5F86 83 10                 sta   result+2,s
2705 5F88 85 22                 sta   <menuhand+2
2706 5F8A
2707 5F8A 20 90 7C              jsr   pushdefmenu              Pass pointer to source.
2708 5F8D D4 22                 pei   <menuhand+2              Pass handle of destination.
2709 5F8F D4 20                 pei   <menuhand
2710 5F91 F4 00 00              pea   0                        Pass number of bytes to move.
2711 5F94 F4 2C 00              pea   BARSIZE+4
2712 5F97 A2 02 28 22           _PtrToHand                     Move source into destination.
2713 5F9E
2714 5F9E              ;
2715 5F9E              ; --- Set menu bar's port to use -------------------------------------
2716 5F9E              ;
2717 5F9E 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand)
2718 5FA1
2719 5FA1 A5 46                 lda   <screenMode
2720 5FA3 D0 0D                 bne   In640                    Default already set to 10, so only change if in 320.
2721 5FA5
2722 5FA5 A0 11 00              ldy   #CtlFlag+1
2723 5FA8 B7 1C                 lda   [<menuPtr],y
2724 5FAA 29 80 FF              and   #$FF80                   Clear current starting position.
2725 5FAD 09 05 00              ora   #5                       Set new starting position to 5 for 320 mode.
2726 5FB0 97 1C                 sta   [<menuPtr],y
2727 5FB2
2728 5FB2 A9 6F 00     In640    lda   #menuColor               Compute address of default color table.
2729 5FB5 20 98 7C              jsr   pushData
2730 5FB8 A0 24 00              ldy   #CtlColor                Set default color table pointer.
2731 5FBB 68                    pla   
2732 5FBC 97 1C                 sta   [<menuPtr],y
2733 5FBE C8                    iny   
2734 5FBF C8                    iny   
2735 5FC0 68                    pla   
2736 5FC1 97 1C                 sta   [<menuPtr],y
2737 5FC3
2738 5FC3 A3 0C                 lda   owner+2,s
2739 5FC5 03 0A                 ora   owner,s
2740 5FC7 F0 07                 beq   useSystem                Already set?
2741 5FC9
2742 5FC9 A3 0C                 lda   owner+2,s
2743 5FCB 09 00 80              ora   #$8000                   Set 'not system menu bar' flag.
2744 5FCE 80 07                 bra   store1
2745 5FD0
2746 5FD0 20 95 7C     useSystem jsr   pushport                Set system port as owner.
2747 5FD3 68                    pla   
2748 5FD4 83 0C                 sta   owner+2,s
2749 5FD6 68                    pla   
2750 5FD7 83 0C        store1   sta   owner+2,s
2751 5FD9
2752 5FD9 A0 04 00              ldy   #CtlOwner                Assign owner.
2753 5FDC A3 0A                 lda   owner,s
2754 5FDE 97 1C                 sta   [<menuptr],y
2755 5FE0 C8                    iny   
2756 5FE1 C8                    iny   
2757 5FE2 A3 0C                 lda   owner+2,s
2758 5FE4 97 1C                 sta   [<menuptr],y
2759 5FE6 30 3C                 bmi   exit                     System menu bar?  If not exit.
2760 5FE8
2761 5FE8              ;
2762 5FE8              ; --- See if system menu bar should have fall down menus -----
2763 5FE8              ;
2764 5FE8 A9 0A 00              lda   #10                      Number of bytes to allocate.
2765 5FEB 20 27 60              jsr   make_block               Allocate memory.
2766 5FEE DA                    phx                            Save handle.
2767 5FEF 48                    pha   
2768 5FF0 85 EA                 sta   <work
2769 5FF2 86 EC                 stx   <work+2
2770 5FF4
2771 5FF4 F4 02 00              pea   2                        Get message.
2772 5FF7 F4 04 00              pea   4                        Message type.
2773 5FFA DA                    phx                            Pass handle to store message.
2774 5FFB 48                    pha   
2775 5FFC A2 01 15 22           _MessageCenter 
2776 6003 B0 18                 bcs   noMessage
2777 6005
2778 6005 A4 02                 ldy   $2                       ROM 03 bug! Should be #2
2779 6007 B7 EA                 lda   [<work],y
2780 6009 A8                    tay   
2781 600A A7 EA                 lda   [<work]
2782 600C 85 EA                 sta   <work
2783 600E 84 EC                 sty   <work+2
2784 6010
2785 6010 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand)
2786 6013
2787 6013 A0 06 00              ldy   #6                       Get fall down area.
2788 6016 B7 EA                 lda   [<work],y
2789 6018 A0 12 00              ldy   #CtlValue                Set fall down area.
2790 601B 97 1C                 sta   [<menuptr],y
2791 601D
2792 601D A2 02 10 22  noMessage _DisposeHandle                Free message handle.
2793 6024
2794 6024 82 8C 2F     exit     brl   pop4bytes
2795 6027
2796 6027                       ENDP 
2797 6027
2798 6027
2799 6027              ;===========================================================================
2800 6027              ;
2801 6027              ;                   Make_Block
2802 6027              ;
2803 6027              ;                   Allocate a block of memory.
2804 6027              ;
2805 6027              ;   IN:    a = number of bytes to allocate.
2806 6027              ;
2807 6027              ;  OUT:    a = low word of handle.
2808 6027              ;          x = high word of handle.
2809 6027              ;
2810 6027              ;===========================================================================
2811 6027              make_block PROC 
2812 6027
2813 6027 A4 06                 ldy   <MyID                    Pass ID.
2814 6029 A2 00 00              ldx   #0                       Pass attributes.
2815 602C 82 53 2F              brl   allocate3
2816 602F
2817 602F                       ENDP 
2818 602F
2819 602F
2820 602F              ;===========================================================================
2821 602F              ;
2822 602F              ;                   DrawMenuBar
2823 602F              ;
2824 602F              ;                   Draw Current Menu Bar
2825 602F              ;
2826 602F              ;   IN:    Nothing.
2827 602F              ;  OUT:    Nothing.
2828 602F              ;
2829 602F              ;===========================================================================
2830 602F              DrawMenuBar PROC 
2831 602F
2832 602F 20 97 8F              jsr   startup                  Do startup initialization for tool call.
2833 6032 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), locked.
2834 6035 F0 51                 beq   exit2                    Is there a current menu bar?
2835 6037
2836 6037 A0 10 00              ldy   #ctlFlag
2837 603A B7 14                 lda   [<barptr],y
2838 603C 29 80 00              and   #$0080                   Check if the menu bar is visible
2839 603F D0 47                 bne   exit2
2840 6041
2841 6041 20 27 63              jsr   to_myport                Switch to Menu Manager's port.
2842 6044 20 76 63              jsr   getcolor                 Get menu bar's color table pointer.
2843 6047
2844 6047              ;
2845 6047              ; --- Draw menu bar's box ------------------------
2846 6047              ;
2847 6047 A5 34                 lda   <outlineclr
2848 6049 20 E1 6C              jsr   setoutline
2849 604C
2850 604C D4 5A                 pei   <vert_pen
2851 604E F4 01 00              pea   1
2852 6051 A2 04 2C 22           _SetPenSize 
2853 6058
2854 6058 A4 30                 ldy   <norcolor                Pass color in Y.
2855 605A A6 16                 ldx   <barptr+2                Pass address of RECT in A and X.
2856 605C A5 14                 lda   <barptr
2857 605E 18                    clc   
2858 605F 69 08 00              adc   #CtlRect
2859 6062 90 01                 bcc   ok1
2860 6064 E8                    inx   
2861 6065
2862 6065 20 07 7D     ok1      jsr   drawrect                 Draw a blank menu bar (frame and inside).
2863 6068
2864 6068              ;
2865 6068              ; --- Print Titles ------------------
2866 6068              ;
2867 6068 20 35 62              jsr   getmfirst                Get pointer to first menu.
2868 606B F0 15                 beq   exit                     Are there any menus?
2869 606D
2870 606D F4 00 00     lop1     pea   0                        Draw title normal.
2871 6070 A7 1C                 lda   [<menuptr]
2872 6072 48                    pha                            Pass Menu's ID.
2873 6073 A2 0F 2C 22           _HiliteMenu                    Draw menu's title.
2874 607A
2875 607A 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), locked.
2876 607D 20 87 68              jsr   next_menu                Get pointer to next menu.
2877 6080 D0 EB                 bne   lop1
2878 6082
2879 6082 20 5C 63     exit     jsr   to_uport                 Restore caller's port.
2880 6085 20 C4 62              jsr   unlockMenuBar            Leave menu bar and menus unlocked.
2881 6088
2882 6088 82 18 2F     exit2    brl   pop0bytes                no error
2883 608B
2884 608B                       ENDP 
2885 608B
2886 608B
2887 608B              ;===========================================================================
2888 608B              ;
2889 608B              ;                   HideMenuBar
2890 608B              ;
2891 608B              ;                   This call takes the system menubar and hides it by adding
2892 608B              ;                   the menubar rect back to the desktop region. The invisible bit
2893 608B              ;                   in the menubar flag is set so that any subsequent DrawMenuBar
2894 608B              ;                   or HiliteMenu calls will check this bit before doing anything.
2895 608B              ;
2896 608B              ;  IN: nothing
2897 608B              ; OUT: current menu bar is set to the system menubar
2898 608B              ;
2899 608B              ;===========================================================================
2900 608B              HideMenuBar PROC 
2901 608B
2902 608B 20 97 8F              jsr   startup
2903 608E
2904 608E A5 09                 lda   <sysMenu+1               First check if there is a system menu bar
2905 6090 F0 45                 beq   exit1
2906 6092
2907 6092 20 82 62              jsr   sys_current              <barHand = <sysMen. Current = system
2908 6095 20 8B 62              jsr   lockmenubar
2909 6098
2910 6098 A0 10 00              ldy   #CtlFlag
2911 609B B7 14                 lda   [<barptr],y
2912 609D AA                    tax   
2913 609E 29 80 00              and   #$0080                   First check if menu bar is already invisible
2914 60A1 D0 31                 bne   ItsInvisible
2915 60A3
2916 60A3 8A                    txa   
2917 60A4 09 80 00              ora   #$0080                   Set invisible flag for menu bar
2918 60A7 97 14                 sta   [<barptr],y
2919 60A9
2920 60A9 A9 01 00              lda   #1                       Set Desktop operation for "toDesk", since we are hiding the
2921 60AC 85 58                 sta   <temp                    menu bar we need to add the rect back to the desktop.
2922 60AE 20 14 61              jsr   AddorSubRegion
2923 60B1
2924 60B1 48                    pha                            Reset all the SCBs which were initially altered
2925 60B2 A2 04 17 22           _GetMasterSCB                  by InitPalette.
2926 60B9 A2 04 14 22           _SetAllSCBs 
2927 60C0
2928 60C0 A6 16                 ldx   <barptr+2
2929 60C2 A5 14                 lda   <barptr                  ; refresh only the menu bar that got hidden
2930 60C4 18                    clc   
2931 60C5 69 08 00              adc   #CtlRect
2932 60C8 90 01                 bcc   noCarry
2933 60CA E8                    inx   
2934 60CB DA           noCarry  phx   
2935 60CC 48                    pha   
2936 60CD A2 0E 39 22           _RefreshDesktop 
2937 60D4
2938 60D4 20 C4 62     ItsInvisible jsr   unlockmenubar
2939 60D7
2940 60D7 82 C9 2E     exit1    brl   pop0bytes
2941 60DA
2942 60DA                       ENDP 
2943 60DA
2944 60DA
2945 60DA              ;===========================================================================
2946 60DA              ;
2947 60DA              ;                   ShowMenuBar
2948 60DA              ;
2949 60DA              ;                   This call shows a hidden system menu bar by subtracting the
2950 60DA              ;                   menu bar rect from the desktop and refreshing the desktop.
2951 60DA              ;                   The system menu bar is made the current menu bar.
2952 60DA              ;
2953 60DA              ;===========================================================================
2954 60DA              ShowMenuBar PROC 
2955 60DA
2956 60DA 20 97 8F              jsr   startup
2957 60DD
2958 60DD A5 09                 lda   <sysMenu+1               First check if there is a system menu bar
2959 60DF F0 30                 beq   exit2
2960 60E1
2961 60E1 20 82 62              jsr   sys_current              <barHand = <sysMen. Current = system
2962 60E4 20 8B 62              jsr   lockmenubar
2963 60E7
2964 60E7 A0 10 00              ldy   #ctlFlag
2965 60EA B7 14                 lda   [<barptr],y
2966 60EC AA                    tax   
2967 60ED 29 80 00              and   #$0080                   First check if menu bar is visible already.
2968 60F0 F0 1C                 beq   ItsVisible
2969 60F2
2970 60F2 8A                    txa   
2971 60F3 29 7F FF              and   #$FF7F                   Set the menu bar to visible.
2972 60F6 97 14                 sta   [<barptr],y
2973 60F8
2974 60F8 A9 00 00              lda   #0
2975 60FB 85 58                 sta   <temp                    Set the DeskTop operation to "fromDesk", since we're
2976 60FD 20 14 61              jsr   AddorSubRegion           showing the menu bar we need to subtract it from the desktop.
2977 6100
2978 6100 A2 0F 2A 22           _DrawMenuBar                   Show the menu bar by redrawing it.
2979 6107
2980 6107 A2 0F 2F 22           _InitPalette                   Reinitialize the SCBs in the menu bar so the apple logo
2981 610E              ;                                       shows up correctly.
2982 610E 20 C4 62     ItsVisible jsr   unlockmenubar
2983 6111
2984 6111 82 8F 2E     exit2    brl   pop0bytes
2985 6114
2986 6114                       ENDP 
2987 6114
2988 6114              ;==================================================
2989 6114              ;
2990 6114              ;                   AddorSubRegion
2991 6114              ;
2992 6114              ;  IN: <temp contains the operation for DeskTop call to perform
2993 6114              ;      <barptr is set the system menu bar
2994 6114              ; OUT: nothing
2995 6114              ;
2996 6114              ;==================================================
2997 6114              AddorSubRegion PROC 
2998 6114
2999 6114 48                    pha                            First get  a new region that we are going to use
3000 6115 48                    pha                            to add or subtract from the desktop region.
3001 6116 A2 04 67 22           _NewRgn 
3002 611D
3003 611D A3 01                 lda   1,s                      Store handle to region on our direct page space for now.
3004 611F 85 EA                 sta   <work
3005 6121 A3 03                 lda   3,s
3006 6123 85 EC                 sta   <work+2
3007 6125
3008 6125 A5 14                 lda   <barptr                  Calculate the pointer to the system menu bar's rectangle.
3009 6127 18                    clc   
3010 6128 69 08 00              adc   #ctlrect
3011 612B AA                    tax   
3012 612C A5 16                 lda   <barptr+2
3013 612E 69 00 00              adc   #0
3014 6131 48                    pha   
3015 6132 DA                    phx   
3016 6133 A2 04 6C 22           _RectRgn                       Convert our region to a rectanglar region.
3017 613A
3018 613A D4 58                 pei   <temp                    Add or subtract this region from our desktop, thereby
3019 613C D4 EC                 pei   <work+2                  showing or hiding the menu bar.
3020 613E D4 EA                 pei   <work
3021 6140 A2 0E 0C 22           _DeskTop 
3022 6147 90 03                 bcc   noerr
3023 6149 68                    pla   
3024 614A 68                    pla   
3025 614B 68                    pla   
3026 614C
3027 614C D4 EC        noerr    pei   <work+2
3028 614E D4 EA                 pei   <work
3029 6150 A2 04 68 22           _DisposeRgn 
3030 6157
3031 6157 60                    rts   
3032 6158
3033 6158                       ENDP 
3034 6158
3035 6158              ;===========================================================================
3036 6158              ;
3037 6158              ;                   HiliteMenu
3038 6158              ;
3039 6158              ;                   Print a Title.
3040 6158              ;
3041 6158              ;   IN:    PUSH:WORD - 0 = normal, 1 = highlighted, bit 15 =1 for invert.
3042 6158              ;          PUSH:WORD - Menu ID.
3043 6158              ;
3044 6158              ;===========================================================================
3045 6158              HiliteMenu PROC 
3046 6158
3047 6158              menunum  equ   input
3048 6158              flag     equ   menunum+2
3049 6158
3050 6158 20 97 8F              jsr   startup                  ;Do startup initialization for tool call.
3051 615B 20 8B 62              jsr   lockMenuBar              ;<barPtr = (<barHand), locked.
3052 615E F0 74                 beq   exit4                    ;Is there a current menu bar?
3053 6160
3054 6160 A0 10 00              ldy   #ctlFlag
3055 6163 B7 14                 lda   [<barptr],y
3056 6165 29 80 00              and   #$0080                   ;Is the menu bar invisible
3057 6168 D0 6A                 bne   exit4                    ;It's invisible
3058 616A
3059 616A A3 0A                 lda   menunum,s                ;ID of menu to hilite.
3060 616C 20 38 62              jsr   getmptr                  ;Get menu's pointer.
3061 616F F0 60                 beq   exit3                    ;Was the menu found?
3062 6171
3063 6171 20 27 63              jsr   to_myport                ;Switch to Menu Manager's port.
3064 6174 A2 04 36 22           _PenNormal 
3065 617B
3066 617B              ;
3067 617B              ; --- Draw title's background -------
3068 617B              ;
3069 617B A0 08 00              ldy   #CtlRect+y1
3070 617E B7 14                 lda   [<barptr],y
3071 6180 85 48                 sta   <menurect+y1
3072 6182
3073 6182 A0 0C 00              ldy   #CtlRect+y2
3074 6185 B7 14                 lda   [<barptr],y
3075 6187 85 4C                 sta   <menurect+y2
3076 6189
3077 6189 A0 0A 00              ldy   #menuFlag                ;Check if this menu is a pop-up menu.
3078 618C B7 1C                 lda   [<menuptr],y             ;If it is then we don't want to calculate the title's rect
3079 618E 29 01 00              and   #M_POPUP                 ;like we normally would for a regular menu.
3080 6191 F0 13                 beq   notPopup
3081 6193
3082 6193 A0 0A 00              ldy   #CtlRect+x1              ;We don't do the fudging that titlexstart does.
3083 6196 B7 14                 lda   [<barptr],y              ;The pop-up's title rect is calculated just by using the
3084 6198 85 4A                 sta   <menurect+x1             ;y1, y2, and x1 coordinates of the control rect and then
3085 619A              ;                                       ;calculating x2 by adding the titleWidth to x1.
3086 619A A0 0E 00              ldy   #TitleWidth
3087 619D 18                    clc   
3088 619E 77 1C                 adc   [<menuptr],y
3089 61A0 85 4E                 sta   <menurect+x2
3090 61A2
3091 61A2 C6 4C                 dec   <menurect+y2             Since this is a pop-up control we must account for the
3092 61A4              ;                                       bottom drop shadow which is a part of the control rect.
3093 61A4 80 0D                 bra   SkipThisShit
3094 61A6
3095 61A6 E6 48        notPopup inc   <menurect+y1
3096 61A8 C6 4C                 dec   <menurect+y2
3097 61AA
3098 61AA A3 0A                 lda   menunum,s                Find title's starting position.
3099 61AC 20 01 62              jsr   titlexstart
3100 61AF 86 4A                 stx   <menurect+x1
3101 61B1 84 4E                 sty   <menurect+x2
3102 61B3
3103 61B3 A3 0C        SkipThisShit lda   flag,s               Get hilite/unhilite flag.
3104 61B5 AA                    tax   
3105 61B6 10 0F                 bpl   skip1                    Requesting XOR highliting?
3106 61B8
3107 61B8 A0 0A 00              ldy   #MenuFlag                Will menu allow XOR highliting?
3108 61BB B7 1C                 lda   [<menuptr],y
3109 61BD 29 20 00              and   #M_NO_XOR                XOR flag set?
3110 61C0 D0 05                 bne   skip1
3111 61C2
3112 61C2 8A                    txa   
3113 61C3 29 FF 7F              and   #$7FFF                   Don't allow special XOR highlighting.
3114 61C6 AA                    tax   
3115 61C7
3116 61C7 8A           skip1    txa                            Pass hilite/unhilite flag in A.
3117 61C8 A2 03 00              ldx   #mDrawTitle
3118 61CB 20 C5 6F              jsr   dispatch
3119 61CE
3120 61CE 20 5C 63     exit2    jsr   to_uport                 Restore caller's port.
3121 61D1 20 C4 62     exit3    jsr   unlockMenuBar            Leave menu bar and menus unlocked.
3122 61D4
3123 61D4 82 DC 2D     exit4    brl   pop4bytes                no error
3124 61D7
3125 61D7                       ENDP 
3126 61D7
3127 61D7
3128 61D7              ;===========================================================================
3129 61D7              ;
3130 61D7              ;                   FlashMenuBar
3131 61D7              ;
3132 61D7              ;   IN:    None.
3133 61D7              ;  OUT:    None.
3134 61D7              ;
3135 61D7              ;===========================================================================
3136 61D7              FlashMenubar PROC 
3137 61D7
3138 61D7 20 97 8F              jsr   startup                  Do startup initialization for tool call.
3139 61DA 20 E6 61              jsr   qdraw                    Draw the menu bar with InvertColor.
3140 61DD 20 E6 61              jsr   qdraw                    Redraw the bar with barColor.
3141 61E0
3142 61E0 20 C4 62              jsr   unlockMenuBar            Leave menu bar and menus unlocked.
3143 61E3
3144 61E3 82 BD 2D              brl   pop0bytes                no error
3145 61E6
3146 61E6
3147 61E6              ; = = = = = = = = = = = = = = = = = = = = = = = = =
3148 61E6              ;        Code optimumzation
3149 61E6              ; = = = = = = = = = = = = = = = = = = = = = = = = =
3150 61E6              ;
3151 61E6 20 8B 62     qdraw    jsr   lockMenuBar              <barPtr = (<barHand), locked.
3152 61E9 F0 15                 beq   exit100                  Is there a current menu bar?
3153 61EB
3154 61EB 20 76 63              jsr   getcolor                 Get menu bar's color's.
3155 61EE              ;                                       work = color table pointer.
3156 61EE
3157 61EE A5 32                 lda   <hiliteclr               Swap normal and selected colors.
3158 61F0 87 EA                 sta   [<work]
3159 61F2
3160 61F2 A0 02 00              ldy   #2
3161 61F5 A5 30                 lda   <norcolor
3162 61F7 97 EA                 sta   [<work],y
3163 61F9
3164 61F9 A2 0F 2A 22           _DrawMenubar 
3165 6200 60           exit100  rts   
3166 6201
3167 6201                       ENDP 
3168 6201
3169 6201
3170 6201              ;===========================================================================
3171 6201              ;
3172 6201              ;                   TitleXStart
3173 6201              ;
3174 6201              ;                   Find title's starting position.
3175 6201              ;
3176 6201              ;   IN:    a = menu ID.
3177 6201              ;          barptr = menu bar pointer.
3178 6201              ;
3179 6201              ;  OUT:    x = x position of title's left side.
3180 6201              ;          y = x position of title's right side.
3181 6201              ;          menuptr set to menu pointer.
3182 6201              ;          a = 0 and equal flag is TRUE if no menu.
3183 6201              ;
3184 6201              ;===========================================================================
3185 6201              titlexstart PROC 
3186 6201
3187 6201              pos      equ   1
3188 6201              menunum  equ   pos+2
3189 6201
3190 6201 48                    pha                            Save menu ID.
3191 6202
3192 6202 A0 11 00              ldy   #CtlFlag+1
3193 6205 B7 14                 lda   [<barptr],y
3194 6207 29 7F 00              and   #$007F                   Start position of titles,
3195 620A 18                    clc   
3196 620B 65 5A                 adc   <vert_pen                plus width of left side vertical line,
3197 620D A0 0A 00              ldy   #CtlRect+x1              plus left side of menu bar,
3198 6210 77 14                 adc   [<barptr],y
3199 6212 48                    pha                            equal left side of first menu title.
3200 6213
3201 6213 20 35 62              jsr   getmfirst                Get pointer of first menu.
3202 6216 F0 16                 beq   exit                     Are there any menus?
3203 6218
3204 6218 A0 0E 00     lop1     ldy   #TitleWidth
3205 621B A3 01                 lda   pos,s
3206 621D AA                    tax                            Save last position.
3207 621E 18                    clc   
3208 621F 77 1C                 adc   [<menuptr],y
3209 6221 83 01                 sta   pos,s
3210 6223
3211 6223 A7 1C                 lda   [<menuptr]
3212 6225 C3 03                 cmp   menunum,s
3213 6227 F0 05                 beq   exit                     Is this the menu?
3214 6229
3215 6229 20 87 68              jsr   next_menu                Next menu.
3216 622C D0 EA                 bne   lop1                     Are there any more?
3217 622E              ;                                       Error to fall through.
3218 622E
3219 622E 7A           exit     ply                            Right side of title.
3220 622F 68                    pla                            Menu number.
3221 6230
3222 6230 A5 1C                 lda   <menuptr                 Return error state if any.
3223 6232 05 1E                 ora   <menuptr+2
3224 6234 60                    rts   
3225 6235
3226 6235                       ENDP 
3227 6235
3228 6235
3229 6235              ;===========================================================================
3230 6235              ;
3231 6235              ;                   GetMFirst
3232 6235              ;
3233 6235              ;                   Find menu pointer.
3234 6235              ;
3235 6235              ;   IN:    barptr = menu bar pointer.
3236 6235              ;
3237 6235              ;  OUT:    BEQ if menu not found.
3238 6235              ;          BNE if menu found, <menuPtr = pointer to menu record.
3239 6235              ;
3240 6235              ;===========================================================================
3241 6235              getmfirst PROC 
3242 6235
3243 6235 A9 00 00              lda   #0                       Find first menu.
3244 6238
3245 6238              ;================================================================
3246 6238              ;                   GetMPtr
3247 6238              ;
3248 6238              ;   IN:    a = menu ID number.
3249 6238              ;
3250 6238              ;================================================================
3251 6238                       ENTRY getmptr
3252 6238 AA           getmptr  tax   
3253 6239 F0 03                 beq   ok1
3254 623B
3255 623B A2 03 00              ldx   #3                       Find given ID.
3256 623E
3257 623E 20 44 62     ok1      jsr   getmhand                 Get handle of menu.
3258 6241 82 D1 00              brl   derefMenuHand            <menuptr = (<menuhand).
3259 6244
3260 6244
3261 6244              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3262 6244              ;          Find menu handle
3263 6244              ;
3264 6244              ;   IN:    a = menu's ID.
3265 6244              ;          x = search flag:
3266 6244              ;                0 = handle of first menu in list.
3267 6244              ;                1 = handle of last menu in list.
3268 6244              ;                2 = handle of menu before given menu.
3269 6244              ;                3 = handle of given menu.
3270 6244              ;
3271 6244              ;  OUT:    <menuhand = handle of menu.
3272 6244              ;
3273 6244              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3274 6244                       ENTRY getmhand
3275 6244              getmhand  
3276 6244
3277 6244              look_for equ   1
3278 6244              id       equ   look_for+2
3279 6244
3280 6244 48                    pha                            Save ID to search for.
3281 6245 DA                    phx                            Save search flag.
3282 6246
3283 6246 A9 28 00              lda   #MenuList                Start with first menu in menu list.
3284 6249 85 36                 sta   <menu_cnt
3285 624B 80 0A                 bra   enter100
3286 624D
3287 624D A3 01        lop100   lda   look_for,s               Is the first menu wanted?
3288 624F F0 22                 beq   exit100
3289 6251
3290 6251 A7 1C                 lda   [<menuptr]               Get menu's ID.
3291 6253 C3 03                 cmp   id,s                     Match?
3292 6255 F0 05                 beq   gotit100
3293 6257
3294 6257 20 87 68     enter100 jsr   next_menu                Get handle of menu from menu list.
3295 625A D0 F1                 bne   lop100
3296 625C
3297 625C A3 01        gotit100 lda   look_for,s
3298 625E F0 13                 beq   exit100
3299 6260
3300 6260 C9 03 00              cmp   #3
3301 6263 F0 0E                 beq   exit100
3302 6265
3303 6265 88                    dey                            Backup one menu handle.
3304 6266 88                    dey   
3305 6267 88                    dey   
3306 6268 88                    dey   
3307 6269 C0 28 00              cpy   #MenuList                Did we go too far?
3308 626C 90 05                 bcc   exit100
3309 626E
3310 626E 84 36                 sty   <menu_cnt
3311 6270 82 14 06              brl   next_menu                Get handle of menu from menu list.
3312 6273
3313 6273 68           exit100  pla                            Fix stack.
3314 6274 68                    pla   
3315 6275 60                    rts   
3316 6276
3317 6276                       ENDP 
3318 6276
3319 6276
3320 6276              ;===========================================================================
3321 6276              ;
3322 6276              ;                   SetCurrentBar
3323 6276              ;
3324 6276              ;                   Make last parameter passed the current menu bar.
3325 6276              ;
3326 6276              ;   IN:    Last parameter passed = menu bar handle.
3327 6276              ;
3328 6276              ;  OUT:    <barHand = last parameter passed.
3329 6276              ;
3330 6276              ;===========================================================================
3331 6276              setCurrentBar PROC 
3332 6276
3333 6276 A3 0C                 lda   input+2,s                Get menu bar pointer.
3334 6278 85 18                 sta   <barhand
3335 627A A3 0E                 lda   input+4,s
3336 627C 85 1A                 sta   <barhand+2
3337 627E 05 18                 ora   <barhand                 Menu bar passed?
3338 6280 D0 08                 bne   exit
3339 6282
3340 6282                       ENTRY sys_current
3341 6282              sys_current  
3342 6282 A5 08                 lda   <sysmenu                 Caller wants the system bar.
3343 6284 85 18                 sta   <barhand
3344 6286 A5 0A                 lda   <sysmenu+2
3345 6288 85 1A                 sta   <barhand+2
3346 628A
3347 628A 60           exit     rts   
3348 628B
3349 628B                       ENDP 
3350 628B
3351 628B
3352 628B              ;===========================================================================
3353 628B              ;
3354 628B              ;                   LockMenuBar
3355 628B              ;
3356 628B              ;                   Lock current menu bar & every menu.
3357 628B              ;
3358 628B              ;   IN:    <barHand = handle of current menu bar.
3359 628B              ;
3360 628B              ;  OUT:    BEQ if no current menu bar.
3361 628B              ;          BNE if <barPtr = (<barHand).
3362 628B              ;                 <barHand = locked.
3363 628B              ;                 Every menu in menu bar is locked.
3364 628B              ;
3365 628B              ;===========================================================================
3366 628B              lockMenuBar PROC 
3367 628B
3368 628B A5 19                 lda   <barHand+1               Is there a menu bar?
3369 628D F0 34                 beq   exit
3370 628F
3371 628F A0 04 00              ldy   #4                       Lock menu bar.
3372 6292 B7 18                 lda   [<barHand],y
3373 6294 09 00 80              ora   #$8000
3374 6297 97 18                 sta   [<barHand],y
3375 6299
3376 6299 88                    dey                            Dereference menu bar.
3377 629A 88                    dey   
3378 629B B7 18                 lda   [<barHand],y
3379 629D 85 16                 sta   <barPtr+2
3380 629F A7 18                 lda   [<barHand]
3381 62A1 85 14                 sta   <barPtr
3382 62A3
3383 62A3 D4 36                 pei   <menu_cnt                Save.
3384 62A5 D4 22                 pei   <menuhand+2
3385 62A7 D4 20                 pei   <menuhand
3386 62A9
3387 62A9 A9 28 00              lda   #MenuList                Start with first menu in menu list.
3388 62AC 85 36                 sta   <menu_cnt
3389 62AE 80 03                 bra   enter1
3390 62B0
3391 62B0 20 F1 62     lop1     jsr   lockMenuHand             <menuhand = locked.
3392 62B3
3393 62B3 20 87 68     enter1   jsr   next_menu                Get handle of menu from menu list.
3394 62B6 D0 F8                 bne   lop1
3395 62B8
3396 62B8 68                    pla                            Restore.
3397 62B9 85 20                 sta   <menuhand
3398 62BB 68                    pla   
3399 62BC 85 22                 sta   <menuhand+2
3400 62BE 68                    pla   
3401 62BF 85 36                 sta   <menu_cnt
3402 62C1
3403 62C1 A5 19                 lda   <barHand+1               Set BNE flag.
3404 62C3 60           exit     rts   
3405 62C4
3406 62C4                       ENDP 
3407 62C4
3408 62C4
3409 62C4              ;===========================================================================
3410 62C4              ;
3411 62C4              ;                   UnlockMenuBar
3412 62C4              ;
3413 62C4              ;                   Unlock current menu bar & every menu.
3414 62C4              ;
3415 62C4              ;   IN:    <barHand = handle of current menu bar.
3416 62C4              ;
3417 62C4              ;  OUT:    <barHand = locked.
3418 62C4              ;          Every menu in menu bar is unlocked.
3419 62C4              ;
3420 62C4              ;===========================================================================
3421 62C4              unlockMenuBar PROC 
3422 62C4
3423 62C4 A5 19                 lda   <barHand+1               Is there a menu bar?
3424 62C6 F0 28                 beq   exit
3425 62C8
3426 62C8 D4 36                 pei   <menu_cnt                Save.
3427 62CA D4 22                 pei   <menuhand+2
3428 62CC D4 20                 pei   <menuhand
3429 62CE
3430 62CE A9 28 00              lda   #MenuList                Start with first menu in menu list.
3431 62D1 85 36                 sta   <menu_cnt
3432 62D3 80 03                 bra   enter1
3433 62D5
3434 62D5 20 03 63     lop1     jsr   unlockMenuHand           <menuhand = unlocked.
3435 62D8
3436 62D8 20 87 68     enter1   jsr   next_menu                Get handle of menu from menu list.
3437 62DB D0 F8                 bne   lop1
3438 62DD
3439 62DD 68                    pla                            Restore.
3440 62DE 85 20                 sta   <menuhand
3441 62E0 68                    pla   
3442 62E1 85 22                 sta   <menuhand+2
3443 62E3 68                    pla   
3444 62E4 85 36                 sta   <menu_cnt
3445 62E6
3446 62E6 A0 04 00              ldy   #4                       Unlock menu bar.
3447 62E9 B7 18                 lda   [<barHand],y
3448 62EB 29 FF 7F              and   #$7FFF
3449 62EE 97 18                 sta   [<barHand],y
3450 62F0
3451 62F0 60           exit     rts   
3452 62F1
3453 62F1                       ENDP 
3454 62F1
3455 62F1
3456 62F1              ;===========================================================================
3457 62F1              ;
3458 62F1              ;                   LockMenuHand
3459 62F1              ;
3460 62F1              ;                   Lock <menuhand.
3461 62F1              ;
3462 62F1              ;   IN:    <menuhand = handle.
3463 62F1              ;
3464 62F1              ;  OUT:    <menuhand = locked.
3465 62F1              ;
3466 62F1              ;===========================================================================
3467 62F1              lockMenuHand PROC 
3468 62F1
3469 62F1 A0 04 00              ldy   #4
3470 62F4 B7 20                 lda   [<menuhand],y            Guess if this is a handle.
3471 62F6 29 FF 7F              and   #$7FFF
3472 62F9 D0 07                 bne   exit                     Attributes don't look like mine.
3473 62FB
3474 62FB B7 20                 lda   [<menuhand],y            Attributes look like a good handle,
3475 62FD 09 00 80              ora   #$8000                   I'll take a chance and lock it.
3476 6300 97 20                 sta   [<menuhand],y
3477 6302
3478 6302 60           exit     rts   
3479 6303
3480 6303                       ENDP 
3481 6303
3482 6303
3483 6303              ;===========================================================================
3484 6303              ;
3485 6303              ;                   UnlockMenuHand
3486 6303              ;
3487 6303              ;                   Unlock <menuhand.
3488 6303              ;
3489 6303              ;   IN:    <menuhand = handle.
3490 6303              ;
3491 6303              ;  OUT:    <menuhand = unlocked.
3492 6303              ;
3493 6303              ;===========================================================================
3494 6303              unlockMenuHand PROC 
3495 6303
3496 6303 A0 04 00              ldy   #4                       Unlock the menu.
3497 6306
3498 6306 B7 20                 lda   [<menuhand],y            Guess if this is a handle.
3499 6308 29 FF 7F              and   #$7FFF
3500 630B D0 07                 bne   exit                     Attributes don't look like mine.
3501 630D
3502 630D B7 20                 lda   [<menuhand],y
3503 630F 29 FF 7F              and   #$7FFF
3504 6312 97 20                 sta   [<menuhand],y
3505 6314 60           exit     rts   
3506 6315
3507 6315                       ENDP 
3508 6315
3509 6315
3510 6315              ;===========================================================================
3511 6315              ;
3512 6315              ;                   DerefMenuHand
3513 6315              ;
3514 6315              ;                   Dereference menu handle.
3515 6315              ;
3516 6315              ;   IN:    <menuhand = handle of menu bar record.
3517 6315              ;
3518 6315              ;  OUT:    BEQ if <menuHand = 0.
3519 6315              ;          BNE if <menuHand is not zero, <menuptr = (<menuhand).
3520 6315              ;
3521 6315              ;===========================================================================
3522 6315              derefMenuHand PROC 
3523 6315
3524 6315 A6 21                 ldx   <menuhand+1              Is there a menu handle?
3525 6317 F0 08                 beq   store1
3526 6319
3527 6319 A0 01 00              ldy   #1
3528 631C B7 20                 lda   [<menuhand],y            Dereference the handle.
3529 631E AA                    tax   
3530 631F A7 20                 lda   [<menuhand]
3531 6321
3532 6321 85 1C        store1   sta   <menuPtr
3533 6323 86 1D                 stx   <menuPtr+1
3534 6325 8A                    txa                            Set equal flag.
3535 6326 60                    rts   
3536 6327
3537 6327                       ENDP 
3538 6327
3539 6327
3540 6327              ;===========================================================================
3541 6327              ;
3542 6327              ;                   To_MyPort
3543 6327              ;
3544 6327              ;                   Switch to Menu Manager' port.
3545 6327              ;
3546 6327              ;===========================================================================
3547 6327              to_myport PROC 
3548 6327
3549 6327 A0 06 00              ldy   #CtlOwner+2              Use current port?
3550 632A B7 14                 lda   [<barptr],y
3551 632C 30 15                 bmi   exit
3552 632E
3553 632E 20 44 63              jsr   save_port                Save current port before switching.
3554 6331
3555 6331 A0 06 00              ldy   #CtlOwner+2              Switch to menu bar's port.
3556 6334 B7 14                 lda   [<barptr],y
3557 6336 48                    pha   
3558 6337 88                    dey   
3559 6338 88                    dey   
3560 6339 B7 14                 lda   [<barptr],y
3561 633B 48                    pha   
3562 633C A2 04 1B 22           _SetPort 
3563 6343
3564 6343 60           exit     rts   
3565 6344
3566 6344                       ENDP 
3567 6344
3568 6344
3569 6344              ;===========================================================================
3570 6344              ;
3571 6344              ;                   Save_Port
3572 6344              ;
3573 6344              ;                   Save current port, if not saved.
3574 6344              ;
3575 6344              ;===========================================================================
3576 6344              save_port PROC 
3577 6344
3578 6344 E6 6C                 inc   <port_nest               Nest Counter.
3579 6346
3580 6346 A5 68                 lda   <old_port                Something already saved?
3581 6348 05 6A                 ora   <old_port+2
3582 634A D0 0F                 bne   exit
3583 634C
3584 634C 48                    pha                            Space for current port handle.
3585 634D 48                    pha   
3586 634E A2 04 1C 22           _GetPort                       Get current port
3587 6355 68                    pla   
3588 6356 85 68                 sta   <old_port                Save.
3589 6358 68                    pla   
3590 6359 85 6A                 sta   <old_port+2
3591 635B
3592 635B 60           exit     rts   
3593 635C
3594 635C                       ENDP 
3595 635C
3596 635C
3597 635C              ;===========================================================================
3598 635C              ;
3599 635C              ;                   To_UPort
3600 635C              ;
3601 635C              ;                   Return original port.
3602 635C              ;
3603 635C              ;===========================================================================
3604 635C              to_uport PROC 
3605 635C
3606 635C A5 68                 lda   <old_port                Is there something to restore?
3607 635E A8                    tay   
3608 635F 05 6A                 ora   <old_port+2
3609 6361 F0 12                 beq   exit
3610 6363
3611 6363 C6 6C                 dec   <port_nest               Am I done calling myself?
3612 6365 D0 0E                 bne   exit
3613 6367
3614 6367 D4 6A                 pei   <old_port+2              Restore original port.
3615 6369 5A                    phy   
3616 636A A2 04 1B 22           _SetPort 
3617 6371 64 68                 stz   <old_port                Restore completed, ready for next save.
3618 6373 64 6A                 stz   <old_port+2
3619 6375
3620 6375 60           exit     rts   
3621 6376
3622 6376                       ENDP 
3623 6376
3624 6376
3625 6376              ;===========================================================================
3626 6376              ;
3627 6376              ;                   GetColor
3628 6376              ;
3629 6376              ;                   Get menu bar's color table pointer.
3630 6376              ;
3631 6376              ;   IN:    barptr = pointer to menu bar.
3632 6376              ;
3633 6376              ;  OUT:    <unhiliteclr = unhighlighted color.
3634 6376              ;          <hiliteclr = highlight color.
3635 6376              ;          <outlineclr = outline color.
3636 6376              ;          <work = pointer to menu bar's color table.
3637 6376              ;
3638 6376              ;===========================================================================
3639 6376              getcolor PROC 
3640 6376              ;
3641 6376              ; -- Set colors from color table, if there is one ------------
3642 6376              ;
3643 6376 A0 24 00              ldy   #CtlColor                Get pointer to color table.
3644 6379 B7 14                 lda   [<barptr],y
3645 637B 85 EA                 sta   <work
3646 637D C8                    iny   
3647 637E C8                    iny   
3648 637F B7 14                 lda   [<barptr],y
3649 6381 85 EC                 sta   <work+2
3650 6383 05 EA                 ora   <work
3651 6385 D0 0C                 bne   colorTableOK
3652 6387
3653 6387 A9 41 85              lda   #DefColorTable           If CtlColor is zero then use the default color table
3654 638A 85 EA                 sta   <work                    in ROM.
3655 638C A9 FD 00              lda   #^DefColorTable
3656 638F 85 EC                 sta   <work+2
3657 6391 80 3A                 bra   NotPopUpControl
3658 6393
3659 6393 A0 16 00     colorTableOK ldy   #ctlProc+2
3660 6396 B7 14                 lda   [<barptr],y
3661 6398 10 33                 bpl   NotPopUpControl
3662 639A
3663 639A A0 3C 00              ldy   #PopUpCtlRecord.ctlmoreflags
3664 639D B7 14                 lda   [<barptr],y
3665 639F 29 18 00              and   #$0018                   Get ref type for color table
3666 63A2 F0 29                 beq   NotPopUpControl
3667 63A4
3668 63A4 89 08 00              bit   #$0008
3669 63A7 D0 18                 bne   ItsAHandleRef
3670 63A9
3671 63A9 48           ItsAResource pha   
3672 63AA 48                    pha   
3673 63AB F4 0D 80              PushWord #$800d 
3674 63AE A5 EC                 lda   <work+2
3675 63B0 48                    pha   
3676 63B1 A5 EA                 lda   <work
3677 63B3 48                    pha   
3678 63B4 A2 10 32 22           _CMLoadResource 
3679 63BB 68                    pla   
3680 63BC 85 EA                 sta   <work
3681 63BE 68                    pla   
3682 63BF 85 EC                 sta   <work+2
3683 63C1
3684 63C1 A0 02 00     ItsAHandleRef ldy   #2
3685 63C4 B7 EA                 lda   [<work],y
3686 63C6 AA                    tax   
3687 63C7 A7 EA                 lda   [<work]
3688 63C9 85 EA                 sta   <work
3689 63CB 86 EC                 stx   <work+2
3690 63CD
3691 63CD              NotPopUpControl  
3692 63CD A0 04 00              ldy   #4                       Fetch colors from table.
3693 63D0 B7 EA        lop1     lda   [<work],y
3694 63D2 BB                    tyx   
3695 63D3 95 30                 sta   <norcolor,x
3696 63D5 88                    dey   
3697 63D6 88                    dey   
3698 63D7 10 F7                 bpl   lop1
3699 63D9
3700 63D9 60           exit     rts   
3701 63DA
3702 63DA                       ENDP 
3703 63DA
3704 63DA
3705 63DA              ;===========================================================================
3706 63DA              ;
3707 63DA              ;                   TrackMenu2
3708 63DA              ;
3709 63DA              ;                   Track user inside pop-up menu bar.
3710 63DA              ;
3711 63DA              ;===========================================================================
3712 63DA              trackmenu2 PROC 
3713 63DA
3714 63DA 64 54                 stz   <curselect               set no selection flag to start with
3715 63DC 64 6E                 stz   <inactItem               set no inactive item selected flag also
3716 63DE
3717 63DE 48           playitAgain pha   
3718 63DF F4 00 00              PushWord #0 
3719 63E2 A2 06 0F 22           _WaitMouseUp 
3720 63E9 68                    pla   
3721 63EA D0 22                 bne   keepgoing                if mouse up then we're done
3722 63EC
3723 63EC A5 38                 lda   <blink                   number of times to flash item
3724 63EE 0A                    asl   a                        double it for number of on/offs
3725 63EF 85 50        looper   sta   <count
3726 63F1 A5 54                 lda   <curselect               item to flash
3727 63F3 F0 16                 beq   byebye                   look ma! no item to flash
3728 63F5
3729 63F5 49 00 80              eor   #$8000                   flipflop hilite/unhilite bit
3730 63F8 85 54                 sta   <curselect
3731 63FA A2 04 00              ldx   #mDrawItem               send draw menu message
3732 63FD 20 C5 6F              jsr   dispatch
3733 6400
3734 6400 A0 00 30              ldy   #$3000                   time of delay
3735 6403 88           delay    dey   
3736 6404 D0 FD                 bne   delay
3737 6406
3738 6406 A5 50                 lda   <count                   next flash
3739 6408 3A                    dec   a
3740 6409 10 E4                 bpl   looper                   done?
3741 640B 82 6B 00     byebye   brl   Quit
3742 640E
3743 640E A9 3A 00     keepgoing lda   #yrat                   get new mouse location
3744 6411 20 64 8F              jsr   pushDPage
3745 6414 A2 06 0C 22           _GetMouse 
3746 641B
3747 641B A5 3C                 lda   <xrat                    is mouse in the pop-up menu
3748 641D C5 4A                 cmp   <menurect+x1
3749 641F 90 09                 bcc   notinrect
3750 6421 C5 4E                 cmp   <menurect+x2
3751 6423 B0 05                 bcs   notinrect
3752 6425 20 0C 66              jsr   checkbounds
3753 6428 90 07                 bcc   ckitems
3754 642A
3755 642A 64 50        notinrect stz   <count                  re-initialize some flags
3756 642C 64 6E                 stz   <inactItem
3757 642E
3758 642E 82 24 00              brl   redrawtheItem            if so then unhilite it
3759 6431
3760 6431 A2 01 00     ckitems  ldx   #mChoose                 check which item we've stumbled upon
3761 6434 20 C5 6F              jsr   dispatch
3762 6437
3763 6437 A8                    tay                            save a
3764 6438 A5 04                 lda   <globalFlag              is help on?
3765 643A 29 01 00              and   #G_HELP
3766 643D D0 09                 bne   nohelp
3767 643F
3768 643F 98                    tya                            don't allow disabled item selection
3769 6440 29 00 40              and   #$4000                   is the item disabled?
3770 6443 F0 03                 beq   nohelp
3771 6445
3772 6445 A0 00 00              ldy   #0                       if disabled, then it's a no hit
3773 6448
3774 6448 98           nohelp   tya   
3775 6449 85 50                 sta   <count                   store new selection
3776 644B 64 6E                 stz   <inactItem               clear inactive item flag, just in case
3777 644D
3778 644D AA                    tax                            save
3779 644E 29 00 40              and   #$4000                   is the item inactive?
3780 6451 F0 02                 beq   redrawtheItem
3781 6453
3782 6453 86 6E                 stx   <inactItem               remember over an inactive item
3783 6455
3784 6455 A5 54        redrawtheItem lda   <curselect          is the current hilited item number the same
3785 6457 C5 50                 cmp   <count                   as the new?
3786 6459 F0 18                 beq   cont_poll
3787 645B
3788 645B AA                    tax                            is there a currently hilited item?
3789 645C F0 09                 beq   skipit
3790 645E
3791 645E 29 FF 7F              and   #$7FFF                   pass item number as unhilited
3792 6461 A2 04 00              ldx   #mDrawItem
3793 6464 20 C5 6F              jsr   dispatch
3794 6467
3795 6467 A5 50        skipit   lda   <count                   newly hilited item index
3796 6469 85 54                 sta   <curselect               it is now the currently hilited
3797 646B F0 06                 beq   cont_poll
3798 646D
3799 646D A2 04 00              ldx   #mDrawItem
3800 6470 20 C5 6F              jsr   dispatch
3801 6473
3802 6473 20 47 66     cont_poll jsr   checkforScrolling
3803 6476 82 65 FF              brl   playitAgain
3804 6479
3805 6479 60           quit     rts   
3806 647A
3807 647A                       ENDP 
3808 647A
3809 647A
3810 647A              ;	APPEND MTRACK.ASM
3811 647A              ;
3812 647A              ; 03/30/87 Dan - Added SpecialRect call to frame and fill empty menu in one
3813 647A              ;                call.  The menu will be drawn via FillRect and FrameRect if
3814 647A              ;                the SpecialRect function or QDAux tool is not available.
3815 647A              ;
3816 647A              ;===========================================================================
3817 647A              ;
3818 647A              ;                   TrackMenu
3819 647A              ;
3820 647A              ;                   Track user inside menu bar.
3821 647A              ;
3822 647A              ;   IN:    barptr = pointer to locked menu bar.
3823 647A              ;          x = 2 if button started up, 0 if started down.
3824 647A              ;          yrat = y starting position of cursor.
3825 647A              ;          xrat = x starting position of cursor.
3826 647A              ;
3827 647A              ;  OUT:    a = selection.
3828 647A              ;          yrat = selected item's ID, zero if none selected.
3829 647A              ;          xrat = selected menu's ID, or dimmed item ID if help is on.
3830 647A              ;
3831 647A              ;===========================================================================
3832 647A              trackmenu PROC 
3833 647A
3834 647A 86 60                 stx   <startbutt               Save starting button state.
3835 647C
3836 647C 20 27 63              jsr   to_myport                Switch to Menu Manager's port.
3837 647F
3838 647F 20 76 63              jsr   GetColor
3839 6482 A5 30                 lda   <norcolor                Set the background pattern to background of menus.
3840 6484 20 B8 7C              jsr   pushcolor                Just in case we have a scrollable colored menu,
3841 6487 A2 04 34 22           _SetBackPat                    calling ScrollRect won't have flicker effect.
3842 648E
3843 648E 64 AC                 stz   <event+what              Clear my event record's event code.
3844 6490 80 03                 bra   enter1                   Check the given position first.
3845 6492
3846 6492              ;
3847 6492              ; ---------------------------------------------------------------------
3848 6492              ; --- Wait for a menu to be selected. ---------------------------------
3849 6492              ; ---------------------------------------------------------------------
3850 6492
3851 6492 20 9A 68     poll_bar jsr   getMEvent                Get the cursor's current position.
3852 6495
3853 6495 64 54        enter1   stz   <curselect               Set no selection flag to start with.
3854 6497 64 6E                 stz   <inactItem               Set no inactive item selected flag also.
3855 6499
3856 6499 A5 AC                 lda   <event+what              Get button event.
3857 649B C9 02 00              cmp   #MOUSEUP                 Has the button been released?
3858 649E D0 03                 bne   next1
3859 64A0 82 44 01              brl   exit                     Button released, return to caller.
3860 64A3
3861 64A3 C9 01 00     next1    cmp   #MOUSEDOWN               Has the mouse button gone down?
3862 64A6 D0 02                 bne   ok2
3863 64A8
3864 64A8 64 60                 stz   <startbutt               Set the global flag to BUTTON DOWN.
3865 64AA
3866 64AA              ;
3867 64AA              ; ------- Find out which menu mouse is over ----------------------------
3868 64AA              ;
3869 64AA 20 B2 6C     ok2      jsr   onbar                    Check if on menu bar at all.
3870 64AD D0 07                 bne   cont_1                   Yes, on menu bar.
3871 64AF
3872 64AF A5 60                 lda   <startbutt               Button up?
3873 64B1 F0 DF                 beq   poll_bar                 Continue to watch cursor.
3874 64B3 82 31 01              brl   exit                     If up and not on bar, then return.
3875 64B6
3876 64B6 20 35 62     cont_1   jsr   getmfirst                Start with the head of the list.
3877 64B9 F0 D7                 beq   poll_bar                 Are there any menus?
3878 64BB
3879 64BB A7 1C        lop1     lda   [<menuptr]               Get menu's ID.
3880 64BD 85 52                 sta   <titlenum                Keep menu's ID here.
3881 64BF
3882 64BF 20 01 62              jsr   titlexstart              Find the left and right sides of title.
3883 64C2 86 5C                 stx   <Titlex1                 Save left side of title.
3884 64C4 84 5E                 sty   <Titlex2                 Save right side of title.
3885 64C6 86 4A                 stx   <menurect+x1             Menu's left side is same as title's.
3886 64C8
3887 64C8 C4 3C                 cpy   <xrat                    Is cursor over this title?
3888 64CA 90 04                 bcc   nextmenu                 I already know we're on the bar,
3889 64CC E4 3C                 cpx   <xrat                    are we in the same column as
3890 64CE 90 07                 bcc   gotit                    the title?
3891 64D0
3892 64D0 20 87 68     nextmenu jsr   next_menu
3893 64D3 D0 E6                 bne   lop1                     Any more menus?
3894 64D5 F0 BB                 beq   poll_bar                 Try again with updated cursor position.
3895 64D7
3896 64D7              ; ----------------------------------------------------------
3897 64D7              ; --- Print items into menu --------------------------------
3898 64D7              ; ----------------------------------------------------------
3899 64D7
3900 64D7              gotit     
3901 64D7 20 EC 6C              jsr   pull_down                Draw a blank menu.
3902 64DA
3903 64DA              ;------------------------------------------------------
3904 64DA              ; --- Poll user for item selection --------------------
3905 64DA              ;------------------------------------------------------
3906 64DA
3907 64DA A5 AC        poll_menu lda   <event+what
3908 64DC C9 01 00              cmp   #MOUSEDOWN               Has button gone down?
3909 64DF D0 04                 bne   next3
3910 64E1
3911 64E1 64 60                 stz   <startbutt               Set BUTTON DOWN flag.
3912 64E3 80 27                 bra   ok7
3913 64E5
3914 64E5 C9 02 00     next3    cmp   #MOUSEUP
3915 64E8 D0 22                 bne   ok7
3916 64EA
3917 64EA              ; ------ Button has been released ----------------------------------------
3918 64EA              ;
3919 64EA A5 38        buttonup lda   <blink                   Number of times to flash item.
3920 64EC 0A                    asl   a                        Double it for number of on/offs.
3921 64ED 85 50        lop8     sta   <count
3922 64EF
3923 64EF A5 54                 lda   <curselect               Item to flash.
3924 64F1 F0 16                 beq   quit                     Exit if no selection made.
3925 64F3
3926 64F3 49 00 80              eor   #$8000                   FlipFlop hilite/unhilite bit.
3927 64F6 85 54                 sta   <curselect
3928 64F8 A2 04 00              ldx   #mDrawItem               Send draw menu message.
3929 64FB 20 C5 6F              jsr   dispatch
3930 64FE
3931 64FE A0 00 30     wait     ldy   #$3000                   Wait while the user admires my work.
3932 6501 88           delay    dey   
3933 6502 D0 FD                 bne   delay
3934 6504
3935 6504 A5 50                 lda   <count                   Next flash.
3936 6506 3A                    dec   a
3937 6507 10 E4                 bpl   lop8                     Done?
3938 6509 82 D8 00     quit     brl   exit2                    Pull up menu and return.
3939 650C
3940 650C              ; ------ Check if user is on menu bar, but has left menu's title's -----
3941 650C              ;
3942 650C 20 9A 68     ok7      jsr   getMEvent                Get a mouse event.
3943 650F
3944 650F 64 50                 stz   <count                   Start with cursor not over any item.
3945 6511
3946 6511 20 B2 6C              jsr   onbar                    Is cursor on menubar?
3947 6514 F0 2A                 beq   ckmenu                   If not, there's nothing to worry about.
3948 6516
3949 6516 A5 5C                 lda   <Titlex1                 On menubar, still over our title?
3950 6518 C5 3C                 cmp   <xrat
3951 651A B0 0F                 bcs   newmenu
3952 651C A5 5E                 lda   <Titlex2
3953 651E C5 3C                 cmp   <xrat
3954 6520 90 09                 bcc   newmenu
3955 6522
3956 6522 A5 D6                 lda   <uparrow                 check if we have an up arrow
3957 6524 F0 02                 beq   noUpArrow
3958 6526 E6 DA                 inc   <inUpArrow               tells routine CheckForScrolling to scroll up arrrow
3959 6528
3960 6528 82 95 00     noUpArrow brl   redrawitem              Unhilite the hilited item, if one is.
3961 652B
3962 652B              ; --------- Try to pull up menu and look for another. ----------------------
3963 652B              ;
3964 652B A5 54        newmenu  lda   <curselect               Is an item hilited?
3965 652D F0 0B                 beq   ok8
3966 652F
3967 652F 29 FF 7F              and   #$7FFF                   Pass item number as unhilited.
3968 6532 A2 04 00              ldx   #mDrawItem
3969 6535 20 C5 6F              jsr   dispatch                 Redraw the item as unhilited.
3970 6538
3971 6538 64 54                 stz   <curselect               No item selected (for pullup call).
3972 653A
3973 653A 20 26 6F     ok8      jsr   pullup
3974 653D 82 55 FF              brl   enter1                   Keep tracking user.
3975 6540
3976 6540              ;-----------------------------------------------
3977 6540              ;          Hit test for item on menu.
3978 6540              ;-----------------------------------------------
3979 6540              ;
3980 6540              ; --- Check if cursor is in the menu ------------------------------
3981 6540
3982 6540 A5 3C        ckmenu   lda   <xrat
3983 6542 C5 4A                 cmp   <menurect+x1             check if pt is within the left and right
3984 6544 90 09                 bcc   notinrect                boundaries of the menu rectangle
3985 6546 C5 4E                 cmp   <menurect+x2
3986 6548 B0 05                 bcs   notinrect
3987 654A 20 0C 66              jsr   checkbounds
3988 654D 90 4D                 bcc   ckitems                  mouse is inside the menu
3989 654F
3990 654F A0 0A 00     notinrect ldy   #menuFlag
3991 6552 B7 1C                 lda   [<menuptr],y
3992 6554 29 00 01              and   #AlwaysCallmChoose
3993 6557 F0 06                 beq   @1
3994 6559
3995 6559 A5 54                 lda   <curselect               check if there needs to an item unhighlighted first
3996 655B D0 02                 bne   @1
3997 655D 80 3D                 bra   ckitems
3998 655F
3999 655F 64 50        @1       stz   <count                   Not over any item.
4000 6561 64 6E                 stz   <inactItem               Not over any inactive item either.
4001 6563
4002 6563 A5 60                 lda   <startbutt               Is button up?
4003 6565 F0 59                 beq   redrawitem               If no, no need to check off menu.
4004 6567              ;
4005 6567              ; ------- Pull up menu if cursor leaves menu while button up ------------
4006 6567              ;
4007 6567 20 2A 75              jsr   pushmrect                Pass pointer to menurect.
4008 656A F4 F4 FF              pea   $FFF4                    Horizontal grace buffer.
4009 656D F4 F0 FF              pea   $FFF0                    Vertical grace buffer.
4010 6570 A2 04 4C 22           _InsetRect                     Expand menurect for grace buffer.
4011 6577
4012 6577 48                    pha   
4013 6578 20 25 75              jsr   pushyrat                 Pass pointer to point to check.
4014 657B 20 2A 75              jsr   pushmrect                Pass pointer to RECT to check.
4015 657E A2 04 4F 22           _PtInRect                      Check if outside grace buffer.
4016 6585
4017 6585 20 2A 75              jsr   pushmrect                Pass pointer to menurect.
4018 6588 F4 0C 00              pea   12                       Horizontal grace buffer.
4019 658B F4 10 00              pea   16                       Vertical grace buffer.
4020 658E A2 04 4C 22           _InsetRect                     Put menurect back the way it was.
4021 6595
4022 6595 68                    pla                            Non-zero if in, zero if not inside.
4023 6596 D0 28                 bne   redrawitem
4024 6598
4025 6598 64 54                 stz   <curselect               Off a menu, return no selection.
4026 659A 80 48                 bra   exit2
4027 659C
4028 659C              ; --- Cursor is in the menu, now hit test items ------------------------------
4029 659C              ;
4030 659C A2 01 00     ckitems  ldx   #mChoose                 Ask defProc to hit test items.
4031 659F 20 C5 6F              jsr   dispatch
4032 65A2
4033 65A2 A8                    tay                            Save A.
4034 65A3 A5 04                 lda   <globalFlag              Is help on?
4035 65A5 29 01 00              and   #G_HELP
4036 65A8 D0 09                 bne   ok3                      If on, allow disabled item selection.
4037 65AA
4038 65AA 98                    tya                            Don't allow disabled item selection.
4039 65AB 29 00 40              and   #$4000                   Is the item disabled?
4040 65AE F0 03                 beq   ok3                      If not, then OK.
4041 65B0
4042 65B0 A0 00 00              ldy   #0                       If disabled, then it's a no hit.
4043 65B3
4044 65B3 98           ok3      tya   
4045 65B4 85 50                 sta   <count                   Store new selection.
4046 65B6 64 6E                 stz   <inactItem               Clear inactive item flag, just in case.
4047 65B8
4048 65B8 AA                    tax                            Save.
4049 65B9 29 00 40              and   #$4000                   Is the item inactive?
4050 65BC F0 02                 beq   redrawitem
4051 65BE
4052 65BE 86 6E                 stx   <inactItem               Remember over an inactive item.
4053 65C0
4054 65C0              ; --- Item state has changed --------------------------------------------------
4055 65C0              ;
4056 65C0 A5 54        redrawitem lda   <curselect             Is the current hilited item number
4057 65C2 C5 50                 cmp   <count                   the same as the new?
4058 65C4 F0 18                 beq   cont_poll                State hasn't changed, continue to poll.
4059 65C6
4060 65C6              ; --------- Unhighlight current selection --------
4061 65C6              ;
4062 65C6 AA                    tax   
4063 65C7 F0 09                 beq   skip25                   Is there a currently hilited item?
4064 65C9
4065 65C9 29 FF 7F              and   #$7FFF                   Pass item number as unhilited.
4066 65CC A2 04 00              ldx   #mDrawItem
4067 65CF 20 C5 6F              jsr   dispatch                 Redraw the item as unhilited.
4068 65D2
4069 65D2              ; --------- Highlight new selection --------------
4070 65D2              ;
4071 65D2 A5 50        skip25   lda   <count                   Newly hilited item index.
4072 65D4 85 54                 sta   <curselect               It is now the currently hilited.
4073 65D6 F0 06                 beq   cont_poll                Is the new state a hilited item?
4074 65D8              ;                                       Pass item number in A.
4075 65D8
4076 65D8 A2 04 00              ldx   #mDrawItem
4077 65DB 20 C5 6F              jsr   dispatch                 Redraw the new item as hilited.
4078 65DE
4079 65DE 20 47 66     cont_poll jsr   checkForScrolling
4080 65E1 82 F6 FE              brl   poll_menu                Continue to poll user.
4081 65E4
4082 65E4              ;-------------------------------------
4083 65E4              ;          End of track menu.
4084 65E4              ;-------------------------------------
4085 65E4
4086 65E4 20 26 6F     exit2    jsr   pullup                   Erase the menu.
4087 65E7
4088 65E7              ;
4089 65E7              ; --- Return selection ---------------
4090 65E7              ;
4091 65E7 64 3A        exit     stz   <yrat                    Selection IDs returned in yrat, xrat.
4092 65E9 64 3C                 stz   <xrat                    So zero out, no selection, just in case.
4093 65EB
4094 65EB A5 54                 lda   <curselect               Was the user over an enabled item when
4095 65ED F0 1A                 beq   exit3                    the button was released?
4096 65EF 29 FF 3F              and   #$3FFF                   Mask off hilite bit,
4097 65F2 85 54                 sta   <curselect               to get just the item number.
4098 65F4
4099 65F4 A5 6E                 lda   <inactItem               Was the user over a disabled item when
4100 65F6 F0 0E                 beq   ok1                      the button was released?
4101 65F8
4102 65F8 29 FF 3F              and   #$3FFF
4103 65FB 85 54                 sta   <curselect               Item number to find ID for.
4104 65FD 20 78 68              jsr   get_ids                  Get the menu and item ID numbers.
4105 6600 85 3C                 sta   <xrat                    Return the disabled item ID in high word
4106 6602 64 3A                 stz   <yrat                    of TaskData and zero in the low word.
4107 6604 80 03                 bra   exit3
4108 6606
4109 6606 20 78 68     ok1      jsr   get_ids                  Selection made, get ID numbers.
4110 6609              ;
4111 6609 82 50 FD     exit3    brl   to_uport                 Restore caller's port.
4112 660C
4113 660C                       ENDP 
4114 660C
4115 660C
4116 660C              ;===========================================================================
4117 660C              ;
4118 660C              ;                   CheckBounds
4119 660C              ;
4120 660C              ;  IN:              <menurect = rectangle of current menu pulled down
4121 660C              ;                   <yrat = current y location of mouse
4122 660C              ; OUT:              carry clear if pt in bounds
4123 660C              ;                   carry set if pt otta bounds
4124 660C              ;
4125 660C              ;===========================================================================
4126 660C              checkBounds PROC 
4127 660C
4128 660C A5 D6                 lda   <upArrow                 ;check if there's an up arrow
4129 660E F0 11                 beq   upperbounds              ;0 = no up arrow, 1 = up arrow
4130 6610 A5 3A                 lda   <yrat
4131 6612 30 09                 bmi   WayOttaBounds
4132 6614 A5 48                 lda   <menurect+y1
4133 6616 18                    clc   
4134 6617 65 E6                 adc   <font_h
4135 6619 C5 3A                 cmp   <yrat                    ;check if pt is above or below arrow item
4136 661B 90 0A                 bcc   otherend                 ;it's below if clear
4137 661D E6 DA        WayOttaBounds inc   <inUpArrow          ;set flag that says mouse is in up arrow
4138 661F 80 22                 bra   ottaBounds               ;its otta bounds so set carry
4139 6621
4140 6621 A5 48        upperbounds lda   <menurect+y1
4141 6623 C5 3A                 cmp   <yrat                    ;check if pt above or below item #1
4142 6625 B0 1C                 bcs   ottaBounds               ;its below this item 1
4143 6627
4144 6627 A5 D8        otherend lda   <dwnArrow                ;check if there's a down arrow
4145 6629 F0 12                 beq   lowerbounds              ;0 = no down arrow, 1 = down arrow
4146 662B A5 3A                 lda   <yrat
4147 662D 30 14                 bmi   ottabounds
4148 662F A5 4C                 lda   <menurect+y2
4149 6631 38                    sec   
4150 6632 E5 E6                 sbc   <font_h                  ;check if pt above or below the down item
4151 6634 3A                    dec   a
4152 6635 C5 3A                 cmp   <yrat
4153 6637 B0 0C                 bcs   InMenu                   ;we're in the menu
4154 6639 E6 DC                 inc   <inDwnArrow              ;set flag that says mouse is in down arrow
4155 663B 80 06                 bra   ottaBounds
4156 663D
4157 663D A5 4C        lowerbounds lda   <menurect+y2
4158 663F C5 3A                 cmp   <yrat                    ;check if pt above or below last item
4159 6641 B0 02                 bcs   InMenu
4160 6643 38           ottaBounds sec   
4161 6644 60                    rts   
4162 6645
4163 6645 18           InMenu   clc   
4164 6646 60                    rts   
4165 6647
4166 6647                       ENDP 
4167 6647
4168 6647
4169 6647              ;===========================================================================
4170 6647              ;
4171 6647              ;                   CheckForScrolling
4172 6647              ;
4173 6647              ;                   checks if menu is a SCROLLER, if it is check if mouse
4174 6647              ;                   in up/down arrows, if it is then S C R O L L  man!
4175 6647              ;
4176 6647              ;                   Flags that are set to give more info on what to do after scrolling:
4177 6647              ;                   $8000 = get rid of up arrow and redraw first item in menu list
4178 6647              ;                   $4000 = get rid of down arrow and redraw last item in menu list
4179 6647              ;                   $2000 = draw up flag
4180 6647              ;                   $1000 = draw down arrow
4181 6647              ;
4182 6647              ;                   Scrolling Speeds: flags that are set in <count
4183 6647              ;                   $0000 = fast scrolling
4184 6647              ;                   $0800 = medium scrolling
4185 6647              ;
4186 6647              ;   IN:             <inUpArrow = set if in up arrow, therefore scroll
4187 6647              ;                   <inDwnArrow = set if in down arrow, therefore scroll the other way
4188 6647              ;                   <menuptr = ptr to current menu record
4189 6647              ;                   <menurect = rectangle corresponding to item in <count
4190 6647              ;                   <rect = rectangle that we calculate for _ScrollRect
4191 6647              ;
4192 6647              ;  OUT:             <uparrow, <dwnarrow, flags accordingly
4193 6647              ;
4194 6647              ;===========================================================================
4195 6647              checkForScrolling PROC 
4196 6647
4197 6647 A0 0A 00              ldy   #menuFlag
4198 664A B7 1C                 lda   [<menuptr],y
4199 664C 29 02 00              and   #M_SCROLL
4200 664F D0 03                 bne   checkmore
4201 6651 82 4B 01              brl   noScrolling
4202 6654
4203 6654              ;--------------------------------------------------------------------------
4204 6654              ;------  Check for up arrow  ----------------------------------------------
4205 6654
4206 6654 A5 DA        checkmore lda   <InUpArrow
4207 6656 D0 03                 bne   scrollup
4208 6658 82 48 00              brl   checkdown
4209 665B
4210 665B 64 DA        scrollup stz   <inUpArrow               reset flag
4211 665D C6 D0                 dec   <firstVisItem            first visible item in menu decrements by one
4212 665F A5 D0                 lda   <firstVisItem
4213 6661 85 50                 sta   <count                   this is the item that is scrolling into view
4214 6663 C9 02 00              cmp   #2                       when first item becomes 2 then up arrow disappears and
4215 6666 D0 09                 bne   NotFirstItem1            firstitem then becomes 1
4216 6668
4217 6668 A5 50                 lda   <count
4218 666A 09 00 80              ora   #$8000                   set flag that says get rid of up arrow and redraw
4219 666D 85 50                 sta   <count                   first item in list
4220 666F C6 D0                 dec   <firstVisItem
4221 6671
4222 6671 A0 0A 00     NotFirstItem1 ldy   #menuflag           check to see whether this is a regular menu or not
4223 6674 B7 1C                 lda   [<menuptr],y
4224 6676 29 01 00              and   #M_POPUP
4225 6679 F0 0D                 beq   @111
4226 667B
4227 667B A5 4C                 lda   <menurect+y2
4228 667D C5 E4                 cmp   <saveY2
4229 667F F0 07                 beq   @111
4230 6681
4231 6681 18                    clc   
4232 6682 65 E6                 adc   <font_h
4233 6684 85 4C                 sta   <menurect+y2
4234 6686 80 14                 bra   stillRoomInRect
4235 6688
4236 6688 A0 0C 00     @111     ldy   #NumOfItems
4237 668B B7 1C                 lda   [<menuptr],y
4238 668D C5 D2                 cmp   <lastVisItem             if lastVisItem is actual last item in menu then we need dwn arrow
4239 668F D0 09                 bne   NotLastItem1
4240 6691
4241 6691 A5 50                 lda   <count                   this means that the last item in menu is now out of view
4242 6693 09 00 10              ora   #$1000                   set flag that says draw down arrow
4243 6696 85 50                 sta   <count
4244 6698 C6 D2                 dec   <lastVisItem             lastVisItem decremented by 2, last item is out of view
4245 669A C6 D2        NotLastItem1 dec   <lastVisItem         and second to last item becomes the down arrow item
4246 669C
4247 669C 20 A0 67     stillRoomInRect jsr   setSpeedUp
4248 669F
4249 669F A4 E6                 ldy   <font_h                  horizontal scroll distance, scrolling down so it's positive
4250 66A1 80 53                 bra   Scroll_Man
4251 66A3
4252 66A3
4253 66A3              ;--------------------------------------------------------------------------
4254 66A3              ;------  Check for down arrow  --------------------------------------------
4255 66A3
4256 66A3 A5 DC        CheckDown lda   <InDwnArrow
4257 66A5 D0 03                 bne   scrolldown
4258 66A7 82 F5 00              brl   noScrolling
4259 66AA
4260 66AA 64 DC        scrolldown stz   <inDwnArrow            reset flag
4261 66AC E6 D2                 inc   <lastVisItem             since we're scrolling up, last vis item is incremented
4262 66AE A5 D2                 lda   <lastVisItem
4263 66B0 85 50                 sta   <count                   item that is scrolling into view
4264 66B2 1A                    inc   a
4265 66B3 A0 0C 00              ldy   #NumOfItems              if NumOfItems = totalitems-1 then we've scrolled up as
4266 66B6 D7 1C                 cmp   [<menuptr],y             much as we can, so bye bye down arrow
4267 66B8 D0 09                 bne   NotLastItem2
4268 66BA
4269 66BA A5 50                 lda   <count
4270 66BC 09 00 40              ora   #$4000                   set flag that says redraw last item in menu and get rid
4271 66BF 85 50                 sta   <count                   of the down arrow icon
4272 66C1 E6 D2                 inc   <lastVisItem
4273 66C3
4274 66C3 A0 0A 00     NotLastItem2 ldy   #menuflag
4275 66C6 B7 1C                 lda   [<menuptr],y
4276 66C8 29 01 00              and   #M_POPUP
4277 66CB F0 0D                 beq   notPopUpType2
4278 66CD
4279 66CD A5 48                 lda   <menurect+y1
4280 66CF C5 E2                 cmp   <saveY1
4281 66D1 F0 07                 beq   notPopUpType2
4282 66D3
4283 66D3 38                    sec   
4284 66D4 E5 E6                 sbc   <font_h
4285 66D6 85 48                 sta   <menurect+y1
4286 66D8 80 12                 bra   around
4287 66DA
4288 66DA A5 D0        notPopUpType2 lda   <firstVisItem       if FirstItem = 1 then scrolling up will scroll this item
4289 66DC C9 01 00              cmp   #1                       out of view, sooo... we need to put an up arrow in
4290 66DF D0 09                 bne   NotFirstItem2
4291 66E1
4292 66E1 A5 50                 lda   <count                   firstitem=1
4293 66E3 09 00 20              ora   #$2000                   set flag that says draw up arrow
4294 66E6 85 50                 sta   <count
4295 66E8 E6 D0                 inc   <firstVisItem            increment by two because item1 is scrolled out of view
4296 66EA E6 D0        NotFirstItem2 inc   <firstVisItem       and item2 becomes the up arrow therefore firstitem=3
4297 66EC
4298 66EC 20 B0 67     around   jsr   setSpeedDwn
4299 66EF
4300 66EF A5 E6                 lda   <font_h                  make it negative because we're scrolling up
4301 66F1 49 FF FF              eor   #$FFFF
4302 66F4 1A                    inc   a
4303 66F5 A8                    tay                            store value to scroll in y-reg
4304 66F6
4305 66F6 A5 48        Scroll_Man lda   <menurect+y1           calculate the rectangle to scroll
4306 66F8 A6 D6                 ldx   <uparrow                 our rectangle to scroll is <menurect if there are no
4307 66FA F0 03                 beq   noUp                     up/down arrows, if there are subtract them from our
4308 66FC 18                    clc                            rect
4309 66FD 65 E6                 adc   <font_h
4310 66FF 85 0C        noUp     sta   <rect+y1
4311 6701
4312 6701 A5 4C                 lda   <menurect+y2
4313 6703 A6 D8                 ldx   <dwnArrow
4314 6705 F0 03                 beq   noDown
4315 6707 38                    sec   
4316 6708 E5 E6                 sbc   <font_h
4317 670A 85 10        noDown   sta   <rect+y2
4318 670C
4319 670C 20 34 75              jsr   pushrect
4320 670F F4 00 00              pea   0                        no horizontal movement
4321 6712 5A                    phy                            vertical distance to scroll, set up above
4322 6713
4323 6713 F4 00 00              pea   0                        nil for region handle
4324 6716 F4 00 00              pea   0
4325 6719
4326 6719 A2 04 7E 22           _ScrollRect                    scroll the menu
4327 6720
4328 6720 E6 DE                 inc   <specialFlag             flag to tell draw_item to not use xor highlighting
4329 6722 A5 50                 lda   <count                   update the item that scrolled out of view
4330 6724 29 FF 07              and   #$07FF                   mask off high some bits to get just the item to redraw
4331 6727 A2 04 00              ldx   #mDrawItem
4332 672A 20 C5 6F              jsr   dispatch
4333 672D
4334 672D A5 50                 lda   <count
4335 672F 29 00 F0              and   #$F000                   check if any special flags were set
4336 6732 F0 3E                 beq   NoSpecial
4337 6734
4338 6734 A5 50                 lda   <count
4339 6736 29 00 80              and   #$8000
4340 6739 D0 09                 bne   redrawfirst
4341 673B
4342 673B A5 50                 lda   <count
4343 673D 29 00 40              and   #$4000
4344 6740 D0 09                 bne   redrawlast
4345 6742 80 14                 bra   DrawUpOrDown
4346 6744
4347 6744 A9 01 00     redrawFirst lda   #1                    erase up arrow and draw first item
4348 6747 64 D6                 stz   <upArrow
4349 6749 80 07                 bra   drawit
4350 674B
4351 674B A0 0C 00     redrawlast ldy   #NumOfItems            erase down arrow and draw last item
4352 674E B7 1C                 lda   [<menuptr],y
4353 6750 64 D8                 stz   <dwnArrow
4354 6752
4355 6752 A2 04 00     drawit   ldx   #mDrawItem
4356 6755 20 C5 6F              jsr   dispatch
4357 6758
4358 6758 A5 50        DrawUpOrDown lda   <count
4359 675A 29 00 20              and   #$2000
4360 675D F0 07                 beq   DrawDown
4361 675F
4362 675F E6 D6                 inc   <uparrow
4363 6761 20 C2 67              jsr   DrawUpArrow
4364 6764 80 0C                 bra   NoSpecial
4365 6766
4366 6766 A5 50        DrawDown lda   <count
4367 6768 29 00 10              and   #$1000
4368 676B F0 05                 beq   NoSpecial
4369 676D E6 D8                 inc   <dwnarrow
4370 676F 20 1C 68              jsr   DrawDwnArrow
4371 6772
4372 6772 A5 50        NoSpecial lda   <count                  see if the slow scroll flag is set
4373 6774 29 00 08              and   #$0800
4374 6777 F0 22                 beq   delayDone                if not then we don't need to run the delay
4375 6779
4376 6779 48                    pha                            get starting tick value
4377 677A 48                    pha   
4378 677B A2 03 25 22           _GetTick 
4379 6782 68                    pla                            just need low word of tick count
4380 6783 FA                    plx   
4381 6784 85 E0                 sta   <scrollCount             put starting tick value on our direct page
4382 6786
4383 6786 48           getNextTick pha   
4384 6787 48                    pha   
4385 6788 A2 03 25 22           _GetTick 
4386 678F 68                    pla   
4387 6790 FA                    plx   
4388 6791 38                    sec   
4389 6792 E5 E0                 sbc   <scrollCount
4390 6794 C9 14 00              cmp   #20                      our delay is 20 ticks or .33 seconds
4391 6797 B0 02                 bcs   delayDone
4392 6799 80 EB                 bra   getNextTick
4393 679B
4394 679B 64 50        delayDone stz   <count                  set to zero so that
4395 679D 64 DE                 stz   <specialFlag
4396 679F
4397 679F 60           NoScrolling rts   
4398 67A0
4399 67A0
4400 67A0              ;==================================================
4401 67A0              ;
4402 67A0              ; SetSpeedUp
4403 67A0              ;
4404 67A0 A5 3A        setSpeedUp lda   <yrat
4405 67A2 30 1D                 bmi   fast
4406 67A4 A5 48                 lda   <menurect+y1
4407 67A6 18                    clc                            the first 5 pixels of up arrow constitutes slow section
4408 67A7 69 07 00              adc   #7                       check if it's in the slow speed section
4409 67AA C5 3A                 cmp   <yrat
4410 67AC B0 13                 bcs   fast
4411 67AE 80 0A                 bra   setSlow
4412 67B0
4413 67B0              ;==================================================
4414 67B0              ;
4415 67B0              ; SetSpeedDwn
4416 67B0              ;
4417 67B0 A5 4C        setSpeedDwn lda   <menurect+y2
4418 67B2 38                    sec                            the first 5 pixels of down arrow constitutes slow section
4419 67B3 E9 07 00              sbc   #7                       check if it's in the slow speed section
4420 67B6 C5 3A                 cmp   <yrat
4421 67B8 90 07                 bcc   fast
4422 67BA A5 50        setSlow  lda   <count
4423 67BC 09 00 08              ora   #$0800                   set slow poke flag in count
4424 67BF 85 50                 sta   <count
4425 67C1
4426 67C1 60           fast     rts   
4427 67C2
4428 67C2                       ENDP 
4429 67C2
4430 67C2              ;===========================================================================
4431 67C2              ;
4432 67C2              ;                   DrawUpArrow
4433 67C2              ;
4434 67C2              ;  IN:              <menurect = rectangle of last item found, need x1, x2 only
4435 67C2              ;                   <rect = rect to be calculated for 1 item in menu list
4436 67C2              ;
4437 67C2              ; OUT:              nothing
4438 67C2              ;
4439 67C2              ;===========================================================================
4440 67C2              DrawUpArrow PROC 
4441 67C2
4442 67C2 A5 48                 lda   <menurect+y1             calculate the rectangle of first item
4443 67C4 85 0C                 sta   <rect+y1                 and store it in <rect
4444 67C6 18                    clc   
4445 67C7 65 E6                 adc   <font_h
4446 67C9 85 10                 sta   <rect+y2
4447 67CB 20 34 75              jsr   pushrect                 rect of first item in menu
4448 67CE
4449 67CE A5 30                 lda   <norcolor                fill in rect will background color of menu
4450 67D0 20 B8 7C              jsr   PushColor
4451 67D3 A2 04 57 22           _FillRect 
4452 67DA
4453 67DA F4 04 00              pea   4                        Transfer forground pixels only.
4454 67DD A2 04 9C 22           _SetTextMode 
4455 67E4
4456 67E4 A5 46                 lda   ScreenMode
4457 67E6 F0 0E                 beq   ModeIs320
4458 67E8
4459 67E8 F4 FD 00 F4           PushLong #UpArrowLocInfo640 
4460 67EE F4 FD 00 F4           PushLong #UpArrowBounds640 
4461 67F4 80 0C                 bra   FinishThisSucker
4462 67F6
4463 67F6              ModeIs320  
4464 67F6 F4 FD 00 F4           PushLong #UpArrowLocInfo320 
4465 67FC F4 FD 00 F4           PushLong #UpArrowBounds320 
4466 6802              FinishThisSucker  
4467 6802
4468 6802 A5 62                 lda   <text_width
4469 6804 18                    clc                            don't wan't any carry to be rotating in on us
4470 6805 6A                    ror   a
4471 6806 18                    clc   
4472 6807 65 4A                 adc   <menurect+x1             width to indent before drawing the up arrow, same
4473 6809 65 62                 adc   <text_width              indentation as when we're drawing an item.
4474 680B 48                    pha                            x coordinate of upper left corner of icon
4475 680C A5 48                 lda   <menurect+y1
4476 680E 1A                    inc   a
4477 680F 1A                    inc   a
4478 6810 48                    pha                            y coordinate of upper left corner of icon
4479 6811 F4 03 80              pea   $8003
4480 6814 A2 04 D6 22           _PPToPort 
4481 681B
4482 681B 60                    rts   
4483 681C
4484 681C                       ENDP 
4485 681C
4486 681C
4487 681C              ;===========================================================================
4488 681C              ;
4489 681C              ;                   DrawDwnArrow
4490 681C              ;
4491 681C              ;===========================================================================
4492 681C              DrawDwnArrow PROC 
4493 681C
4494 681C              LocInfoRec equ   work
4495 681C
4496 681C A5 4C                 lda   <menurect+y2             calculate the rectangle for the last item in list
4497 681E 85 10                 sta   <rect+y2                 store result in <rect
4498 6820 38                    sec   
4499 6821 E5 E6                 sbc   <font_h
4500 6823 85 0C                 sta   <rect+y1
4501 6825 20 34 75              jsr   pushrect                 rect for last item in menu
4502 6828
4503 6828 A5 30                 lda   <norcolor
4504 682A 20 B8 7C              jsr   PushColor
4505 682D A2 04 57 22           _FillRect 
4506 6834
4507 6834 F4 04 00              pea   4                        Transfer forground pixels only.
4508 6837 A2 04 9C 22           _SetTextMode 
4509 683E
4510 683E A5 46                 lda   ScreenMode
4511 6840 F0 0E                 beq   ModeIs320
4512 6842
4513 6842 F4 FD 00 F4           PushLong #DownArrowLocInfo640 
4514 6848 F4 FD 00 F4           PushLong #DownArrowBounds640 
4515 684E 80 0C                 bra   FinishThisSucker
4516 6850
4517 6850              ModeIs320  
4518 6850 F4 FD 00 F4           PushLong #DownArrowLocInfo320 
4519 6856 F4 FD 00 F4           PushLong #DownArrowBounds320 
4520 685C              FinishThisSucker  
4521 685C A5 62                 lda   <text_width
4522 685E 18                    clc                            don't wan't any carry to be rotating in on us
4523 685F 6A                    ror   a
4524 6860 18                    clc   
4525 6861 65 4A                 adc   <menurect+x1             amount of space to indent before drawing the down arrow.
4526 6863 65 62                 adc   <text_width              indentation is same as that used when drawing an item
4527 6865 48                    pha                            X coordinate of upper left corner of destination
4528 6866 A5 4C                 lda   <menurect+y2
4529 6868 38                    sec   
4530 6869 E9 0B 00              sbc   #11
4531 686C 48                    pha                            Y coordinate of upper left corner of destination
4532 686D F4 03 80              pea   $8003
4533 6870 A2 04 D6 22           _PPToPort 
4534 6877
4535 6877 60                    rts   
4536 6878
4537 6878                       ENDP 
4538 6878
4539 6878              ;===========================================================================
4540 6878              ;
4541 6878              ;                   Get_IDs
4542 6878              ;
4543 6878              ;                   Pack MenuID and ItemID.
4544 6878              ;
4545 6878              ;   IN:    <menuptr = pointer to menu.
4546 6878              ;          <itemptr = pointer to item.
4547 6878              ;          <curselect = item number.
4548 6878              ;
4549 6878              ;  OUT:    <yrat = item ID number.
4550 6878              ;          <xrat = menu ID number.
4551 6878              ;
4552 6878              ;===========================================================================
4553 6878              get_ids  PROC 
4554 6878
4555 6878 A7 1C                 lda   [<menuptr]               Get MenuID.
4556 687A 85 3C                 sta   <xrat
4557 687C
4558 687C A5 54                 lda   <curselect               Pass item number in A.
4559 687E A2 05 00              ldx   #mGetItemID
4560 6881 20 C5 6F              jsr   dispatch
4561 6884 85 3A                 sta   <yrat
4562 6886 60                    rts   
4563 6887
4564 6887                       ENDP 
4565 6887
4566 6887
4567 6887              ;===========================================================================
4568 6887              ;
4569 6887              ;                   Next_Menu
4570 6887              ;
4571 6887              ;                   Get next menu pointer.
4572 6887              ;
4573 6887              ;   IN:    barptr = pointer to menu bar.
4574 6887              ;          menu_cnt = index to next menu handle in menu list.
4575 6887              ;
4576 6887              ;  OUT:    menuptr = NextMenu.
4577 6887              ;          Equal flag is TRUE if no more menus.
4578 6887              ;          menu_cnt = menu_cnt + 4.
4579 6887              ;
4580 6887              ;===========================================================================
4581 6887              next_menu PROC 
4582 6887
4583 6887 A4 36                 ldy   <menu_cnt
4584 6889 B7 14                 lda   [<barptr],y
4585 688B 85 20                 sta   <menuhand
4586 688D C8                    iny   
4587 688E C8                    iny   
4588 688F B7 14                 lda   [<barptr],y
4589 6891 85 22                 sta   <menuhand+2
4590 6893 C8                    iny   
4591 6894 C8                    iny   
4592 6895 84 36                 sty   <menu_cnt                Store index to next menu.
4593 6897
4594 6897 82 7B FA              brl   derefMenuHand            <menuptr = (<menuhand).
4595 689A
4596 689A                       ENDP 
4597 689A
4598 689A
4599 689A              ;===========================================================================
4600 689A              ;
4601 689A              ;                   GetMEvent
4602 689A              ;
4603 689A              ;                   Get mouse event.
4604 689A              ;
4605 689A              ;  OUT:    event = event record.
4606 689A              ;          yrat = event+where+y1 in local.
4607 689A              ;          xrat = event+where+x1 in local.
4608 689A              ;
4609 689A              ;===========================================================================
4610 689A              getMEvent PROC 
4611 689A
4612 689A 48                    pha                            Space for return value.
4613 689B F4 06 00              pea   6                        Accept mouse up and down events.
4614 689E A9 AC 00              lda   #event                   Pass pointer to my event record.
4615 68A1 20 64 8F              jsr   pushDpage
4616 68A4 A2 06 0A 22           _GetNextEvent 
4617 68AB 68                    pla                            Get event flag, but I don't use it.
4618 68AC
4619 68AC A5 B6                 lda   <event+where+y1          Convert position of mouse to local.
4620 68AE 85 3A                 sta   <yrat
4621 68B0 A5 B8                 lda   <event+where+x1
4622 68B2 85 3C                 sta   <xrat
4623 68B4
4624 68B4 20 25 75              jsr   pushyrat
4625 68B7 A2 04 85 22           _GlobalToLocal 
4626 68BE
4627 68BE 60                    rts   
4628 68BF
4629 68BF                       ENDP 
4630 68BF
4631 68BF              ;===========================================================================
4632 68BF              ;
4633 68BF              ;                   PopUpMenuSelect
4634 68BF              ;
4635 68BF              ;                   Handle user interaction with pop-up menu. The bits M_CACHE and M_POPUP
4636 68BF              ;                   must be set in the menu flag. Upon entering these bits are set and
4637 68BF              ;                   restored to there original state when you exit.
4638 68BF              ;
4639 68BF              ;   IN:  PUSH:LONG - menuin: handle to menu
4640 68BF              ;        PUSH:WORD - popupflag: tells us what type of popup you want $0001 = with white space
4641 68BF              ;        PUSH:WORD - yloc:   top of current selection
4642 68BF              ;        PUSH:WORD - xloc:   left side of "popped-up" menu
4643 68BF              ;        PUSH:WORD - itemnum:item ID of current selection
4644 68BF              ;
4645 68BF              ;  OUT:  WORD - item selected
4646 68BF              ;
4647 68BF              ;===========================================================================
4648 68BF              PopUpMenuSelect PROC 
4649 68BF
4650 68BF              menuin   equ   input
4651 68BF              popupflag equ   menuin+4
4652 68BF              yloc     equ   popupflag+2
4653 68BF              xloc     equ   yloc+2
4654 68BF              itemnum  equ   xloc+2
4655 68BF              return   equ   itemnum+2
4656 68BF
4657 68BF                       import pushPortData
4658 68BF                       import popPortData
4659 68BF
4660 68BF 20 97 8F              jsr   startup
4661 68C2
4662 68C2 20 8B 62              jsr   lockmenubar
4663 68C5
4664 68C5 20 46 6A              jsr   saveColor
4665 68C8 20 76 63              jsr   GetColor
4666 68CB
4667 68CB A3 0A                 lda   menuin,s
4668 68CD 85 20                 sta   <menuhand
4669 68CF A3 0C                 lda   menuin+2,s
4670 68D1 85 22                 sta   <menuhand+2
4671 68D3
4672 68D3 20 F1 62              jsr   lockmenuhand
4673 68D6 20 15 63              jsr   derefmenuhand
4674 68D9
4675 68D9 A0 0A 00              ldy   #menuFlag
4676 68DC B7 1C                 lda   [<menuptr],y
4677 68DE 48                    pha                            Save original menuFlag on the stack
4678 68DF 09 01 00              ora   #M_POPUP                 Set the bit that says this is a pop-up menu
4679 68E2 29 F7 FF              and   #_M_CACHE                Clear cache bit, pop-up menus cannot be cached
4680 68E5 97 1C                 sta   [<menuptr],y
4681 68E7
4682 68E7 20 61 6A              jsr   InitStuff                initialize some zero page equates
4683 68EA
4684 68EA 20 25 74              jsr   getifirst                get first item in menu
4685 68ED F0 0B        checkNext beq   invalidItem             item not found, so return invalid item error
4686 68EF E6 D4                 inc   <currentSel              offset of item in list
4687 68F1 C3 16                 cmp   itemnum+2,s              have we found our initial selection?
4688 68F3 F0 1C                 beq   gotit
4689 68F5 20 37 74              jsr   next_item
4690 68F8 80 F3                 bra   checkNext
4691 68FA
4692 68FA A0 0C 00     invalidItem ldy   #NumOfItems           make sure the menu is not empty before assigning init. sel
4693 68FD B7 1C                 lda   [<menuptr],y             to first item in the menu list
4694 68FF D0 0B                 bne   @888
4695 6901 A9 01 00              lda   #1
4696 6904 85 4A                 sta   <menurect+x1
4697 6906 3A                    dec   a
4698 6907 85 4E                 sta   <menurect+x2
4699 6909 82 A5 00              brl   popEmpty
4700 690C A9 01 00     @888     lda   #1                       If item ID is invalid then I default to the first
4701 690F 85 D4                 sta   <currentSel              item in the menu list.
4702 6911
4703 6911 A2 02 00     gotit    ldx   #msize                   get menu width and height
4704 6914 20 C5 6F              jsr   dispatch
4705 6917
4706 6917              ;=============================================================================
4707 6917              ; calculate pop-up rectangle
4708 6917              ;
4709 6917 A3 12                 lda   yloc+2,s
4710 6919 3A                    dec   a
4711 691A 85 48                 sta   <menurect+y1             top of menu
4712 691C A3 14                 lda   xloc+2,s
4713 691E 85 4A                 sta   <menurect+x1             left edge of menu
4714 6920
4715 6920 A0 02 00              ldy   #menuwidth
4716 6923 18                    clc   
4717 6924 77 1C                 adc   [<menuptr],y
4718 6926 85 4E                 sta   <menurect+x2             right edge of menu
4719 6928
4720 6928 A0 04 00              ldy   #menuheight
4721 692B B7 1C                 lda   [<menuptr],y
4722 692D 18                    clc   
4723 692E 65 48                 adc   <menurect+y1             bottom of menu
4724 6930 1A                    inc   a                        make room for drop shadow
4725 6931 85 4C                 sta   <menurect+y2
4726 6933
4727 6933 A3 10                 lda   popupflag+2,s
4728 6935 29 40 00              and   #FType2PopUp
4729 6938 85 E2                 sta   <saveY1
4730 693A
4731 693A A5 D4                 lda   <currentSel              a-reg contains input to adjust rect
4732 693C 20 AA 6B              jsr   adjustRect               adjust rectangle to reflect current selection
4733 693F
4734 693F A5 D4                 lda   <currentSel              If the current selection is the first item in list then
4735 6941 C9 01 00              cmp   #1                       top of pop-up can't be adjusted any further.
4736 6944 F0 03                 beq   noAdjustTop
4737 6946
4738 6946 20 12 6B              jsr   adjustTop                current port rectangle
4739 6949
4740 6949 A5 D4        noAdjustTop lda   <currentSel           If the current selection is the last item in the menu then
4741 694B C5 D2                 cmp   <lastVisItem             the bottom cannot be adjusted any further.
4742 694D F0 0C                 beq   noAdjustBott
4743 694F 1A                    inc   a
4744 6950 C5 D2                 cmp   <lastVisItem
4745 6952 D0 04                 bne   @99
4746 6954 A5 E2                 lda   <saveY1
4747 6956 F0 03                 beq   noAdjustBott
4748 6958
4749 6958 20 5F 6B     @99      jsr   adjustBottom
4750 695B
4751 695B              noAdjustBott  
4752 695B A5 F0                 lda   <portRect+x1
4753 695D D0 0C                 bne   CheckLeftSideFirst
4754 695F
4755 695F A6 F0                 ldx   <portRect+x1
4756 6961 A5 F4                 lda   <portRect+x2
4757 6963 20 0D 6F              jsr   justifyRight             Move menu left if off right
4758 6966 20 FB 6E              jsr   justifyLeft              Move menu right if off left
4759 6969 80 0E                 bra   around
4760 696B
4761 696B              CheckLeftSideFirst  
4762 696B A6 F0                 ldx   <portRect+x1
4763 696D A5 F4                 lda   <portRect+x2
4764 696F 20 FB 6E              jsr   justifyLeft
4765 6972 A6 F0                 ldx   <portRect+x1
4766 6974 A5 F4                 lda   <portRect+x2
4767 6976 20 0D 6F              jsr   justifyRight
4768 6979
4769 6979              around    
4770 6979 A5 E2                 lda   <saveY1
4771 697B F0 03                 beq   @222
4772 697D
4773 697D 20 D9 69              jsr   doWhiteSpace             user wants the pop-up with the white space
4774 6980
4775 6980 E6 DE        @222     inc   <specialFlag             flag that tells pull_down2 to just draw box and shadow
4776 6982 20 24 81              jsr   pushPortData             save grafport vars...
4777 6985 20 7B 6D              jsr   pull_down2               draw the pop-up box, drop shadow
4778 6988 C6 DE                 dec   <specialFlag
4779 698A
4780 698A A5 48                 lda   <menurect+y1
4781 698C 1A                    inc   a
4782 698D 48                    pha   
4783 698E A5 4C                 lda   <menurect+y2
4784 6990 3A                    dec   a
4785 6991 48                    pha   
4786 6992
4787 6992 A5 E4                 lda   <saveY2
4788 6994 D0 09                 bne   @333
4789 6996
4790 6996 A5 48                 lda   <menurect+y1
4791 6998 18                    clc   
4792 6999 65 E2                 adc   <saveY1
4793 699B 85 48                 sta   <menurect+y1
4794 699D 80 07                 bra   saveWhite
4795 699F
4796 699F A5 4C        @333     lda   <menurect+y2
4797 69A1 38                    sec   
4798 69A2 E5 E2                 sbc   <saveY1
4799 69A4 85 4C                 sta   <menurect+y2
4800 69A6
4801 69A6 68           saveWhite pla   
4802 69A7 85 E4                 sta   <saveY2
4803 69A9 68                    pla   
4804 69AA 85 E2                 sta   <saveY1
4805 69AC
4806 69AC 20 CE 6E              jsr   NeverMind
4807 69AF 80 03                 bra   SkipPopEmpty
4808 69B1 20 24 81     popEmpty jsr   PushPortData
4809 69B4              SkipPopEmpty  
4810 69B4 20 DA 63              jsr   trackMenu2               ;track the mouse in the menu until a mouse up
4811 69B7 20 51 81              jsr   popPortData              ;restore this grafport
4812 69BA A5 54                 lda   <curselect               ;get user selection and return it on the stack
4813 69BC F0 02                 beq   noSelection
4814 69BE
4815 69BE A7 24                 lda   [<itemptr]               ;get the ID
4816 69C0 83 18        noSelection sta   return+2,s
4817 69C2
4818 69C2 E6 54                 inc   <curselect
4819 69C4 20 26 6F              jsr   pullup                   ;pull up the pop-up menu
4820 69C7
4821 69C7 A0 0A 00              ldy   #MenuFlag                ;Restore the menu flag to its original state.
4822 69CA 68                    pla   
4823 69CB 97 1C                 sta   [<menuptr],y
4824 69CD 20 03 63              jsr   unlockmenuhand
4825 69D0
4826 69D0 20 54 6A              jsr   restoreColor
4827 69D3
4828 69D3 20 C4 62              jsr   unlockmenubar
4829 69D6
4830 69D6 82 FA 25              brl   pop12bytes
4831 69D9
4832 69D9                       ENDP 
4833 69D9
4834 69D9
4835 69D9              ;==================================================
4836 69D9              ;
4837 69D9              ; doWhiteSpace
4838 69D9              ;
4839 69D9              ;  IN: <menuptr = ptr to current menu record
4840 69D9              ;      <menurect = rectangle of current menu
4841 69D9              ;
4842 69D9              ; OUT: <menurect = modified to account for white space
4843 69D9              ;
4844 69D9              ;==================================================
4845 69D9              doWhiteSpace PROC 
4846 69D9
4847 69D9              top      equ   work                     ;redefine some direct page equates
4848 69D9              bottom   equ   top+2
4849 69D9
4850 69D9 64 E2                 stz   <saveY1
4851 69DB
4852 69DB A5 D0                 lda   <firstVisItem
4853 69DD 38                    sec   
4854 69DE E9 01 00              sbc   #1                       ;find out if top was adjusted
4855 69E1 85 EA                 sta   <top                     ;if it has then we may need to add white space to bottom
4856 69E3
4857 69E3 A0 0C 00              ldy   #NumOfItems
4858 69E6 B7 1C                 lda   [<menuptr],y
4859 69E8 38                    sec   
4860 69E9 E5 D2                 sbc   <lastVisItem             ;find out if bottom was adjusted
4861 69EB 85 EC                 sta   <bottom                  ;if it has then we may need to add white space to the top
4862 69ED
4863 69ED A5 EA                 lda   <top
4864 69EF D0 09                 bne   @1
4865 69F1
4866 69F1 A5 EC                 lda   <bottom
4867 69F3 F0 0C                 beq   done                     ;pop-up fits on the screen
4868 69F5
4869 69F5 20 02 6A              jsr   addToTop
4870 69F8 80 07                 bra   done
4871 69FA
4872 69FA A5 EC        @1       lda   <bottom
4873 69FC D0 03                 bne   done
4874 69FE
4875 69FE 20 24 6A              jsr   addToBottom
4876 6A01
4877 6A01 60           done     rts   
4878 6A02
4879 6A02
4880 6A02              ;==========================================================
4881 6A02              ;
4882 6A02                       ENTRY addToTop
4883 6A02              addToTop  
4884 6A02 A9 00 00              lda   #0
4885 6A05 85 E4                 sta   <saveY2
4886 6A07
4887 6A07 C6 EC        subtractNext dec   <bottom
4888 6A09 A5 EC                 lda   <bottom
4889 6A0B F0 16                 beq   topDone
4890 6A0D A5 48                 lda   <menurect+y1
4891 6A0F 38                    sec   
4892 6A10 E5 E6                 sbc   <font_h
4893 6A12 30 0F                 bmi   topDone
4894 6A14 C5 EE                 cmp   <portRect+y1
4895 6A16 90 0B                 bcc   topDone
4896 6A18 85 48                 sta   <menurect+y1
4897 6A1A A5 E2                 lda   <saveY1
4898 6A1C 18                    clc   
4899 6A1D 65 E6                 adc   <font_h
4900 6A1F 85 E2                 sta   <saveY1
4901 6A21 80 E4                 bra   subtractNext
4902 6A23
4903 6A23 60           topDone  rts   
4904 6A24
4905 6A24              ;==========================================================
4906 6A24              ;
4907 6A24                       ENTRY addToBottom
4908 6A24              addToBottom  
4909 6A24 A9 01 00              lda   #1
4910 6A27 85 E4                 sta   <saveY2
4911 6A29
4912 6A29 C6 EA        addNext  dec   <top
4913 6A2B A5 EA                 lda   <top
4914 6A2D F0 16                 beq   bottomDone
4915 6A2F A5 4C                 lda   <menurect+y2
4916 6A31 18                    clc   
4917 6A32 65 E6                 adc   <font_h
4918 6A34 C5 F2                 cmp   <portRect+y2
4919 6A36 F0 0D                 beq   bottomDone
4920 6A38 B0 0B                 bcs   bottomDone
4921 6A3A 85 4C                 sta   <menurect+y2
4922 6A3C A5 E2                 lda   <saveY1
4923 6A3E 18                    clc   
4924 6A3F 65 E6                 adc   <font_h
4925 6A41 85 E2                 sta   <saveY1
4926 6A43 80 E4                 bra   addNext
4927 6A45
4928 6A45 60           bottomDone rts   
4929 6A46
4930 6A46
4931 6A46                       ENDP 
4932 6A46
4933 6A46              ;==================================================
4934 6A46              ;
4935 6A46              ; SaveColor/RestoreColor
4936 6A46              ;
4937 6A46              ;==================================================
4938 6A46              saveColor PROC 
4939 6A46
4940 6A46              xnorcolor equ   work+6                  ; save previous menu colors
4941 6A46              xhiliteclr equ   xnorcolor+2
4942 6A46              xoutlineclr equ   xhiliteclr+2
4943 6A46
4944 6A46 A5 30                 lda   <norcolor
4945 6A48 85 F0                 sta   <xnorcolor
4946 6A4A A5 32                 lda   <hiliteclr
4947 6A4C 85 F2                 sta   <xhiliteclr
4948 6A4E A5 34                 lda   <outlineclr
4949 6A50 85 F4                 sta   <xoutlineclr
4950 6A52 80 0C                 bra   done
4951 6A54
4952 6A54                       ENTRY restoreColor
4953 6A54              restoreColor  
4954 6A54 A5 F0                 lda   <xnorcolor
4955 6A56 85 30                 sta   <norcolor
4956 6A58 A5 F2                 lda   <xhiliteclr
4957 6A5A 85 32                 sta   <hiliteclr
4958 6A5C A5 F4                 lda   <xoutlineclr
4959 6A5E 85 34                 sta   <outlineclr
4960 6A60
4961 6A60 60           done     rts   
4962 6A61
4963 6A61                       ENDP 
4964 6A61
4965 6A61              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4966 6A61              ;
4967 6A61              ;          Init some direct page flags and get our port rect
4968 6A61              ;
4969 6A61              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4970 6A61              InitStuff PROC 
4971 6A61
4972 6A61              ;
4973 6A61              ; --- Before calculating if the menus need to be scrolled, we must first find
4974 6A61              ; --- the intersection between the VisRgn, ClipRgn and PortRect
4975 6A61              ;
4976 6A61 A9 EE 00              lda   #portRect                ;find out what the current port rect is set to
4977 6A64 20 64 8F              jsr   pushDPage                ;so we can make sure the menurect stays
4978 6A67 A2 04 20 22           _GetPortRect                   ;within these bounds
4979 6A6E
4980 6A6E 48                    pha                            ;Second source rectangle
4981 6A6F 48                    pha   
4982 6A70 A2 04 C9 22           _GetVisHandle 
4983 6A77 68                    pla   
4984 6A78 FA                    plx   
4985 6A79 20 D9 6A              jsr   IntersectRects
4986 6A7C
4987 6A7C 48                    pha   
4988 6A7D 48                    pha   
4989 6A7E A2 04 C7 22           _GetClipHandle 
4990 6A85 68                    pla   
4991 6A86 FA                    plx   
4992 6A87 20 D9 6A              jsr   IntersectRects
4993 6A8A
4994 6A8A A9 EE 00              lda   #portRect+y1             ;convert the port rect to global coordinates
4995 6A8D 20 64 8F              jsr   pushDPage
4996 6A90 A2 04 84 22           _LocalToGlobal 
4997 6A97
4998 6A97 A9 F2 00              lda   #portRect+y2
4999 6A9A 20 64 8F              jsr   pushDPage
5000 6A9D A2 04 84 22           _LocalToGlobal 
5001 6AA4
5002 6AA4 A5 EE                 lda   <portRect+y1             ;If our port is the apps window and the window is above
5003 6AA6 10 02                 bpl   @1                       ;the screen then make the upper otta bounds 0.
5004 6AA8 64 EE                 stz   <portRect+y1
5005 6AAA
5006 6AAA A9 C8 00     @1       lda   #ScreenWidth             ;If our port is the apps window and the window drops below
5007 6AAD C5 F2                 cmp   <portRect+y2             ;the screen then make the lower otta bounds the screen width.
5008 6AAF B0 02                 bcs   @2
5009 6AB1 85 F2                 sta   <portRect+y2
5010 6AB3
5011 6AB3 64 DA        @2       stz   <inUpArrow               ;init some flags that say this is a normal menu so far
5012 6AB5 64 DC                 stz   <inDwnArrow
5013 6AB7 64 D6                 stz   <upArrow
5014 6AB9 64 D8                 stz   <dwnArrow
5015 6ABB 64 DE                 stz   <specialFlag
5016 6ABD 64 D4                 stz   <currentSel
5017 6ABF 64 E2                 stz   <saveY1
5018 6AC1 64 E4                 stz   <saveY2
5019 6AC3
5020 6AC3 64 D0                 stz   <firstVisItem            ;first visible item is initially 1
5021 6AC5 E6 D0                 inc   <firstVisItem
5022 6AC7
5023 6AC7 A0 0C 00              ldy   #NumOfItems
5024 6ACA B7 1C                 lda   [<menuptr],y
5025 6ACC 85 D2                 sta   <lastVisItem             ;so far last visible item is last item in the menu list
5026 6ACE
5027 6ACE A0 0A 00              ldy   #MenuFlag                ;set flag telling us this is a normal non-scroller
5028 6AD1 B7 1C                 lda   [<menuptr],y
5029 6AD3 29 FD FF              and   #_M_SCROLL
5030 6AD6 97 1C                 sta   [<menuptr],y
5031 6AD8
5032 6AD8 60                    rts   
5033 6AD9
5034 6AD9              ;==================================================
5035 6AD9              ;
5036 6AD9              ;                   IntersectRects
5037 6AD9              ;
5038 6AD9              ; A-reg and X-reg contains a handle to a region. This routine takes this
5039 6AD9              ; handle and calculates the ptr to the region's bounding rectangle and stores
5040 6AD9              ; it in <temptr. It then intersects this rect with the rect found in <portRect.
5041 6AD9              ;
5042 6AD9              ;  IN: a = low word of handle to region, x = high word (source rect 1)
5043 6AD9              ;      <portRect contains the rectangle to intersect what's in a and x.
5044 6AD9              ; OUT: <portRect contains the intersection of the two rects
5045 6AD9              ;
5046 6AD9              ;==================================================
5047 6AD9                       ENTRY IntersectRects
5048 6AD9              IntersectRects  
5049 6AD9
5050 6AD9 85 28                 sta   <temptr
5051 6ADB 86 2A                 stx   <temptr+2
5052 6ADD A0 02 00              ldy   #2
5053 6AE0 B7 28                 lda   [<temptr],y
5054 6AE2 AA                    tax   
5055 6AE3 A7 28                 lda   [<temptr]
5056 6AE5 85 28                 sta   <temptr
5057 6AE7 86 2A                 stx   <temptr+2
5058 6AE9
5059 6AE9 A5 28                 lda   <temptr
5060 6AEB A6 2A                 ldx   <temptr+2
5061 6AED 18                    clc   
5062 6AEE 69 02 00              adc   #2                       Skip pass the length word
5063 6AF1 85 28                 sta   <temptr
5064 6AF3 90 03                 bcc   NoCarryFromAdd
5065 6AF5 E8                    inx   
5066 6AF6 85 2A                 sta   <temptr+2
5067 6AF8
5068 6AF8 48           NoCarryFromAdd pha                      Result space for SectRect call.
5069 6AF9 A9 EE 00              lda   #portRect                Source Rectangle 1
5070 6AFC 20 64 8F              jsr   pushDPage
5071 6AFF D4 2A                 pei   <temptr+2                Source Rectangle 2
5072 6B01 D4 28                 pei   <temptr
5073 6B03 A9 EE 00              lda   #portRect                Destination rectangle.
5074 6B06 20 64 8F              jsr   pushDPage
5075 6B09 A2 04 4D 22           _SectRect 
5076 6B10 68                    pla   
5077 6B11
5078 6B11 60                    rts   
5079 6B12
5080 6B12                       ENDP 
5081 6B12
5082 6B12              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5083 6B12              ;                   AdjustTop
5084 6B12              ;
5085 6B12              ;                   Check to see if the menu is too long. If so then
5086 6B12              ;                   shorten menu until it fits and set flag that says
5087 6B12              ;                   menu is scrollable.
5088 6B12              ;
5089 6B12              ;   IN:             <menurect = current menu rect.
5090 6B12              ;                   <portRect = rectangle of current port rect in global coord.
5091 6B12              ;
5092 6B12              ;  OUT:             <menurect top is chopped off until it can fit in
5093 6B12              ;                   the boundsRect
5094 6B12              ;
5095 6B12              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5096 6B12              adjustTop PROC 
5097 6B12
5098 6B12 A5 D4        adjustIt lda   <currentSel
5099 6B14 C5 D0                 cmp   <firstVisItem            if firstVisItem = currentSel then we're done adjusting
5100 6B16 D0 20                 bne   ok                       since we don't want to adjust the top of the menu rect
5101 6B18              ;                                       past the top of the pop-up rect
5102 6B18 A5 E2                 lda   <saveY1
5103 6B1A F0 05                 beq   @77
5104 6B1C
5105 6B1C E6 D0                 inc   <firstVisItem
5106 6B1E 82 31 00              brl   setupScroll
5107 6B21
5108 6B21 A5 48        @77      lda   <menurect+y1
5109 6B23 38                    sec   
5110 6B24 E5 E6                 sbc   <font_h
5111 6B26 85 48                 sta   <menurect+y1
5112 6B28 A5 D0                 lda   <firstVisItem
5113 6B2A 3A                    dec   a
5114 6B2B C9 01 00              cmp   #1
5115 6B2E D0 05                 bne   @1
5116 6B30 C6 D0                 dec   <firstVisItem
5117 6B32 82 29 00              brl   DoneAdjusting
5118 6B35 82 1A 00     @1       brl   setupScroll
5119 6B38
5120 6B38 A5 48        ok       lda   <menurect+y1
5121 6B3A 30 04                 bmi   pastTop
5122 6B3C C5 EE                 cmp   <portRect+y1
5123 6B3E B0 09                 bcs   topAdjusted
5124 6B40
5125 6B40 18           pastTop  clc   
5126 6B41 65 E6                 adc   <font_h
5127 6B43 85 48                 sta   <menurect+y1
5128 6B45 E6 D0                 inc   <firstVisItem
5129 6B47 80 C9                 bra   adjustIt
5130 6B49
5131 6B49 A5 D0        topAdjusted lda   <firstVisItem         if firstVisItem is still 1 then no adjusting was done
5132 6B4B C9 01 00              cmp   #1
5133 6B4E F0 0E                 beq   DoneAdjusting
5134 6B50
5135 6B50 E6 D0                 inc   <firstVisItem            account for up arrow
5136 6B52 E6 D6        setUpScroll inc   <upArrow              set flag that says we have an up arrow
5137 6B54
5138 6B54 A0 0A 00              ldy   #menuflag                set flag in menu record that says this menu scrolls
5139 6B57 B7 1C                 lda   [<menuptr],y
5140 6B59 09 02 00              ora   #M_SCROLL
5141 6B5C 97 1C                 sta   [<menuptr],y
5142 6B5E
5143 6B5E 60           DoneAdjusting rts   
5144 6B5F
5145 6B5F                       ENDP 
5146 6B5F
5147 6B5F
5148 6B5F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5149 6B5F              ;                   AdjustBottom
5150 6B5F              ;
5151 6B5F              ;                   Check to see if the menu is too long. If so then
5152 6B5F              ;                   shorten menu until it fits and set flag that says
5153 6B5F              ;                   menu is scrollable.
5154 6B5F              ;
5155 6B5F              ;   IN:             <menurect = current menu rect.
5156 6B5F              ;                   <portRect = rectangle of current port rect in global coord.
5157 6B5F              ;
5158 6B5F              ;  OUT:             <menurect bottom is chopped off until it can fit in
5159 6B5F              ;                   the boundsRect
5160 6B5F              ;
5161 6B5F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5162 6B5F              adjustBottom PROC 
5163 6B5F
5164 6B5F A5 4C                 lda   <menurect+y2
5165 6B61 C5 F2                 cmp   <portRect+y2             check if menu falls below bounds rect
5166 6B63              ;                                       if it does call -  S C R O L L Man
5167 6B63 90 44                 bcc   NoFancyScrolling
5168 6B65
5169 6B65 A5 E2                 lda   <saveY1                  Is this a type 2 popup? (a.k.a. white-space popup)
5170 6B67 D0 07                 bne   DecTotalHeight
5171 6B69
5172 6B69 A5 D2                 lda   <lastVisItem
5173 6B6B C9 04 00              cmp   #4
5174 6B6E 90 39                 bcc   NoFancyScrolling
5175 6B70
5176 6B70 A5 D2        DecTotalHeight lda   <lastVisItem
5177 6B72 C5 D4                 cmp   <currentSel
5178 6B74 F0 1C                 beq   alldone2
5179 6B76 C9 03 00              cmp   #3
5180 6B79 D0 04                 bne   @11
5181 6B7B A5 E2                 lda   <saveY1
5182 6B7D F0 0F                 beq   alldone
5183 6B7F
5184 6B7F A5 4C        @11      lda   <menurect+y2
5185 6B81 C5 F2                 cmp   <portRect+y2
5186 6B83 90 09                 bcc   alldone
5187 6B85 38                    sec   
5188 6B86 E5 E6                 sbc   <font_h
5189 6B88 85 4C                 sta   <menurect+y2             ;subtract height of one item at a time
5190 6B8A C6 D2                 dec   <lastVisItem             ;update last visible item
5191 6B8C 80 E2                 bra   DecTotalHeight
5192 6B8E
5193 6B8E C6 D2        alldone  dec   <lastVisItem             ;the down arrow at bottom of menu subtracts one
5194 6B90              ;                                       ;extra item from our view
5195 6B90 80 0B                 bra   setScrollFlag
5196 6B92
5197 6B92 A5 E2        alldone2 lda   <saveY1
5198 6B94 D0 F8                 bne   alldone
5199 6B96 A5 4C                 lda   <menurect+y2
5200 6B98 18                    clc   
5201 6B99 65 E6                 adc   <font_h
5202 6B9B 85 4C                 sta   <menurect+y2
5203 6B9D
5204 6B9D A0 0A 00     setScrollFlag ldy   #MenuFlag           ;set flag telling us this is going to be a
5205 6BA0 B7 1C                 lda   [<menuptr],y             ;scroller
5206 6BA2 09 02 00              ora   #M_SCROLL
5207 6BA5 97 1C                 sta   [<menuptr],y
5208 6BA7
5209 6BA7 E6 D8                 inc   <dwnarrow                ;it's scrollable so we need a down arrow
5210 6BA9
5211 6BA9 60           NoFancyScrolling rts   
5212 6BAA
5213 6BAA                       ENDP adjustBottom
5214 6BAA
5215 6BAA              ;===========================================================================
5216 6BAA              ;
5217 6BAA              ;                   AdjustRect
5218 6BAA              ;
5219 6BAA              ;                   Adjust menu rectangle to reflect current selection.
5220 6BAA              ;
5221 6BAA              ;  IN:              <menurect = rectangle to adjust
5222 6BAA              ;                   a-reg = current item selected in the pop-up menu
5223 6BAA              ;
5224 6BAA              ; OUT:              <menurect = adjusted
5225 6BAA              ;
5226 6BAA              ;===========================================================================
5227 6BAA              adjustRect PROC 
5228 6BAA
5229 6BAA A8                    tay                            contains the currently selected pop-up item
5230 6BAB 88           adjust   dey   
5231 6BAC F0 10                 beq   adjusted
5232 6BAE
5233 6BAE A5 48                 lda   <menurect+y1             move whole rect up one item at a time
5234 6BB0 38                    sec   
5235 6BB1 E5 E6                 sbc   <font_h
5236 6BB3 85 48                 sta   <menurect+y1
5237 6BB5
5238 6BB5 A5 4C                 lda   <menurect+y2
5239 6BB7 38                    sec   
5240 6BB8 E5 E6                 sbc   <font_h
5241 6BBA 85 4C                 sta   <menurect+y2
5242 6BBC 80 ED                 bra   adjust
5243 6BBE
5244 6BBE 60           adjusted rts   
5245 6BBF
5246 6BBF                       ENDP 
5247 6BBF
5248 6BBF
5249 6BBF              ;===========================================================================
5250 6BBF              ;
5251 6BBF              ;                   MenuSelect
5252 6BBF              ;
5253 6BBF              ;                   Handle user interaction with menu bar.
5254 6BBF              ;
5255 6BBF              ;   IN:  PUSH:LONG - pointer to event record which contains
5256 6BBF              ;                      point where button went down, should be in MenuBar.
5257 6BBF              ;        PUSH:LONG - MENUBAR handle, or zero for system bar.
5258 6BBF              ;
5259 6BBF              ;  OUT: Task record TaskData = Item ID in low word, menu ID in high word.
5260 6BBF              ;                              item ID = 0 if no selection was made.
5261 6BBF              ;
5262 6BBF              ;===========================================================================
5263 6BBF              MenuSelect PROC 
5264 6BBF
5265 6BBF              menuin   equ   input
5266 6BBF              eventptrIn equ   menuin+4
5267 6BBF
5268 6BBF              eventptr equ   work
5269 6BBF
5270 6BBF 20 97 8F              jsr   startup                  Do startup initialization for tool call.
5271 6BC2
5272 6BC2 20 76 62              jsr   setCurrentBar            <barHand = passed menu bar.
5273 6BC5 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
5274 6BC8 F0 62                 beq   exitMenu2                Is there a current menu bar?
5275 6BCA
5276 6BCA 20 2F 6C              jsr   getevptr                 Get event pointer.
5277 6BCD
5278 6BCD A0 0A 00              ldy   #where                   Get point of event.
5279 6BD0 B7 EA                 lda   [<eventptr],y
5280 6BD2 85 3A                 sta   <yrat
5281 6BD4 C8                    iny   
5282 6BD5 C8                    iny   
5283 6BD6 B7 EA                 lda   [<eventptr],y
5284 6BD8 85 3C                 sta   <xrat
5285 6BDA
5286 6BDA 20 27 63              jsr   to_myport
5287 6BDD
5288 6BDD 20 25 75     TS3EntersHere jsr   pushyrat
5289 6BE0 A2 04 85 22           _GlobalToLocal 
5290 6BE7
5291 6BE7 20 B2 6C              jsr   onbar                    Cursor on menu bar?
5292 6BEA F0 1E                 beq   exit
5293 6BEC
5294 6BEC A2 00 00              ldx   #0                       Pull down menu flag.
5295 6BEF A0 00 00              ldy   #what                    Was the button down?
5296 6BF2 B7 EA                 lda   [<eventptr],y
5297 6BF4 C9 01 00              cmp   #1
5298 6BF7 F0 1A                 beq   watch_menu
5299 6BF9
5300 6BF9 A0 12 00              ldy   #CtlValue
5301 6BFC B7 14                 lda   [<barptr],y
5302 6BFE F0 0A                 beq   exit
5303 6C00 A0 08 00              ldy   #CtlRect+y1
5304 6C03 18                    clc   
5305 6C04 77 14                 adc   [<barptr],y
5306 6C06 C5 3A                 cmp   <yrat
5307 6C08 B0 06                 bcs   ok
5308 6C0A
5309 6C0A 64 3A        exit     stz   <yrat                    No selection flag.
5310 6C0C 64 3C                 stz   <xrat
5311 6C0E 80 06                 bra   exitmenu
5312 6C10
5313 6C10 A2 02 00     ok       ldx   #2                       Fall down menu flag.
5314 6C13 20 7A 64     watch_menu jsr   trackmenu              Watch the menu.
5315 6C16
5316 6C16                       ENTRY exitmenu
5317 6C16              exitmenu  
5318 6C16 20 2F 6C              jsr   getevptr
5319 6C19 A0 10 00              ldy   #TaskData
5320 6C1C A5 3A                 lda   <yrat                    Item ID.
5321 6C1E 97 EA                 sta   [<eventptr],y            Return item ID number.
5322 6C20 C8                    iny   
5323 6C21 C8                    iny   
5324 6C22 A5 3C                 lda   <xrat                    Menu ID number.
5325 6C24 97 EA                 sta   [<eventptr],y            Return Menu ID number.
5326 6C26
5327 6C26 20 5C 63              jsr   to_uport
5328 6C29 20 C4 62              jsr   unlockMenuBar            Leave menu bar and menus unlocked.
5329 6C2C
5330 6C2C                       ENTRY exitMenu2
5331 6C2C              exitMenu2  
5332 6C2C 82 94 23              brl   pop8bytes                error
5333 6C2F
5334 6C2F
5335 6C2F              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
5336 6C2F              ;        Get event pointer.
5337 6C2F              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
5338 6C2F                       ENTRY getevptr
5339 6C2F              getevptr  
5340 6C2F A3 10                 lda   eventptrIn+2,s           Get pointer to event record.
5341 6C31 85 EA                 sta   <eventptr
5342 6C33 A3 12                 lda   eventptrIn+4,s
5343 6C35 85 EC                 sta   <eventptr+2
5344 6C37
5345 6C37 60                    rts   
5346 6C38
5347 6C38                       ENDP 
5348 6C38
5349 6C38              ;===========================================================================
5350 6C38              ;
5351 6C38              ;                   MenuKey
5352 6C38              ;
5353 6C38              ;                   Find item associated with key.
5354 6C38              ;
5355 6C38              ;   IN:  PUSH:LONG - pointer to event record which contains
5356 6C38              ;                      character entered.
5357 6C38              ;        PUSH:LONG - MENUBAR handle, or zero for system bar.
5358 6C38              ;
5359 6C38              ;  OUT:  Task recrd TaskData = Item ID in low word, menu ID in high word.
5360 6C38              ;                              item ID = 0 if no selection was made.
5361 6C38              ;
5362 6C38              ;===========================================================================
5363 6C38              MenuKey  PROC 
5364 6C38
5365 6C38              menuin   equ   input
5366 6C38              eventptrIn equ   menuin+4
5367 6C38
5368 6C38              eventptr equ   work
5369 6C38              key      equ   eventptr+4
5370 6C38
5371 6C38 20 97 8F              jsr   startup                  Do startup initialization for tool call.
5372 6C3B 20 76 62              jsr   setCurrentBar            <barHand = passed menu bar.
5373 6C3E 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
5374 6C41 F0 E9                 beq   exitMenu2                Is there a current menu bar?
5375 6C43
5376 6C43 20 2F 6C              jsr   getevptr                 Get pointer to event record.
5377 6C46
5378 6C46 64 3A                 stz   <yrat                    Clear item found flag.
5379 6C48 64 3C                 stz   <xrat                    Clear dimmed item selected flag.
5380 6C4A
5381 6C4A A0 0E 00              ldy   #modif                   Get modifier flags.
5382 6C4D B7 EA                 lda   [<eventptr],y            Check if option key was down.
5383 6C4F 29 00 01              and   #$0100
5384 6C52 F0 C2                 beq   exitmenu
5385 6C54
5386 6C54 A0 02 00              ldy   #message                 Get key.
5387 6C57 B7 EA                 lda   [<eventptr],y            Convert character to what's in record.
5388 6C59 85 EE                 sta   <key                     Save key.
5389 6C5B
5390 6C5B A9 02 00              lda   #ItemChar                Check primary character first.
5391 6C5E 85 EA                 sta   <work
5392 6C60 20 87 6C              jsr   ck_chars
5393 6C63 B0 07                 bcs   gotit
5394 6C65
5395 6C65 E6 EA                 inc   <work                    Check alternate character next.
5396 6C67 20 87 6C              jsr   ck_chars
5397 6C6A 90 AA                 bcc   exitmenu
5398 6C6C
5399 6C6C A0 06 00     gotit    ldy   #ItemFlag                Is item enabled and visible?
5400 6C6F B7 24                 lda   [<itemptr],y
5401 6C71 29 88 00              and   #I_ENABLED+I_INVIS
5402 6C74 D0 A0                 bne   exitmenu                 Can only select visible, enabled items.
5403 6C76
5404 6C76 20 78 68              jsr   get_ids                  Get packed MenuId and ItemID.
5405 6C79
5406 6C79 F4 01 80              pea   $8001                    Highlight flag, xor if possible.
5407 6C7C D4 3C                 pei   <xrat                    Pass menu ID number to highlight.
5408 6C7E A2 0F 2C 22           _HiliteMenu                    Draw menu's title highlighted.
5409 6C85
5410 6C85 80 8F                 bra   exitmenu
5411 6C87
5412 6C87
5413 6C87              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5414 6C87              ;          Check key against keyboard equivalent.
5415 6C87              ;
5416 6C87              ;  IN:     work = index into item record (ItemChar or ItemAltChar).
5417 6C87              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5418 6C87              ck_chars  
5419 6C87
5420 6C87              ;
5421 6C87              ; --- Check every menu in menu bar ------------------------
5422 6C87              ;
5423 6C87 20 35 62              jsr   getmfirst                Get pointer to first menu in menu list.
5424 6C8A F0 24                 beq   errorout                 Are there any menus to check?
5425 6C8C
5426 6C8C              ;
5427 6C8C              ; ------- Check all items in this menu -----------------------------
5428 6C8C              ;
5429 6C8C A0 0A 00     lop1     ldy   #MenuFlag                Is the menu enabled and visible?
5430 6C8F B7 1C                 lda   [<menuptr],y
5431 6C91 29 94 00              and   #M_ENABLED+M_INVIS+M_STANDARD
5432 6C94 D0 15                 bne   nextmenu                 Only select from visible, enabled menus.
5433 6C96
5434 6C96 20 25 74              jsr   getifirst                itemptr = pointer to first item in menu.
5435 6C99 F0 10                 beq   nextmenu                 Is there a first item?
5436 6C9B
5437 6C9B A4 EA        lop2     ldy   <work                    Index to ItemChar or ItemAltChar.
5438 6C9D B7 24                 lda   [<itemptr],y
5439 6C9F 29 FF 00              and   #$00FF                   Same key, and enabled flags.
5440 6CA2 C5 EE                 cmp   <key
5441 6CA4 F0 0B                 beq   gotit2
5442 6CA6
5443 6CA6 20 37 74              jsr   next_item
5444 6CA9 D0 F0                 bne   lop2
5445 6CAB
5446 6CAB 20 87 68     nextmenu jsr   next_menu                Get pointer to next menu.
5447 6CAE D0 DC                 bne   lop1                     Any more menus?
5448 6CB0
5449 6CB0 18           errorout clc                            Set not found flag.
5450 6CB1 60           gotit2   rts   
5451 6CB2
5452 6CB2                       ENDP 
5453 6CB2
5454 6CB2
5455 6CB2              ;===========================================================================
5456 6CB2              ;
5457 6CB2              ;                   OnBar
5458 6CB2              ;
5459 6CB2              ;                   Check if xrat and yrat are in the menu bar.
5460 6CB2              ;
5461 6CB2              ;   IN:    barptr = pointer to menu bar.
5462 6CB2              ;
5463 6CB2              ;  OUT:    Equal flag is FALSE if point is not inside RECT.
5464 6CB2              ;          Equal flag is TRUE if point is inside RECT.
5465 6CB2              ;
5466 6CB2              ;===========================================================================
5467 6CB2              onbar    PROC 
5468 6CB2
5469 6CB2              ypt      equ   1
5470 6CB2              xpt      equ   ypt+2
5471 6CB2              box      equ   xpt+2
5472 6CB2
5473 6CB2 A6 16                 ldx   <barptr+2
5474 6CB4 A5 14                 lda   <barptr
5475 6CB6 18                    clc   
5476 6CB7 69 08 00              adc   #CtlRect
5477 6CBA 90 01                 bcc   inside
5478 6CBC E8                    inx   
5479 6CBD
5480 6CBD
5481 6CBD              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5482 6CBD              ;        Check if a point is inside a RECT
5483 6CBD              ;
5484 6CBD              ;   IN:  a = low address of RECT.
5485 6CBD              ;        x = high address of RECT.
5486 6CBD              ;        xrat and yrat = point to check.
5487 6CBD              ;
5488 6CBD              ;  OUT:  Equal flag is TRUE if point is not inside RECT.
5489 6CBD              ;        Equal flag is FALSE if point is inside RECT.
5490 6CBD              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5491 6CBD                       ENTRY inside
5492 6CBD              inside    
5493 6CBD A8                    tay   
5494 6CBE
5495 6CBE 48                    pha                            Space for result.
5496 6CBF
5497 6CBF F4 00 00              pea   0                        Pass address of point to check.
5498 6CC2 7B                    tdc   
5499 6CC3 18                    clc   
5500 6CC4 69 3A 00              adc   #yrat
5501 6CC7 48                    pha   
5502 6CC8
5503 6CC8 DA                    phx                            Pass address of RECT to check.
5504 6CC9 5A                    phy   
5505 6CCA A2 04 4F 22           _PtInRect 
5506 6CD1 68                    pla   
5507 6CD2
5508 6CD2 60                    rts   
5509 6CD3
5510 6CD3                       ENDP 
5511 6CD3
5512 6CD3
5513 6CD3              ;===========================================================================
5514 6CD3              ;
5515 6CD3              ;                   MenuRefresh
5516 6CD3              ;
5517 6CD3              ;                   Return redraw area.
5518 6CD3              ;
5519 6CD3              ;   IN:    PUSH:LONG - address of routine that will redraw screen.
5520 6CD3              ;
5521 6CD3              ;  OUT:    None.
5522 6CD3              ;
5523 6CD3              ;===========================================================================
5524 6CD3              MenuRefresh PROC 
5525 6CD3
5526 6CD3              routine  equ   9
5527 6CD3
5528 6CD3 20 97 8F              jsr   startup                  Do startup initialization for tool call.
5529 6CD6
5530 6CD6 A3 09                 lda   routine,s
5531 6CD8 85 3E                 sta   <creamed
5532 6CDA A3 0B                 lda   routine+2,s
5533 6CDC 85 40                 sta   <creamed+2
5534 6CDE
5535 6CDE 82 D2 22              brl   pop4bytes                no error
5536 6CE1
5537 6CE1                       ENDP 
5538 6CE1
5539 6CE1
5540 6CE1              ;===========================================================================
5541 6CE1              ;
5542 6CE1              ;                   SetOutLine
5543 6CE1              ;
5544 6CE1              ;                   Set pen to outline color.
5545 6CE1              ;
5546 6CE1              ;   IN:    a = pattern/color.
5547 6CE1              ;
5548 6CE1              ;  OUT:    Set to a solid.
5549 6CE1              ;
5550 6CE1              ;===========================================================================
5551 6CE1              setoutline PROC 
5552 6CE1
5553 6CE1 20 B8 7C              jsr   pushcolor
5554 6CE4 A2 04 30 22           _SetPenPat 
5555 6CEB
5556 6CEB 60                    rts   
5557 6CEC
5558 6CEC                       ENDP 
5559 6CEC
5560 6CEC
5561 6CEC              ;===========================================================================
5562 6CEC              ;
5563 6CEC              ;                   Pull_Down
5564 6CEC              ;
5565 6CEC              ;                   Pull down a blank menu.
5566 6CEC              ;
5567 6CEC              ;   IN:    <menuptr = pointer to menu.
5568 6CEC              ;          <barptr = pointer to menubar.
5569 6CEC              ;          <titlenum = menu's ID number.
5570 6CEC              ;          <Titlex1 = title's left side.
5571 6CEC              ;          <Titlex2 = title's right side.
5572 6CEC              ;          <menurect+x1 = menu's left side.
5573 6CEC              ;
5574 6CEC              ;  OUT:    menurect = interior coordinates of menu (excluding frame).
5575 6CEC              ;
5576 6CEC              ;===========================================================================
5577 6CEC              pull_down PROC 
5578 6CEC
5579 6CEC              ; ------ Highlight title --------------------------------------
5580 6CEC              ;
5581 6CEC F4 01 80              pea   $8001                    ;Highlight flag.
5582 6CEF D4 52                 pei   <titlenum                ;Pass menu's ID.
5583 6CF1 A2 0F 2C 22           _HiliteMenu                    ;Draw the menu's title highlighted.
5584 6CF8 20 8B 62              jsr   lockMenuBar              ;<barPtr = (<barHand), bar & menus locked.
5585 6CFB 20 15 63              jsr   derefMenuHand            ;<menuptr = (<menuhand).
5586 6CFE
5587 6CFE A0 0C 00              ldy   #NumOfItems              ;check if we have an empty menu or not before
5588 6D01 B7 1C                 lda   [<menuptr],y             ;pulling it down
5589 6D03 D0 13                 bne   notEmpty
5590 6D05
5591 6D05 A0 0A 00              ldy   #menuFlag
5592 6D08 B7 1C                 lda   [<menuptr],y
5593 6D0A 29 10 00              and   #M_STANDARD              ;if menu is empty make sure that it's not a custom menu
5594 6D0D D0 09                 bne   notEmpty                 ;if custom then it's not really empty because custom menus
5595 6D0F A9 01 00              lda   #1                       ;don't use the NumOfItems field anyways
5596 6D12 85 4A                 sta   <menurect+x1
5597 6D14 3A                    dec   a
5598 6D15 85 4E                 sta   <menurect+x2
5599 6D17 60                    rts   
5600 6D18              ;
5601 6D18              ; ------ Compute RECT for menu -----------------------
5602 6D18              ;
5603 6D18 A0 0C 00     notEmpty ldy   #CtlRect+y2
5604 6D1B B7 14                 lda   [<barptr],y
5605 6D1D 3A                    dec   a                        ;Overlap top of menu with bottom of bar.
5606 6D1E 85 48                 sta   <menurect+y1
5607 6D20 A0 04 00              ldy   #MenuHeight
5608 6D23 18                    clc   
5609 6D24 77 1C                 adc   [<menuptr],y             ;Plus the height for the bottom side.
5610 6D26 1A                    inc   a                        ;Plus room for drop shadow.
5611 6D27 85 4C                 sta   <menurect+y2
5612 6D29
5613 6D29 A0 02 00              ldy   #MenuWidth
5614 6D2C A5 4A                 lda   <menurect+x1
5615 6D2E 18                    clc   
5616 6D2F 77 1C                 adc   [<menuptr],y             ;Plus the width for the right side.
5617 6D31 69 02 00              adc   #2                       ;Plus romm for drop shadow.
5618 6D34 A6 46                 ldx   <screenmode              ;What resolution are we in?
5619 6D36 F0 03                 beq   store1
5620 6D38 69 02 00              adc   #2                       ;Extra drop shadow in 640 mode.
5621 6D3B 85 4E        store1   sta   <menurect+x2
5622 6D3D
5623 6D3D              ;
5624 6D3D              ; --- Convert menu RECT to global coordinates ----------------
5625 6D3D              ;
5626 6D3D A9 48 00              lda   #menurect+y1
5627 6D40 20 64 8F              jsr   pushDpage
5628 6D43 A2 04 84 22           _LocalToGlobal 
5629 6D4A
5630 6D4A A9 4C 00              lda   #menurect+y2
5631 6D4D 20 64 8F              jsr   pushDpage
5632 6D50 A2 04 84 22           _LocalToGlobal 
5633 6D57
5634 6D57 20 61 6A              jsr   initStuff                ;Initialize some flags in our direct page
5635 6D5A 20 5F 6B              jsr   adjustBottom             ;Check if menu extends below the screen
5636 6D5D
5637 6D5D              ;
5638 6D5D              ; --- Get menu on screen, move left if off right -------------
5639 6D5D              ;
5640 6D5D A5 F0                 lda   <portRect+x1
5641 6D5F D0 0C                 bne   DoLeftLast
5642 6D61
5643 6D61 A6 F0                 ldx   <portRect+x1
5644 6D63 A5 F4                 lda   <portRect+x2
5645 6D65 20 0D 6F              jsr   justifyRight
5646 6D68 20 FB 6E              jsr   justifyLeft
5647 6D6B 80 0E                 bra   doneJustification
5648 6D6D
5649 6D6D A6 F0        DoLeftLast ldx   <portRect+x1
5650 6D6F A5 F4                 lda   <portRect+x2
5651 6D71 20 FB 6E              jsr   justifyLeft
5652 6D74 A6 F0                 ldx   <portRect+x1
5653 6D76 A5 F4                 lda   <portRect+x2
5654 6D78 20 0D 6F              jsr   justifyRight
5655 6D7B
5656 6D7B              doneJustification  
5657 6D7B              ;
5658 6D7B              ; --- Get handle of menu cache -------------------------------
5659 6D7B              ;
5660 6D7B              pull_down2 PROC 
5661 6D7B
5662 6D7B 64 44                 stz   <sav_buff+2              Set 'no cache' flag just in case.
5663 6D7D 64 42                 stz   <sav_buff
5664 6D7F
5665 6D7F A0 0A 00              ldy   #MenuFlag                Check if there can be a cache.
5666 6D82 B7 1C                 lda   [<menuptr],y
5667 6D84 29 08 00              and   #M_CACHE
5668 6D87 D0 27                 bne   cacheOK
5669 6D89
5670 6D89 20 52 80              jsr   allocateCache
5671 6D8C B0 5E                 bcs   noCache
5672 6D8E DA                    phx                            Save allocated cache.
5673 6D8F 48                    pha   
5674 6D90 85 42                 sta   <sav_buff                Dereference cache.
5675 6D92 86 44                 stx   <sav_buff+2
5676 6D94 A0 02 00              ldy   #2
5677 6D97 B7 42                 lda   [<sav_buff],y
5678 6D99 A8                    tay   
5679 6D9A A7 42                 lda   [<sav_buff]
5680 6D9C 85 42                 sta   <sav_buff
5681 6D9E 84 44                 sty   <sav_buff+2
5682 6DA0
5683 6DA0 A9 00 00              lda   #0                       Mark cache as BAD (not containing menu).
5684 6DA3 87 42                 sta   [<sav_buff]
5685 6DA5
5686 6DA5 68                    pla                            Put cache handle into sav_buff.
5687 6DA6 85 42                 sta   <sav_buff
5688 6DA8 68                    pla   
5689 6DA9 09 00 80              ora   #$8000                   Set temp cache flag.
5690 6DAC 85 44                 sta   <sav_buff+2
5691 6DAE 80 27                 bra   saveScreen
5692 6DB0
5693 6DB0 A0 15 00     cacheOK  ldy   #MenuCache+1
5694 6DB3 B7 1C                 lda   [<menuptr],y
5695 6DB5 85 43                 sta   <sav_buff+1
5696 6DB7 F0 0F                 beq   tryCache                 Is there a cache?
5697 6DB9 88                    dey   
5698 6DBA B7 1C                 lda   [<menuptr],y
5699 6DBC 85 42                 sta   <sav_buff
5700 6DBE
5701 6DBE A0 01 00              ldy   #1                       Has the cache been purged?
5702 6DC1 B7 42                 lda   [<sav_buff],y
5703 6DC3 D0 12                 bne   saveScreen
5704 6DC5
5705 6DC5 20 CF 80              jsr   freeCache                Free purged cache.
5706 6DC8
5707 6DC8 20 2F 80     tryCache jsr   makeCache                Allocate a new cache for the menu.
5708 6DCB
5709 6DCB A0 14 00              ldy   #MenuCache
5710 6DCE B7 1C                 lda   [<menuptr],y
5711 6DD0 85 42                 sta   <sav_buff
5712 6DD2 C8                    iny   
5713 6DD3 B7 1C                 lda   [<menuptr],y
5714 6DD5 85 43                 sta   <sav_buff+1
5715 6DD7              ;
5716 6DD7              ; --- Save screen to buffer ---------------------------------
5717 6DD7
5718 6DD7 A5 43        saveScreen lda   <sav_buff+1
5719 6DD9 F0 11                 beq   noCache                  Is there a cache?
5720 6DDB
5721 6DDB F4 00 00              pea   0                        Pass no purge flag.
5722 6DDE D4 44                 pei   <sav_buff+2              Pass cache handle.
5723 6DE0 D4 42                 pei   <sav_buff
5724 6DE2 A2 02 24 22           _SetPurge                      Make cache nonpurgeable for now.
5725 6DE9
5726 6DE9 20 33 7D              jsr   cache
5727 6DEC              ;
5728 6DEC              ;     a = TRUE to not draw, FALSE to draw menu.
5729 6DEC              ;
5730 6DEC 48           noCache  pha                            Save draw flag.
5731 6DED
5732 6DED A9 48 00              lda   #menurect+y1             Convert upper lefty corner to global.
5733 6DF0 20 64 8F              jsr   pushDpage
5734 6DF3 A2 04 85 22           _GlobalToLocal 
5735 6DFA
5736 6DFA A9 4C 00              lda   #menurect+y2             Convert lower right corner to global.
5737 6DFD 20 64 8F              jsr   pushDpage
5738 6E00 A2 04 85 22           _GlobalToLocal                 menurect = now in global coordinates.
5739 6E07
5740 6E07 A4 4E                 ldy   <menurect+x2             Subtract drop shadow from 'menurect'.
5741 6E09 88                    dey   
5742 6E0A 88                    dey   
5743 6E0B A5 46                 lda   <screenmode
5744 6E0D F0 02                 beq   store3
5745 6E0F 88                    dey   
5746 6E10 88                    dey   
5747 6E11
5748 6E11 84 4E        store3   sty   <menurect+x2
5749 6E13 C6 4C                 dec   <menurect+y2             subtract the bottom drop shadow
5750 6E15
5751 6E15 68                    pla   
5752 6E16 F0 10                 beq   drawMenu
5753 6E18
5754 6E18 20 2A 75              jsr   pushmrect                Pass pointer to menurect.
5755 6E1B D4 5A                 pei   <vert_pen                Width of vertical line.
5756 6E1D F4 01 00              pea   1                        Height of horizontal lines.
5757 6E20 A2 04 4C 22           _InsetRect                     Indent menurect.
5758 6E27
5759 6E27 60                    rts   
5760 6E28
5761 6E28              ;
5762 6E28              ; --- Menu has to be drawn ---------------------------------------
5763 6E28              ;
5764 6E28 D4 5A        drawMenu pei   <vert_pen                Line width.
5765 6E2A F4 01 00              pea   1                        Line height.
5766 6E2D A2 04 2C 22           _SetPenSize 
5767 6E34
5768 6E34 A9 48 00              lda   #menurect                Pass pointer to menu RECT.
5769 6E37 20 64 8F              jsr   pushDpage
5770 6E3A A5 34                 lda   <outlineclr              Compute frame color.
5771 6E3C 20 E7 6E              jsr   pushSmear                Push smeared color.
5772 6E3F A5 30                 lda   <norcolor                Use menu bar's color.
5773 6E41 20 E7 6E              jsr   pushSmear                Push smeared color.
5774 6E44 A2 12 0C 22           _SpecialRect 
5775 6E4B 90 32                 bcc   skip1                    Error?
5776 6E4D C9 03 00              cmp   #3                       Tool or function not found?
5777 6E50 B0 2D                 bcs   skip1
5778 6E52
5779 6E52 68                    pla                            Remove inputs to SpecialRect.
5780 6E53 68                    pla   
5781 6E54 68                    pla   
5782 6E55 68                    pla   
5783 6E56
5784 6E56              ;
5785 6E56              ; --- Draw menu old way --------------------------------------
5786 6E56              ;
5787 6E56 E6 48                 inc   <menurect+y1
5788 6E58
5789 6E58 A9 48 00              lda   #menurect                Pass pointer to menu RECT.
5790 6E5B 20 64 8F              jsr   pushDpage
5791 6E5E A9 00 00              lda   #0                       Use BarColor.
5792 6E61 20 B0 7C              jsr   pushcolor2               Push pointer to color pattern.
5793 6E64 A2 04 57 22           _FillRect                      Draw a blank solid color menu.
5794 6E6B
5795 6E6B C6 48                 dec   <menurect+y1
5796 6E6D
5797 6E6D A5 34                 lda   <outlineclr              Set outline pattern.
5798 6E6F 20 E1 6C              jsr   setoutline
5799 6E72
5800 6E72 A9 48 00              lda   #menurect                Frame menu.
5801 6E75 20 64 8F              jsr   pushDpage
5802 6E78 A2 04 53 22           _FrameRect 
5803 6E7F
5804 6E7F              ; ------- Drop shadow for menu -------------------
5805 6E7F
5806 6E7F A5 34        skip1    lda   <outlineclr
5807 6E81 20 E1 6C              jsr   setoutline
5808 6E84
5809 6E84 A4 4E                 ldy   <menurect+x2
5810 6E86 5A                    phy                            Pass last point.
5811 6E87 A5 48                 lda   <menurect+y1
5812 6E89 18                    clc   
5813 6E8A 69 04 00              adc   #4
5814 6E8D 48                    pha   
5815 6E8E
5816 6E8E 5A                    phy                            Set second point.
5817 6E8F A6 4C                 ldx   <menurect+y2
5818 6E91 DA                    phx   
5819 6E92
5820 6E92 A5 4A                 lda   <menurect+x1             Set starting point.
5821 6E94 18                    clc   
5822 6E95 69 05 00              adc   #5
5823 6E98 48                    pha   
5824 6E99 DA                    phx   
5825 6E9A A2 04 3A 22           _MoveTo 
5826 6EA1 A2 04 3C 22           _LineTo                        Bottom dropshadow.
5827 6EA8
5828 6EA8 A5 5A                 lda   <vert_pen                Vertical width.
5829 6EAA 0A                    asl   a
5830 6EAB 48                    pha                            Line width.
5831 6EAC F4 01 00              pea   1                        Line height.
5832 6EAF A2 04 2C 22           _SetPenSize 
5833 6EB6 A2 04 3C 22           _LineTo 
5834 6EBD
5835 6EBD A9 01 00              lda   #1
5836 6EC0 48                    pha   
5837 6EC1 48                    pha   
5838 6EC2 A2 04 2C 22           _SetPenSize                    Reset pen size to normal.
5839 6EC9
5840 6EC9 A5 DE                 lda   <specialFlag
5841 6ECB F0 01                 beq   NeverMind
5842 6ECD 60                    rts   
5843 6ECE
5844 6ECE                       ENTRY NeverMind
5845 6ECE 20 2A 75     NeverMind jsr   pushmrect               Pass pointer to menurect.
5846 6ED1 D4 5A                 pei   <vert_pen                Width of vertical line.
5847 6ED3 F4 01 00              pea   1                        Height of horizontal lines.
5848 6ED6 A2 04 4C 22           _InsetRect                     Indent menurect.
5849 6EDD
5850 6EDD A2 00 00              ldx   #mDrawMenu               Send draw menu message.
5851 6EE0 82 E2 00              brl   dispatch
5852 6EE3
5853 6EE3              ;
5854 6EE3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5855 6EE3              ;          Push smeared color.
5856 6EE3              ;
5857 6EE3              ;   IN:    a = color in bits 4-7.
5858 6EE3              ;
5859 6EE3              ;  OUT:    Color smeared into all 4 nibbles and pushed on stack.
5860 6EE3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5861 6EE3                       ENTRY pushSmearLow
5862 6EE3 0A           pushSmearLow asl   a
5863 6EE4 0A                    asl   a
5864 6EE5 0A                    asl   a
5865 6EE6 0A                    asl   a
5866 6EE7              ;
5867 6EE7 FA           pushSmear plx                           Get return address.
5868 6EE8
5869 6EE8 29 F0 00              and   #$00F0
5870 6EEB 48                    pha   
5871 6EEC 4A                    lsr   a
5872 6EED 4A                    lsr   a
5873 6EEE 4A                    lsr   a
5874 6EEF 4A                    lsr   a
5875 6EF0 03 01                 ora   1,s
5876 6EF2 83 01                 sta   1,s
5877 6EF4 EB                    xba   
5878 6EF5 03 01                 ora   1,s
5879 6EF7 83 01                 sta   1,s
5880 6EF9
5881 6EF9 DA                    phx                            Put return address back.
5882 6EFA
5883 6EFA 60                    rts   
5884 6EFB
5885 6EFB
5886 6EFB              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5887 6EFB              ;          If menu is off left side of screen, move it right.
5888 6EFB              ;
5889 6EFB              ;   IN:    a = max right side.
5890 6EFB              ;          x = minimum left side.
5891 6EFB              ;          <menurect = current menu rect.
5892 6EFB              ;
5893 6EFB              ;  OUT:    <menurect moved to left if off max right.
5894 6EFB              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5895 6EFB              JustifyLeft PROC 
5896 6EFB
5897 6EFB 18                    clc                            (One extra.)
5898 6EFC E5 4E                 sbc   <menurect+x2             Less the menu's right side.
5899 6EFE B0 0C                 bcs   exit100                  Is the menu off the right?
5900 6F00
5901 6F00 AA                    tax                            Save amount to move menu.
5902 6F01 18                    clc   
5903 6F02 65 4A                 adc   <menurect+x1             Move left side to left.
5904 6F04 85 4A                 sta   <menurect+x1
5905 6F06 8A                    txa   
5906 6F07 18                    clc   
5907 6F08 65 4E                 adc   <menurect+x2             Move right side to left.
5908 6F0A 85 4E                 sta   <menurect+x2
5909 6F0C
5910 6F0C 60           exit100  rts   
5911 6F0D
5912 6F0D                       ENDP 
5913 6F0D
5914 6F0D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5915 6F0D              ;          If menu is off right side of screen, move it left.
5916 6F0D              ;
5917 6F0D              ;   IN:    a = max right side.
5918 6F0D              ;          x = minimum left side.
5919 6F0D              ;          <menurect = current menu rect.
5920 6F0D              ;
5921 6F0D              ;  OUT:    <menurect moved to left if off max right.
5922 6F0D              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5923 6F0D              JustifyRight PROC 
5924 6F0D
5925 6F0D              minX1    equ   1
5926 6F0D              maxX2    equ   minX1+2
5927 6F0D
5928 6F0D 48                    pha   
5929 6F0E DA                    phx   
5930 6F0F
5931 6F0F A5 4A                 lda   <menurect+x1             Off left side?
5932 6F11 C3 01                 cmp   minX1,s
5933 6F13 10 0E                 bpl   exit101
5934 6F15
5935 6F15 A5 4E                 lda   <menurect+x2
5936 6F17 38                    sec   
5937 6F18 E5 4A                 sbc   <menurect+x1
5938 6F1A 18                    clc   
5939 6F1B 63 01                 adc   minX1,s
5940 6F1D 85 4E                 sta   <menurect+x2
5941 6F1F
5942 6F1F A3 01                 lda   minX1,s
5943 6F21 85 4A                 sta   <menurect+x1
5944 6F23
5945 6F23 FA           exit101  plx                            Remove temp stack space.
5946 6F24 68                    pla   
5947 6F25
5948 6F25 60                    rts   
5949 6F26
5950 6F26                       ENDP 
5951 6F26
5952 6F26              ;===========================================================================
5953 6F26              ;
5954 6F26              ;                   PullUp
5955 6F26              ;
5956 6F26              ;                   Erase Menu
5957 6F26              ;
5958 6F26              ;   IN:    menurect = RECT containing menu.
5959 6F26              ;
5960 6F26              ;===========================================================================
5961 6F26              pullup   PROC 
5962 6F26
5963 6F26 A0 0C 00              ldy   #NumOfItems              check to see if we have an empty menu
5964 6F29 B7 1C                 lda   [<menuptr],y
5965 6F2B D0 0D                 bne   notEmpty                 if we don't proceed as normal, else nothing to pull up
5966 6F2D A0 0A 00              ldy   #menuFlag
5967 6F30 B7 1C                 lda   [<menuptr],y
5968 6F32 29 10 00              and   #M_STANDARD              make sure not custom menu since it doesn't use NumOfItems
5969 6F35 D0 03                 bne   notEmpty
5970 6F37 82 5D 00              brl   unHiliteTitle
5971 6F3A
5972 6F3A              ; --- Try to restore screen ---------------------------
5973 6F3A              ;
5974 6F3A              notEmpty  
5975 6F3A 20 B0 6F              jsr   resetThings              just in case this menu was scrollable we need to restore
5976 6F3D              ;                                       a few things
5977 6F3D A5 43                 lda   <sav_buff+1              Was the screen area saved to a buffer?
5978 6F3F F0 26                 beq   try_wmgr
5979 6F41
5980 6F41 20 C6 7F              jsr   uncache
5981 6F44
5982 6F44 A5 44                 lda   <sav_buff+2              Check if it was a temp cache.
5983 6F46 10 0F                 bpl   setPurge
5984 6F48
5985 6F48 29 FF 00              and   #$00FF                   Free temp cache.
5986 6F4B 48                    pha   
5987 6F4C D4 42                 pei   <sav_buff
5988 6F4E A2 02 10 22           _DisposeHandle 
5989 6F55 80 3C                 bra   cktitle
5990 6F57
5991 6F57 F4 03 00     setPurge pea   3                        Pass 'first to purge' flag.
5992 6F5A D4 44                 pei   <sav_buff+2              Pass cache handle.
5993 6F5C D4 42                 pei   <sav_buff
5994 6F5E A2 02 24 22           _SetPurge                      Make cache purgeable.
5995 6F65 80 2C                 bra   cktitle
5996 6F67
5997 6F67              ; --- Ask Window Manager to restore screen ------------
5998 6F67              ;
5999 6F67 20 2A 75     try_wmgr jsr   pushmrect                Expand menu RECT to include frame
6000 6F6A F4 FA FF              pea   $FFFA                    and drop shadow.
6001 6F6D F4 FA FF              pea   $FFFA                    This makes the RECT larger than needed
6002 6F70 A2 04 4C 22           _InsetRect                     but takes less code.
6003 6F77
6004 6F77 20 2A 75              jsr   pushmrect                Pass pointer of RECT to restore.
6005 6F7A A2 0E 39 22           _RefreshDesktop                Ask Window Manager to refresh the screen.
6006 6F81 90 10                 bcc   cktitle                  Error if Window Manager not running.
6007 6F83
6008 6F83              ; --- Ask application to restore screen ---------------
6009 6F83              ;
6010 6F83 A5 3E                 lda   <creamed                 Is there a routine to go to?
6011 6F85 05 40                 ora   <creamed+2
6012 6F87 F0 08                 beq   nobody
6013 6F89
6014 6F89 A5 3E                 lda   <creamed                 Call application's routine.
6015 6F8B A6 3F                 ldx   <creamed+1
6016 6F8D 22 37 70 FD           jsl   long_call
6017 6F91
6018 6F91              ; --- Nobody will restore the screen ------------------------------------
6019 6F91              ;
6020 6F91 68           nobody   pla                            Fix stack.
6021 6F92 68                    pla   
6022 6F93
6023 6F93              ; --- Unhighlight title if menu was down, but no selection was made -----
6024 6F93              ;
6025 6F93 A5 6E        cktitle  lda   <inactItem               Was the selected item inactive?
6026 6F95 D0 04                 bne   ok1                      If yes, leave the menu title unhilited.
6027 6F97
6028 6F97 A5 54        unHiliteTitle lda   <curselect
6029 6F99 D0 14                 bne   exit3
6030 6F9B
6031 6F9B F4 00 80     ok1      pea   $8000                    Normal
6032 6F9E D4 52                 pei   <titlenum                Menu number.
6033 6FA0 A2 0F 2C 22           _HiliteMenu 
6034 6FA7 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
6035 6FAA 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand).
6036 6FAD
6037 6FAD 64 52                 stz   <titlenum                No selection made.
6038 6FAF
6039 6FAF 60           exit3    rts   
6040 6FB0
6041 6FB0                       ENDP 
6042 6FB0
6043 6FB0              ;===========================================================================
6044 6FB0              ;
6045 6FB0              ;                   ResetThings
6046 6FB0              ;
6047 6FB0              ;  IN:              <menuptr: ptr to menu record
6048 6FB0              ; OUT:              nothing
6049 6FB0              ;
6050 6FB0              ; If menu was scrollable, we need to reset a few things:
6051 6FB0              ;      The variable <firstVisItem is used to hold the first item visible, if it is zero
6052 6FB0              ;      then nothing has been scrolled and the menu can remain cached if it is not zero
6053 6FB0              ;      then we need to free the cache and redraw the menu the next time.
6054 6FB0              ;
6055 6FB0              ;===========================================================================
6056 6FB0              ResetThings PROC 
6057 6FB0
6058 6FB0 A0 0A 00              ldy   #menuflag                ;first check to see if menu was scrollable
6059 6FB3 B7 1C                 lda   [<menuptr],y
6060 6FB5 29 02 00              and   #M_SCROLL
6061 6FB8 F0 0A                 beq   ottahere                 ;it's not so we don't need to do anything
6062 6FBA
6063 6FBA A5 D0                 lda   <firstVisItem
6064 6FBC C9 01 00              cmp   #1
6065 6FBF F0 03                 beq   ottahere
6066 6FC1
6067 6FC1 20 CF 80              jsr   freecache                free cache so that the next time menu is pulled down
6068 6FC4              ;                                       we can redraw it
6069 6FC4 60           ottahere rts   
6070 6FC5
6071 6FC5                       ENDP 
6072 6FC5
6073 6FC5              ;
6074 6FC5              ;            APPEND	MDEFPROC.ASM
6075 6FC5              ;
6076 6FC5              ; 03/30/87 Dan - Added SetTextFace to size_menu so width of menu would take
6077 6FC5              ;                into account special effects applied to item text.  Also,
6078 6FC5              ;                reset text face to plain when done.
6079 6FC5              ;
6080 6FC5              ;===========================================================================
6081 6FC5              ;          Dispatch menu command.
6082 6FC5              ;
6083 6FC5              ;   IN:    x = message.
6084 6FC5              ;          a = parameter to pass to defProc.
6085 6FC5              ;          menurect = RECT to pass.
6086 6FC5              ;          yrat = y point to pass.
6087 6FC5              ;          xrat = x point to pass.
6088 6FC5              ;          menuhand = handle of menu.
6089 6FC5              ;          menuptr = pointer to menu.
6090 6FC5              ;
6091 6FC5              ;  OUT:    a = returned value from defProc.
6092 6FC5              ;
6093 6FC5              ;===========================================================================
6094 6FC5              dispatch PROC 
6095 6FC5
6096 6FC5 85 56                 sta   <param                   Save parameter.
6097 6FC7
6098 6FC7 A0 07 00              ldy   #MenuProc+1              Custom menu?
6099 6FCA B7 1C                 lda   [<menuptr],y
6100 6FCC D0 12                 bne   custom
6101 6FCE
6102 6FCE              ; --- Call the standard menu defProc ---------------------------------------
6103 6FCE              ;
6104 6FCE 8A                    txa   
6105 6FCF 0A                    asl   a
6106 6FD0 AA                    tax   
6107 6FD1 7C D4 6F              jmp   (standards,x)            I have none.
6108 6FD4
6109 6FD4 3E 70        standards DC W:draw_menu                mDrawMenu  = 0
6110 6FD6 83 70                 DC W:choose_item               mChoose    = 1
6111 6FD8 C9 70                 DC W:size_menu                 mSize      = 2
6112 6FDA 37 71                 DC W:draw_title                mDrawTitle = 3
6113 6FDC 3E 72                 DC W:draw_item                 mDrawItem  = 4
6114 6FDE AA 73                 DC W:get_itemID                mGetItemID = 5
6115 6FE0
6116 6FE0              ;
6117 6FE0              ; --- Call a custom menu defProc ---------------------------------------
6118 6FE0              ;
6119 6FE0 E0 01 00     custom   cpx   #1                       Choose command?
6120 6FE3 D0 15                 bne   ok1
6121 6FE5
6122 6FE5 A5 04                 lda   <globalFlag              Is help on?
6123 6FE7 29 01 00              and   #G_HELP
6124 6FEA D0 0E                 bne   ok1                      If help on, OK to check disabled menu.
6125 6FEC
6126 6FEC A0 0A 00              ldy   #MenuFlag                Is the menu enabled?
6127 6FEF B7 1C                 lda   [<menuptr],y
6128 6FF1 29 80 00              and   #M_ENABLED
6129 6FF4 F0 04                 beq   ok1                      If disabled, no item can be selected.
6130 6FF6
6131 6FF6 A9 00 00              lda   #0                       Return no hit flag.
6132 6FF9
6133 6FF9 60                    rts   
6134 6FFA
6135 6FFA
6136 6FFA DA           ok1      phx                            Remember command message.
6137 6FFB
6138 6FFB D4 22                 pei   <menuhand+2              Save.
6139 6FFD D4 20                 pei   <menuhand
6140 6FFF
6141 6FFF 48                    pha                            Space for result (none used).
6142 7000
6143 7000 DA                    phx                            Pass message command.
6144 7001
6145 7001 D4 22                 pei   <menuhand+2              Send handle of menu.
6146 7003 D4 20                 pei   <menuhand
6147 7005
6148 7005 20 2A 75              jsr   pushmrect                Pass address of menu's RECT.
6149 7008
6150 7008 D4 3C                 pei   <xrat                    Pass x coordinate.
6151 700A D4 3A                 pei   <yrat                    Pass y coordinate.
6152 700C
6153 700C D4 56                 pei   <param                   Parameter to pass.
6154 700E
6155 700E A0 07 00              ldy   #MenuProc+1
6156 7011 B7 1C                 lda   [<menuptr],y
6157 7013 AA                    tax   
6158 7014 88                    dey   
6159 7015 B7 1C                 lda   [<menuptr],y
6160 7017 22 37 70 FD           jsl   long_call                Call application's defProc.
6161 701B 68                    pla                            Get result.
6162 701C FA                    plx                            Restore menu handle.
6163 701D 86 20                 stx   <menuhand
6164 701F FA                    plx   
6165 7020 86 22                 stx   <menuhand+2
6166 7022 48                    pha                            Put result back.
6167 7023 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
6168 7026 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand).
6169 7029
6170 7029 68                    pla                            Get return value.
6171 702A
6172 702A FA                    plx                            Get saved command message.
6173 702B E0 03 00              cpx   #mDrawTitle
6174 702E D0 06                 bne   exit                     Was it a draw menu title command?
6175 7030
6176 7030 A8                    tay                            Did the defProc draw the title?
6177 7031 D0 03                 bne   exit                     If yes, all done.
6178 7033
6179 7033 82 01 01              brl   draw_title               Custom defProc wants default title.
6180 7036
6181 7036 60           exit     rts   
6182 7037
6183 7037                       ENDP 
6184 7037
6185 7037
6186 7037              ;===========================================================================
6187 7037              ;
6188 7037              ;                   Long call.
6189 7037              ;
6190 7037              ;   IN:    x = middle WORD (bits 8-23) of address of destination routine.
6191 7037              ;          a = low WORD of address of destination routine.
6192 7037              ;
6193 7037              ;  OUT:    Calling this routine is the same as:
6194 7037              ;
6195 7037              ;                jsl   (ax)
6196 7037              ;
6197 7037              ;          where the low byte in 'a' is the low byte of the destination
6198 7037              ;          address, and x = the next 2 bytes of the destination address.
6199 7037              ;
6200 7037              ;===========================================================================
6201 7037              long_call PROC 
6202 7037
6203 7037 3A                    dec   a                        Make low word look like a return address.
6204 7038              ;                                       !!! High byte of address is not decremented
6205 7038              ;                                       because the program counter doesn't wrap
6206 7038              ;                                       to the next bank!!!!
6207 7038
6208 7038 DA                    phx                            Push the high byte.
6209 7039 BA                    tsx                            Leave only the high byte of the address.
6210 703A E8                    inx   
6211 703B 9A                    txs   
6212 703C
6213 703C 48                    pha                            Push the low word of the address.
6214 703D
6215 703D 6B                    rtl                            Go to the address.
6216 703E              ;
6217 703E              ;  When the routine called returns, it
6218 703E              ;  will return to the routine that called 'longCall', not here.
6219 703E              ;
6220 703E                       ENDP 
6221 703E
6222 703E
6223 703E              ;===========================================================================
6224 703E              ;
6225 703E              ;                   Draw_Menu
6226 703E              ;
6227 703E              ;                   Draw the inside of a standard text menu.
6228 703E              ;
6229 703E              ;   IN:    menuhand = handle of menu.
6230 703E              ;          menuptr = pointer of menu.
6231 703E              ;
6232 703E              ;===========================================================================
6233 703E              draw_menu PROC 
6234 703E
6235 703E              counter  equ   work+4
6236 703E
6237 703E F4 04 00              pea   4                        We need to set this just in case we're not in the
6238 7041 A2 04 9C 22           _SetTextMode                   Menu Manager's port.
6239 7048
6240 7048 A5 D2                 lda   <lastVisItem             Load number of last visible item in menu
6241 704A 38                    sec   
6242 704B E5 D0                 sbc   <firstVisItem            just in case firstVisItem not equal to 1, which may
6243 704D 1A                    inc   a                        be the case if this was a pop-up menu
6244 704E 85 EE                 sta   <counter
6245 7050 F0 21                 beq   nothingToDraw
6246 7052
6247 7052 A5 D0                 lda   <firstVisItem            Load item number of first visible item in menu
6248 7054 20 AD 73              jsr   calcitem                 Get pointer to first visible item.
6249 7057 D0 09                 bne   enter2                   Are there any items?
6250 7059
6251 7059 60                    rts                            If not, I'm done.
6252 705A
6253 705A
6254 705A 20 0D 74     draw_lop jsr   getitemh                 Get the height of the item.
6255 705D 18                    clc   
6256 705E 65 0C                 adc   <rect+y1
6257 7060 85 10                 sta   <rect+y2                 Set the item's coordinates.
6258 7062
6259 7062 A9 00 00     enter2   lda   #0                       Draw the item as normal.
6260 7065 20 F7 72              jsr   text_guts                Draw the item's text part.
6261 7068
6262 7068 A5 10                 lda   <rect+y2                 Bottom of item becomes top of next.
6263 706A 85 0C                 sta   <rect+y1
6264 706C
6265 706C 20 37 74              jsr   next_item                Get the pointer to next item.
6266 706F C6 EE                 dec   <counter
6267 7071 D0 E7                 bne   draw_lop                 Any more items?
6268 7073
6269 7073 A5 D6        nothingToDraw lda   <upArrow            Do we have to draw an up arrow?
6270 7075 F0 03                 beq   checkNext
6271 7077 20 C2 67              jsr   DrawUpArrow
6272 707A
6273 707A A5 D8        checkNext lda   <dwnArrow               Do we have to draw a down arrow?
6274 707C F0 03                 beq   noscroll
6275 707E 20 1C 68              jsr   DrawDwnArrow
6276 7081
6277 7081 18           noscroll clc   
6278 7082 60                    rts   
6279 7083
6280 7083                       ENDP 
6281 7083
6282 7083
6283 7083              ;===========================================================================
6284 7083              ;
6285 7083              ;                   Choose_Item
6286 7083              ;
6287 7083              ;                   Hit test menu items.
6288 7083              ;
6289 7083              ;   IN:    menuhand = handle of menu.
6290 7083              ;          menuptr = pointer of menu.
6291 7083              ;          yrat = y coordinate to check.
6292 7083              ;          xrat = x coordinate to check.
6293 7083              ;          point is on the menu.
6294 7083              ;          menu is enabled.
6295 7083              ;
6296 7083              ;  OUT:    a = item number selected (start with 1), zero if none hit.
6297 7083              ;                bit 15 set for selected.
6298 7083              ;                bit 14 set if disabled.
6299 7083              ;
6300 7083              ;===========================================================================
6301 7083              choose_item PROC 
6302 7083
6303 7083 A5 D0                 lda   <firstVisItem
6304 7085 3A                    dec   a
6305 7086 85 50                 sta   <count
6306 7088
6307 7088 E6 50        lop5     inc   <count                   Next item.
6308 708A A5 50                 lda   <count
6309 708C 20 AD 73              jsr   calcitem                 Get item's RECT and pointer.
6310 708F F0 33                 beq   not_found                Off end of menu?
6311 7091
6312 7091 A2 00 00              ldx   #0                       Check if cursor is inside item.
6313 7094 7B                    tdc   
6314 7095 18                    clc   
6315 7096 69 0C 00              adc   #rect                    Pass pointer to 'rect'.
6316 7099 20 BD 6C              jsr   inside
6317 709C F0 EA                 beq   lop5
6318 709E
6319 709E              ;
6320 709E              ; --- Cursor over item --------------------------------------------
6321 709E              ;
6322 709E 20 1D 74     no_scroller jsr   getistrg              Never allow cursor over dividing line.
6323 70A1 A7 64                 lda   [<strg_ptr]
6324 70A3 C9 01 2D              cmp   #$2D01
6325 70A6 F0 1C                 beq   not_found
6326 70A8
6327 70A8 A5 50                 lda   <count
6328 70AA 09 00 80              ora   #$8000                   Mark item as selected.
6329 70AD AA                    tax   
6330 70AE
6331 70AE A0 05 00              ldy   #ItemFlag-1              Is item disabled?
6332 70B1 B7 24                 lda   [<itemptr],y
6333 70B3 30 0A                 bmi   disabled                 If yes, mark as selected and disabled.
6334 70B5
6335 70B5 A0 0A 00              ldy   #MenuFlag                Is the menu enabled?
6336 70B8 B7 1C                 lda   [<menuptr],y
6337 70BA 29 80 00              and   #M_ENABLED
6338 70BD F0 08                 beq   exit                     If not, item is also not disabled.
6339 70BF
6340 70BF 8A           disabled txa                            Set disabled bit.
6341 70C0 09 00 40              ora   #$4000
6342 70C3 60                    rts   
6343 70C4
6344 70C4 A2 00 00     not_found ldx   #0                      Not over any item.
6345 70C7 8A           exit     txa                            Return result in A.
6346 70C8
6347 70C8 60                    rts   
6348 70C9
6349 70C9                       ENDP 
6350 70C9
6351 70C9
6352 70C9              ;===========================================================================
6353 70C9              ;
6354 70C9              ;                   Size_Menu
6355 70C9              ;
6356 70C9              ;                   Compute the default size of the menu.
6357 70C9              ;
6358 70C9              ;   IN:    menuptr = pointer to menu.
6359 70C9              ;          menuhand = handle of menu.
6360 70C9              ;          menuWidth = zero to set default width.
6361 70C9              ;          menuHeight = zero to set default height.
6362 70C9              ;
6363 70C9              ;  OUT:    menuWidth = default width if it was zero.
6364 70C9              ;          menuHeight = default height if it was zero.
6365 70C9              ;
6366 70C9              ;===========================================================================
6367 70C9              size_menu PROC 
6368 70C9
6369 70C9 64 10                 stz   <rect+y2                 Height accumulator.
6370 70CB 64 12                 stz   <rect+x2                 Width accumulator.
6371 70CD
6372 70CD              ; --- Set every item's height, max width, and menu's height -----
6373 70CD              ;
6374 70CD 20 25 74              jsr   getifirst                Get pointer to first item.
6375 70D0 F0 61                 beq   exit                     Are there any items?
6376 70D2
6377 70D2              ; ------- Find item's width --------------------
6378 70D2              ;
6379 70D2 20 04 81     lop1     jsr   FixTextFace
6380 70D5
6381 70D5
6382 70D5 48                    pha                            Space for result.
6383 70D6 20 1D 74              jsr   getistrg                 Get pointer to item's string.
6384 70D9 DA                    phx                            Pass high word.
6385 70DA 48                    pha                            Pass low word.
6386 70DB A2 04 A9 22           _StringWidth                   Get string's width.
6387 70E2
6388 70E2 A5 62                 lda   <text_width              Add room for the check mark.
6389 70E4 18                    clc   
6390 70E5 65 62                 adc   <text_width
6391 70E7 65 62                 adc   <text_width
6392 70E9 AA                    tax   
6393 70EA A0 02 00              ldy   #ItemChar
6394 70ED B7 24                 lda   [<itemptr],y
6395 70EF 29 FF 00              and   #$00FF
6396 70F2 F0 10                 beq   ok34
6397 70F4 A5 62                 lda   <text_width
6398 70F6 18                    clc                            Now add space for the keyboard equivalent, the apple key
6399 70F7 6A                    ror   a                        and a chacracter, plus one extra for slop
6400 70F8 18                    clc   
6401 70F9 65 62                 adc   <text_width
6402 70FB 65 62                 adc   <text_width              1 1/2 for check mark, 2 for cmd-key-equiv,2 for space
6403 70FD 65 62                 adc   <text_width
6404 70FF 65 62                 adc   <text_width
6405 7101 65 62                 adc   <text_width
6406 7103 AA                    tax   
6407 7104 8A           ok34     txa   
6408 7105 18                    clc   
6409 7106 63 01                 adc   1,s
6410 7108 FA                    plx                            Pull in x just to fix stack, a = value.
6411 7109
6412 7109              ; ------- Keep the width of the widest item ----------------
6413 7109              ;
6414 7109 C5 12                 cmp   <rect+x2                 Is this the longest item?
6415 710B 90 02                 bcc   do_height
6416 710D 85 12                 sta   <rect+x2                 Save the longest width.
6417 710F
6418 710F              ; ------- Accumulate item height ----------------------------
6419 710F              ;
6420 710F 20 0D 74     do_height jsr   getitemh                Get the item's height.
6421 7112 18                    clc                            Keep a running height total.
6422 7113 65 10                 adc   <rect+y2
6423 7115 85 10                 sta   <rect+y2
6424 7117
6425 7117              ; ------- Next item --------------------------------------------
6426 7117              ;
6427 7117 20 37 74              jsr   next_item
6428 711A D0 B6                 bne   lop1                     Any more items?
6429 711C
6430 711C              ; --- Set the default values -----------------------------------
6431 711C              ;
6432 711C A0 02 00              ldy   #MenuWidth
6433 711F B7 1C                 lda   [<menuptr],y             Was menu's width given?
6434 7121 D0 04                 bne   skip1
6435 7123
6436 7123 A5 12                 lda   <rect+x2                 Set menu's width.
6437 7125 97 1C                 sta   [<menuptr],y             Store the menu's width.
6438 7127
6439 7127 C8           skip1    iny   
6440 7128 C8                    iny   
6441 7129 B7 1C                 lda   [<menuptr],y             Was the menu's height given.
6442 712B D0 06                 bne   exit
6443 712D
6444 712D A5 10                 lda   <rect+y2                 Set menu's height.
6445 712F 1A                    inc   a
6446 7130 1A                    inc   a
6447 7131
6448 7131 97 1C        store    sta   [<menuptr],y             Store the menu's height.
6449 7133
6450 7133 20 1F 81     exit     jsr   ClearTextFace            Plain text.
6451 7136
6452 7136 60                    rts   
6453 7137
6454 7137                       ENDP 
6455 7137
6456 7137
6457 7137              ;===========================================================================
6458 7137              ;
6459 7137              ;                   Draw_Title
6460 7137              ;
6461 7137              ;                   Draw menu title.
6462 7137              ;
6463 7137              ;   IN:    <barPtr = pointer to locked menu bar.
6464 7137              ;          <menurect = title's enclosing rectangle.
6465 7137              ;          <menuhand = handle of menu.
6466 7137              ;          <menuptr = pointer to menu.
6467 7137              ;          <param =  0 = normal, 1 = highlighted, bit 15 =1 for invert.
6468 7137              ;
6469 7137              ;===========================================================================
6470 7137              draw_title PROC 
6471 7137
6472 7137              sav_patt equ   1
6473 7137
6474 7137 48                    pha                            Space for save pattern.
6475 7138
6476 7138 20 76 63              jsr   getcolor                 Get menu bar's colors.
6477 713B
6478 713B 20 1F 81              jsr   ClearTextFace
6479 713E
6480 713E 20 2A 75              jsr   pushmrect                Common need.
6481 7141              ;
6482 7141              ;
6483 7141              ; --- Special case XOR hiliting ---------------------------------
6484 7141              ;
6485 7141 A5 56                 lda   <param                   Did caller ask for invert?
6486 7143 10 09                 bpl   do_fill
6487 7145
6488 7145 A2 04 56 22           _InvertRect                    Special case XOR.
6489 714C 68                    pla                            All done, get rid of temp space.
6490 714D
6491 714D 60                    rts   
6492 714E
6493 714E              ;
6494 714E              ; --- Color replace drawing --------------------------------------
6495 714E              ;
6496 714E A4 30        do_fill  ldy   <norcolor                Normal color.
6497 7150
6498 7150 A5 56                 lda   <param                   Hilite or Unhilite?
6499 7152 F0 02                 beq   ok78
6500 7154
6501 7154 A4 32                 ldy   <hiliteclr               Inverted color.
6502 7156
6503 7156 98           ok78     tya   
6504 7157 83 05                 sta   sav_patt+4,s             Save the color used for background.
6505 7159 20 B8 7C              jsr   pushcolor
6506 715C A2 04 57 22           _FillRect 
6507 7163
6508 7163              ;
6509 7163              ; ------ Draw title ---------------------------------------------------
6510 7163              ;
6511 7163 20 89 5B              jsr   getrMenuTitle
6512 7166 85 64                 sta   <strg_ptr
6513 7168 86 66                 stx   <strg_ptr+2
6514 716A
6515 716A A7 64                 lda   [<strg_ptr]
6516 716C C9 01 FF              cmp   #$FF01                   Special color apple logo?
6517 716F F0 05                 beq   doAppleLogo
6518 7171 C9 01 40              cmp   #$4001
6519 7174 D0 30                 bne   ok30
6520 7176
6521 7176              ;
6522 7176              ; ---------- Draw Apple Logo --------------------------------------------
6523 7176              ;
6524 7176 A3 01        doAppleLogo lda   sav_patt,s            Get the background pattern.
6525 7178 20 C6 7C              jsr   get_apple                Put the Apple logo in 'image'.
6526 717B
6527 717B A9 33 00              lda   #imageInfo               Pass pointer to source LocInfo.
6528 717E 20 98 7C              jsr   pushData
6529 7181 A9 2B 00              lda   #clip100                 Pass pointer to source RECT.
6530 7184 20 98 7C              jsr   pushData
6531 7187 A5 4A                 lda   <menurect+x1
6532 7189 18                    clc   
6533 718A 69 04 00              adc   #4
6534 718D 48                    pha                            Pass destination X.
6535 718E A0 0C 00              ldy   #CtlRect+y2
6536 7191 B7 14                 lda   [<barptr],y
6537 7193 38                    sec   
6538 7194 E9 08 00              sbc   #8                       Height of apple logo.
6539 7197 E5 E8                 sbc   <descent                 System font's descent.
6540 7199 48                    pha                            Pass destination Y.
6541 719A F4 00 00              pea   0                        Pass mode, copy.
6542 719D A2 04 D6 22           _PPToPort 
6543 71A4
6544 71A4 80 63                 bra   ck_dim
6545 71A6
6546 71A6              ;
6547 71A6              ; ---------- Print Title string ------------------------------------------
6548 71A6              ;
6549 71A6 48           ok30     pha   
6550 71A7 A2 04 A1 22           _GetForeColor 
6551 71AE
6552 71AE A3 03                 lda   sav_patt+2,s
6553 71B0 29 0F 00              and   #$000F                   Smear foreground color for text.
6554 71B3 20 E3 6E              jsr   pushSmearLow             Push smeared color
6555 71B6 A2 04 A0 22           _SetForeColor                  Set text color.
6556 71BD
6557 71BD 48                    pha                            Save original text mode.
6558 71BE A2 04 9D 22           _GetTextMode 
6559 71C5
6560 71C5 F4 04 00              pea   4                        Transfer forground pixels only.
6561 71C8 A2 04 9C 22           _SetTextMode 
6562 71CF
6563 71CF A0 0C 00              ldy   #CtlRect+y2
6564 71D2 B7 14                 lda   [<barptr],y              I want all titles on same line.
6565 71D4 38                    sec   
6566 71D5 E5 E8                 sbc   <descent
6567 71D7 A8                    tay                            Y position to print title.
6568 71D8
6569 71D8 A6 4A                 ldx   <menurect+x1             X position to print.
6570 71DA
6571 71DA 20 1E 7D              jsr   printstrg                Print menu's title.
6572 71DD
6573 71DD
6574 71DD              ;
6575 71DD              ; If the port is the menu manager's port, don't bother restoring the text mode
6576 71DD              ; and fore color.
6577 71DD              ;
6578 71DD              ; We only did this cause Word Perfect begged.  (They also admitted how ashamed
6579 71DD              ; they were and promised to never do it again.)
6580 71DD              ;
6581 71DD 48                    pha                            ; get the current port
6582 71DE 48                    pha   
6583 71DF A2 04 1C 22           _GetPort 
6584 71E6 68                    pla   
6585 71E7 FA                    plx   
6586 71E8
6587 71E8 38                    sec   
6588 71E9 E9 75 00              sbc   #port
6589 71EC B0 01                 bcs   @1
6590 71EE CA                    dex   
6591 71EF              @1        
6592 71EF C5 00                 cmp   <data
6593 71F1 D0 08                 bne   @NotSame
6594 71F3 E4 02                 cpx   <Data+2
6595 71F5 D0 04                 bne   @NotSame
6596 71F7
6597 71F7 68                    pla                            ; they are the same so clear off text mode and fore color
6598 71F8 68                    pla   
6599 71F9 80 0E                 bra   @AllDone                 ; fini
6600 71FB
6601 71FB              @NotSame                                ; different port so run old code.
6602 71FB
6603 71FB A2 04 9C 22           _SetTextMode                   restore original text mode
6604 7202 A2 04 A0 22           _SetForeColor 
6605 7209
6606 7209              @AllDone  
6607 7209              ;
6608 7209              ;
6609 7209              ; --------- Dim Title ---------------------------------------------------
6610 7209              ;
6611 7209 A0 0A 00     ck_dim   ldy   #MenuFlag
6612 720C B7 1C                 lda   [<menuptr],y
6613 720E 29 80 00              and   #M_ENABLED               Disabled?
6614 7211 F0 29                 beq   exit
6615 7213
6616 7213 F4 FD 00              pea   dimmed>>16
6617 7216 F4 C2 84              pea   dimmed
6618 7219 A2 04 32 22           _SetPenMask 
6619 7220
6620 7220 20 2A 75              jsr   pushmrect
6621 7223 A3 05                 lda   sav_patt+4,s
6622 7225 20 B8 7C              jsr   pushcolor
6623 7228 A2 04 57 22           _FillRect 
6624 722F
6625 722F F4 FD 00              pea   nor_mask>>16
6626 7232 F4 CA 84              pea   nor_mask
6627 7235 A2 04 32 22           _SetPenMask 
6628 723C
6629 723C 68           exit     pla                            Get rid of sav_patt.
6630 723D
6631 723D 60                    rts   
6632 723E
6633 723E                       ENDP 
6634 723E
6635 723E
6636 723E              ;===========================================================================
6637 723E              ;
6638 723E              ;                   Draw_Item
6639 723E              ;
6640 723E              ;                   Draw a standard text menu item.
6641 723E              ;
6642 723E              ;   IN:  param = bits 0-13 = item number to draw.
6643 723E              ;                bit 14 = 1 if item is dimmed.
6644 723E              ;                bit 15 = 1 if item should be hilited.
6645 723E              ;        menuptr = pointer to menu.
6646 723E              ;
6647 723E              ;  OUT:  itemptr = pointer to item.
6648 723E              ;
6649 723E              ;===========================================================================
6650 723E              draw_item PROC 
6651 723E
6652 723E              dflag    equ   1
6653 723E
6654 723E              ;
6655 723E              ; --- Do setups ------------------------------------
6656 723E              ;
6657 723E A2 00 00              ldx   #0                       Normal flag.
6658 7241 A5 56                 lda   <param
6659 7243 10 01                 bpl   do_normal
6660 7245 E8                    inx                            Hilite flag.
6661 7246
6662 7246 DA           do_normal phx                           Save draw flag.
6663 7247 29 FF 3F              and   #$3FFF                   Clear hilite and dimmed bits.
6664 724A
6665 724A 20 AD 73              jsr   calcitem                 Get item pointer and set 'rect'.
6666 724D
6667 724D              ;
6668 724D              ; --- Draw item's background -----------------------
6669 724D              ;
6670 724D 20 34 75              jsr   pushrect                 Common need.
6671 7250 A5 DE                 lda   <specialFlag             Flag setup by routine checkForScrolling, so that
6672 7252 D0 4B                 bne   dont_xor                 we just don't do an invertRect for this item
6673 7254              ;
6674 7254              ; ------ Special case XOR highlight ----------------
6675 7254              ;
6676 7254 A5 56                 lda   <param                   Is item dimmed?
6677 7256 29 00 40              and   #$4000
6678 7259 F0 31                 beq   ok2
6679 725B
6680 725B F4 02 00              pea   2                        XOR
6681 725E A2 04 2E 22           _SetPenMode 
6682 7265
6683 7265 F4 FD 00              pea   dimmed>>16
6684 7268 F4 C2 84              pea   dimmed
6685 726B A2 04 32 22           _SetPenMask 
6686 7272
6687 7272 F4 0F 00              pea   15                       Solid ($FFFF) pattern.
6688 7275 A2 04 37 22           _SetSolidPenPat 
6689 727C
6690 727C A2 04 53 22           _FrameRect 
6691 7283 A2 04 36 22           _PenNormal 
6692 728A 68                    pla   
6693 728B
6694 728B 60                    rts   
6695 728C
6696 728C
6697 728C A0 06 00     ok2      ldy   #ItemFlag                Special case XOR flag set?
6698 728F B7 24                 lda   [<itemptr],y
6699 7291 29 20 00              and   #I_NO_XOR
6700 7294 F0 09                 beq   dont_xor
6701 7296
6702 7296 A2 04 56 22           _InvertRect                    Invert the item.
6703 729D
6704 729D 68                    pla                            Get rid of state flag.
6705 729E
6706 729E 60                    rts   
6707 729F
6708 729F              ;
6709 729F              ; ------ Set up for text item background -----------
6710 729F              ;
6711 729F A4 30        dont_xor ldy   <norcolor                Find background color of item.
6712 72A1 A3 05                 lda   dflag+4,s
6713 72A3 F0 02                 beq   ok1
6714 72A5 A4 32                 ldy   <hiliteclr
6715 72A7 98           ok1      tya                            Color of background to use if text.
6716 72A8 20 B8 7C              jsr   pushcolor                Push pointer to color pattern.
6717 72AB A2 04 57 22           _FillRect                      Fill item's background color.
6718 72B2
6719 72B2              ;
6720 72B2              ; --- Draw guts of item -------------------------------------
6721 72B2              ;
6722 72B2 68                    pla                            Get rid of state flag (needed in A).
6723 72B3 82 41 00              brl   text_guts                Draw text item's guts, and exit.
6724 72B6
6725 72B6                       ENDP 
6726 72B6
6727 72B6
6728 72B6              ;===========================================================================
6729 72B6              ;
6730 72B6              ;                   Ck_Disable
6731 72B6              ;
6732 72B6              ;                   Disable the item.
6733 72B6              ;
6734 72B6              ;   IN:    itemptr = pointer to item.
6735 72B6              ;          barptr = menu bar pointer.
6736 72B6              ;
6737 72B6              ;  OUT:    Item disabled if bit set in ItemFlag.
6738 72B6              ;
6739 72B6              ;===========================================================================
6740 72B6              ck_disable PROC 
6741 72B6
6742 72B6 A0 06 00              ldy   #ItemFlag                Load flag in high byte to set neg flag.
6743 72B9 B7 24                 lda   [<itemptr],y
6744 72BB 29 80 00              and   #I_ENABLED
6745 72BE D0 0A                 bne   mash_it
6746 72C0
6747 72C0 A0 0A 00              ldy   #MenuFlag                You're not out of the woods yet,
6748 72C3 B7 1C                 lda   [<menuptr],y             a item is disabled if its menu is.
6749 72C5 29 80 00              and   #M_ENABLED
6750 72C8 F0 2C                 beq   exit
6751 72CA
6752 72CA F4 FD 00     mash_it  pea   dimmed>>16
6753 72CD F4 C2 84              pea   dimmed
6754 72D0 A2 04 32 22           _SetPenMask 
6755 72D7
6756 72D7 20 34 75              jsr   pushrect                 Pass pointer of item's RECT.
6757 72DA              ;                                       Disabled can't be selected.
6758 72DA A5 30                 lda   <norcolor                Get menu's background color.
6759 72DC 29 FF 00              and   #$00FF                   Always solid.
6760 72DF
6761 72DF 20 B8 7C              jsr   pushcolor                Push pointer to color pattern.
6762 72E2 A2 04 57 22           _FillRect                      Fill will be dithered.
6763 72E9
6764 72E9 F4 FD 00              pea   nor_mask>>16             Reset drawing mask to normal solid.
6765 72EC F4 CA 84              pea   nor_mask
6766 72EF A2 04 32 22           _SetPenMask 
6767 72F6
6768 72F6 60           exit     rts   
6769 72F7
6770 72F7                       ENDP 
6771 72F7
6772 72F7
6773 72F7              ;===========================================================================
6774 72F7              ;
6775 72F7              ;                   Text_Guts
6776 72F7              ;
6777 72F7              ;                   Draw text item's guts.
6778 72F7              ;
6779 72F7              ;   IN:    a = state of item, 0 = normal, 1 = selected.
6780 72F7              ;
6781 72F7              ;===========================================================================
6782 72F7              text_guts PROC 
6783 72F7
6784 72F7 A4 30                 ldy   <norcolor                Normal color.
6785 72F9 AA                    tax                            Is item selected?
6786 72FA F0 02                 beq   ok1
6787 72FC A4 32                 ldy   <hiliteclr               If yes, use hilite color.
6788 72FE 98           ok1      tya   
6789 72FF 29 0F 00              and   #$000F
6790 7302 20 E3 6E              jsr   pushSmearLow             Push smeared color
6791 7305 A2 04 A0 22           _SetForeColor                  Set color to use for text.
6792 730C
6793 730C 20 04 81              jsr   FixTextFace
6794 730F
6795 730F              ;
6796 730F              ; --- Dividing line (not the same thing as an underline) ---------------
6797 730F              ;
6798 730F 20 1D 74              jsr   getistrg                 Put item's string pointer in 'strg_ptr'.
6799 7312
6800 7312 A7 64                 lda   [<strg_ptr]              Get the first two bytes from the string.
6801 7314 C9 01 2D              cmp   #$2D01                   Dividing line flag?
6802 7317 D0 14                 bne   main_text
6803 7319
6804 7319 A5 10                 lda   <rect+y2                 Center line in item.
6805 731B 38                    sec   
6806 731C E5 0C                 sbc   <rect+y1
6807 731E 4A                    lsr   a
6808 731F 18                    clc   
6809 7320 65 0C                 adc   <rect+y1
6810 7322 A8                    tay   
6811 7323
6812 7323 A5 0E                 lda   <rect+x1                 Draw from wall to wall.
6813 7325 A6 12                 ldx   <rect+x2
6814 7327 CA                    dex                            Not past right side.
6815 7328 20 46 74              jsr   hline                    Draw the dividing line and exit.
6816 732B 80 64                 bra   ck_dim
6817 732D
6818 732D              ;
6819 732D              ; --- Print item's text ----------------------------------------
6820 732D              ;
6821 732D              main_text                               ; !!!! Font not defined yet !!!!!
6822 732D A5 10                 lda   <rect+y2
6823 732F 38                    sec   
6824 7330 E5 E8                 sbc   <descent
6825 7332 A8                    tay                            Y = position to print item.
6826 7333                       phy   
6827 7333
6828 7333 A5 62                 lda   <text_width
6829 7335 18                    clc                            don't wan't any carry to be rotating in on us
6830 7336 6A                    ror   a
6831 7337 18                    clc   
6832 7338 65 0E                 adc   <rect+x1
6833 733A 65 62                 adc   <text_width              Ident 1 1/2 times the width of 'W' to make room for mark
6834 733C                       pha                            X starting position of item's text.
6835 733C                       jsr   GetIconInfo
6836 733C AA                    tax   
6837 733D                       beq   @noIcon
6838 733D                       clc   
6839 733D                       adc   1,s                      Add in the width of the icon.
6840 733D                       adc   #2                       Add some extra slop for spacing in between the icon
6841 733D                       sta   1,s
6842 733D              @noIcon  plx   
6843 733D                       ply   
6844 733D 20 1E 7D              jsr   printstrg
6845 7340
6846 7340 20 1F 81              jsr   DrawItemIcon             If the item has an icon this routine draws it, otherwise
6847 7343              ;                                       it just returns.
6848 7343              ;
6849 7343              ; --- Mark item -------------------------------------------------
6850 7343              ;
6851 7343                       jsr   ClearTextFace            Check marks and command key equiv. always appear in plain text
6852 7343
6853 7343 A0 04 00              ldy   #ItemCheck
6854 7346 B7 24                 lda   [<itemptr],y
6855 7348 29 FF 00              and   #$00FF
6856 734B F0 1B                 beq   ck_command               Is there a mark?
6857 734D
6858 734D A0 01 00              ldy   #mark+1
6859 7350 97 00                 sta   [<data],y                Put the character in a string.
6860 7352
6861 7352 20 7C 7C              jsr   pushmark                 Push address of 'mark'.
6862 7355 68                    pla                            Pass string's address in 'strg_ptr'.
6863 7356 85 64                 sta   <strg_ptr
6864 7358 68                    pla   
6865 7359 85 66                 sta   <strg_ptr+2
6866 735B
6867 735B A5 10                 lda   <rect+y2
6868 735D 38                    sec   
6869 735E E5 E8                 sbc   <descent
6870 7360 A8                    tay                            Y = position to print item.
6871 7361
6872 7361 A6 0E                 ldx   <rect+x1                 Pass the x starting position in X.
6873 7363 E8                    inx   
6874 7364 E8                    inx   
6875 7365
6876 7365 20 1E 7D              jsr   printstrg                Print the mark.
6877 7368
6878 7368              ;
6879 7368              ; --- Command character tied to item --------------------
6880 7368              ;
6881 7368 A0 02 00     ck_command ldy   #ItemChar
6882 736B B7 24                 lda   [<itemptr],y
6883 736D 29 FF 00              and   #$00FF
6884 7370 F0 1F                 beq   ck_dim
6885 7372
6886 7372 A0 05 00              ldy   #com_key+2
6887 7375 97 00                 sta   [<data],y                Store character in command string.
6888 7377
6889 7377 20 81 7C              jsr   pushcom_key
6890 737A 68                    pla                            Pass address of com_key in 'strg_ptr'.
6891 737B 85 64                 sta   <strg_ptr
6892 737D 68                    pla   
6893 737E 85 66                 sta   <strg_ptr+2
6894 7380
6895 7380 A5 10                 lda   <rect+y2
6896 7382 38                    sec   
6897 7383 E5 E8                 sbc   <descent
6898 7385 A8                    tay                            Y = position to print item.
6899 7386
6900 7386 A5 12                 lda   <rect+x2                 Calculate starting position for printing the
6901 7388 38                    sec                            command key equivalents. Allow two for this.
6902 7389 E5 62                 sbc   <text_width
6903 738B E5 62                 sbc   <text_width
6904 738D AA                    tax                            Pass x starting position.
6905 738E
6906 738E 20 1E 7D              jsr   printstrg
6907 7391
6908 7391              ;
6909 7391              ; --- Disable text -------------------------------------
6910 7391              ;
6911 7391 20 B6 72     ck_dim   jsr   ck_disable               Check to disable item.
6912 7394
6913 7394              ;
6914 7394              ; --- Underline the item --------------------------------
6915 7394              ;
6916 7394 A0 06 00     ck_underl ldy   #ItemFlag
6917 7397 B7 24                 lda   [<itemptr],y
6918 7399 29 40 00              and   #I_NOUNDER               Underline flag set?
6919 739C F0 0B                 beq   exit
6920 739E
6921 739E A5 0E                 lda   <rect+x1                 Draw underline.
6922 73A0 A6 12                 ldx   <rect+x2
6923 73A2 CA                    dex   
6924 73A3 A4 10                 ldy   <rect+y2
6925 73A5 88                    dey   
6926 73A6 20 46 74              jsr   hline
6927 73A9
6928 73A9 60           exit     rts   
6929 73AA
6930 73AA                       ENDP 
6931 73AA
6932 73AA
6933 73AA              ;===========================================================================
6934 73AA              ;
6935 73AA              ;                   Get_ItemID
6936 73AA              ;
6937 73AA              ;                   Return item ID.
6938 73AA              ;
6939 73AA              ;   IN:    itemptr = pointer to item.
6940 73AA              ;
6941 73AA              ;  OUT:    a = item ID number.
6942 73AA              ;
6943 73AA              ;===========================================================================
6944 73AA              get_itemID PROC 
6945 73AA
6946 73AA A7 24                 lda   [<itemptr]               Return item ID number.
6947 73AC
6948 73AC 60                    rts   
6949 73AD
6950 73AD                       ENDP 
6951 73AD
6952 73AD
6953 73AD              ;===========================================================================
6954 73AD              ;
6955 73AD              ;                   CalcItem
6956 73AD              ;
6957 73AD              ;                   Setup item's parameters
6958 73AD              ;
6959 73AD              ;   IN:  a = item index, 0 = first item.
6960 73AD              ;        menuptr = pointer to menu.
6961 73AD              ;        menurect = coordinates of menu.
6962 73AD              ;
6963 73AD              ;  OUT:  Equal flag is TRUE if item not found.
6964 73AD              ;        rect = item's coordinates (last item in list if item not found).
6965 73AD              ;        itemptr = pointer to item (zero if item not found).
6966 73AD              ;
6967 73AD              ;===========================================================================
6968 73AD              calcitem PROC 
6969 73AD
6970 73AD              ; --- Setups ----------------------------------------------------------
6971 73AD              ;
6972 73AD 38                    sec   
6973 73AE E5 D0                 sbc   <firstVisItem            normalize it
6974 73B0 48                    pha                            Save item's index.
6975 73B1
6976 73B1 20 25 74              jsr   getifirst                Get the address of first item.
6977 73B4
6978 73B4              ;
6979 73B4              ; --- Run down the item list, accumulating item heights, until ---------
6980 73B4              ; --- given item index counter is exhausted.                   ---------
6981 73B4              ;
6982 73B4
6983 73B4 20 EF 73              jsr   getStarting              Get starting vertical position
6984 73B7 80 1B                 bra   enter20
6985 73B9
6986 73B9 A0 0C 00     lop20    ldy   #ITEMSIZE                Check ID of next item.
6987 73BC B7 24                 lda   [<itemptr],y             Get item's ID.
6988 73BE D0 09                 bne   ok20                     No more items if ID is zero.
6989 73C0              ;
6990 73C0              ; ------- No more items, and matching ID was not found -----------------
6991 73C0              ;
6992 73C0 20 0D 74              jsr   getitemh                 Get the height for the last item.
6993 73C3 64 24                 stz   <itemptr                 Set, off menu flag.
6994 73C5 64 26                 stz   <itemptr+2
6995 73C7 80 13                 bra   exit1
6996 73C9
6997 73C9 20 0D 74     ok20     jsr   getitemh                 Get height of item,
6998 73CC 18                    clc                            and add it to the current top.
6999 73CD 65 0C                 adc   <rect+y1
7000 73CF 85 0C                 sta   <rect+y1                 Store the top of this item.
7001 73D1
7002 73D1 20 37 74              jsr   next_item
7003 73D4
7004 73D4 68           enter20  pla                            Index counter.
7005 73D5 3A                    dec   a
7006 73D6 48                    pha   
7007 73D7 10 E0                 bpl   lop20                    Done.
7008 73D9
7009 73D9              ;
7010 73D9              ; --- Item found and rect+y1 = top of the item, compute the rest -----
7011 73D9              ;
7012 73D9 20 0D 74              jsr   getitemh                 Get height of item,
7013 73DC 18           exit1    clc                            and add it to the top,
7014 73DD 65 0C                 adc   <rect+y1
7015 73DF 85 10                 sta   <rect+y2                 and store it as the bottom.
7016 73E1
7017 73E1 68                    pla                            Get rid of index counter.
7018 73E2
7019 73E2              ;
7020 73E2              ; --- Compute the left and right side of the item -------------------
7021 73E2              ;
7022 73E2 A5 4A                 lda   <menurect+x1             Left side.
7023 73E4 85 0E                 sta   <rect+x1
7024 73E6
7025 73E6 A5 4E                 lda   <menurect+x2             Right side.
7026 73E8 85 12                 sta   <rect+x2
7027 73EA
7028 73EA A5 24                 lda   <itemptr                 Set return flag (was item found?).
7029 73EC 05 26                 ora   <itemptr+2
7030 73EE
7031 73EE 60                    rts   
7032 73EF
7033 73EF                       ENDP 
7034 73EF
7035 73EF              ;===========================================================================
7036 73EF              ;
7037 73EF              ;                   GetStarting
7038 73EF              ;
7039 73EF              ;   IN:     <menurect = menu's rectangle
7040 73EF              ;           <menuptr = ptr to menu record
7041 73EF              ;
7042 73EF              ;  OUT:     <rect = starting position
7043 73EF              ;===========================================================================
7044 73EF              getstarting PROC 
7045 73EF
7046 73EF A5 D0                 lda   <firstVisItem
7047 73F1 C9 01 00              cmp   #1
7048 73F4 F0 07                 beq   @1
7049 73F6 A5 48                 lda   <menurect+y1
7050 73F8 18                    clc   
7051 73F9 65 E6                 adc   <font_h
7052 73FB 80 02                 bra   @2
7053 73FD A5 48        @1       lda   <menurect+y1
7054 73FF 85 0C        @2       sta   <rect+y1
7055 7401
7056 7401 A4 D0                 ldy   <firstVisItem
7057 7403 88                    dey   
7058 7404 F0 06        lop1     beq   out
7059 7406 20 37 74              jsr   next_item
7060 7409 88                    dey   
7061 740A 80 F8                 bra   lop1
7062 740C
7063 740C 60           out      rts   
7064 740D
7065 740D                       ENDP 
7066 740D
7067 740D              ;===========================================================================
7068 740D              ;
7069 740D              ;                   GetItemH
7070 740D              ;
7071 740D              ;                   Get height of an item.
7072 740D              ;
7073 740D              ;   IN:    itemptr = item pointer.
7074 740D              ;          menu_type = 0 if text menu, not zero if color menu.
7075 740D              ;
7076 740D              ;  OUT:    a = item's height.
7077 740D              ;
7078 740D              ;===========================================================================
7079 740D              getitemh PROC 
7080 740D
7081 740D A0 06 00              ldy   #ItemFlag
7082 7410 B7 24                 lda   [<itemptr],y
7083 7412 29 08 00              and   #I_INVIS
7084 7415 49 08 00              eor   #I_INVIS
7085 7418 F0 02                 beq   exit                     If invisible, zero height.
7086 741A
7087 741A A5 E6                 lda   <font_h                  Text item height.
7088 741C
7089 741C 60           exit     rts   
7090 741D
7091 741D                       ENDP 
7092 741D
7093 741D              ;===========================================================================
7094 741D              ;
7095 741D              ;                   getistrg
7096 741D              ;
7097 741D              ;                   Get item's string pointer.
7098 741D              ;
7099 741D              ;   IN:    itemptr = item
7100 741D              ;
7101 741D              ;  OUT:    strg_ptr = item's string pointer.
7102 741D              ;          a = low word.
7103 741D              ;          x = high word.
7104 741D              ;
7105 741D              ;===========================================================================
7106 741D              getistrg PROC 
7107 741D
7108 741D 20 64 5B              jsr   getrItemName
7109 7420 85 64                 sta   <strg_ptr
7110 7422 86 66                 stx   <strg_ptr+2
7111 7424
7112 7424 60                    rts   
7113 7425
7114 7425                       ENDP 
7115 7425
7116 7425
7117 7425              ;===========================================================================
7118 7425              ;
7119 7425              ;                   GetIFirst
7120 7425              ;
7121 7425              ;                   Get pointer to first item in menu.
7122 7425              ;
7123 7425              ;   IN:    menuptr = pointer to menu.
7124 7425              ;
7125 7425              ;  OUT:    itemptr = pointer to first item in menu.
7126 7425              ;          Equal flag = TRUE if no items in menu.
7127 7425              ;
7128 7425              ;===========================================================================
7129 7425              getifirst PROC 
7130 7425
7131 7425 A6 1E                 ldx   <menuptr+2
7132 7427 A5 1C                 lda   <menuptr
7133 7429 18                    clc   
7134 742A 69 18 00              adc   #ItemList
7135 742D 90 01                 bcc   store1
7136 742F E8                    inx   
7137 7430
7138 7430 85 24        store1   sta   <itemptr
7139 7432 86 26                 stx   <itemptr+2
7140 7434
7141 7434 A7 24                 lda   [<itemptr]               Set return flag.
7142 7436
7143 7436 60                    rts   
7144 7437
7145 7437                       ENDP 
7146 7437
7147 7437
7148 7437              ;===========================================================================
7149 7437              ;
7150 7437              ;                   Next_Item
7151 7437              ;
7152 7437              ;                   Get the ID of the next menu item.
7153 7437              ;
7154 7437              ;   IN:  itemptr = pointer to current item.
7155 7437              ;
7156 7437              ;  OUT:  Equal is TRUE if there isn't any more items.
7157 7437              ;        ELSE
7158 7437              ;              itemptr = pointer to next item.
7159 7437              ;
7160 7437              ;===========================================================================
7161 7437              next_item PROC 
7162 7437
7163 7437 A5 24                 lda   <itemptr
7164 7439 18                    clc   
7165 743A 69 0C 00              adc   #ITEMSIZE
7166 743D 90 02                 bcc   store
7167 743F E6 26                 inc   <itemptr+2
7168 7441 85 24        store    sta   <itemptr
7169 7443
7170 7443 A7 24                 lda   [<itemptr]               Set last item return flag.
7171 7445
7172 7445 60                    rts   
7173 7446
7174 7446                       ENDP 
7175 7446
7176 7446
7177 7446              ;===========================================================================
7178 7446              ;
7179 7446              ;                   HLine
7180 7446              ;
7181 7446              ;                   Draw a horizontal line.
7182 7446              ;
7183 7446              ;   IN:    PUSH:WORD - color.
7184 7446              ;          a = starting x position.
7185 7446              ;          x = ending x position.
7186 7446              ;          y = line number.
7187 7446              ;
7188 7446              ;  OUT:    a,x,y all the same as in.
7189 7446              ;
7190 7446              ;===========================================================================
7191 7446              hline    PROC 
7192 7446
7193 7446              linenum  equ   1
7194 7446              xpos1    equ   linenum+2
7195 7446              xpos2    equ   xpos1+2
7196 7446
7197 7446 DA                    phx   
7198 7447 48                    pha   
7199 7448 5A                    phy   
7200 7449
7201 7449 48                    pha   
7202 744A 5A                    phy   
7203 744B A2 04 3A 22           _MoveTo 
7204 7452
7205 7452 A5 34                 lda   <outLineClr              Set color of line.
7206 7454 20 E1 6C              jsr   setoutline
7207 7457
7208 7457 A3 05                 lda   xpos2,s                  Line to.
7209 7459 48                    pha   
7210 745A A3 03                 lda   linenum+2,s
7211 745C 48                    pha   
7212 745D A2 04 3C 22           _LineTo 
7213 7464
7214 7464 7A                    ply   
7215 7465 68                    pla   
7216 7466 FA                    plx   
7217 7467
7218 7467 60                    rts   
7219 7468
7220 7468                       ENDP 
7221 7468
7222 7468
7223 7468              ;
7224 7468              ;          APPEND MCALLS.ASM
7225 7468              ;
7226 7468              ;===========================================================================
7227 7468              ;
7228 7468              ;                   FixMenuBar
7229 7468              ;
7230 7468              ;                   Set size of Menu bar.
7231 7468              ;
7232 7468              ;   IN:    None.
7233 7468              ;
7234 7468              ;  OUT:    WORD - height of menu bar.
7235 7468              ;
7236 7468              ;===========================================================================
7237 7468              FixMenuBar PROC 
7238 7468
7239 7468              result   equ   input
7240 7468
7241 7468              myTemp   equ   work
7242 7468
7243 7468 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7244 746B 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7245 746E F0 73                 beq   exit2                    Is there a current menu bar?
7246 7470
7247 7470 20 27 63              jsr   to_myport                Switch to my port for text calls.
7248 7473
7249 7473              ;
7250 7473              ; --- Get the menu's pointer ---------------------
7251 7473              ;
7252 7473 20 35 62              jsr   getmfirst                Get pointer of first menu in menu list.
7253 7476 F0 49                 beq   exit                     Are there any menus?
7254 7478
7255 7478              ;
7256 7478              ; --- Set the title's width if it isn't already set -------------
7257 7478              ;
7258 7478 A0 0E 00     lop1     ldy   #TitleWidth              Check if width is already set.
7259 747B B7 1C                 lda   [<menuptr],y
7260 747D D0 2E                 bne   skip10
7261 747F
7262 747F 48                    pha                            Space for result.
7263 7480
7264 7480 20 89 5B              jsr   getrMenuTitle            Get the menu title
7265 7483
7266 7483 86 EC                 stx   <mytemp+2
7267 7485 85 EA                 sta   <mytemp
7268 7487 A7 EA                 lda   [<mytemp]                Check if the title is the apple logo title
7269 7489 C9 01 FF              cmp   #$FF01
7270 748C F0 05                 beq   setAppleLogoWidth
7271 748E C9 01 40              cmp   #$4001
7272 7491 D0 07                 bne   notAppleLogo
7273 7493 A9 18 00     setAppleLogoWidth lda   #24
7274 7496 83 01                 sta   1,s
7275 7498 80 0D                 bra   widthSet
7276 749A
7277 749A A5 EC 48 A5  notAppleLogo PushLong <mytemp 
7278 74A0
7279 74A0 A2 04 A9 22           _StringWidth 
7280 74A7 68           widthSet pla   
7281 74A8 A0 0E 00              ldy   #TitleWidth
7282 74AB 97 1C                 sta   [<menuptr],y             Store width of menu title.
7283 74AD
7284 74AD              skip10    
7285 74AD              ;
7286 74AD              ; --- Set the width and height of the menu ----------------------------
7287 74AD              ;
7288 74AD A9 FF FF              lda   #$FFFF
7289 74B0 48                    pha                            Default width.
7290 74B1 48                    pha                            Default height.
7291 74B2 A7 1C                 lda   [<menuptr]
7292 74B4 48                    pha                            Pass menu's ID.
7293 74B5 A2 0F 1C 22           _CalcMenuSize 
7294 74BC
7295 74BC 20 87 68              jsr   next_menu                Get the pointer to the next menu.
7296 74BF D0 B7                 bne   lop1                     Any more menus?
7297 74C1
7298 74C1              ;
7299 74C1              ; --- Check if menu bar height needs to be set -------------
7300 74C1              ;
7301 74C1 A0 0C 00     exit     ldy   #CtlRect+y2
7302 74C4 B7 14                 lda   [<barptr],y              Is the menu bar height already set?
7303 74C6 D0 0D                 bne   skip1                    If yes, don't reset.
7304 74C8
7305 74C8 A0 08 00              ldy   #CtlRect+y1
7306 74CB B7 14                 lda   [<barptr],y
7307 74CD 38                    sec                            Get an extra pixel here.
7308 74CE 65 E6                 adc   <font_h                  Add font height.
7309 74D0 A0 0C 00              ldy   #CtlRect+y2
7310 74D3 97 14                 sta   [<barptr],y              Store menu bar's bottom side.
7311 74D5
7312 74D5 A0 08 00     skip1    ldy   #CtlRect+y1              Return menu bar's height.
7313 74D8 38                    sec   
7314 74D9 F7 14                 sbc   [<barptr],y
7315 74DB 83 0A                 sta   result,s
7316 74DD
7317 74DD 20 5C 63              jsr   to_uport                 Restore original port.
7318 74E0 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7319 74E3              ;
7320 74E3 82 BD 1A     exit2    brl   pop0bytes                no error
7321 74E6
7322 74E6                       ENDP 
7323 74E6
7324 74E6              ;===========================================================================
7325 74E6              ;
7326 74E6              ;                   CalcMenuSize
7327 74E6              ;
7328 74E6              ;                   Set size of Menu.
7329 74E6              ;
7330 74E6              ;   IN:  PUSH:WORD - width of menu, zero to compute, $FFFF to check first.
7331 74E6              ;        PUSH:WORD - height of menu, zero to compute, $FFFF to check first.
7332 74E6              ;        PUSH:WORD - menu ID.
7333 74E6              ;
7334 74E6              ;  OUT:  None.
7335 74E6              ;
7336 74E6              ;===========================================================================
7337 74E6              CalcMenuSize PROC 
7338 74E6
7339 74E6              menunum  equ   input
7340 74E6              height   equ   menunum+2
7341 74E6              TheWidth equ   height+2
7342 74E6
7343 74E6 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7344 74E9 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7345 74EC F0 34                 beq   exit2                    Is there a current menu bar?
7346 74EE
7347 74EE 20 27 63              jsr   to_myport                Switch to my port for text calls.
7348 74F1
7349 74F1 A3 0A                 lda   menunum,s                Get menu's ID.
7350 74F3 20 38 62              jsr   getmptr                  Now get its pointer.
7351 74F6 F0 24                 beq   exit                     Was the menu found?
7352 74F8
7353 74F8 20 CF 80              jsr   freeCache                Free menu's cache, size maybe wrong.
7354 74FB
7355 74FB A0 02 00              ldy   #MenuWidth               Set menu record with given parameters.
7356 74FE A3 0E                 lda   TheWidth,s
7357 7500 10 02                 bpl   ok1
7358 7502
7359 7502 B7 1C                 lda   [<menuptr],y             Leave MenuWidth alone.
7360 7504
7361 7504 97 1C        ok1      sta   [<menuptr],y
7362 7506 AA                    tax                            Save.
7363 7507 C8                    iny   
7364 7508 C8                    iny   
7365 7509 A3 0C                 lda   height,s
7366 750B 10 02                 bpl   ok2
7367 750D
7368 750D B7 1C                 lda   [<menuptr],y             Leave MenuHeight alone.
7369 750F
7370 750F 97 1C        ok2      sta   [<menuptr],y
7371 7511 F0 03                 beq   calc_size                Asking for default height?
7372 7513 8A                    txa   
7373 7514 D0 06                 bne   exit                     Asking for default width?
7374 7516
7375 7516              ;
7376 7516              ; --- Compute default width and height ----------------------------------
7377 7516              ;
7378 7516 A2 02 00     calc_size ldx   #mSize                  Ask defProc to compute menu size.
7379 7519 20 C5 6F              jsr   dispatch                 Call menu's defProc.
7380 751C
7381 751C 20 5C 63     exit     jsr   to_uport                 Restore original port.
7382 751F 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7383 7522
7384 7522 82 96 1A     exit2    brl   pop6bytes                no error
7385 7525
7386 7525                       ENDP 
7387 7525
7388 7525
7389 7525              ;===========================================================================
7390 7525              ;
7391 7525              ;                   PushYRat
7392 7525              ;
7393 7525              ;                   Push address of zero page variables.
7394 7525              ;
7395 7525              ;===========================================================================
7396 7525              pushyrat PROC 
7397 7525
7398 7525 A9 3A 00              lda   #yrat
7399 7528 80 0D                 bra   enter
7400 752A
7401 752A                       ENTRY pushmrect
7402 752A              pushmrect  
7403 752A A9 48 00              lda   #menurect
7404 752D 80 08                 bra   enter
7405 752F
7406 752F                       ENTRY pushscInfo1
7407 752F              pushscInfo1  
7408 752F A9 9C 00              lda   #scInfo1
7409 7532 80 03                 bra   enter
7410 7534
7411 7534                       ENTRY pushrect
7412 7534 A9 0C 00     pushrect lda   #rect                    Most used.
7413 7537
7414 7537 82 2A 1A     enter    brl   pushDpage
7415 753A
7416 753A                       ENDP 
7417 753A
7418 753A              ;===========================================================================
7419 753A              ;
7420 753A              ;                   InsertMItem2
7421 753A              ;
7422 753A              ;                   Insert Item into ItemList.
7423 753A              ;
7424 753A              ;   IN:    PUSH:WORD - refDescriptor, describes what next long is (ptr, hdl, res. ID)
7425 753A              ;          PUSH:LONG - ptr, handle, or resource ID of MenuItemTemplate
7426 753A              ;          PUSH:WORD - item ID, zero to insert in front, $FFFF to append.
7427 753A              ;          PUSH:WORD - menu ID.
7428 753A              ;
7429 753A              ;  OUT:    None.
7430 753A              ;
7431 753A              ;===========================================================================
7432 753A              InsertMItem2 PROC 
7433 753A
7434 753A              menunum  equ   input
7435 753A              itemnum  equ   menunum+2
7436 753A              itemstrg equ   itemnum+2
7437 753A              refdescriptor equ   itemstrg+4
7438 753A
7439 753A 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7440 753D 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7441 7540 F0 1F                 beq   myexit2                  Is there a current menu bar?
7442 7542
7443 7542 20 85 75              jsr   commonInsert
7444 7545 B0 17                 bcs   myexit
7445 7547
7446 7547 A3 0E                 lda   itemstrg,s
7447 7549 85 2C                 sta   <temptr2
7448 754B A3 10                 lda   itemstrg+2,s
7449 754D 85 2E                 sta   <temptr2+2
7450 754F
7451 754F A3 12                 lda   refdescriptor,s
7452 7551
7453 7551 A4 28                 ldy   <temptr
7454 7553 20 04 5B              jsr   fillitemRec
7455 7556
7456 7556 A0 0C 00              ldy   #NumOfItems              update total number of items in the menu
7457 7559 B7 1C                 lda   [<menuptr],y
7458 755B 1A                    inc   a
7459 755C 97 1C                 sta   [<menuptr],y
7460 755E
7461 755E 20 C4 62     myexit   jsr   unlockmenubar
7462 7561
7463 7561 82 67 1A     myexit2  brl   pop10bytes
7464 7564
7465 7564
7466 7564              ;===========================================================================
7467 7564              ;
7468 7564              ;                   InsertMItem
7469 7564              ;
7470 7564              ;                   Insert Item into ItemList.
7471 7564              ;
7472 7564              ;   IN:    PUSH:LONG - pointer ot item string to be inserted.
7473 7564              ;          PUSH:WORD - item ID, zero to insert in front, $FFFF to append.
7474 7564              ;          PUSH:WORD - menu ID.
7475 7564              ;
7476 7564              ;  OUT:    None.
7477 7564              ;
7478 7564              ;===========================================================================
7479 7564              InsertMItem PROC 
7480 7564
7481 7564              menunum  equ   input
7482 7564              itemnum  equ   menunum+2
7483 7564              itemstrg equ   itemnum+2
7484 7564
7485 7564 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7486 7567 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7487 756A F0 16                 beq   exit2                    Is there a current menu bar?
7488 756C
7489 756C 20 85 75              jsr   commonInsert
7490 756F B0 0E                 bcs   exit
7491 7571              ;
7492 7571              ; --- Insert the item ----------------------------------------------
7493 7571              ;
7494 7571 A3 0E                 lda   itemstrg,s               Pass pointer to item string.
7495 7573 85 64                 sta   <strg_ptr
7496 7575 A3 10                 lda   itemstrg+2,s
7497 7577 85 66                 sta   <strg_ptr+2
7498 7579
7499 7579 A2 01 00              ldx   #1                       Build record.
7500 757C 20 D6 5D              jsr   parse_item
7501 757F
7502 757F 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7503 7582
7504 7582 82 3E 1A     exit2    brl   pop8bytes                no error
7505 7585
7506 7585
7507 7585              ;===========================================================================
7508 7585              ;
7509 7585              ;                   CommonInsert
7510 7585              ;
7511 7585              ;===========================================================================
7512 7585                       entry commonInsert 
7513 7585              commonInsert  
7514 7585 A3 0C                 lda   menunum+2,s
7515 7587 20 38 62              jsr   getmptr                  Get the pointer to the menu.
7516 758A F0 54                 beq   gohome                   Menu not found?
7517 758C
7518 758C A0 0C 00              ldy   #NumOfItems              Check if the menu is empty
7519 758F B7 1C                 lda   [<menuptr],y
7520 7591 D0 13                 bne   notEmpty1
7521 7593 A3 0E                 lda   itemnum+2,s
7522 7595 C9 00 00              cmp   #$0000                   Are we inserting at beginning
7523 7598 F0 05                 beq   @111
7524 759A C9 FF FF              cmp   #$FFFF                   Are we inserting at end
7525 759D D0 41                 bne   gohome                   not $0000 and not $FFFF with an empty menu means adios
7526 759F
7527 759F A9 00 00     @111     lda   #0
7528 75A2 83 0E                 sta   itemnum+2,s
7529 75A4 80 07                 bra   expand
7530 75A6
7531 75A6 A3 0E        notEmpty1 lda   itemnum+2,s             Make sure given item ID is valid.
7532 75A8 20 D1 79              jsr   getiptr2
7533 75AB F0 33                 beq   gohome                   Item not found?
7534 75AD
7535 75AD              ;
7536 75AD              ; --- Expand menu record for new item --------------------------------
7537 75AD              ;
7538 75AD A6 22        expand   ldx   <menuhand+2              Pass menu's handle.
7539 75AF A5 20                 lda   <menuhand
7540 75B1 A0 0C 00              ldy   #ITEMSIZE                Number of bytes to increase by.
7541 75B4 20 14 77              jsr   growBlock                Expand the menu record.
7542 75B7 B0 27                 bcs   gohome                   Error?
7543 75B9
7544 75B9 20 CF 80              jsr   freeCache                Set cache to bad if menu has a cache.
7545 75BC
7546 75BC              ;
7547 75BC              ; --- Make space for the item  ----------------------------------------
7548 75BC              ;
7549 75BC D4 EA                 pei   <work                    Save size of block.
7550 75BE
7551 75BE A3 10                 lda   itemnum+4,s              Get pointer to where to insert item.
7552 75C0 20 D1 79              jsr   getiptr2
7553 75C3 68                    pla   
7554 75C4 85 EA                 sta   <work                    Restore size of block.
7555 75C6
7556 75C6 A3 0E                 lda   itemnum+2,s
7557 75C8 F0 03                 beq   skip2                    If insert at front, ready.
7558 75CA
7559 75CA 20 37 74              jsr   next_item                Insert after given item.
7560 75CD
7561 75CD A5 24        skip2    lda   <itemptr                 Compute number of bytes in front of item.
7562 75CF 38                    sec   
7563 75D0 E5 1C                 sbc   <menuptr
7564 75D2 85 28                 sta   <temptr                  Pass to 'into_block'.
7565 75D4
7566 75D4 A5 24                 lda   <itemptr
7567 75D6 A6 26                 ldx   <itemptr+2
7568 75D8 A0 0C 00              ldy   #ITEMSIZE
7569 75DB 20 43 77              jsr   into_block               Insert gap into menu record for item.
7570 75DE
7571 75DE 18                    clc   
7572 75DF 60                    rts   
7573 75E0
7574 75E0 38           gohome   sec   
7575 75E1 60                    rts   
7576 75E2
7577 75E2                       ENDP 
7578 75E2
7579 75E2
7580 75E2              ;===========================================================================
7581 75E2              ;
7582 75E2              ;                   InsertMenu
7583 75E2              ;
7584 75E2              ;                   Insert Menu into MenuList.
7585 75E2              ;
7586 75E2              ;   IN:    PUSH:LONG - handle of menu to insert.
7587 75E2              ;          PUSH:WORD - menu ID, zero to insert at front.
7588 75E2              ;
7589 75E2              ;  OUT:    None.
7590 75E2              ;
7591 75E2              ;===========================================================================
7592 75E2              InsertMenu PROC 
7593 75E2
7594 75E2              menunum  equ   input
7595 75E2              menuin   equ   menunum+2
7596 75E2
7597 75E2 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7598 75E5 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7599 75E8 F0 62                 beq   exit2                    Is there a current menu bar?
7600 75EA
7601 75EA A3 0A                 lda   menunum,s
7602 75EC F0 05                 beq   ok2                      If I'm looking for first we're ok.
7603 75EE 20 38 62              jsr   getmptr                  Make sure ID is valid, and get offset.
7604 75F1 F0 56                 beq   exit                     Was the menu found?
7605 75F3
7606 75F3              ;
7607 75F3              ; --- Expand menu bar record for new menu --------------------------------
7608 75F3              ;
7609 75F3 A6 1A        ok2      ldx   <barhand+2               Pass menu bar's handle.
7610 75F5 A5 18                 lda   <barhand
7611 75F7 A0 04 00              ldy   #4                       Number of bytes to increase by.
7612 75FA 20 14 77              jsr   growBlock                Expand the menu record.
7613 75FD B0 4A                 bcs   exit                     Error?
7614 75FF
7615 75FF A3 0C                 lda   menuin,s
7616 7601 85 20                 sta   <menuhand
7617 7603 A3 0E                 lda   menuin+2,s
7618 7605 85 22                 sta   <menuhand+2
7619 7607 20 F1 62              jsr   lockMenuHand             <menuhand = locked.
7620 760A 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand).
7621 760D
7622 760D A0 06 00              ldy   #CtlOwner+2              Is this a window menu bar?
7623 7610 B7 14                 lda   [<barptr],y
7624 7612 10 0A                 bpl   ok3
7625 7614
7626 7614 A0 0A 00              ldy   #MenuFlag                Don't allow caching for window menus.
7627 7617 B7 1C                 lda   [<menuptr],y
7628 7619 29 F7 FF              and   #_M_CACHE
7629 761C 97 1C                 sta   [<menuptr],y
7630 761E
7631 761E              ; --- Make space for the new menu handle  -------------------------------
7632 761E              ;
7633 761E A3 0A        ok3      lda   menunum,s
7634 7620 D0 05                 bne   skip2                    If insert after, I'm ready.
7635 7622
7636 7622 A9 28 00              lda   #MenuList                Insert at front, reset 'menu_cnt'.
7637 7625 85 36                 sta   <menu_cnt
7638 7627
7639 7627 A6 16        skip2    ldx   <barptr+2                Compute where to insert.
7640 7629 A5 14                 lda   <barptr
7641 762B 18                    clc   
7642 762C 65 36                 adc   <menu_cnt
7643 762E 90 01                 bcc   ok1
7644 7630 E8                    inx   
7645 7631 A4 36        ok1      ldy   <menu_cnt                Number of bytes in front of insert.
7646 7633 84 28                 sty   <temptr                  Pass to 'into_block'.
7647 7635
7648 7635 A0 04 00              ldy   #4
7649 7638 20 43 77              jsr   into_block               Insert gap into menu record for item.
7650 763B              ;
7651 763B              ; --- Store new handle into gap ---------------------------------------
7652 763B              ;
7653 763B A3 0C                 lda   menuin,s
7654 763D 87 2C                 sta   [<temptr2]
7655 763F A0 02 00              ldy   #2
7656 7642 A3 0E                 lda   menuin+2,s
7657 7644 97 2C                 sta   [<temptr2],y
7658 7646
7659 7646 20 F6 80              jsr   everycachefree
7660 7649
7661 7649 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7662 764C              ;
7663 764C 82 6C 19     exit2    brl   pop6bytes                no error
7664 764F
7665 764F                       ENDP 
7666 764F
7667 764F
7668 764F              ;===========================================================================
7669 764F              ;
7670 764F              ;                   DeleteMItem
7671 764F              ;
7672 764F              ;                   Delete Item from ItemList.
7673 764F              ;
7674 764F              ;   IN:    PUSH:WORD - item ID.
7675 764F              ;
7676 764F              ;  OUT:    None.
7677 764F              ;
7678 764F              ;===========================================================================
7679 764F              DeleteMItem PROC 
7680 764F
7681 764F              itemnum  equ   input
7682 764F
7683 764F 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7684 7652 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7685 7655 F0 7D                 beq   exit2                    Is there a current menu bar?
7686 7657
7687 7657 A3 0A                 lda   itemnum,s
7688 7659 20 BF 79              jsr   getiptr                  Get pointer to item to delete.
7689 765C F0 73                 beq   exit                     Was the item found?
7690 765E
7691 765E              ;
7692 765E              ; --- Move other items over deleted item --------------------------
7693 765E              ;
7694 765E A0 16 00     lop1     ldy   #(ITEMSIZE*2)-2
7695 7661 A2 0A 00              ldx   #ITEMSIZE-2
7696 7664 B7 24        lop2     lda   [<itemptr],y
7697 7666 5A                    phy   
7698 7667 9B                    txy   
7699 7668 97 24                 sta   [<itemptr],y
7700 766A 7A                    ply   
7701 766B 88                    dey   
7702 766C 88                    dey   
7703 766D CA                    dex   
7704 766E CA                    dex   
7705 766F 10 F3                 bpl   lop2
7706 7671
7707 7671 20 37 74              jsr   next_item                Any more items?
7708 7674 D0 E8                 bne   lop1
7709 7676
7710 7676              ;
7711 7676              ; --- Shrink menu record for deleted item --------------------------------
7712 7676              ;
7713 7676 A0 0C 00              ldy   #NumOfItems              Update number of total items in menu.
7714 7679 B7 1C                 lda   [<menuptr],y
7715 767B 3A                    dec   a
7716 767C 97 1C                 sta   [<menuptr],y
7717 767E
7718 767E A6 22                 ldx   <menuhand+2              Pass menu's handle.
7719 7680 A5 20                 lda   <menuhand
7720 7682 A0 F6 FF              ldy   #$FFF6                   Number of bytes to decrease.
7721 7685 20 14 77              jsr   growBlock                Shrink the menu record.
7722 7688
7723 7688 20 CF 80              jsr   freeCache                Set cache to bad if menu has a cache.
7724 768B
7725 768B A0 0A 00              ldy   #menuFlag
7726 768E B7 1C                 lda   [<menuptr],y
7727 7690 29 01 00              and   #M_POPUP                 Is this menu a pop-up menu?
7728 7693 F0 3C                 beq   exit
7729 7695
7730 7695 A0 16 00              ldy   #ctlProc+2
7731 7698 B7 14                 lda   [<barptr],y
7732 769A 10 35                 bpl   exit                     This must be a super control before we change current sel.
7733 769C
7734 769C A0 12 00              ldy   #ctlValue                If it is then we need to check if we just deleted
7735 769F B7 14                 lda   [<barptr],y              the currently selected item.
7736 76A1 C3 0A                 cmp   itemnum,s
7737 76A3 D0 2C                 bne   exit
7738 76A5
7739 76A5 A0 06 00              ldy   #ctlOwner+2              Make sure the origin is right before drawing.
7740 76A8 B7 14                 lda   [<barptr],y
7741 76AA 48                    pha   
7742 76AB 88                    dey   
7743 76AC 88                    dey   
7744 76AD B7 14                 lda   [<barptr],y
7745 76AF 48                    pha   
7746 76B0 A2 0E 4D 22           _StartDrawing 
7747 76B7
7748 76B7 F4 00 00              pea   0                        New control value, 0 = no current selection in pop-up
7749 76BA D4 1A                 pei   <barhand+2
7750 76BC D4 18                 pei   <barhand                 Handle to pop-up control
7751 76BE A2 10 19 22           _SetCtlValue 
7752 76C5
7753 76C5 A9 00 00              lda   #0
7754 76C8 48                    pha   
7755 76C9 48                    pha   
7756 76CA A2 04 23 22           _SetOrigin 
7757 76D1
7758 76D1 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7759 76D4
7760 76D4 82 D4 18     exit2    brl   pop2bytes                no error
7761 76D7
7762 76D7                       ENDP 
7763 76D7
7764 76D7
7765 76D7              ;===========================================================================
7766 76D7              ;
7767 76D7              ;                   DeleteMenu
7768 76D7              ;
7769 76D7              ;                   Delete one Menu from MenuList.
7770 76D7              ;
7771 76D7              ;   IN:    PUSH:WORD - menu ID.
7772 76D7              ;
7773 76D7              ;  OUT:    None.
7774 76D7              ;
7775 76D7              ;===========================================================================
7776 76D7              DeleteMenu PROC 
7777 76D7
7778 76D7              menunum  equ   input
7779 76D7
7780 76D7 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7781 76DA 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
7782 76DD F0 32                 beq   exit2                    Is there a current menu bar?
7783 76DF
7784 76DF              ;
7785 76DF              ; --- Take menu out of menu list ---------------------------------
7786 76DF              ;
7787 76DF A3 0A                 lda   menunum,s                ID to match.
7788 76E1 20 38 62              jsr   getmptr                  Find the menu.
7789 76E4 F0 28                 beq   exit                     Error?
7790 76E6
7791 76E6 20 CF 80              jsr   freecache                Release cache that may be allocated for this menu.
7792 76E9
7793 76E9 20 87 68     lop2     jsr   next_menu
7794 76EC
7795 76EC A5 36                 lda   <menu_cnt
7796 76EE 38                    sec   
7797 76EF E9 08 00              sbc   #8
7798 76F2 A8                    tay   
7799 76F3
7800 76F3 A5 20                 lda   <menuhand
7801 76F5 97 14                 sta   [<barptr],y
7802 76F7 A5 22                 lda   <menuhand+2
7803 76F9 C8                    iny   
7804 76FA C8                    iny   
7805 76FB 97 14                 sta   [<barptr],y
7806 76FD
7807 76FD 05 20                 ora   <menuhand                Any more menu's?
7808 76FF D0 E8                 bne   lop2
7809 7701
7810 7701              ;
7811 7701              ; --- Shrink menu record for deleted item --------------------------------
7812 7701              ;
7813 7701 A6 1A                 ldx   <barhand+2               Pass menu bar's handle.
7814 7703 A5 18                 lda   <barhand
7815 7705 A0 FC FF              ldy   #$FFFC                   Number of bytes to decrease.
7816 7708 20 14 77              jsr   growBlock                Shrink the menu record.
7817 770B
7818 770B 20 F6 80              jsr   everycachefree           Menus may now be in different order.
7819 770E
7820 770E 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
7821 7711
7822 7711 82 97 18     exit2    brl   pop2bytes                no error
7823 7714
7824 7714                       ENDP 
7825 7714
7826 7714
7827 7714              ;===========================================================================
7828 7714              ;
7829 7714              ;                   GrowBlock
7830 7714              ;
7831 7714              ;                   Increase the size of a allocated memory block.
7832 7714              ;
7833 7714              ;   IN:    x/a = handle top resize.
7834 7714              ;          y = number of bytes to insert.
7835 7714              ;
7836 7714              ;  OUT:    <work = new size.
7837 7714              ;          Carry is set if unable to expand, clear if ok.
7838 7714              ;
7839 7714              ;===========================================================================
7840 7714              growBlock PROC 
7841 7714
7842 7714 85 28                 sta   <temptr                  Save handle.
7843 7716 86 2A                 stx   <temptr+2
7844 7718 84 EA                 sty   <work                    Save size delta.
7845 771A
7846 771A 48                    pha                            Space for result
7847 771B 48                    pha   
7848 771C DA                    phx                            Pass handle.
7849 771D 48                    pha   
7850 771E A2 02 18 22           _GetHandleSize                 Get the present size of the block.
7851 7725
7852 7725 20 C4 62              jsr   unlockMenuBar            Unlock menu bar & menus so they can move.
7853 7728
7854 7728 68                    pla                            Get the current size.
7855 7729 18                    clc   
7856 772A 65 EA                 adc   <work                    Increase the size.
7857 772C 85 EA                 sta   <work                    Save new size.
7858 772E
7859 772E 48                    pha                            Pass new size.
7860 772F D4 2A                 pei   <temptr+2                Pass handle.
7861 7731 D4 28                 pei   <temptr
7862 7733 A2 02 19 22           _SetHandleSize                 Expand the block.
7863 773A
7864 773A 08                    php                            Save error code.
7865 773B 20 8B 62              jsr   lockMenuBar              Relock menu bar & menus.
7866 773E 20 15 63              jsr   derefMenuHand            <menuptr = (<menuhand).
7867 7741 28                    plp                            Return error code, if any.
7868 7742
7869 7742 60                    rts   
7870 7743
7871 7743                       ENDP 
7872 7743
7873 7743
7874 7743              ;===========================================================================
7875 7743              ;
7876 7743              ;                   Into_Block
7877 7743              ;
7878 7743              ;                   Insert zero bytes into middle of block.
7879 7743              ;
7880 7743              ;   IN:    x/a = pointer to insert place.
7881 7743              ;          y = number of bytes to insert.
7882 7743              ;          <work = number of bytes in block.
7883 7743              ;          <temptr = number of bytes in front of insertion point.
7884 7743              ;
7885 7743              ;===========================================================================
7886 7743              into_block PROC 
7887 7743
7888 7743 85 2C                 sta   <temptr2
7889 7745 86 2E                 stx   <temptr2+2
7890 7747 84 EC                 sty   <work+2                  Number of bytes to insert.
7891 7749
7892 7749 A5 EA                 lda   <work                    Number of bytes in block,
7893 774B 38                    sec   
7894 774C E5 28                 sbc   <temptr                  less number of bytes in front of insert,
7895 774E 3A                    dec   a                        less one word,
7896 774F 3A                    dec   a
7897 7750 AA                    tax                            equals offset from insert to end of record.
7898 7751 E5 EC                 sbc   <work+2                  Less size of insert, equals offset to
7899 7753 A8                    tay                            data that needs to be moved.
7900 7754
7901 7754 B7 2C        lop1     lda   [<temptr2],y
7902 7756 5A                    phy   
7903 7757 9B                    txy   
7904 7758 97 2C                 sta   [<temptr2],y
7905 775A 7A                    ply   
7906 775B A9 00 00              lda   #0                       Clear gap as we go.
7907 775E 97 2C                 sta   [<temptr2],y
7908 7760 CA                    dex   
7909 7761 CA                    dex   
7910 7762 88                    dey   
7911 7763 88                    dey   
7912 7764 10 EE                 bpl   lop1
7913 7766
7914 7766 60                    rts   
7915 7767
7916 7767                       ENDP 
7917 7767
7918 7767
7919 7767              ;===========================================================================
7920 7767              ;
7921 7767              ;                   GetSysBar
7922 7767              ;
7923 7767              ;                   Return pointer to System Menu bar.
7924 7767              ;
7925 7767              ;   IN:  None.
7926 7767              ;
7927 7767              ;  OUT:  LONG - handle of system menu bar.
7928 7767              ;
7929 7767              ;===========================================================================
7930 7767              GetSysBar PROC 
7931 7767
7932 7767              result   equ   input
7933 7767
7934 7767 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7935 776A
7936 776A A5 08                 lda   <sysmenu
7937 776C 83 0A                 sta   result,s
7938 776E A5 0A                 lda   <sysmenu+2
7939 7770 83 0C                 sta   result+2,s
7940 7772
7941 7772 82 2E 18              brl   pop0bytes                no error
7942 7775
7943 7775                       ENDP 
7944 7775
7945 7775
7946 7775              ;===========================================================================
7947 7775              ;
7948 7775              ;                   SetSysBar
7949 7775              ;
7950 7775              ;                   Install new system menu bar.
7951 7775              ;
7952 7775              ;   IN:    PUSH:LONG - menu bar handle.
7953 7775              ;
7954 7775              ;  OUT:    None.
7955 7775              ;
7956 7775              ;===========================================================================
7957 7775              SetSysBar PROC 
7958 7775
7959 7775              newbar   equ   input
7960 7775
7961 7775 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7962 7778
7963 7778 A3 0A                 lda   newbar,s                 Set new system menu bar pointer.
7964 777A 85 08                 sta   <sysmenu
7965 777C A3 0C                 lda   newbar+2,s
7966 777E 85 0A                 sta   <sysmenu+2
7967 7780
7968 7780 82 30 18              brl   pop4bytes                no error
7969 7783
7970 7783                       ENDP 
7971 7783
7972 7783
7973 7783              ;===========================================================================
7974 7783              ;
7975 7783              ;                   SetMenuBar
7976 7783              ;
7977 7783              ;                   Set current menu bar.
7978 7783              ;
7979 7783              ;   IN:    PUSH:LONG - new current menu bar, zero for system menu bar.
7980 7783              ;
7981 7783              ;  OUT:    None.
7982 7783              ;
7983 7783              ;===========================================================================
7984 7783              SetMenuBar PROC 
7985 7783
7986 7783 20 97 8F              jsr   startup                  Do startup initialization for tool call.
7987 7786 20 76 62              jsr   setCurrentBar            <barHand = passed menu bar.
7988 7789
7989 7789 82 27 18              brl   pop4bytes                no error
7990 778C
7991 778C                       ENDP 
7992 778C
7993 778C
7994 778C              ;===========================================================================
7995 778C              ;
7996 778C              ;                   GetMenuBar
7997 778C              ;
7998 778C              ;                   Get current menu bar.
7999 778C              ;
8000 778C              ;   IN:    None.
8001 778C              ;
8002 778C              ;  OUT:    LONG - handle of current menu bar.
8003 778C              ;
8004 778C              ;===========================================================================
8005 778C              GetMenuBar PROC 
8006 778C
8007 778C              result   equ   input
8008 778C
8009 778C 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8010 778F
8011 778F A5 18                 lda   <barhand                 Return current menu bar.
8012 7791 83 0A                 sta   result,s
8013 7793 A5 1A                 lda   <barhand+2
8014 7795 83 0C                 sta   result+2,s
8015 7797
8016 7797 82 09 18              brl   pop0bytes                no error
8017 779A
8018 779A                       ENDP 
8019 779A
8020 779A
8021 779A              ;===========================================================================
8022 779A              ;
8023 779A              ;                   CountMItems
8024 779A              ;
8025 779A              ;                   Return number of items in menu.
8026 779A              ;
8027 779A              ;   IN:    PUSH:WORD - menu ID.
8028 779A              ;
8029 779A              ;  OUT:    WORD - number of items in menu, $FFFF if menu not found.
8030 779A              ;
8031 779A              ;===========================================================================
8032 779A              CountMItems PROC 
8033 779A
8034 779A              menunum  equ   input
8035 779A              result   equ   menunum+2
8036 779A
8037 779A 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8038 779D 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8039 77A0 F0 21                 beq   exit2                    Is there a current menu bar?
8040 77A2
8041 77A2 A9 FF FF              lda   #$FFFF
8042 77A5 83 0C                 sta   result,s                 Start with error.
8043 77A7
8044 77A7 A3 0A                 lda   menunum,s                Pass menu's ID.
8045 77A9 20 38 62              jsr   getmptr                  Put pointer to menu into 'menuptr'.
8046 77AC F0 0E                 beq   exit                     Is there a menu with that ID?
8047 77AE
8048 77AE 64 EA                 stz   <work                    Item counter.
8049 77B0 20 25 74              jsr   getifirst
8050 77B3 F0 07                 beq   exit                     Is there even one item?
8051 77B5
8052 77B5 E6 EA        lop1     inc   <work
8053 77B7 20 37 74              jsr   next_item                Next item.
8054 77BA D0 F9        enter1   bne   lop1                     Any more items?
8055 77BC
8056 77BC A5 EA        exit     lda   <work
8057 77BE 83 0C                 sta   result,s                 Return number of items.
8058 77C0
8059 77C0 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8060 77C3
8061 77C3 82 E5 17     exit2    brl   pop2bytes                no error
8062 77C6
8063 77C6                       ENDP 
8064 77C6
8065 77C6
8066 77C6              ;===========================================================================
8067 77C6              ;
8068 77C6              ;                   SetBarColors
8069 77C6              ;
8070 77C6              ;                   Set colors of menu bar.
8071 77C6              ;
8072 77C6              ;   IN:  PUSH:WORD - Normal color:    Bits 0-3 = text color when normal.
8073 77C6              ;                                     Bits 4-7 = background color when normal.
8074 77C6              ;                                     Bits 8-15 = zero.
8075 77C6              ;                                     $FFFF to not set.
8076 77C6              ;
8077 77C6              ;        PUSH:WORD - Selected color:  Bits 0-3 = text color when selected.
8078 77C6              ;                                     Bits 4-7 = background color when selected.
8079 77C6              ;                                     Bits 8-15 = zero.
8080 77C6              ;                                     $FFFF to not set.
8081 77C6              ;
8082 77C6              ;        PUSH:WORD - Outline color:   Bits 0-3 = zero.
8083 77C6              ;                                     Bits 7-4 = outine color.
8084 77C6              ;                                     Bits 8-15 = zero.
8085 77C6              ;                                     $FFFF to not set.
8086 77C6              ;
8087 77C6              ;  OUT:  None.
8088 77C6              ;
8089 77C6              ;===========================================================================
8090 77C6              SetBarColors PROC 
8091 77C6
8092 77C6              newout   equ   input
8093 77C6              newinvert equ   newout+2
8094 77C6              newbar   equ   newinvert+2
8095 77C6
8096 77C6 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8097 77C9 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8098 77CC F0 2D                 beq   exit2                    Is there a current menu bar?
8099 77CE
8100 77CE A0 24 00              ldy   #CtlColor
8101 77D1 B7 14                 lda   [<barptr],y
8102 77D3 C8                    iny   
8103 77D4 C8                    iny   
8104 77D5 17 14                 ora   [<barptr],y
8105 77D7 F0 1F                 beq   exit
8106 77D9
8107 77D9 20 C1 80              jsr   everyCacheBad            Set cache to bad if menu has a cache.
8108 77DC 20 76 63              jsr   getcolor                 work = pointer to color table.
8109 77DF
8110 77DF A0 00 00              ldy   #0
8111 77E2 A3 0E                 lda   newbar,s                 Should bar color be set?
8112 77E4 30 02                 bmi   next1
8113 77E6 97 EA                 sta   [<work],y
8114 77E8
8115 77E8 C8           next1    iny   
8116 77E9 C8                    iny   
8117 77EA A3 0C                 lda   newinvert,s              Should invert color be set.
8118 77EC 30 02                 bmi   next2
8119 77EE 97 EA                 sta   [<work],y
8120 77F0
8121 77F0 C8           next2    iny   
8122 77F1 C8                    iny   
8123 77F2 A3 0A                 lda   newout,s                 Should outline color be set.
8124 77F4 30 02                 bmi   exit
8125 77F6 97 EA                 sta   [<work],y
8126 77F8
8127 77F8 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8128 77FB
8129 77FB 82 BD 17     exit2    brl   pop6bytes                no error
8130 77FE
8131 77FE                       ENDP 
8132 77FE
8133 77FE
8134 77FE              ;===========================================================================
8135 77FE              ;
8136 77FE              ;                   GetBarColors
8137 77FE              ;
8138 77FE              ;                   Return menu bar's colors.
8139 77FE              ;
8140 77FE              ;   IN:  None.
8141 77FE              ;
8142 77FE              ;  OUT:  LONG - Bits 31-24 = undefined.
8143 77FE              ;               Bits 23-20 = outline color.
8144 77FE              ;               Bits 19-16 = undefined.
8145 77FE              ;               Bits 15-12 = background color when selected.
8146 77FE              ;               Bits  11-8 = text color when selected.
8147 77FE              ;               Bits   7-4 = background color when not selected.
8148 77FE              ;               Bits   3-0 = text color when not selected.
8149 77FE              ;
8150 77FE              ;===========================================================================
8151 77FE              GetBarColors PROC 
8152 77FE
8153 77FE              result   equ   input
8154 77FE
8155 77FE 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8156 7801 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8157 7804 F0 11                 beq   exit2                    Is there a current menu bar?
8158 7806
8159 7806 20 76 63              jsr   getcolor                 Get menu bar colors.
8160 7809
8161 7809 A5 34                 lda   <outlineclr
8162 780B 83 0C                 sta   result+2,s
8163 780D
8164 780D A5 32                 lda   <hiliteclr
8165 780F EB                    xba   
8166 7810 05 30                 ora   <norcolor
8167 7812 83 0A                 sta   result,s
8168 7814
8169 7814 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8170 7817
8171 7817 82 89 17     exit2    brl   pop0bytes                no error
8172 781A
8173 781A                       ENDP 
8174 781A
8175 781A
8176 781A              ;===========================================================================
8177 781A              ;
8178 781A              ;                   SetMTitleStart
8179 781A              ;
8180 781A              ;                   Set starting position of titles.
8181 781A              ;
8182 781A              ;   IN:  PUSH:WORD - starting position, bits 0-6 used.
8183 781A              ;
8184 781A              ;  OUT:  None.
8185 781A              ;
8186 781A              ;===========================================================================
8187 781A              SetMTitleStart PROC 
8188 781A
8189 781A              newstart equ   input
8190 781A
8191 781A 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8192 781D 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8193 7820 F0 12                 beq   exit2                    Is there a current menu bar?
8194 7822
8195 7822 A0 11 00              ldy   #CtlFlag+1
8196 7825 B7 14                 lda   [<barptr],y
8197 7827 29 80 FF              and   #$FF80                   Clear current starting position.
8198 782A 03 0A                 ora   newstart,s               Set new starting position.
8199 782C 97 14                 sta   [<barptr],y
8200 782E
8201 782E 20 F6 80              jsr   everyCacheFree           Free every cahce, size maybe wrong.
8202 7831
8203 7831 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8204 7834
8205 7834 82 74 17     exit2    brl   pop2bytes                no error
8206 7837
8207 7837                       ENDP 
8208 7837
8209 7837
8210 7837              ;===========================================================================
8211 7837              ;
8212 7837              ;                   GetMTitleStart
8213 7837              ;
8214 7837              ;                   Return starting position of titles.
8215 7837              ;
8216 7837              ;   IN:  None.
8217 7837              ;
8218 7837              ;  OUT:  WORD - starting position.
8219 7837              ;
8220 7837              ;===========================================================================
8221 7837              GetMTitleStart PROC 
8222 7837
8223 7837              result   equ   input
8224 7837
8225 7837 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8226 783A 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8227 783D F0 0D                 beq   exit2                    Is there a current menu bar?
8228 783F
8229 783F A0 11 00              ldy   #CtlFlag+1
8230 7842 B7 14                 lda   [<barptr],y
8231 7844 29 7F 00              and   #$007F                   Get just the current starting position.
8232 7847 83 0A                 sta   result,s
8233 7849
8234 7849 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8235 784C
8236 784C 82 54 17     exit2    brl   pop0bytes                no error
8237 784F
8238 784F                       ENDP 
8239 784F
8240 784F
8241 784F              ;===========================================================================
8242 784F              ;
8243 784F              ;                   GetMHandle
8244 784F              ;
8245 784F              ;                   Find the handle of menu.
8246 784F              ;
8247 784F              ;   IN:    PUSH:WORD - Menu ID of menu to find.
8248 784F              ;
8249 784F              ;  OUT:    LONG - menu pointer, or zero if error.
8250 784F              ;
8251 784F              ;===========================================================================
8252 784F              GetMHandle PROC 
8253 784F
8254 784F              id       equ   input
8255 784F              result   equ   id+2
8256 784F
8257 784F 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8258 7852 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8259 7855 F0 10                 beq   exit2                    Is there a current menu bar?
8260 7857
8261 7857 A3 0A                 lda   id,s                     Pass ID in A.
8262 7859 20 38 62              jsr   getmptr                  Get handle of menu.
8263 785C
8264 785C A5 20                 lda   <menuhand                Return found handle.
8265 785E 83 0C                 sta   result,s
8266 7860 A5 22                 lda   <menuhand+2
8267 7862 83 0E                 sta   result+2,s
8268 7864
8269 7864 20 C4 62              jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8270 7867
8271 7867 82 41 17     exit2    brl   pop2bytes                no error
8272 786A
8273 786A                       ENDP 
8274 786A
8275 786A
8276 786A              ;===========================================================================
8277 786A              ;
8278 786A              ;                   SetMenuID
8279 786A              ;
8280 786A              ;                   Set menu ID number.
8281 786A              ;
8282 786A              ;   IN:  PUSH:WORD - new ID.
8283 786A              ;        PUSH:WORD - menu's ID.
8284 786A              ;
8285 786A              ;  OUT:  None.
8286 786A              ;
8287 786A              ;===========================================================================
8288 786A              SetMenuID PROC 
8289 786A
8290 786A              menunum  equ   input
8291 786A              newID    equ   menunum+2
8292 786A
8293 786A 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8294 786D 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8295 7870 F0 0E                 beq   exit2                    Is there a current menu bar?
8296 7872
8297 7872 A3 0A                 lda   menunum,s
8298 7874 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8299 7877 F0 04                 beq   exit                     Menu not found?
8300 7879
8301 7879 A3 0C                 lda   newID,s
8302 787B 87 1C                 sta   [<menuptr]               Set new ID.
8303 787D
8304 787D 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8305 7880
8306 7880 82 30 17     exit2    brl   pop4bytes                no error
8307 7883
8308 7883                       ENDP 
8309 7883
8310 7883
8311 7883              ;===========================================================================
8312 7883              ;
8313 7883              ;                   SetMTitleWidth
8314 7883              ;
8315 7883              ;                   Set menu title's width.
8316 7883              ;
8317 7883              ;   IN:  PUSH:WORD - width.
8318 7883              ;        PUSH:WORD - menu's ID.
8319 7883              ;
8320 7883              ;  OUT:  None.
8321 7883              ;
8322 7883              ;===========================================================================
8323 7883              SetMTitleWidth PROC 
8324 7883
8325 7883              menunum  equ   input
8326 7883              newwidth equ   menunum+2
8327 7883
8328 7883 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8329 7886 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8330 7889 F0 14                 beq   exit2                    Is there a current menu bar?
8331 788B
8332 788B A3 0A                 lda   menunum,s
8333 788D 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8334 7890 F0 0A                 beq   exit                     Menu not found?
8335 7892
8336 7892 A0 0E 00              ldy   #TitleWidth
8337 7895 A3 0C                 lda   newwidth,s
8338 7897 97 1C                 sta   [<menuptr],y             Set new title width.
8339 7899
8340 7899 20 F6 80              jsr   everyCacheFree           Free every cahce, size maybe wrong.
8341 789C
8342 789C 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8343 789F
8344 789F 82 11 17     exit2    brl   pop4bytes                no error
8345 78A2
8346 78A2                       ENDP 
8347 78A2
8348 78A2
8349 78A2              ;===========================================================================
8350 78A2              ;
8351 78A2              ;                   GetMTitleWidth
8352 78A2              ;
8353 78A2              ;                   Return menu title's width.
8354 78A2              ;
8355 78A2              ;   IN:  PUSH:WORD - menu's ID.
8356 78A2              ;
8357 78A2              ;  OUT:  WORD - title's width.
8358 78A2              ;
8359 78A2              ;===========================================================================
8360 78A2              GetMTitleWidth PROC 
8361 78A2
8362 78A2              menunum  equ   input
8363 78A2              result   equ   menunum+2
8364 78A2
8365 78A2 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8366 78A5 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8367 78A8 F0 11                 beq   exit2                    Is there a current menu bar?
8368 78AA
8369 78AA A3 0A                 lda   menunum,s
8370 78AC 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8371 78AF F0 07                 beq   exit                     Menu not found?
8372 78B1
8373 78B1 A0 0E 00              ldy   #TitleWidth
8374 78B4 B7 1C                 lda   [<menuptr],y             Get menu's title width,
8375 78B6 83 0C                 sta   result,s                 and pass it back to caller.
8376 78B8
8377 78B8 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8378 78BB
8379 78BB 82 ED 16     exit2    brl   pop2bytes                no error
8380 78BE
8381 78BE                       ENDP 
8382 78BE
8383 78BE
8384 78BE              ;===========================================================================
8385 78BE              ;
8386 78BE              ;                   SetMenuFlag
8387 78BE              ;
8388 78BE              ;                   Set menu's MenuFlag
8389 78BE              ;
8390 78BE              ;   IN:  PUSH:WORD - new value, bits to clear or set.
8391 78BE              ;        PUSH:WORD - menu's ID.
8392 78BE              ;
8393 78BE              ;  OUT:  None.
8394 78BE              ;
8395 78BE              ;===========================================================================
8396 78BE              SetMenuFlag PROC 
8397 78BE
8398 78BE              menunum  equ   input
8399 78BE              newValue equ   menunum+2
8400 78BE
8401 78BE 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8402 78C1 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8403 78C4 F0 1C                 beq   exit2                    Is there a current menu bar?
8404 78C6
8405 78C6 A3 0A                 lda   menunum,s
8406 78C8 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8407 78CB F0 12                 beq   exit                     Menu not found?
8408 78CD
8409 78CD 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
8410 78D0
8411 78D0 A0 0A 00              ldy   #MenuFlag
8412 78D3 A3 0C                 lda   newValue,s
8413 78D5 30 04                 bmi   reset
8414 78D7
8415 78D7 17 1C                 ora   [<menuptr],y             Set desired bits.
8416 78D9 80 02                 bra   store
8417 78DB
8418 78DB 37 1C        reset    and   [<menuptr],y             Clear desired bits.
8419 78DD 97 1C        store    sta   [<menuptr],y             Store new flag.
8420 78DF
8421 78DF 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8422 78E2
8423 78E2 82 CE 16     exit2    brl   pop4bytes                no error
8424 78E5                       ENDP 
8425 78E5
8426 78E5
8427 78E5              ;===========================================================================
8428 78E5              ;
8429 78E5              ;                   GetMenuFlag
8430 78E5              ;
8431 78E5              ;                   Get menu's MenuFlag.
8432 78E5              ;
8433 78E5              ;   IN:    PUSH:WORD - menu's ID.
8434 78E5              ;
8435 78E5              ;  OUT:    WORD - MenuFlag.
8436 78E5              ;
8437 78E5              ;===========================================================================
8438 78E5              GetMenuFlag PROC 
8439 78E5
8440 78E5              menunum  equ   input
8441 78E5              result   equ   menunum+2
8442 78E5
8443 78E5 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8444 78E8 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8445 78EB F0 11                 beq   exit2                    Is there a current menu bar?
8446 78ED
8447 78ED A3 0A                 lda   menunum,s
8448 78EF 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8449 78F2 F0 07                 beq   exit                     Menu not found?
8450 78F4
8451 78F4 A0 0A 00              ldy   #MenuFlag
8452 78F7 B7 1C                 lda   [<menuptr],y             Get menu's flag.
8453 78F9 83 0C                 sta   result,s                 and pass it back to caller.
8454 78FB
8455 78FB 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8456 78FE
8457 78FE 82 AA 16     exit2    brl   pop2bytes                no error
8458 7901
8459 7901                       ENDP 
8460 7901
8461 7901              ;===========================================================================
8462 7901              ;
8463 7901              ;                   SetMenuTitle2
8464 7901              ;
8465 7901              ;  IN: PUSH:WORD - refdescriptor, describes following long (ptr, handle, res ID)
8466 7901              ;      PUSH:LONG - titleref, ptr, handle or resource ID of title
8467 7901              ;      PUSH:WORD - id of menu that gets new title
8468 7901              ;
8469 7901              ;===========================================================================
8470 7901              SetMenuTitle2 PROC 
8471 7901
8472 7901              menunum  equ   input
8473 7901              titleref equ   menunum+2
8474 7901              refdescriptor equ   titleref+4
8475 7901
8476 7901 20 97 8F              jsr   startup
8477 7904 20 8B 62              jsr   lockmenubar
8478 7907 F0 51                 beq   exit2
8479 7909
8480 7909 A3 0A                 lda   menunum,s
8481 790B 20 38 62              jsr   getmptr                  ;Put menu pointer into 'menuptr'.
8482 790E F0 47                 beq   exit                     ;Menu not found?
8483 7910
8484 7910 A0 10 00              ldy   #TitleName               ;put titleref in menu record
8485 7913 A3 0C                 lda   titleref,s
8486 7915 97 1C                 sta   [<menuptr],y
8487 7917 C8                    iny   
8488 7918 C8                    iny   
8489 7919 A3 0E                 lda   titleref+2,s
8490 791B 97 1C                 sta   [<menuptr],y
8491 791D
8492 791D              ;
8493 791D              ; now we must set the menuflag to jive with what the refdescriptor is
8494 791D              ;
8495 791D A3 10                 lda   refdescriptor,s
8496 791F 0A                    asl   a
8497 7920 AA                    tax   
8498 7921
8499 7921 A0 0A 00              ldy   #MenuFlag                ;clear out the high two bits before setting anything
8500 7924 B7 1C                 lda   [<menuptr],y
8501 7926 29 FF 3F              and   #CLEAR_TWO_BITS
8502 7929
8503 7929 7C 2C 79              jmp   (table,x)
8504 792C
8505 792C 3C 79        table    DC W:pointer
8506 792E 37 79                 DC W:handle
8507 7930 32 79                 DC W:resourceID
8508 7932
8509 7932 09 00 80     resourceID ora   #M_RESOURCEID
8510 7935 80 05                 bra   pointer
8511 7937
8512 7937 09 00 40     handle   ora   #M_HANDLE
8513 793A 80 00                 bra   pointer
8514 793C
8515 793C A0 0A 00     pointer  ldy   #MenuFlag
8516 793F 97 1C                 sta   [<menuptr],y
8517 7941
8518 7941 48                    pha                            ;space for result
8519 7942 20 89 5B              jsr   getrMenuTitle            ;get the width of the menu title
8520 7945 DA                    phx                            ;getmenutitle returns result in a-reg and x-reg
8521 7946 48                    pha   
8522 7947 A2 04 A9 22           _StringWidth 
8523 794E
8524 794E 68                    pla   
8525 794F A0 0E 00              ldy   #TitleWidth
8526 7952 97 1C                 sta   [<menuptr],y
8527 7954
8528 7954 20 F6 80              jsr   everyCacheFree           ;Free every cahce, size maybe wrong.
8529 7957
8530 7957 20 C4 62     exit     jsr   unlockMenuBar
8531 795A
8532 795A 82 66 16     exit2    brl   pop8bytes
8533 795D
8534 795D                       ENDP 
8535 795D
8536 795D              ;===========================================================================
8537 795D              ;
8538 795D              ;                   SetMenuTitle
8539 795D              ;
8540 795D              ;                   Set menu's title.
8541 795D              ;
8542 795D              ;   IN:  PUSH:LONG - pointer to string.
8543 795D              ;        PUSH:WORD - menu's ID.
8544 795D              ;
8545 795D              ;  OUT:  None.
8546 795D              ;
8547 795D              ;===========================================================================
8548 795D              SetMenuTitle PROC 
8549 795D
8550 795D              menunum  equ   input
8551 795D              newstrg  equ   menunum+2
8552 795D
8553 795D 20 97 8F              jsr   startup                  ;Do startup initialization for tool call.
8554 7960 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8555 7963 F0 35                 beq   exit2                    Is there a current menu bar?
8556 7965
8557 7965 A3 0A                 lda   menunum,s
8558 7967 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8559 796A F0 2B                 beq   exit                     Menu not found?
8560 796C
8561 796C A0 0A 00              ldy   #MenuFlag                Clear upper two bits of menures flag to signify that
8562 796F B7 1C                 lda   [<menuptr],y             menu title is a pointer (need to do this just in case the
8563 7971 29 FF 3F              and   #CLEAR_TWO_BITS          last reference was a handle or resource ID)
8564 7974 97 1C                 sta   [<menuptr],y
8565 7976
8566 7976 A0 10 00              ldy   #TitleName
8567 7979 A3 0C                 lda   newstrg,s                Get pointer to new string.
8568 797B 97 1C                 sta   [<menuptr],y
8569 797D AA                    tax   
8570 797E C8                    iny   
8571 797F C8                    iny   
8572 7980 A3 0E                 lda   newstrg+2,s
8573 7982 97 1C                 sta   [<menuptr],y
8574 7984
8575 7984 48                    pha                            Space for result.
8576 7985 48                    pha                            Pass address of string.
8577 7986 DA                    phx   
8578 7987 A2 04 A9 22           _StringWidth 
8579 798E 68                    pla   
8580 798F A0 0E 00              ldy   #TitleWidth
8581 7992 97 1C                 sta   [<menuptr],y             Store width of menu title.
8582 7994
8583 7994 20 F6 80              jsr   everyCacheFree           Free every cahce, size maybe wrong.
8584 7997
8585 7997 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8586 799A
8587 799A 82 1E 16     exit2    brl   pop6bytes                no error
8588 799D
8589 799D                       ENDP 
8590 799D
8591 799D
8592 799D              ;===========================================================================
8593 799D              ;
8594 799D              ;                   GetMenuTitle
8595 799D              ;
8596 799D              ;                   Return pointer to menu's title.
8597 799D              ;
8598 799D              ;   IN:  PUSH:WORD - menu's ID.
8599 799D              ;
8600 799D              ;  OUT:  LONG - pointer to menu's title, zero if error.
8601 799D              ;
8602 799D              ;===========================================================================
8603 799D              GetMenuTitle PROC 
8604 799D
8605 799D              menunum  equ   input
8606 799D              result   equ   menunum+2
8607 799D
8608 799D 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8609 79A0 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8610 79A3 F0 17                 beq   exit2                    Is there a current menu bar?
8611 79A5
8612 79A5 A3 0A                 lda   menunum,s
8613 79A7 20 38 62              jsr   getmptr                  Put menu pointer into 'menuptr'.
8614 79AA F0 0D                 beq   exit                     Menu not found?
8615 79AC
8616 79AC A0 10 00              ldy   #TitleName               Return pointer to menu's title.
8617 79AF B7 1C                 lda   [<menuptr],y
8618 79B1 83 0C                 sta   result,s
8619 79B3 C8                    iny   
8620 79B4 C8                    iny   
8621 79B5 B7 1C                 lda   [<menuptr],y
8622 79B7 83 0E                 sta   result+2,s
8623 79B9
8624 79B9 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8625 79BC
8626 79BC 82 EC 15     exit2    brl   pop2bytes                no error
8627 79BF
8628 79BF                       ENDP 
8629 79BF
8630 79BF
8631 79BF              ;===========================================================================
8632 79BF              ;
8633 79BF              ;                   GetIPtr
8634 79BF              ;
8635 79BF              ;                   Find pointer of item.
8636 79BF              ;
8637 79BF              ;
8638 79BF              ;   IN:    a = item's ID, zero to find first item, $FFFF to find last.
8639 79BF              ;
8640 79BF              ;  OUT:    itemptr = pointer to item.
8641 79BF              ;          Equal flag = TRUE if error.
8642 79BF              ;
8643 79BF              ;===========================================================================
8644 79BF              GetIPtr  PROC 
8645 79BF
8646 79BF              ; --- Search every menu in the menu bar -----------------------------
8647 79BF              ;
8648 79BF 85 EA                 sta   <work                    Save ID I'm looking for.
8649 79C1
8650 79C1 20 35 62              jsr   getmfirst                Start with first menu.
8651 79C4 F0 0A                 beq   exit                     Are there any menus?
8652 79C6
8653 79C6 20 D3 79     lop3     jsr   getiptr3                 Search every item in menu.
8654 79C9 D0 05                 bne   exit                     Item found?
8655 79CB
8656 79CB 20 87 68     nextmenu jsr   next_menu                Try next menu.
8657 79CE D0 F6                 bne   lop3                     Any more menus?
8658 79D0
8659 79D0 60           exit     rts   
8660 79D1
8661 79D1
8662 79D1                       ENTRY getiptr2
8663 79D1              getiptr2  
8664 79D1
8665 79D1 85 EA                 sta   <work                    Save ID to look for.
8666 79D3              ;
8667 79D3              ; ------ Search every item in the menu ------------------------------
8668 79D3              ;
8669 79D3                       ENTRY getiptr3
8670 79D3              getiptr3  
8671 79D3
8672 79D3 20 25 74     lop1     jsr   getifirst                Get pointer to first item in menu.
8673 79D6 D0 01                 bne   lop2                     Are there any items in the menu?
8674 79D8 60                    rts                            12/5/88 HY, if no items were found we used to bra to nextmenu
8675 79D9              ;                                       now I just return if the menu is empty.
8676 79D9
8677 79D9 A5 EA        lop2     lda   <work                    ID I'm looking for.
8678 79DB F0 12                 beq   found                    Looking for first one?
8679 79DD C9 FF FF              cmp   #$FFFF                   Looking for last one?
8680 79E0 F0 06                 beq   ck_last
8681 79E2 C7 24                 cmp   [<itemptr]               Does item's ID match ID I'm looking for?
8682 79E4 D0 0D                 bne   nextitem
8683 79E6 80 07                 bra   found                    If matched, I found it.
8684 79E8
8685 79E8 A0 0C 00     ck_last  ldy   #ITEMSIZE                Look at the ID of the next item.
8686 79EB B7 24                 lda   [<itemptr],y
8687 79ED D0 04                 bne   nextitem                 Is it the last?
8688 79EF
8689 79EF A9 01 00     found    lda   #1                       Set not equal flag for found.
8690 79F2 60                    rts   
8691 79F3
8692 79F3 20 37 74     nextitem jsr   next_item                Next item.
8693 79F6 D0 E1                 bne   lop2                     Any more items in this menu?
8694 79F8
8695 79F8 60                    rts   
8696 79F9
8697 79F9                       ENDP 
8698 79F9
8699 79F9
8700 79F9              ;===========================================================================
8701 79F9              ;
8702 79F9              ;                   SetItemID
8703 79F9              ;
8704 79F9              ;                   Set new item ID.
8705 79F9              ;
8706 79F9              ;   IN:    PUSH:WORD - new ID.
8707 79F9              ;          PUSH:WORD - item's ID.
8708 79F9              ;
8709 79F9              ;  OUT:    None.
8710 79F9              ;
8711 79F9              ;===========================================================================
8712 79F9              SetItemID PROC 
8713 79F9
8714 79F9              itemnum  equ   input
8715 79F9              newID    equ   itemnum+2
8716 79F9
8717 79F9 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8718 79FC 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8719 79FF F0 0E                 beq   exit2                    Is there a current menu bar?
8720 7A01
8721 7A01 A3 0A                 lda   itemnum,s
8722 7A03 20 BF 79              jsr   getiptr
8723 7A06 F0 04                 beq   exit                     Error?
8724 7A08
8725 7A08 A3 0C                 lda   newID,s
8726 7A0A 87 24                 sta   [<itemptr]
8727 7A0C
8728 7A0C 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8729 7A0F
8730 7A0F 82 A1 15     exit2    brl   pop4bytes                no error
8731 7A12
8732 7A12                       ENDP 
8733 7A12
8734 7A12              ;===========================================================================
8735 7A12              ;
8736 7A12              ;                   SetMItem2
8737 7A12              ;
8738 7A12              ;  IN: PUSH:WORD - refdescriptor, describes what next long is (0=ptr, 1=hdl, 2=res ID)
8739 7A12              ;      PUSH:LONG - titleref, pointer, handle or resource ID of a resource menu item
8740 7A12              ;      PUSH:WORD - item's ID
8741 7A12              ;
8742 7A12              ; OUT: None.
8743 7A12              ;
8744 7A12              ;===========================================================================
8745 7A12              SetMItem2 PROC 
8746 7A12
8747 7A12              itemnum  equ   input
8748 7A12              titleref equ   itemnum+2                ; ptr, hdl, resource ID of new item name
8749 7A12              refdescriptor equ   titleref+4
8750 7A12
8751 7A12              myTemp   equ   work
8752 7A12              newFlag  equ   myTemp+4
8753 7A12
8754 7A12 20 97 8F              jsr   startup
8755 7A15 20 8B 62              jsr   lockmenubar
8756 7A18 F0 6E                 beq   exit2
8757 7A1A A3 0A                 lda   itemnum,s
8758 7A1C 20 BF 79              jsr   getiptr
8759 7A1F F0 64                 beq   exit
8760 7A21 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache
8761 7A24
8762 7A24 A0 06 00              ldy   #ItemFlag                Get flag of current item and clear the first two bits
8763 7A27 B7 24                 lda   [<itemptr],y             We need to clear them because latter on we're going to
8764 7A29 29 FF 3F              and   #CLEAR_TWO_BITS          'OR' it with the new value
8765 7A2C 97 24                 sta   [<itemptr],y
8766 7A2E
8767 7A2E A3 0C                 lda   titleref,s
8768 7A30 85 EA                 sta   <myTemp
8769 7A32 A3 0E                 lda   titleref+2,s
8770 7A34 85 EC                 sta   <myTemp+2
8771 7A36
8772 7A36 A3 10                 lda   refdescriptor,s
8773 7A38 0A                    asl   a
8774 7A39 AA                    tax   
8775 7A3A 7C 3D 7A              jmp   (table,x)
8776 7A3D
8777 7A3D 5E 7A        table    DC W:pointer
8778 7A3F 52 7A                 DC W:handle
8779 7A41 43 7A                 DC W:resourceID
8780 7A43
8781 7A43 A3 0E        resourceID lda   titleref+2,s           Load the menu item resource and get the handle to it
8782 7A45 AA                    tax   
8783 7A46 A3 0C                 lda   titleref,s
8784 7A48 A0 0A 80              ldy   #rMenuItem
8785 7A4B 20 C4 5B              jsr   LoadnRelease
8786 7A4E 85 EA                 sta   <myTemp                  Store handle back on my direct page
8787 7A50 86 EC                 stx   <myTemp+2
8788 7A52
8789 7A52 A0 02 00     handle   ldy   #2                       Dereference the menu item handle and put ptr back
8790 7A55 B7 EA                 lda   [<myTemp],y              into my direct page
8791 7A57 AA                    tax   
8792 7A58 A7 EA                 lda   [<myTemp]
8793 7A5A 85 EA                 sta   <myTemp
8794 7A5C 86 EC                 stx   <myTemp+2
8795 7A5E
8796 7A5E A0 08 00     pointer  ldy   #resItemFlag             Find out how the item name is being referenced, is it a
8797 7A61 B7 EA                 lda   [<myTemp],y              pointer, handle, or resource ID?
8798 7A63 29 00 C0              and   #FIRST_TWO_BITS
8799 7A66 85 EE                 sta   <newFlag
8800 7A68
8801 7A68 A0 06 00              ldy   #ItemFlag
8802 7A6B B7 24                 lda   [<itemptr],y
8803 7A6D 05 EE                 ora   <newFlag
8804 7A6F 97 24                 sta   [<itemptr],y             Update the item flag in our item record
8805 7A71
8806 7A71 A0 0A 00              ldy   #resItemName             Get new name from item template
8807 7A74 B7 EA                 lda   [<myTemp],y
8808 7A76 A0 08 00              ldy   #itemName
8809 7A79 97 24                 sta   [<itemptr],y
8810 7A7B A0 0C 00              ldy   #resItemName+2
8811 7A7E B7 EA                 lda   [<myTemp],y
8812 7A80 A0 0A 00              ldy   #resItemName
8813 7A83 97 24                 sta   [<itemptr],y
8814 7A85
8815 7A85 20 C4 62     exit     jsr   unlockmenubar
8816 7A88
8817 7A88 82 38 15     exit2    brl   pop8bytes
8818 7A8B
8819 7A8B                       ENDP 
8820 7A8B
8821 7A8B              ;===========================================================================
8822 7A8B              ;
8823 7A8B              ;                   SetMItem
8824 7A8B              ;
8825 7A8B              ;                   Set new item string.
8826 7A8B              ;
8827 7A8B              ;   IN:    PUSH:LONG - pointer to new string.
8828 7A8B              ;          PUSH:WORD - item's ID.
8829 7A8B              ;
8830 7A8B              ;  OUT:    None.
8831 7A8B              ;
8832 7A8B              ;===========================================================================
8833 7A8B              SetMItem PROC 
8834 7A8B
8835 7A8B              itemnum  equ   input
8836 7A8B              strg     equ   itemnum+2
8837 7A8B
8838 7A8B 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8839 7A8E 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8840 7A91 F0 2E                 beq   exit2                    Is there a current menu bar?
8841 7A93
8842 7A93 A3 0A                 lda   itemnum,s
8843 7A95 20 BF 79              jsr   getiptr
8844 7A98 F0 24                 beq   exit                     Error?
8845 7A9A
8846 7A9A 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
8847 7A9D
8848 7A9D A0 06 00              ldy   #ItemFlag                Since the reference to the item name is a ptr to that name
8849 7AA0 B7 24                 lda   [<itemptr],y             we clear the first two bits of the item flag
8850 7AA2 29 FF 3F              and   #CLEAR_TWO_BITS
8851 7AA5 97 24                 sta   [<itemptr],y
8852 7AA7
8853 7AA7 A3 0C                 lda   strg,s                   Pass pointer to string.
8854 7AA9 85 64                 sta   <strg_ptr
8855 7AAB A3 0E                 lda   strg+2,s
8856 7AAD 85 66                 sta   <strg_ptr+2
8857 7AAF
8858 7AAF 20 B4 5C              jsr   parse_strg               Get and set length of string.
8859 7AB2
8860 7AB2 A0 08 00              ldy   #ItemName                Set adjusted pointer to new string.
8861 7AB5 A5 64                 lda   <strg_ptr
8862 7AB7 97 24                 sta   [<itemptr],y
8863 7AB9 A5 65                 lda   <strg_ptr+1
8864 7ABB C8                    iny   
8865 7ABC 97 24                 sta   [<itemptr],y
8866 7ABE
8867 7ABE 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8868 7AC1
8869 7AC1 82 F7 14     exit2    brl   pop6bytes                no error
8870 7AC4
8871 7AC4                       ENDP 
8872 7AC4
8873 7AC4
8874 7AC4              ;===========================================================================
8875 7AC4              ;
8876 7AC4              ;                   GetItem
8877 7AC4              ;
8878 7AC4              ;                   Get item's string.
8879 7AC4              ;
8880 7AC4              ;   IN:  PUSH:WORD - item's ID.
8881 7AC4              ;
8882 7AC4              ;  OUT:  LONG - pointer to item's text.
8883 7AC4              ;
8884 7AC4              ;===========================================================================
8885 7AC4              GetItem  PROC 
8886 7AC4
8887 7AC4              itemnum  equ   input
8888 7AC4              result   equ   itemnum+2
8889 7AC4
8890 7AC4 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8891 7AC7 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8892 7ACA F0 20                 beq   exit2                    Is there a current menu bar?
8893 7ACC
8894 7ACC A3 0A                 lda   itemnum,s                Get item's ID.
8895 7ACE 20 BF 79              jsr   getiptr                  Now get its pointer.
8896 7AD1 D0 09                 bne   foundSomething           Error?
8897 7AD3 20 C4 62              jsr   unlockMenuBar
8898 7AD6 A0 02 0F              ldy   #Item_Not_Found
8899 7AD9 82 D2 14              brl   Epop2bytes
8900 7ADC
8901 7ADC A0 08 00     foundSomething ldy   #ItemName
8902 7ADF B7 24                 lda   [<temptr],y
8903 7AE1 83 0C                 sta   result,s
8904 7AE3 C8                    iny   
8905 7AE4 C8                    iny   
8906 7AE5 B7 24                 lda   [<temptr],y
8907 7AE7 83 0E                 sta   result+2,s
8908 7AE9
8909 7AE9 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
8910 7AEC
8911 7AEC 82 BC 14     exit2    brl   pop2bytes                no error
8912 7AEF
8913 7AEF                       ENDP 
8914 7AEF
8915 7AEF
8916 7AEF              ;===========================================================================
8917 7AEF              ;
8918 7AEF              ;                   SetMItemName2
8919 7AEF              ;
8920 7AEF              ;  IN: PUSH:WORD - refdescriptor, describes what next long will be
8921 7AEF              ;      PUSH:LONG - titleref, pointer, handle, or resource ID of title name
8922 7AEF              ;      PUSH:WORD - menuitem, ID of item that will get new title
8923 7AEF              ;
8924 7AEF              ; OUT: None.
8925 7AEF              ;
8926 7AEF              ;===========================================================================
8927 7AEF              SetMItemName2 PROC 
8928 7AEF
8929 7AEF              itemnum  equ   input
8930 7AEF              titleref equ   itemnum+2                ; ptr, hdl, resource ID of new item name
8931 7AEF              refdescriptor equ   titleref+4
8932 7AEF
8933 7AEF 20 97 8F              jsr   startup
8934 7AF2 20 8B 62              jsr   lockMenuBar
8935 7AF5 F0 39                 beq   exit2
8936 7AF7
8937 7AF7 A3 0A                 lda   itemnum,s                Get item's ID.
8938 7AF9 20 BF 79              jsr   getiptr                  Now get its pointer (in <itemptr).
8939 7AFC F0 2F                 beq   exit                     Error?
8940 7AFE
8941 7AFE 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
8942 7B01
8943 7B01 A0 08 00              ldy   #ItemName                Insert new item name into the item record
8944 7B04 A3 0C                 lda   titleref,s
8945 7B06 97 24                 sta   [<temptr],y
8946 7B08 C8                    iny   
8947 7B09 C8                    iny   
8948 7B0A A3 0E                 lda   titleref+2,s
8949 7B0C 97 24                 sta   [<temptr],y
8950 7B0E
8951 7B0E A3 10                 lda   refdescriptor,s
8952 7B10 0A                    asl   a
8953 7B11 AA                    tax   
8954 7B12
8955 7B12 A0 06 00              ldy   #ItemFlag                Get flag of current item and clear the first two bits
8956 7B15 B7 24                 lda   [<itemptr],y             We need to clear them because later on we're going to
8957 7B17 29 FF 3F              and   #CLEAR_TWO_BITS          'OR' it with the new value
8958 7B1A
8959 7B1A 7C 1D 7B              jmp   (table,x)
8960 7B1D
8961 7B1D 2B 7B        table    DC W:pointer
8962 7B1F 28 7B                 DC W:handle
8963 7B21 23 7B                 DC W:resourceID
8964 7B23
8965 7B23 09 00 80     resourceID ora   #M_RESOURCEID
8966 7B26 80 03                 bra   pointer
8967 7B28
8968 7B28 09 00 40     handle   ora   #M_HANDLE
8969 7B2B
8970 7B2B 97 24        pointer  sta   [<itemptr],y
8971 7B2D
8972 7B2D 20 C4 62     exit     jsr   unlockMenuBar
8973 7B30
8974 7B30 82 90 14     exit2    brl   pop8bytes
8975 7B33
8976 7B33                       ENDP 
8977 7B33
8978 7B33
8979 7B33              ;===========================================================================
8980 7B33              ;
8981 7B33              ;                   SetMItemName
8982 7B33              ;
8983 7B33              ;                   Set item's string.
8984 7B33              ;
8985 7B33              ;   IN:    PUSH:LONG - pointer to pascal string.
8986 7B33              ;          PUSH:WORD - item's ID.
8987 7B33              ;
8988 7B33              ;  OUT:    None.
8989 7B33              ;
8990 7B33              ;===========================================================================
8991 7B33              SetMItemName PROC 
8992 7B33
8993 7B33              itemnum  equ   input
8994 7B33              newName  equ   itemnum+2
8995 7B33
8996 7B33 20 97 8F              jsr   startup                  Do startup initialization for tool call.
8997 7B36 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
8998 7B39 F0 24                 beq   exit2                    Is there a current menu bar?
8999 7B3B
9000 7B3B A3 0A                 lda   itemnum,s                Get item's ID.
9001 7B3D 20 BF 79              jsr   getiptr                  Now get its pointer.
9002 7B40 F0 1A                 beq   exit                     Error?
9003 7B42
9004 7B42 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
9005 7B45
9006 7B45 A0 06 00              ldy   #ItemFlag                Get flag of current item and clear the first two bits
9007 7B48 B7 24                 lda   [<itemptr],y             We need to clear them because later on we're going to
9008 7B4A 29 FF 3F              and   #CLEAR_TWO_BITS          'OR' it with the new value
9009 7B4D 97 24                 sta   [<itemptr],y
9010 7B4F
9011 7B4F A0 08 00              ldy   #ItemName
9012 7B52 A3 0C                 lda   newName,s
9013 7B54 97 24                 sta   [<temptr],y
9014 7B56 C8                    iny   
9015 7B57 C8                    iny   
9016 7B58 A3 0E                 lda   newName+2,s
9017 7B5A 97 24                 sta   [<temptr],y
9018 7B5C
9019 7B5C 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9020 7B5F
9021 7B5F 82 59 14     exit2    brl   pop6bytes                no error
9022 7B62
9023 7B62                       ENDP 
9024 7B62
9025 7B62
9026 7B62              ;===========================================================================
9027 7B62              ;
9028 7B62              ;                   EnableMItem
9029 7B62              ;
9030 7B62              ;                   Enable Item
9031 7B62              ;
9032 7B62              ;   IN:    PUSH:WORD - item ID.
9033 7B62              ;
9034 7B62              ;  OUT:    None.
9035 7B62              ;
9036 7B62              ;===========================================================================
9037 7B62              EnableMItem PROC 
9038 7B62
9039 7B62              itemnum  equ   input
9040 7B62
9041 7B62 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9042 7B65 A9 7F FF              lda   #$FF7F                   Clear disable bit.
9043 7B68
9044 7B68                       ENTRY set_iflag
9045 7B68              set_iflag  
9046 7B68
9047 7B68 48                    pha                            Pass newvalue.
9048 7B69 A3 0C                 lda   itemnum+2,s              Pass item's ID.
9049 7B6B 48                    pha   
9050 7B6C A2 0F 26 22           _SetMItemFlag                  Set the item's flag.
9051 7B73
9052 7B73 82 35 14              brl   pop2bytes                no error
9053 7B76
9054 7B76                       ENDP 
9055 7B76
9056 7B76
9057 7B76              ;===========================================================================
9058 7B76              ;
9059 7B76              ;                   DisableMItem
9060 7B76              ;
9061 7B76              ;   IN:    PUSH:WORD - item ID.
9062 7B76              ;
9063 7B76              ;  OUT:    None.
9064 7B76              ;
9065 7B76              ;===========================================================================
9066 7B76              DisableMItem PROC 
9067 7B76
9068 7B76 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9069 7B79
9070 7B79 A9 80 00              lda   #I_ENABLED               Clear disable bit.
9071 7B7C 80 EA                 bra   set_iflag
9072 7B7E
9073 7B7E                       ENDP 
9074 7B7E
9075 7B7E
9076 7B7E              ;===========================================================================
9077 7B7E              ;
9078 7B7E              ;                   SetMItemStyle
9079 7B7E              ;
9080 7B7E              ;                   Set item's style.
9081 7B7E              ;
9082 7B7E              ;   IN:    PUSH:WORD - new style.
9083 7B7E              ;          PUSH:WORD - item ID.
9084 7B7E              ;
9085 7B7E              ;  OUT:    None.
9086 7B7E              ;
9087 7B7E              ;===========================================================================
9088 7B7E              SetMItemStyle PROC 
9089 7B7E
9090 7B7E              itemnum  equ   input
9091 7B7E              newstyle equ   itemnum+2
9092 7B7E
9093 7B7E 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9094 7B81
9095 7B81              StyleBits equ   I_NoBold+I_NoItalic+I_NoScore+I_NoShadow+I_NoOutline
9096 7B81
9097 7B81 F4 F8 E7              pea   $FFFF-StyleBits          Clear existing style
9098 7B84 A3 0C                 lda   itemnum+2,s              Pass item's ID.
9099 7B86 48                    pha   
9100 7B87 A2 0F 26 22           _SetMItemFlag 
9101 7B8E
9102 7B8E              ; Take the input style word and convert it to the format that is in the itemFlag word
9103 7B8E              ; (bold, italic and underline are in the low 3 bits of low byte. shadow and outline
9104 7B8E              ; are in bits 3 and 4 of the high byte.)
9105 7B8E
9106 7B8E A3 0C                 lda   newstyle,s
9107 7B90 AA                    tax   
9108 7B91 29 07 00              and   #I_Nobold+I_NoItalic+I_NoScore
9109 7B94 48                    pha   
9110 7B95 8A                    txa   
9111 7B96 EB                    xba   
9112 7B97 29 00 18              and   #I_NoShadow+I_NoOutline
9113 7B9A 03 01                 ora   1,s
9114 7B9C 83 01                 sta   1,s
9115 7B9E
9116 7B9E A3 0C                 lda   itemnum+2,s
9117 7BA0 48                    pha                            Pass item's ID.
9118 7BA1 A2 0F 26 22           _SetMItemFlag                  Set the item's flag.
9119 7BA8
9120 7BA8 82 08 14              brl   pop4bytes                no error
9121 7BAB
9122 7BAB                       ENDP 
9123 7BAB
9124 7BAB
9125 7BAB              ;===========================================================================
9126 7BAB              ;
9127 7BAB              ;                   GetItemStyle
9128 7BAB              ;
9129 7BAB              ;   IN:    PUSH:WORD - item ID.
9130 7BAB              ;
9131 7BAB              ;  OUT:    WORD - item's style.
9132 7BAB              ;
9133 7BAB              ;===========================================================================
9134 7BAB              GetItemStyle PROC 
9135 7BAB
9136 7BAB              itemnum  equ   input
9137 7BAB              result   equ   itemnum+2
9138 7BAB
9139 7BAB 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9140 7BAE 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9141 7BB1 F0 1E                 beq   exit2                    Is there a current menu bar?
9142 7BB3
9143 7BB3 A3 0A                 lda   itemnum,s                Get item's ID.
9144 7BB5 20 BF 79              jsr   getiptr                  Now get its pointer.
9145 7BB8 F0 14                 beq   exit                     Error?
9146 7BBA
9147 7BBA A0 06 00              ldy   #ItemFlag
9148 7BBD B7 24                 lda   [<itemptr],y
9149 7BBF
9150 7BBF              ;
9151 7BBF              ; Take the word from the item flag and convert it to the format of a style word.
9152 7BBF              ;
9153 7BBF AA                    tax   
9154 7BC0 29 07 00              and   #I_Nobold+I_NoItalic+I_NoScore
9155 7BC3 83 0C                 sta   result,s
9156 7BC5 8A                    txa   
9157 7BC6 29 00 18              and   #I_NoShadow+I_NoOutline
9158 7BC9 EB                    xba   
9159 7BCA 03 0C                 ora   result,s
9160 7BCC 83 0C                 sta   result,s
9161 7BCE
9162 7BCE 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9163 7BD1
9164 7BD1 82 D7 13     exit2    brl   pop2bytes                no error
9165 7BD4
9166 7BD4                       ENDP 
9167 7BD4
9168 7BD4
9169 7BD4              ;===========================================================================
9170 7BD4              ;
9171 7BD4              ;                   SetMItemFlag
9172 7BD4              ;
9173 7BD4              ;   IN:    PUSH:WORD - new bits for flag.
9174 7BD4              ;          PUSH:WORD - item ID.
9175 7BD4              ;
9176 7BD4              ;  OUT:  None.
9177 7BD4              ;
9178 7BD4              ;===========================================================================
9179 7BD4              SetMItemFlag PROC 
9180 7BD4
9181 7BD4              itemnum  equ   input
9182 7BD4              newvalue equ   itemnum+2
9183 7BD4
9184 7BD4 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9185 7BD7 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9186 7BDA F0 1C                 beq   exit2                    Is there a current menu bar?
9187 7BDC
9188 7BDC A3 0A                 lda   itemnum,s                Get item's ID.
9189 7BDE 20 BF 79              jsr   getiptr                  Now get its pointer.
9190 7BE1 F0 12                 beq   exit                     Error?
9191 7BE3
9192 7BE3 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
9193 7BE6
9194 7BE6 A0 06 00              ldy   #ItemFlag
9195 7BE9 A3 0C                 lda   newvalue,s
9196 7BEB 30 04                 bmi   reset
9197 7BED
9198 7BED 17 24                 ora   [<itemptr],y             Set desired bits.
9199 7BEF 80 02                 bra   store
9200 7BF1
9201 7BF1 37 24        reset    and   [<itemptr],y             Clear desired bits.
9202 7BF3 97 24        store    sta   [<itemptr],y             Store new flag.
9203 7BF5
9204 7BF5 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9205 7BF8
9206 7BF8 82 B8 13     exit2    brl   pop4bytes                no error
9207 7BFB
9208 7BFB                       ENDP 
9209 7BFB
9210 7BFB
9211 7BFB              ;===========================================================================
9212 7BFB              ;
9213 7BFB              ;                   CheckMItem
9214 7BFB              ;
9215 7BFB              ;   IN:    PUSH:WORD - TRUE to check, FALSE to uncheck.
9216 7BFB              ;          PUSH:WORD - item's ID number.
9217 7BFB              ;
9218 7BFB              ;  OUT:    None.
9219 7BFB              ;
9220 7BFB              ;===========================================================================
9221 7BFB              CheckMItem PROC 
9222 7BFB
9223 7BFB              itemnum  equ   input
9224 7BFB              newMark  equ   itemnum+2
9225 7BFB
9226 7BFB 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9227 7BFE 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9228 7C01 F0 2C                 beq   exit2                    Is there a current menu bar?
9229 7C03
9230 7C03 A3 0C                 lda   newMark,s
9231 7C05 F0 0F                 beq   setMark
9232 7C07
9233 7C07 A9 12 00              lda   #$0012                   Check mark.
9234 7C0A 83 0C                 sta   newMark,s
9235 7C0C 80 08                 bra   setMark
9236 7C0E
9237 7C0E
9238 7C0E              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
9239 7C0E              ;          Mark an item.
9240 7C0E              ;
9241 7C0E              ;   IN:    PUSH:WORD - character mark, zero for no mark.
9242 7C0E              ;          PUSH:WORD - item's ID number.
9243 7C0E              ;
9244 7C0E              ;  OUT:    None.
9245 7C0E              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
9246 7C0E                       ENTRY SetMItemMark
9247 7C0E              SetMItemMark  
9248 7C0E
9249 7C0E 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9250 7C11 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9251 7C14 F0 19                 beq   exit2                    Is there a current menu bar?
9252 7C16
9253 7C16 A3 0A        setMark  lda   itemnum,s                Get item's ID.
9254 7C18 20 BF 79              jsr   getiptr                  Now get its pointer.
9255 7C1B F0 0F                 beq   exit                     Error?
9256 7C1D
9257 7C1D 20 92 80              jsr   badCache                 Set cache to bad if menu has a cache.
9258 7C20
9259 7C20 A0 04 00              ldy   #ItemCheck
9260 7C23 B7 24                 lda   [<itemptr],y
9261 7C25 29 00 FF              and   #$FF00                   Clear current mark.
9262 7C28 03 0C                 ora   newMark,s                Install new mark.
9263 7C2A 97 24                 sta   [<itemptr],y
9264 7C2C
9265 7C2C 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9266 7C2F
9267 7C2F 82 81 13     exit2    brl   pop4bytes                no error
9268 7C32
9269 7C32                       ENDP 
9270 7C32
9271 7C32
9272 7C32              ;===========================================================================
9273 7C32              ;
9274 7C32              ;                   GetItemMark
9275 7C32              ;
9276 7C32              ;                   Get an item's mark.
9277 7C32              ;
9278 7C32              ;   IN:    PUSH:WORD - item's ID number.
9279 7C32              ;
9280 7C32              ;  OUT:    WORD - item's mark, zero = no mark.
9281 7C32              ;
9282 7C32              ;===========================================================================
9283 7C32              GetItemMark PROC 
9284 7C32
9285 7C32              itemnum  equ   input
9286 7C32              result   equ   itemnum+2
9287 7C32
9288 7C32 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9289 7C35 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9290 7C38 F0 14                 beq   exit2                    Is there a current menu bar?
9291 7C3A
9292 7C3A A3 0A                 lda   itemnum,s                Get item's ID.
9293 7C3C 20 BF 79              jsr   getiptr                  Now get its pointer.
9294 7C3F F0 0A                 beq   exit                     Error?
9295 7C41
9296 7C41 A0 04 00              ldy   #ItemCheck
9297 7C44 B7 24                 lda   [<itemptr],y
9298 7C46 29 FF 00              and   #$00FF                   Get item's mark.
9299 7C49 83 0C                 sta   result,s                 Return mark to caller.
9300 7C4B
9301 7C4B 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9302 7C4E
9303 7C4E 82 5A 13     exit2    brl   pop2bytes                no error
9304 7C51
9305 7C51                       ENDP 
9306 7C51
9307 7C51
9308 7C51              ;===========================================================================
9309 7C51              ;
9310 7C51              ;                   GetItemFlag
9311 7C51              ;
9312 7C51              ;                   Return item's ItemFlag.
9313 7C51              ;
9314 7C51              ;   IN:  PUSH:WORD - item ID.
9315 7C51              ;
9316 7C51              ;  OUT:  WORD - Item's ItemFlag.
9317 7C51              ;
9318 7C51              ;===========================================================================
9319 7C51              GetItemFlag PROC 
9320 7C51
9321 7C51              itemnum  equ   input
9322 7C51              result   equ   itemnum+2
9323 7C51
9324 7C51 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9325 7C54 20 8B 62              jsr   lockMenuBar              <barPtr = (<barHand), bar & menus locked.
9326 7C57 F0 11                 beq   exit2                    Is there a current menu bar?
9327 7C59
9328 7C59 A3 0A                 lda   itemnum,s                Get item's ID.
9329 7C5B 20 BF 79              jsr   getiptr                  Now get its pointer.
9330 7C5E F0 07                 beq   exit                     Error?
9331 7C60
9332 7C60 A0 06 00              ldy   #ItemFlag
9333 7C63 B7 24                 lda   [<itemptr],y             Get current flag,
9334 7C65 83 0C                 sta   result,s                 return it to caller.
9335 7C67
9336 7C67 20 C4 62     exit     jsr   unlockMenuBar            Leave menu bar & menus unlocked.
9337 7C6A
9338 7C6A 82 3E 13     exit2    brl   pop2bytes                no error
9339 7C6D
9340 7C6D                       ENDP 
9341 7C6D
9342 7C6D
9343 7C6D              ;===========================================================================
9344 7C6D              ;
9345 7C6D              ;                   SetItemBlink
9346 7C6D              ;
9347 7C6D              ;   IN:  PUSH:WORD - number of times items should blink when selected.
9348 7C6D              ;
9349 7C6D              ;  OUT:  None.
9350 7C6D              ;
9351 7C6D              ;===========================================================================
9352 7C6D              SetItemBlink PROC 
9353 7C6D
9354 7C6D              new_blink equ   input
9355 7C6D
9356 7C6D 20 97 8F              jsr   startup                  Do startup initialization for tool call.
9357 7C70
9358 7C70 A3 0A                 lda   new_blink,s
9359 7C72 85 38                 sta   <blink
9360 7C74
9361 7C74 82 34 13              brl   pop2bytes                no error
9362 7C77
9363 7C77                       ENDP 
9364 7C77
9365 7C77
9366 7C77              ;===========================================================================
9367 7C77              ;
9368 7C77              ;                   PushDefBarRect
9369 7C77              ;
9370 7C77              ;                   Push address of a RAM data area value.
9371 7C77              ;
9372 7C77              ;===========================================================================
9373 7C77              pushdefBarRect PROC 
9374 7C77 A9 4B 00              lda   #defMenu+CtlRect
9375 7C7A 80 1C                 bra   pushData
9376 7C7C
9377 7C7C                       ENTRY pushmark
9378 7C7C A9 00 00     pushmark lda   #mark
9379 7C7F 80 17                 bra   pushData
9380 7C81
9381 7C81                       ENTRY pushcom_key
9382 7C81 A9 03 00     pushcom_key lda   #com_key
9383 7C84 80 12                 bra   pushData
9384 7C86
9385 7C86                       ENTRY pushimage
9386 7C86 A9 9B 01     pushimage lda   #image
9387 7C89 80 0D                 bra   pushData
9388 7C8B
9389 7C8B                       ENTRY pushColorTable
9390 7C8B A9 7B 01     pushColorTable lda   #ColorTable
9391 7C8E 80 08                 bra   pushData
9392 7C90
9393 7C90                       ENTRY pushDefMenu
9394 7C90 A9 43 00     pushDefMenu lda   #defMenu
9395 7C93 80 03                 bra   pushData
9396 7C95
9397 7C95                       ENTRY pushport
9398 7C95 A9 75 00     pushport lda   #port
9399 7C98
9400 7C98
9401 7C98              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
9402 7C98              ;          Push pointer to data area variable.
9403 7C98              ;
9404 7C98              ;   IN:    a = offset into data area.
9405 7C98              ;          <data = pointer to data area.
9406 7C98              ;
9407 7C98              ;  OUT:    <data+a on stack.
9408 7C98              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
9409 7C98                       ENTRY pushData
9410 7C98 FA           pushData plx   
9411 7C99
9412 7C99 A4 02                 ldy   <data+2
9413 7C9B 18                    clc   
9414 7C9C 65 00                 adc   <data
9415 7C9E 90 01                 bcc   store100
9416 7CA0 C8                    iny   
9417 7CA1 5A           store100 phy   
9418 7CA2 48                    pha   
9419 7CA3
9420 7CA3 DA                    phx   
9421 7CA4
9422 7CA4 60                    rts   
9423 7CA5
9424 7CA5                       ENDP 
9425 7CA5
9426 7CA5
9427 7CA5              ;===========================================================================
9428 7CA5              ;
9429 7CA5              ;                   CloseMenuPort
9430 7CA5              ;
9431 7CA5              ;                   Close Menu Manager's port.
9432 7CA5              ;
9433 7CA5              ;===========================================================================
9434 7CA5              closeMenuPort PROC 
9435 7CA5
9436 7CA5 20 95 7C              jsr   pushport                 Pass pointer to Menu Manager port.
9437 7CA8 A2 04 1A 22           _ClosePort 
9438 7CAF
9439 7CAF 60                    rts   
9440 7CB0
9441 7CB0                       ENDP 
9442 7CB0
9443 7CB0
9444 7CB0              ;===========================================================================
9445 7CB0              ;
9446 7CB0              ;                   PushColor2
9447 7CB0              ;
9448 7CB0              ;                   Get a solid color pattern
9449 7CB0              ;
9450 7CB0              ;  IN:   a = zero to use norcolor, not zero to use hiliteclr.
9451 7CB0              ;
9452 7CB0              ; OUT:   pointer to pattern on stack.
9453 7CB0              ;
9454 7CB0              ;===========================================================================
9455 7CB0              pushcolor2 PROC 
9456 7CB0
9457 7CB0 A4 30                 ldy   <norcolor
9458 7CB2 AA                    tax   
9459 7CB3 F0 02                 beq   ok
9460 7CB5 A4 32                 ldy   <hiliteclr
9461 7CB7 98           ok       tya   
9462 7CB8
9463 7CB8                       ENTRY pushcolor
9464 7CB8              pushcolor  
9465 7CB8
9466 7CB8              ;  IN:   a = bits 7-4 equal color index.
9467 7CB8              ;
9468 7CB8 7A                    ply                            Grab return address.
9469 7CB9
9470 7CB9 F4 FD 00              pea   color_patt>>16
9471 7CBC 29 F0 00              and   #$00F0
9472 7CBF 0A                    asl   a
9473 7CC0 69 C2 82              adc   #color_patt
9474 7CC3
9475 7CC3 48                    pha   
9476 7CC4 5A                    phy   
9477 7CC5
9478 7CC5 60                    rts   
9479 7CC6
9480 7CC6                       ENDP 
9481 7CC6
9482 7CC6
9483 7CC6              ;===========================================================================
9484 7CC6              ;
9485 7CC6              ;                   Get_Apple
9486 7CC6              ;
9487 7CC6              ;                   Smear a mono bit image into color.
9488 7CC6              ;
9489 7CC6              ;  IN:   a = background color in bits 4-7.
9490 7CC6              ;
9491 7CC6              ; OUT:   x = high word address of pattern.
9492 7CC6              ;        y = low word address of pattern.
9493 7CC6              ;
9494 7CC6              ;===========================================================================
9495 7CC6              get_apple PROC 
9496 7CC6
9497 7CC6              imagePtr equ   work                     Pointer to image buffer.
9498 7CC6              background equ   imagePtr+4             Background color.
9499 7CC6              apple_mask equ   background+2           Pointer to image mask.
9500 7CC6              apple_data equ   apple_mask+2           Pointer to image data.
9501 7CC6
9502 7CC6              ; --- Initialize for 320 mode -----------------
9503 7CC6              ;
9504 7CC6 29 F0 00              and   #$00F0
9505 7CC9 0A                    asl   a
9506 7CCA A8                    tay   
9507 7CCB B9 C2 82              lda   color_patt,y
9508 7CCE 85 EE                 sta   <background
9509 7CD0
9510 7CD0 20 86 7C              jsr   pushimage                Get address of 'image'.
9511 7CD3 68                    pla   
9512 7CD4 85 EA                 sta   <imagePtr
9513 7CD6 68                    pla   
9514 7CD7 85 EC                 sta   <imagePtr+2
9515 7CD9
9516 7CD9 A9 6E 81              lda   #_320_mask
9517 7CDC 85 F0                 sta   <apple_mask
9518 7CDE A9 AE 81              lda   #_320_data
9519 7CE1 85 F2                 sta   <apple_data
9520 7CE3
9521 7CE3 A0 3E 00              ldy   #62
9522 7CE6
9523 7CE6 A5 9C                 lda   <scInfo1                 What mode are we in?
9524 7CE8 29 80 00              and   #$0080
9525 7CEB F0 0D                 beq   lop1
9526 7CED
9527 7CED              ; --- Initialize for 640 mode ----------------
9528 7CED              ;
9529 7CED A9 EE 81              lda   #_640_mask
9530 7CF0 85 F0                 sta   <apple_mask
9531 7CF2 A9 0E 82              lda   #_640_data
9532 7CF5 85 F2                 sta   <apple_data
9533 7CF7
9534 7CF7              ; --- Fill background around apple and put into image buffer ------------
9535 7CF7              ;
9536 7CF7 A0 1E 00              ldy   #30
9537 7CFA A5 EE        lop1     lda   <background
9538 7CFC 31 F0                 and   (<apple_mask),y
9539 7CFE 11 F2                 ora   (<apple_data),y
9540 7D00 97 EA                 sta   [<imagePtr],y            Store into 'image' buffer.
9541 7D02 88                    dey   
9542 7D03 88                    dey   
9543 7D04 10 F4                 bpl   lop1
9544 7D06
9545 7D06 60                    rts   
9546 7D07
9547 7D07                       ENDP 
9548 7D07
9549 7D07
9550 7D07              ;===========================================================================
9551 7D07              ;
9552 7D07              ;                   DrawRect
9553 7D07              ;
9554 7D07              ;                   Draw a solid rectangle with border.
9555 7D07              ;
9556 7D07              ;  IN:     x/a = address of RECT.
9557 7D07              ;          y = pattern/color.
9558 7D07              ;
9559 7D07              ;===========================================================================
9560 7D07              drawrect PROC 
9561 7D07
9562 7D07 DA                    phx                            For frame call.
9563 7D08 48                    pha   
9564 7D09
9565 7D09 DA                    phx                            For fill call.
9566 7D0A 48                    pha   
9567 7D0B
9568 7D0B 98                    tya   
9569 7D0C 20 B8 7C              jsr   pushcolor                Push pointer to color pattern.
9570 7D0F A2 04 57 22           _FillRect                      Address of RECT already on stack.
9571 7D16
9572 7D16 A2 04 53 22           _FrameRect                     Address of RECT already on stack.
9573 7D1D
9574 7D1D 60                    rts   
9575 7D1E
9576 7D1E                       ENDP 
9577 7D1E
9578 7D1E
9579 7D1E              ;===========================================================================
9580 7D1E              ;
9581 7D1E              ;                   PrintStrg
9582 7D1E              ;
9583 7D1E              ;   IN:    strg_ptr = string to print.
9584 7D1E              ;          x = x poistion.
9585 7D1E              ;          y = y position.
9586 7D1E              ;
9587 7D1E              ;===========================================================================
9588 7D1E              printstrg PROC 
9589 7D1E
9590 7D1E DA                    phx                            Starting x position.
9591 7D1F 5A                    phy                            Starting y position.
9592 7D20 A2 04 3A 22           _MoveTo                        Set pen's starting position.
9593 7D27
9594 7D27 D4 66                 pei   <strg_ptr+2              Pass pointer to string.
9595 7D29 D4 64                 pei   <strg_ptr
9596 7D2B A2 04 A5 22           _DrawString 
9597 7D32
9598 7D32 60                    rts   
9599 7D33
9600 7D33                       ENDP 
9601 7D33
9602 7D33
9603 7D33              ;            APPEND	MCACHE.ASM
9604 7D33              ;
9605 7D33              ;===========================================================================
9606 7D33              ;
9607 7D33              ;                   Cache
9608 7D33              ;
9609 7D33              ;                   Fill cache.
9610 7D33              ;
9611 7D33              ;   IN:    menurect = RECT to cache.
9612 7D33              ;          sav_buff = handle of cache.
9613 7D33              ;
9614 7D33              ;  OUT:    a = TRUE if menu image moved from cache to screen.
9615 7D33              ;          a = FALSE if only screen saved, menu will have to be drawn.
9616 7D33              ;
9617 7D33              ;===========================================================================
9618 7D33              cache    PROC 
9619 7D33
9620 7D33              ssave    equ   work                     0
9621 7D33              lmask    equ   ssave+4                  4
9622 7D33              rmask    equ   lmask+2                  6
9623 7D33              lsmask   equ   rmask+2                  8
9624 7D33              rsmask   equ   lsmask+2                 10
9625 7D33              lineAddr equ   rsmask+2                 12
9626 7D33              cWidth   equ   lineAddr+2               14
9627 7D33              cHeight  equ   cWidth+2                 16
9628 7D33              cacheBuff equ   cHeight+2               18
9629 7D33              ;                                       22
9630 7D33              ;
9631 7D33              ; --- Allocate temp direct page ----------------------------------
9632 7D33              ;
9633 7D33
9634 7D33              temp1    equ   temptr
9635 7D33              temp2    equ   temp1+2
9636 7D33              tempY2   equ   $4C
9637 7D33
9638 7D33 A5 48                 lda   <menurect+y1             Just in case menu extends beyond the top of the screen
9639 7D35 85 28                 sta   <temp1                   (a pop-up menu just might do this).
9640 7D37 10 02                 bpl   @1
9641 7D39
9642 7D39 64 28                 stz   <temp1
9643 7D3B              @1        
9644 7D3B A5 4A                 lda   <menurect+x1
9645 7D3D 85 2A                 sta   <temp2
9646 7D3F 10 02                 bpl   @2
9647 7D41
9648 7D41 64 2A                 stz   <temp2
9649 7D43              @2        
9650 7D43 A2 04 90 22           _HideCursor 
9651 7D4A
9652 7D4A A0 02 00              ldy   #2                       Dereference cache handle.
9653 7D4D B7 42                 lda   [<sav_buff],y
9654 7D4F 85 FE                 sta   <cacheBuff+2
9655 7D51 A7 42                 lda   [<sav_buff]
9656 7D53 85 FC                 sta   <cacheBuff
9657 7D55
9658 7D55              ; --- Compute move parameters ---------------------------------------
9659 7D55              ;
9660 7D55 A5 46                 lda   <screenmode
9661 7D57 D0 1E                 bne   mode640
9662 7D59
9663 7D59              ; ------ 320 mode parameters ---------------------
9664 7D59              ;
9665 7D59 A5 2A                 lda   <temp2
9666 7D5B 29 FC FF              and   #$FFFC
9667 7D5E 85 F8                 sta   <cWidth
9668 7D60
9669 7D60 A5 4E                 lda   <menurect+x2
9670 7D62 AA                    tax   
9671 7D63 29 03 00              and   #$0003
9672 7D66 F0 09                 beq   ok10
9673 7D68 8A                    txa   
9674 7D69 29 FC FF              and   #$FFFC
9675 7D6C 18                    clc   
9676 7D6D 69 04 00              adc   #$0004
9677 7D70 AA                    tax   
9678 7D71 8A           ok10     txa   
9679 7D72 38                    sec   
9680 7D73 E5 F8                 sbc   <cWidth
9681 7D75 80 1D                 bra   enter1
9682 7D77              ;
9683 7D77              ; ------ 640 mode parameters ---------------------
9684 7D77              ;
9685 7D77 A5 2A        mode640  lda   <temp2
9686 7D79 29 F8 FF              and   #$FFF8
9687 7D7C 85 F8                 sta   <cWidth
9688 7D7E
9689 7D7E A5 4E                 lda   <menurect+x2
9690 7D80 AA                    tax   
9691 7D81 29 07 00              and   #$0007
9692 7D84 F0 09                 beq   ok11
9693 7D86 8A                    txa   
9694 7D87 29 F8 FF              and   #$FFF8
9695 7D8A 18                    clc   
9696 7D8B 69 08 00              adc   #$0008
9697 7D8E AA                    tax   
9698 7D8F
9699 7D8F 8A           ok11     txa   
9700 7D90 38                    sec   
9701 7D91 E5 F8                 sbc   <cWidth
9702 7D93 4A                    lsr   a
9703 7D94
9704 7D94 4A           enter1   lsr   a                        Get's number of bytes wide,
9705 7D95 3A                    dec   a                        make it zero relative.
9706 7D96 3A                    dec   a
9707 7D97 85 F8                 sta   <cWidth                  Number of bytes wide.
9708 7D99
9709 7D99 A0 04 00              ldy   #cacheWidth
9710 7D9C 97 FC                 sta   [<cacheBuff],y           Remember number of word wide.
9711 7D9E
9712 7D9E A5 4C                 lda   <tempY2                  Get bottom of menu
9713 7DA0 38                    sec   
9714 7DA1 E5 28                 sbc   <temp1
9715 7DA3 85 FA                 sta   <cHeight                 Number of lines high.
9716 7DA5
9717 7DA5 A0 06 00              ldy   #cacheHeight
9718 7DA8 97 FC                 sta   [<cacheBuff],y           Remember number of lines.
9719 7DAA
9720 7DAA A5 2A                 lda   <temp2
9721 7DAC 29 FC FF              and   #$FFFC                   320 mode.
9722 7DAF A6 46                 ldx   <screenmode
9723 7DB1 F0 04                 beq   ok1
9724 7DB3 29 F8 FF              and   #$FFF8                   640 mode.
9725 7DB6 4A                    lsr   a
9726 7DB7
9727 7DB7 4A           ok1      lsr   a
9728 7DB8 AA                    tax                            Word on line to start with.
9729 7DB9
9730 7DB9 A5 28                 lda   <temp1                   Compute starting screen address.
9731 7DBB 0A                    asl   a
9732 7DBC A8                    tay   
9733 7DBD 8A                    txa   
9734 7DBE 18                    clc   
9735 7DBF 77 CC                 adc   [<lineTable],y
9736 7DC1 85 F6                 sta   <lineAddr
9737 7DC3 A0 02 00              ldy   #cachey1x1
9738 7DC6 97 FC                 sta   [<cacheBuff],y           Remember starting line address.
9739 7DC8
9740 7DC8              ; --- Perform move or exchange -----------------------------------------
9741 7DC8              ;
9742 7DC8 8B                    phb                            Save caller's data bank pointer.
9743 7DC9 A0 79 00              ldy   #port+4                  Switch to menu manager's pixel map bank.
9744 7DCC B7 00                 lda   [<data],y
9745 7DCE EB                    xba   
9746 7DCF 48                    pha   
9747 7DD0 AB                    plb   
9748 7DD1 AB                    plb   
9749 7DD2
9750 7DD2 A7 FC                 lda   [<cacheBuff]             Is the menu image already cached?
9751 7DD4 D0 24                 bne   both
9752 7DD6
9753 7DD6              ;----------------------------------------------------
9754 7DD6              ;          Save screen to cache.
9755 7DD6              ;----------------------------------------------------
9756 7DD6              ;
9757 7DD6 A0 08 00              ldy   #cacheCache              Starting pointer in cache for data.
9758 7DD9
9759 7DD9 A6 F8        lop2     ldx   <cWidth                  Initialize bytes per line counter.
9760 7DDB 5A           lop1     phy   
9761 7DDC 9B                    txy   
9762 7DDD B1 F6                 lda   (<lineAddr),y            Fetch from screen,
9763 7DDF 7A                    ply   
9764 7DE0 97 FC                 sta   [<cacheBuff],y           store in cache.
9765 7DE2 C8                    iny   
9766 7DE3 C8                    iny   
9767 7DE4 CA                    dex   
9768 7DE5 CA                    dex   
9769 7DE6 10 F3                 bpl   lop1
9770 7DE8
9771 7DE8 A5 F6                 lda   <lineAddr
9772 7DEA 18                    clc   
9773 7DEB 69 A0 00              adc   #160
9774 7DEE 85 F6                 sta   <lineAddr
9775 7DF0
9776 7DF0 C6 FA                 dec   <cHeight
9777 7DF2 D0 E5                 bne   lop2
9778 7DF4
9779 7DF4 A0 00 00              ldy   #0                       Menu not drawn from cache flag.
9780 7DF7 82 A1 01              brl   exit
9781 7DFA
9782 7DFA              ;---------------------------------------------
9783 7DFA              ;          Move cache to screen while
9784 7DFA              ;          saving screen to cache.
9785 7DFA              ;---------------------------------------------
9786 7DFA              both      
9787 7DFA
9788 7DFA              save4    equ   1                        Stack offsets.
9789 7DFA              Save3_5  equ   3                        ; damn that Dan O.
9790 7DFA              save3    equ   5
9791 7DFA              save2    equ   7
9792 7DFA              save1    equ   9
9793 7DFA              ;
9794 7DFA              ;
9795 7DFA              ; --- Save tid-bits ------------------------------------
9796 7DFA              ;
9797 7DFA A5 4E                 lda   <menurect+x2
9798 7DFC 38                    sec   
9799 7DFD E9 02 00              sbc   #2
9800 7E00 A6 46                 ldx   <screenmode
9801 7E02 F0 03                 beq   ok4
9802 7E04 E9 02 00              sbc   #2
9803 7E07
9804 7E07 4A           ok4      lsr   a
9805 7E08 9B                    txy   
9806 7E09 F0 01                 beq   ok5
9807 7E0B 4A                    lsr   a
9808 7E0C
9809 7E0C AA           ok5      tax   
9810 7E0D A5 28                 lda   <temp1                   Compute starting screen address.
9811 7E0F 0A                    asl   a
9812 7E10 A8                    tay   
9813 7E11 8A                    txa   
9814 7E12 18                    clc   
9815 7E13 77 CC                 adc   [<lineTable],y
9816 7E15 A8                    tay   
9817 7E16 B9 00 00              lda   |0,y
9818 7E19 48                    pha                            save1
9819 7E1A B9 A0 00              lda   |160,y
9820 7E1D 48                    pha                            save2
9821 7E1E B9 40 01              lda   |320,y
9822 7E21 48                    pha                            save3
9823 7E22 B9 E0 01              lda   |480,y
9824 7E25 48                    pha                            save3_5
9825 7E26
9826 7E26 A5 2A                 lda   <temp2
9827 7E28 4A                    lsr   a
9828 7E29 A6 46                 ldx   <screenmode
9829 7E2B F0 01                 beq   ok6
9830 7E2D 4A                    lsr   a
9831 7E2E
9832 7E2E AA           ok6      tax   
9833 7E2F A5 4C                 lda   <tempY2                  Compute starting screen address.
9834 7E31 3A                    dec   a
9835 7E32 0A                    asl   a
9836 7E33 A8                    tay   
9837 7E34 8A                    txa   
9838 7E35 18                    clc   
9839 7E36 77 CC                 adc   [<lineTable],y
9840 7E38 A8                    tay   
9841 7E39 B9 00 00              lda   |0,y
9842 7E3C 48                    pha                            save4
9843 7E3D
9844 7E3D              ; --- Compute masks for blit -----------------------------
9845 7E3D              ;
9846 7E3D A5 2A                 lda   <temp2
9847 7E3F 29 07 00              and   #$0007
9848 7E42 A4 46                 ldy   <screenmode              ; changed to fix a dropshadow bug
9849 7E44 D0 04                 bne   ok2
9850 7E46 29 03 00              and   #$0003
9851 7E49 0A                    asl   a
9852 7E4A 0A           ok2      asl   a
9853 7E4B AA                    tax   
9854 7E4C BF A6 7F FD           lda   >lmasks,x
9855 7E50 85 EE                 sta   <lmask
9856 7E52 49 FF FF              eor   #$FFFF
9857 7E55 85 F2                 sta   <lsmask
9858 7E57
9859 7E57 A5 4E                 lda   <menurect+x2
9860 7E59 3A                    dec   a
9861 7E5A 29 07 00              and   #$0007
9862 7E5D BB                    tyx                            ; changed to fix a dropshadow bug. Mensch
9863 7E5E D0 05                 bne   ok3
9864 7E60 29 03 00              and   #$0003
9865 7E63 0A                    asl   a
9866 7E64 1A                    inc   a                        ; fix purple haze problem
9867 7E65 0A           ok3      asl   a
9868 7E66 AA                    tax   
9869 7E67 BF B6 7F FD           lda   >rmasks,x
9870 7E6B 85 F0                 sta   <rmask
9871 7E6D 49 FF FF              eor   #$FFFF
9872 7E70 85 F4                 sta   <rsmask
9873 7E72
9874 7E72              ; --- Perform blit -------------------------------------------
9875 7E72              ;
9876 7E72 A0 08 00              ldy   #cacheCache              Starting pointer in cache for data.
9877 7E75
9878 7E75 A6 F8        lop4     ldx   <cWidth                  Initialize bytes per line counter.
9879 7E77
9880 7E77 B7 FC                 lda   [<cacheBuff],y           Fetch menu from cache and save.
9881 7E79 25 F0                 and   <rmask
9882 7E7B 85 EA                 sta   <ssave
9883 7E7D
9884 7E7D 5A                    phy   
9885 7E7E 9B                    txy   
9886 7E7F B1 F6                 lda   (<lineAddr),y            Fetch from screen,
9887 7E81 85 EC                 sta   <ssave+2                 save.
9888 7E83
9889 7E83 25 F4                 and   <rsmask                  Put menu on screen.
9890 7E85 05 EA                 ora   <ssave
9891 7E87 91 F6                 sta   (<lineAddr),y
9892 7E89
9893 7E89 A5 EC                 lda   <ssave+2                 Save screen in cache.
9894 7E8B 7A                    ply   
9895 7E8C 97 FC                 sta   [<cacheBuff],y
9896 7E8E
9897 7E8E C8                    iny   
9898 7E8F C8                    iny   
9899 7E90 CA                    dex   
9900 7E91 CA                    dex   
9901 7E92
9902 7E92 B7 FC        lop3     lda   [<cacheBuff],y           Fetch menu from cache and save.
9903 7E94 85 EA                 sta   <ssave
9904 7E96
9905 7E96 5A                    phy   
9906 7E97 9B                    txy   
9907 7E98 B1 F6                 lda   (<lineAddr),y            Fetch from screen,
9908 7E9A 85 EC                 sta   <ssave+2                 save.
9909 7E9C A5 EA                 lda   <ssave                   Put menu on screen.
9910 7E9E 91 F6                 sta   (<lineAddr),y
9911 7EA0 A5 EC                 lda   <ssave+2                 Save screen in cache.
9912 7EA2 7A                    ply   
9913 7EA3 97 FC                 sta   [<cacheBuff],y
9914 7EA5
9915 7EA5 C8                    iny   
9916 7EA6 C8                    iny   
9917 7EA7 CA                    dex   
9918 7EA8 CA                    dex   
9919 7EA9 D0 E7                 bne   lop3
9920 7EAB
9921 7EAB B7 FC                 lda   [<cacheBuff],y           Fetch menu from cache and save.
9922 7EAD 25 EE                 and   <lmask
9923 7EAF 85 EA                 sta   <ssave
9924 7EB1
9925 7EB1 5A                    phy   
9926 7EB2 9B                    txy   
9927 7EB3 B1 F6                 lda   (<lineAddr),y            Fetch from screen,
9928 7EB5 85 EC                 sta   <ssave+2                 save.
9929 7EB7
9930 7EB7 25 F2                 and   <lsmask                  Put menu on screen.
9931 7EB9 05 EA                 ora   <ssave
9932 7EBB 91 F6                 sta   (<lineAddr),y
9933 7EBD
9934 7EBD A5 EC                 lda   <ssave+2                 Save screen in cache.
9935 7EBF 7A                    ply   
9936 7EC0 97 FC                 sta   [<cacheBuff],y
9937 7EC2
9938 7EC2 C8                    iny   
9939 7EC3 C8                    iny   
9940 7EC4
9941 7EC4 A5 F6                 lda   <lineAddr
9942 7EC6 18                    clc   
9943 7EC7 69 A0 00              adc   #160
9944 7ECA 85 F6                 sta   <lineAddr
9945 7ECC
9946 7ECC C6 FA                 dec   <cHeight
9947 7ECE D0 A5                 bne   lop4
9948 7ED0
9949 7ED0              ; ------ Restore tid-bits ------------------------------------
9950 7ED0              ;
9951 7ED0              ; ------ Lower left corner --------------------------------
9952 7ED0              ;
9953 7ED0 A5 2A                 lda   <temp2
9954 7ED2 85 EC                 sta   <ssave+2
9955 7ED4 4A                    lsr   a
9956 7ED5 A6 46                 ldx   <screenmode
9957 7ED7 F0 01                 beq   ok9
9958 7ED9 4A                    lsr   a
9959 7EDA AA           ok9      tax   
9960 7EDB A5 4C                 lda   <tempY2                  Compute starting screen address.
9961 7EDD 3A                    dec   a
9962 7EDE 0A                    asl   a
9963 7EDF A8                    tay   
9964 7EE0 8A                    txa   
9965 7EE1 18                    clc   
9966 7EE2 77 CC                 adc   [<lineTable],y
9967 7EE4 85 EA                 sta   <ssave
9968 7EE6
9969 7EE6 A5 EC                 lda   <ssave+2
9970 7EE8 A6 46                 ldx   <screenmode
9971 7EEA D0 0D                 bne   Amode_640
9972 7EEC
9973 7EEC A2 02 00              ldx   #2
9974 7EEF 29 01 00              and   #1
9975 7EF2 F0 0A                 beq   store1
9976 7EF4 A2 06 00              ldx   #6
9977 7EF7 80 05                 bra   store1
9978 7EF9
9979 7EF9 29 03 00     Amode_640 and   #3
9980 7EFC 0A                    asl   a
9981 7EFD AA                    tax                            Index to mask.
9982 7EFE BF BE 7F FD  store1   lda   >rmasks+8,x
9983 7F02 85 F0                 sta   <rmask
9984 7F04 49 FF FF              eor   #$FFFF
9985 7F07 85 F4                 sta   <rsmask
9986 7F09
9987 7F09 A3 01                 lda   save4,s
9988 7F0B 25 F0                 and   <rmask
9989 7F0D 83 01                 sta   save4,s
9990 7F0F
9991 7F0F A4 EA                 ldy   <ssave
9992 7F11 B9 00 00              lda   |0,y
9993 7F14 25 F4                 and   <rsmask
9994 7F16 03 01                 ora   save4,s
9995 7F18 99 00 00              sta   |0,y
9996 7F1B
9997 7F1B A5 4E                 lda   <menurect+x2
9998 7F1D 38                    sec   
9999 7F1E E9 02 00              sbc   #2
0000 7F21 A6 46                 ldx   <screenmode
0001 7F23 F0 03                 beq   ok7
0002 7F25 E9 02 00              sbc   #2
0003 7F28 85 EC        ok7      sta   <ssave+2
0004 7F2A 4A                    lsr   a
0005 7F2B 9B                    txy   
0006 7F2C F0 01                 beq   ok8
0007 7F2E 4A                    lsr   a
0008 7F2F AA           ok8      tax   
0009 7F30 A5 28                 lda   <temp1                   Compute starting screen address.
0010 7F32 0A                    asl   a
0011 7F33 A8                    tay   
0012 7F34 8A                    txa   
0013 7F35 18                    clc   
0014 7F36 77 CC                 adc   [<lineTable],y
0015 7F38 85 EA                 sta   <ssave
0016 7F3A
0017 7F3A A5 EC                 lda   <ssave+2
0018 7F3C A6 46                 ldx   <screenmode
0019 7F3E D0 04                 bne   mode_640
0020 7F40
0021 7F40 29 01 00              and   #1
0022 7F43 0A                    asl   a
0023 7F44
0024 7F44 29 03 00     mode_640 and   #3
0025 7F47 0A                    asl   a
0026 7F48 AA                    tax                            Index to mask.
0027 7F49 BF A6 7F FD           lda   >lmasks,x
0028 7F4D 85 F0                 sta   <rmask
0029 7F4F 49 FF FF              eor   #$FFFF
0030 7F52 85 F4                 sta   <rsmask
0031 7F54
0032 7F54 A3 09                 lda   save1,s
0033 7F56 25 F0                 and   <rmask
0034 7F58 83 09                 sta   save1,s
0035 7F5A
0036 7F5A A3 07                 lda   save2,s
0037 7F5C 25 F0                 and   <rmask
0038 7F5E 83 07                 sta   save2,s
0039 7F60
0040 7F60 A3 05                 lda   save3,s
0041 7F62 25 F0                 and   <rmask
0042 7F64 83 05                 sta   save3,s
0043 7F66
0044 7F66 A3 03                 lda   save3_5,s
0045 7F68 25 F0                 and   <rMask
0046 7F6A 83 03                 sta   save3_5,s
0047 7F6C
0048 7F6C A4 EA                 ldy   <ssave
0049 7F6E B9 00 00              lda   |0,y
0050 7F71 25 F4                 and   <rsmask
0051 7F73 03 09                 ora   save1,s
0052 7F75 99 00 00              sta   |0,y
0053 7F78
0054 7F78 B9 A0 00              lda   |160,y
0055 7F7B 25 F4                 and   <rsmask
0056 7F7D 03 07                 ora   save2,s
0057 7F7F 99 A0 00              sta   |160,y
0058 7F82
0059 7F82 B9 40 01              lda   |320,y
0060 7F85 25 F4                 and   <rsmask
0061 7F87 03 05                 ora   save3,s
0062 7F89 99 40 01              sta   |320,y
0063 7F8C
0064 7F8C B9 E0 01              lda   |480,y
0065 7F8F 25 F4                 and   <rsMask
0066 7F91 03 03                 ora   save3_5,s
0067 7F93 99 E0 01              sta   |480,y
0068 7F96
0069 7F96 68                    pla                            Get rid of save4.
0070 7F97 68                    pla                            Get rid of save3_5.
0071 7F98 68                    pla                            Get rid of save3.
0072 7F99 68                    pla                            Get rid of save2.
0073 7F9A 68                    pla                            Get rid of save1.
0074 7F9B
0075 7F9B              ; --- Return to caller -----------------------------------------
0076 7F9B              ;
0077 7F9B AB           exit     plb                            Restore caller's data bank pointer.
0078 7F9C 5A                    phy                            Save flag.
0079 7F9D A2 04 91 22           _ShowCursor 
0080 7FA4 68                    pla                            Restore flag.
0081 7FA5
0082 7FA5 60                    rts   
0083 7FA6
0084 7FA6 FF FF 3F FF  lmasks   DC W:$FFFF,$FF3F,$FF0F,$FF03,$FF00,$3F00,$0F00,$0300
0085 7FB6 C0 00 F0 00  rmasks   DC W:$00C0,$00F0,$00FC,$00FF,$C0FF,$F0FF,$FCFF,$FFFF
0086 7FC6
0087 7FC6                       ENDP 
0088 7FC6
0089 7FC6
0090 7FC6              ;===========================================================================
0091 7FC6              ;
0092 7FC6              ;                   UnCache
0093 7FC6              ;
0094 7FC6              ;   IN:    sav_buff = handle of cache.
0095 7FC6              ;
0096 7FC6              ;===========================================================================
0097 7FC6              UnCache  PROC 
0098 7FC6
0099 7FC6              saveCache equ   work
0100 7FC6              saveScreen equ   saveCache+2
0101 7FC6              lineAddr equ   saveScreen+2
0102 7FC6              cHeight  equ   lineAddr+4
0103 7FC6              cWidth   equ   cHeight+2
0104 7FC6              cacheBuff equ   cWidth+2
0105 7FC6
0106 7FC6 A2 04 90 22           _HideCursor 
0107 7FCD
0108 7FCD A0 02 00              ldy   #2                       Dereference cache handle.
0109 7FD0 B7 42                 lda   [<sav_buff],y
0110 7FD2 85 F8                 sta   <cacheBuff+2
0111 7FD4 A7 42                 lda   [<sav_buff]
0112 7FD6 85 F6                 sta   <cacheBuff
0113 7FD8
0114 7FD8 A0 02 00              ldy   #cachey1x1
0115 7FDB B7 F6                 lda   [<cacheBuff],y           Starting screen address.
0116 7FDD 85 EE                 sta   <lineAddr
0117 7FDF
0118 7FDF A0 04 00              ldy   #cacheWidth              Number of bytes per line.
0119 7FE2 B7 F6                 lda   [<cacheBuff],y
0120 7FE4 85 F4                 sta   <cWidth
0121 7FE6
0122 7FE6 A0 06 00              ldy   #cacheHeight             Number of lines.
0123 7FE9 B7 F6                 lda   [<cacheBuff],y
0124 7FEB 85 F2                 sta   <cHeight
0125 7FED
0126 7FED 8B                    phb                            Save caller's data bank pointer.
0127 7FEE A0 79 00              ldy   #port+4                  Switch to menu manager's pixel map bank.
0128 7FF1 B7 00                 lda   [<data],y
0129 7FF3 EB                    xba   
0130 7FF4 48                    pha   
0131 7FF5 AB                    plb   
0132 7FF6 AB                    plb   
0133 7FF7
0134 7FF7 A0 08 00              ldy   #cacheCache              Starting pointer in cache for data.
0135 7FFA
0136 7FFA A6 F4        lop2     ldx   <cWidth                  Initialize bytes per line counter.
0137 7FFC B7 F6        lop1     lda   [<cacheBuff],y
0138 7FFE 85 EA                 sta   <saveCache
0139 8000 5A                    phy   
0140 8001 9B                    txy   
0141 8002 B1 EE                 lda   (<lineAddr),y
0142 8004 85 EC                 sta   <saveScreen
0143 8006 A5 EA                 lda   <saveCache
0144 8008 91 EE                 sta   (<lineAddr),y
0145 800A 7A                    ply   
0146 800B A5 EC                 lda   <saveScreen
0147 800D 97 F6                 sta   [<cacheBuff],y
0148 800F C8                    iny   
0149 8010 C8                    iny   
0150 8011 CA                    dex   
0151 8012 CA                    dex   
0152 8013 10 E7                 bpl   lop1
0153 8015
0154 8015 A5 EE                 lda   <lineAddr                Next line.
0155 8017 18                    clc   
0156 8018 69 A0 00              adc   #160
0157 801B 85 EE                 sta   <lineAddr
0158 801D
0159 801D C6 F2                 dec   <cHeight                 Any more lines?
0160 801F D0 D9                 bne   lop2
0161 8021
0162 8021 AB                    plb                            Restore caller's data bank pointer.
0163 8022
0164 8022 A9 01 00              lda   #1                       Mark cache as good.
0165 8025 87 F6                 sta   [<cacheBuff]
0166 8027
0167 8027 A2 04 91 22           _ShowCursor 
0168 802E
0169 802E 60                    rts   
0170 802F
0171 802F                       ENDP 
0172 802F
0173 802F
0174 802F              ;===========================================================================
0175 802F              ;
0176 802F              ;                   MakeCache
0177 802F              ;
0178 802F              ;                   Allocate a cache for a menu.
0179 802F              ;
0180 802F              ;   IN:    menuptr = pointer to menu.
0181 802F              ;          menuhand = handle of menu.
0182 802F              ;
0183 802F              ;===========================================================================
0184 802F              makeCache PROC 
0185 802F
0186 802F              cBuff    equ   work
0187 802F
0188 802F 20 52 80              jsr   allocateCache
0189 8032 B0 1D                 bcs   exit                     Was cache allocated?
0190 8034
0191 8034 DA                    phx                            Save allocated cache.
0192 8035 48                    pha   
0193 8036
0194 8036 A0 14 00              ldy   #MenuCache               Store cache handle in menu's record.
0195 8039 68                    pla   
0196 803A AA                    tax   
0197 803B 97 1C                 sta   [<menuptr],y
0198 803D C8                    iny   
0199 803E C8                    iny   
0200 803F 68                    pla   
0201 8040 97 1C                 sta   [<menuptr],y
0202 8042
0203 8042 F4 03 00              pea   3                        Pass purge level 3 (first to go).
0204 8045 48                    pha                            Pass cache handle.
0205 8046 DA                    phx   
0206 8047
0207 8047 20 92 80              jsr   badCache                 Dereference cahce and mark as bad.
0208 804A
0209 804A A2 02 24 22           _SetPurge                      Mark the cache as purgeable.
0210 8051
0211 8051 60           exit     rts   
0212 8052
0213 8052                       ENDP 
0214 8052
0215 8052
0216 8052              ;===========================================================================
0217 8052              ;
0218 8052              ;                   AllocateCache
0219 8052              ;
0220 8052              ;                   Allocate a menu cache.
0221 8052              ;
0222 8052              ;   IN:    menuptr = pointer to menu record.
0223 8052              ;
0224 8052              ;  OUT:    Carry clear if x/a = handle of cache, carry set if no cache.
0225 8052              ;
0226 8052              ;===========================================================================
0227 8052              allocateCache PROC 
0228 8052
0229 8052              cWidth   equ   work
0230 8052              cHeight  equ   cWidth+2
0231 8052
0232 8052 A0 02 00              ldy   #MenuWidth
0233 8055 B7 1C                 lda   [<menuptr],y             Width in pixels,
0234 8057 18                    clc   
0235 8058 A6 46                 ldx   <screenmode
0236 805A D0 05                 bne   mode640
0237 805C
0238 805C 69 02 00              adc   #2                       plus 320 mode drop shadow width.
0239 805F 80 04                 bra   ok2
0240 8061
0241 8061 69 04 00     mode640  adc   #4                       plus 640 mode drop shadow width.
0242 8064 4A                    lsr   a
0243 8065 4A           ok2      lsr   a
0244 8066 18                    clc   
0245 8067 69 04 00              adc   #4
0246 806A 85 EA                 sta   <cWidth                  Number of bytes per line.
0247 806C 29 01 00              and   #1
0248 806F F0 02                 beq   ok3
0249 8071 E6 EA                 inc   <cWidth
0250 8073
0251 8073              ; --- Allocate a cache buffer for the menu ----------------------------------
0252 8073              ;
0253 8073 48           ok3      pha   
0254 8074 48                    pha                            Space for multiply result.
0255 8075 D4 EA                 pei   <cWidth                  Pass number of bytes per line.
0256 8077
0257 8077 A0 04 00              ldy   #MenuHeight
0258 807A B7 1C                 lda   [<menuptr],y
0259 807C 1A                    inc   a                        plus room for the drop shadow
0260 807D 85 EC                 sta   <cHeight
0261 807F 48                    pha                            Pass number of lines.
0262 8080
0263 8080 A2 0B 09 22           _Multiply 
0264 8087 68                    pla                            Number of bytes needed.
0265 8088 FA                    plx   
0266 8089 18                    clc   
0267 808A 69 08 00              adc   #cacheCache              Extra needed for header.
0268 808D              ;                                       Pass number of bytes to allocate in A.
0269 808D
0270 808D A4 06                 ldy   <MyID                    Pass ID to use.
0271 808F 82 ED 0E              brl   allocate2                Allocate memory for the buffer.
0272 8092
0273 8092                       ENDP 
0274 8092
0275 8092
0276 8092              ;===========================================================================
0277 8092              ;
0278 8092              ;                   BadCache
0279 8092              ;
0280 8092              ;                   Set cache to bad if menu has a cache.
0281 8092              ;
0282 8092              ;   IN:    menuptr = pointer to menu.
0283 8092              ;
0284 8092              ;===========================================================================
0285 8092              badCache PROC 
0286 8092
0287 8092 A0 0A 00              ldy   #MenuFlag                Check if there can be a cahce.
0288 8095 B7 1C                 lda   [<menuptr],y
0289 8097 29 08 00              and   #M_CACHE
0290 809A F0 24                 beq   exit
0291 809C
0292 809C A0 15 00              ldy   #MenuCache+1             Is there a cache?
0293 809F B7 1C                 lda   [<menuptr],y
0294 80A1 F0 1D                 beq   exit
0295 80A3
0296 80A3 C8                    iny   
0297 80A4 B7 1C                 lda   [<menuptr],y
0298 80A6 AA                    tax   
0299 80A7 88                    dey   
0300 80A8 88                    dey   
0301 80A9 B7 1C                 lda   [<menuptr],y
0302 80AB
0303 80AB              ;===========================================================================
0304 80AB              ;                   BadCache2
0305 80AB              ;
0306 80AB              ;                   Dereference cahce and mark as bad.
0307 80AB              ;
0308 80AB              ;   IN:    x/a = handle of cache.
0309 80AB              ;
0310 80AB              ;  OUT:    work = pointer to cache, cache marked as bad (invalid image).
0311 80AB              ;
0312 80AB              ;===========================================================================
0313 80AB                       ENTRY badCache2
0314 80AB              badCache2  
0315 80AB
0316 80AB              cBuff    equ   work
0317 80AB
0318 80AB 85 EA                 sta   <cBuff                   Dereference cahce.
0319 80AD 86 EC                 stx   <cBuff+2
0320 80AF
0321 80AF A0 02 00              ldy   #2
0322 80B2 B7 EA                 lda   [<cBuff],y
0323 80B4 A8                    tay   
0324 80B5 A7 EA                 lda   [<cBuff]
0325 80B7 85 EA                 sta   <cBuff
0326 80B9 84 EC                 sty   <cBuff+2
0327 80BB
0328 80BB A9 00 00              lda   #0                       Mark cache as BAD (not containing menu).
0329 80BE 87 EA                 sta   [<cBuff]
0330 80C0
0331 80C0 60           exit     rts   
0332 80C1
0333 80C1                       ENDP 
0334 80C1
0335 80C1
0336 80C1              ;===========================================================================
0337 80C1              ;
0338 80C1              ;                   EveryCacheBad
0339 80C1              ;
0340 80C1              ;                   Set every menu's cache to bad.
0341 80C1              ;
0342 80C1              ;   IN:    barptr = pointer to menu bar.
0343 80C1              ;
0344 80C1              ;===========================================================================
0345 80C1              everyCacheBad PROC 
0346 80C1
0347 80C1 20 35 62              jsr   getmfirst                Start with first menu.
0348 80C4 F0 08                 beq   exit                     Are there any menus?
0349 80C6
0350 80C6 20 92 80     lop1     jsr   badCache                 Mark cache bad if menu has a cache.
0351 80C9
0352 80C9 20 87 68              jsr   next_menu                Try next menu.
0353 80CC D0 F8                 bne   lop1                     Any more menus?
0354 80CE
0355 80CE 60           exit     rts   
0356 80CF
0357 80CF                       ENDP 
0358 80CF
0359 80CF
0360 80CF              ;===========================================================================
0361 80CF              ;
0362 80CF              ;                   FreeCache
0363 80CF              ;
0364 80CF              ;                   Free a menu's cache.
0365 80CF              ;
0366 80CF              ;   IN:    menuptr = pointer to menu.
0367 80CF              ;
0368 80CF              ;===========================================================================
0369 80CF              freeCache PROC 
0370 80CF
0371 80CF A0 0A 00              ldy   #MenuFlag                Check if there can be a cahce.
0372 80D2 B7 1C                 lda   [<menuptr],y
0373 80D4 29 08 00              and   #M_CACHE
0374 80D7 F0 1C                 beq   exit
0375 80D9
0376 80D9 A0 15 00              ldy   #MenuCache+1             Is there a cache?
0377 80DC B7 1C                 lda   [<menuptr],y
0378 80DE F0 15                 beq   exit
0379 80E0
0380 80E0 C8                    iny   
0381 80E1 B7 1C                 lda   [<menuptr],y
0382 80E3 48                    pha                            Put handle of cache to be disposed of on
0383 80E4 88                    dey                            the stack
0384 80E5
0385 80E5 A9 00 00              lda   #0                       Mark cache as gone.
0386 80E8 97 1C                 sta   [<menuptr],y
0387 80EA
0388 80EA 88                    dey   
0389 80EB B7 1C                 lda   [<menuptr],y
0390 80ED 48                    pha   
0391 80EE A2 02 10 22           _DisposeHandle                 Get rid of cache
0392 80F5
0393 80F5 60           exit     rts   
0394 80F6
0395 80F6                       ENDP 
0396 80F6
0397 80F6
0398 80F6              ;===========================================================================
0399 80F6              ;
0400 80F6              ;                   EveryCacheFree
0401 80F6              ;
0402 80F6              ;                   Free every menu's cache.
0403 80F6              ;
0404 80F6              ;   IN:    barptr = pointer to menu bar.
0405 80F6              ;
0406 80F6              ;===========================================================================
0407 80F6              everyCacheFree PROC 
0408 80F6
0409 80F6 20 35 62              jsr   getmfirst                Start with first menu.
0410 80F9 F0 08                 beq   exit                     Are there any menus?
0411 80FB
0412 80FB 20 CF 80     lop1     jsr   freeCache                Mark cache bad if menu has a cache.
0413 80FE
0414 80FE 20 87 68              jsr   next_menu                Try next menu.
0415 8101 D0 F8                 bne   lop1                     Any more menus?
0416 8103
0417 8103 60           exit     rts   
0418 8104
0419 8104                       ENDP 
0420 8104
0421 8104              ****************************************************************
0422 8104              *
0423 8104              TextFaceRoutines PROC 
0424 8104              *
0425 8104              * Sets and Clears the text face field in the grafport
0426 8104              * as specified in the item flag.
0427 8104              *
0428 8104              *
0429 8104              * Inputs:
0430 8104              *                   none
0431 8104              *
0432 8104              * Outputs:
0433 8104              *                   none
0434 8104              *
0435 8104              * External Refs:
0436 8104              *                   none
0437 8104              *
0438 8104              * Entry Points:
0439 8104                       ENTRY FixTextFace
0440 8104                       ENTRY ClearTextFace
0441 8104              *
0442 8104                       longa on                       ; mode
0443 8104                       longi on
0444 8104              *
0445 8104              ****************************************************************
0446 8104
0447 8104              FixTextFace  
0448 8104              ;-----------------------------------------------------------
0449 8104              ;
0450 8104              ; bold, underline and italic are kept in the low three bits
0451 8104              ; of the flag.
0452 8104              ;
0453 8104              ; We merge these with Shadow and Outline kept in bits
0454 8104              ; 11 and 12.
0455 8104              ;
0456 8104
0457 8104 A0 06 00              ldy   #ItemFlag                Get the flag
0458 8107 B7 24                 lda   [<itemptr],y
0459 8109 AA                    tax                            save it here
0460 810A 29 07 00              and   #$0007                   low 3 bits
0461 810D 48                    pha                            save it
0462 810E 8A                    txa                            get flag back
0463 810F 29 00 18              and   #I_NOOUTLINE+I_NOSHADOW  remove unwanted bits
0464 8112 EB                    xba                            put high into low
0465 8113 03 01                 ora   1,s                      merge with rest
0466 8115 83 01                 sta   1,s                      store it
0467 8117 A2 04 9A 22  GoBack   _SetTextFace 
0468 811E
0469 811E 60                    rts   
0470 811F
0471 811F              ClearTextFace  
0472 811F F4 00 00              pea   $0000
0473 8122 80 F3                 bra   GoBack
0474 8124
0475 8124
0476 8124                       ENDP 
0477 8124
0478 8124                       EJECT 
0479 8124              *******************************************************************************
0480 8124              *
0481 8124              PushPortData PROC EXPORT
0482 8124              *
0483 8124              * Description:      This routine will push grafport variables that can be changed
0484 8124              *                   by menuselect and popupmenuselect. This pushes:
0485 8124              *                   BkPat
0486 8124              *                   PnLoc
0487 8124              *                   pnSize
0488 8124              *                   pnMode
0489 8124              *                   pnPat
0490 8124              *                   pnMask
0491 8124              *                   pnVis
0492 8124              *                   fontHandle
0493 8124              *                   fontID
0494 8124              *                   fontFlags
0495 8124              *                   txSize
0496 8124              *                   txFace
0497 8124              *                   txMode
0498 8124              *                   spExtra
0499 8124              *                   chExtra
0500 8124              *                   fgColor
0501 8124              *                   bgColor
0502 8124              *
0503 8124              *
0504 8124              * Inputs:           None
0505 8124              *
0506 8124              * Outputs:          All that stuff on the stack!
0507 8124              *
0508 8124              * External Refs:
0509 8124              *
0510 8124              * Entry Points:
0511 8124              *
0512 8124              *******************************************************************************
0513 8124              *
0514 8124              * Direct page equates for my stack frame, note that I will leave this data on the
0515 8124              * stack and take it off with popPortData
0516 8124              *
0517 8124              FrameSize equ   $74                     ; 70 bytes of data + grafport pointer
0518 8124              portPtr  equ   1                        ; the place we will use for our grafport pointer
0519 8124              LocalPortData equ   portPtr+4           ; storage area for our port pointer
0520 8124              ;
0521 8124              ; First set up our stack frame...
0522 8124 7A                    ply                            ; recover the return address and save it...
0523 8125 7B                    tdc                            ; get the current dpage
0524 8126 AA                    tax                            ; and save it in <X>
0525 8127
0526 8127 3B                    tsc                            ; get the stack pointer
0527 8128 38                    sec   
0528 8129 E9 74 00              sbc   #FrameSize               ; adjust the stack pointer
0529 812C 1B                    tcs                            ; make it the new stack pointer and the new
0530 812D 5B                    tcd                            ; direct page
0531 812E
0532 812E 5A                    phy                            ; restore the return address
0533 812F DA                    phx                            ; and save the old dpage pointer
0534 8130
0535 8130              ; Now get the current grafport pointer
0536 8130 48                    pha                            ; room for result
0537 8131 48                    pha   
0538 8132 A2 04 1C 22           _GetPort                       ;
0539 8139 68                    pla   
0540 813A 85 01                 sta   <portPtr                 ; and save the port pointer to our dpage
0541 813C 68                    pla   
0542 813D 85 03                 sta   <portPtr+2               ;
0543 813F
0544 813F              ; now copy $70 bytes of data to our localportdata area
0545 813F
0546 813F A0 8E 00              ldy   #$8E                     ; last address to copy from
0547 8142 A2 6E 00              ldx   #$6E                     ; last data to copy
0548 8145 B7 01        @CopyLoop lda   [<portPtr],y            ; get the byte of data
0549 8147 95 05                 sta   <LocalPortData,x         ; and save it
0550 8149 88                    dey   
0551 814A 88                    dey   
0552 814B CA                    dex   
0553 814C CA                    dex   
0554 814D 10 F6                 bpl   @CopyLoop
0555 814F
0556 814F              ; now that we are done, lets get the proper direct page off the stack and end...
0557 814F 2B                    pld   
0558 8150 60                    rts                            ; now leave
0559 8151
0560 8151
0561 8151                       EJECT 
0562 8151              *******************************************************************************
0563 8151              *
0564 8151              PopPortData PROC EXPORT
0565 8151              *
0566 8151              * Description:      This routine will pop grafport variables that can be changed
0567 8151              *                   by MenuSelect and PopUpMenuSelect.
0568 8151              *
0569 8151              *             NOTE: You must have called PushPortData first, and the stack must
0570 8151              *                   be set to what it was when pushPortData returned.
0571 8151              *
0572 8151              *        This pops:
0573 8151              *                   BkPat
0574 8151              *                   PnLoc
0575 8151              *                   pnSize
0576 8151              *                   pnMode
0577 8151              *                   pnPat
0578 8151              *                   pnMask
0579 8151              *                   pnVis
0580 8151              *                   fontHandle
0581 8151              *                   fontID
0582 8151              *                   fontFlags
0583 8151              *                   txSize
0584 8151              *                   txFace
0585 8151              *                   txMode
0586 8151              *                   spExtra
0587 8151              *                   chExtra
0588 8151              *                   fgColor
0589 8151              *                   bgColor
0590 8151              *
0591 8151              *
0592 8151              * Inputs:           None
0593 8151              *
0594 8151              * Outputs:          All that stuff on the stack!
0595 8151              *
0596 8151              * External Refs:
0597 8151              *
0598 8151              * Entry Points:
0599 8151              *
0600 8151              *******************************************************************************
0601 8151              *
0602 8151              * Direct page equates for my stack frame, note that I will leave this data on the
0603 8151              * stack and take it off with popPortData
0604 8151              *
0605 8151              FrameSize equ   $74                     ; 70 bytes of data + grafport pointer
0606 8151              savedDPage equ   1
0607 8151              Rtn1     equ   savedDPage+2
0608 8151              portPtr  equ   Rtn1+2                   ; the place we will use for our grafport pointer
0609 8151              LocalPortData equ   portPtr+4           ; storage area for our port pointer
0610 8151              ; first copy $70 bytes of data from our localportdata area to the port
0611 8151 0B                    phd                            ; save the old dPage
0612 8152 3B                    tsc                            ; now make the stack the dPage
0613 8153 5B                    tcd   
0614 8154
0615 8154 A0 8E 00              ldy   #$8E                     ; last address to copy from
0616 8157 A2 6E 00              ldx   #$6E                     ; last data to copy
0617 815A              @CopyLoop  
0618 815A B5 09                 lda   <LocalPortData,x         ; and save it
0619 815C 97 05                 sta   [<portPtr],y             ; get the byte of data
0620 815E 88                    dey   
0621 815F 88                    dey   
0622 8160 CA                    dex   
0623 8161 CA                    dex   
0624 8162 10 F6                 bpl   @CopyLoop
0625 8164
0626 8164              ; Now that we are finished, reset the old dPage and pull all the old shit
0627 8164              ; off the stack
0628 8164 2B                    pld                            ; restore the directpage
0629 8165 7A                    ply                            ; save the return address for a sec...
0630 8166
0631 8166 3B                    tsc                            ; now adjust the stack pointer
0632 8167 18                    clc   
0633 8168 69 74 00              adc   #FrameSize
0634 816B 1B                    tcs                            ; and resave the stack pointer
0635 816C 5A                    phy                            ; restore the return address
0636 816D 60                    rts                            ; now leave
0637 816E
0638 816E
0639 816E
0640 816E              ;===========================================================================
0641 816E              ;
0642 816E              ;                   StaticRAM
0643 816E              ;
0644 816E              ;                   Menu Manager static data.
0645 816E              ;
0646 816E              ;===========================================================================
0647 816E              staticRAM PROC 
0648 816E
0649 816E              ;
0650 816E              ;
0651 816E              ; --- 320 mode Apple logo ---------------------------------------
0652 816E              ;
0653 816E                       ENTRY _320_mask
0654 816E FF FF FF FF  _320_mask DC B:$FF,$FF,$FF,$FF,$00,$FF,$FF,$FF
0655 8176 FF FF FF F0           DC B:$FF,$FF,$FF,$F0,$0F,$FF,$FF,$FF
0656 817E FF F0 00 0F           DC B:$FF,$F0,$00,$0F,$00,$00,$FF,$FF
0657 8186 FF 00 00 00           DC B:$FF,$00,$00,$00,$00,$0F,$FF,$FF
0658 818E FF 00 00 00           DC B:$FF,$00,$00,$00,$00,$0F,$FF,$FF
0659 8196 FF 00 00 00           DC B:$FF,$00,$00,$00,$00,$00,$0F,$FF
0660 819E FF F0 00 00           DC B:$FF,$F0,$00,$00,$00,$00,$FF,$FF
0661 81A6 FF FF 00 0F           DC B:$FF,$FF,$00,$0F,$00,$0F,$FF,$FF
0662 81AE
0663 81AE                       ENTRY _320_data
0664 81AE 00 00 00 00  _320_data DC B:$00,$00,$00,$00,$01,$00,$00,$00
0665 81B6 00 00 00 00           DC B:$00,$00,$00,$00,$10,$00,$00,$00
0666 81BE 00 00 11 10           DC B:$00,$00,$11,$10,$01,$10,$00,$00
0667 81C6 00 01 11 11           DC B:$00,$01,$11,$11,$11,$00,$00,$00
0668 81CE 00 01 11 11           DC B:$00,$01,$11,$11,$11,$00,$00,$00
0669 81D6 00 01 11 11           DC B:$00,$01,$11,$11,$11,$11,$00,$00
0670 81DE 00 00 11 11           DC B:$00,$00,$11,$11,$11,$10,$00,$00
0671 81E6 00 00 01 10           DC B:$00,$00,$01,$10,$11,$00,$00,$00
0672 81EE
0673 81EE              ;
0674 81EE              ; --- 640 mode Apple logo -------------------------------------------
0675 81EE              ;
0676 81EE                       ENTRY _640_mask
0677 81EE FF FF F0 3F  _640_mask DC B:$FF,$FF,$F0,$3F
0678 81F2 FF FF 00 FF           DC B:$FF,$FF,$00,$FF
0679 81F6 F0 00 F0 03           DC B:$F0,$00,$F0,$03
0680 81FA 00 00 00 0F           DC B:$00,$00,$00,$0F
0681 81FE 00 00 00 3F           DC B:$00,$00,$00,$3F
0682 8202 00 00 00 00           DC B:$00,$00,$00,$00
0683 8206 C0 00 00 03           DC B:$C0,$00,$00,$03
0684 820A F0 03 00 3F           DC B:$F0,$03,$00,$3F
0685 820E
0686 820E                       ENTRY _640_data
0687 820E 00 00 01 00  _640_data DC B:$00,$00,$01,$00
0688 8212 00 00 14 00           DC B:$00,$00,$14,$00
0689 8216 01 54 01 50           DC B:$01,$54,$01,$50
0690 821A 15 55 55 40           DC B:$15,$55,$55,$40
0691 821E 15 55 55 00           DC B:$15,$55,$55,$00
0692 8222 15 55 55 54           DC B:$15,$55,$55,$54
0693 8226 05 55 55 50           DC B:$05,$55,$55,$50
0694 822A 01 54 15 00           DC B:$01,$54,$15,$00
0695 822E
0696 822E              ;
0697 822E              ; --- Down Arrow for Scrolling Menus -------------------------------------
0698 822E              ;
0699 822E                       ENTRY DownArrowLocInfo640
0700 822E              DownArrowLocInfo640  
0701 822E 80 00                 DC W:$80
0702 8230 4E 82 FD 00           DC L:DownArrowIcon
0703 8234 04 00                 DC W:4
0704 8236                       ENTRY DownArrowBounds640
0705 8236 00 00 00 00  DownArrowBounds640 DC W:0,0,8,16
0706 823E
0707 823E
0708 823E                       ENTRY DownArrowLocInfo320
0709 823E              DownArrowLocInfo320  
0710 823E 00 00                 DC W:$00
0711 8240 4E 82 FD 00           DC L:DownArrowIcon
0712 8244 04 00                 DC W:4
0713 8246                       ENTRY DownArrowBounds320
0714 8246 00 00 00 00  DownArrowBounds320 DC W:0,0,8,8
0715 824E
0716 824E
0717 824E                       ENTRY DownArrowIcon
0718 824E FF FF FF FF  DownArrowIcon DC B:$FF,$FF,$FF,$FF      ; down arrow image
0719 8252 FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0720 8256 00 00 00 00           DC B:$00,$00,$00,$00
0721 825A F0 00 00 0F           DC B:$F0,$00,$00,$0F
0722 825E FF 00 00 FF           DC B:$FF,$00,$00,$FF
0723 8262 FF F0 0F FF           DC B:$FF,$F0,$0F,$FF
0724 8266 FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0725 826A FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0726 826E
0727 826E              ;
0728 826E              ; --- Up Arrow for Scrolling Menus ---------------------------------------
0729 826E              ;
0730 826E                       ENTRY UpArrowLocInfo640
0731 826E              UpArrowLocInfo640  
0732 826E 80 00                 DC W:$80
0733 8270 8E 82 FD 00           DC L:UpArrowIcon
0734 8274 04 00                 DC W:4
0735 8276                       ENTRY UpArrowBounds640
0736 8276 00 00 00 00  UpArrowBounds640 DC W:0,0,8,16
0737 827E
0738 827E
0739 827E                       ENTRY UpArrowLocInfo320
0740 827E              UpArrowLocInfo320  
0741 827E 00 00                 DC W:$00
0742 8280 8E 82 FD 00           DC L:UpArrowIcon
0743 8284 04 00                 DC W:4
0744 8286                       ENTRY UpArrowBounds320
0745 8286 00 00 00 00  UpArrowBounds320 DC W:0,0,8,8
0746 828E
0747 828E
0748 828E                       ENTRY UpArrowIcon
0749 828E FF FF FF FF  UpArrowIcon DC B:$FF,$FF,$FF,$FF        ; up arrow image
0750 8292 FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0751 8296 FF F0 0F FF           DC B:$FF,$F0,$0F,$FF
0752 829A FF 00 00 FF           DC B:$FF,$00,$00,$FF
0753 829E F0 00 00 0F           DC B:$F0,$00,$00,$0F
0754 82A2 00 00 00 00           DC B:$00,$00,$00,$00
0755 82A6 FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0756 82AA FF FF FF FF           DC B:$FF,$FF,$FF,$FF
0757 82AE
0758 82AE              ;
0759 82AE              ; --- Tables for setting SCB and color tables for color apple logo --------
0760 82AE              ;
0761 82AE                       ENTRY logocolor
0762 82AE C0 00        logocolor DC W:$00C0
0763 82B0 F0 0F                 DC W:$0FF0
0764 82B2 80 0F                 DC W:$0F80
0765 82B4 00 0F                 DC W:$0F00
0766 82B6 0F 0F                 DC W:$0F0F
0767 82B8 04 00                 DC W:$0004
0768 82BA
0769 82BA                       ENTRY scanbyte
0770 82BA 01           scanbyte DC B:1
0771 82BB 01                    DC B:1
0772 82BC 01                    DC B:1
0773 82BD 02                    DC B:2
0774 82BE 03                    DC B:3
0775 82BF 04                    DC B:4
0776 82C0 05                    DC B:5
0777 82C1 06                    DC B:6
0778 82C2
0779 82C2                       ENTRY color_patt
0780 82C2              color_patt  
0781 82C2 00 00 00 00           DC B:0,0,0,0,0,0,0,0
0782 82CA 00 00 00 00           DC B:0,0,0,0,0,0,0,0
0783 82D2 00 00 00 00           DC B:0,0,0,0,0,0,0,0
0784 82DA 00 00 00 00           DC B:0,0,0,0,0,0,0,0
0785 82E2 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
0786 82EA 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
0787 82F2 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
0788 82FA 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
0789 8302 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
0790 830A 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
0791 8312 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
0792 831A 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
0793 8322 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
0794 832A 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
0795 8332 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
0796 833A 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
0797 8342 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
0798 834A 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
0799 8352 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
0800 835A 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
0801 8362 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
0802 836A 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
0803 8372 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
0804 837A 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
0805 8382 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
0806 838A 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
0807 8392 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
0808 839A 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
0809 83A2 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
0810 83AA 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
0811 83B2 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
0812 83BA 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
0813 83C2 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
0814 83CA 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
0815 83D2 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
0816 83DA 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
0817 83E2 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
0818 83EA 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
0819 83F2 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
0820 83FA 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
0821 8402 AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
0822 840A AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
0823 8412 AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
0824 841A AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
0825 8422 BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
0826 842A BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
0827 8432 BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
0828 843A BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
0829 8442 CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
0830 844A CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
0831 8452 CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
0832 845A CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
0833 8462 DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
0834 846A DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
0835 8472 DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
0836 847A DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
0837 8482 EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
0838 848A EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
0839 8492 EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
0840 849A EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
0841 84A2 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
0842 84AA FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
0843 84B2 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
0844 84BA FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
0845 84C2
0846 84C2              ;
0847 84C2              ; --- Masks for dimmed and normal text -----------------------------
0848 84C2
0849 84C2                       ENTRY dimmed
0850 84C2 55 AA 55 AA  dimmed   DC B:$55,$AA,$55,$AA,$55,$AA,$55,$AA
0851 84CA                       ENTRY nor_mask
0852 84CA FF FF FF FF  nor_mask DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
0853 84D2
0854 84D2              ;
0855 84D2              ;------------------------------------------------------------
0856 84D2              ;          Data used to initialize RAM data area.
0857 84D2              ;------------------------------------------------------------
0858 84D2              ;
0859 84D2                       ENTRY startInitRAM
0860 84D2              startInitRAM  
0861 84D2 01 00 00              DC B:$01,$00,$00
0862 84D5 02 11 00 00           DC B:$02,$11,$00,$00
0863 84D9
0864 84D9              ;
0865 84D9              ; +++ The following blocks give information to QuickDraw about the
0866 84D9              ;     structure of screen RAM and data to use when moving data to or from
0867 84D9              ;     the screen.
0868 84D9
0869 84D9 00                    DC B:0                         Scan line control byte.
0870 84DA 00                    DC B:0                         Reserved.
0871 84DB 00 20 E1 00           DC L:$E12000                   Starting address of screen.
0872 84DF A0 00                 DC W:160                       Number of bytes per line.
0873 84E1 00 00 00 00           DC W:0,0,200,320               Bounds of screen.
0874 84E9
0875 84E9 00                    DC B:0                         Scan line control byte.
0876 84EA 00                    DC B:0                         Reserved.
0877 84EB 00 00 00 00           DC L:0                         Starting address of image.
0878 84EF 00 00                 DC W:0                         Number of bytes per line.
0879 84F1 00 00 00 00           DC W:0,0,0,0                   Bounds of image.
0880 84F9
0881 84F9 01 00                 DC W:1
0882 84FB 01 00                 DC W:1
0883 84FD 00 00 00 00           DC W:0,0,8,16                  Size of destination.
0884 8505
0885 8505              ;
0886 8505              ; +++ The following blocks give information to QuickDraw about the
0887 8505              ;     structure of screen RAM and data to use when moving data to or from
0888 8505              ;     the screen.
0889 8505              ;
0890 8505 00                    DC B:0                         Scan line control byte.
0891 8506 00                    DC B:0                         Reserved.
0892 8507 00 00 00 00           DC L:0                         Starting address of image.
0893 850B 08 00                 DC W:8                         Number of bytes per line.
0894 850D 00 00 00 00           DC W:0,0,8,16                  Bounds of image.
0895 8515
0896 8515              ;
0897 8515              ; --- Default System Menu Bar Template ---------------------------
0898 8515              ;
0899 8515 00 00 00 00           DC L:0                         Next Control.
0900 8519 00 00 00 00           DC L:0                         Menu owner.
0901 851D 00 00 00 00           DC W:0,0,13,320                MenuBar RECT.
0902 8525 00                    DC B:$00                       Flag, visible
0903 8526 0A                    DC B:$0A                       Hilite, active, low byte is where 1st menu starts
0904 8527 00 00                 DC W:0                         Value.
0905 8529 0C 00 00 00           DC L:12                        Menu bar definition procedure flag.
0906 852D 00 00 00 00           DC L:0                         Default action procedure, none.
0907 8531 00 00 00 00           DC L:0                         Data.
0908 8535 00 00 00 00           DC L:0                         RefCon.
0909 8539 00 00 00 00           DC L:0                         Pointer to color table, default.
0910 853D 00 00 00 00           DC L:0                         Handle of first menu in menu bar.
0911 8541              ;
0912 8541              ;
0913 8541              ; --- Default menu bar color table ---------------------------
0914 8541              ;
0915 8541                       ENTRY DefColorTable
0916 8541 F0 00        DefColorTable DC W:$00F0                Normal color, black text on white.
0917 8543 0F 00                 DC W:$000F                     Hilited color, white text on black.
0918 8545 00 00                 DC W:$0000                     Outline color, black.
0919 8547
0920 8547                       ENTRY endInitRAM
0921 8547              endInitRAM  
0922 8547
0923 8547                       ENDP 
0924 8547
0925 8547                       END   
